//=============================================================================
// NnGameReplicationInfo.
//=============================================================================
class NnGameReplicationInfo expands GameReplicationInfo;


var NnCTFTeamInfo Teams[8];
var int NumTeams;

// These items are set-up by NnCTFGame
var byte TC_None;
var byte TC_Spectator;
var byte TC_First;
var byte TC_Red;
var byte TC_Blue;
var byte TC_Green;
var byte TC_Yellow;
var byte TC_Last;

// Which teams are holding which flags.  255 == None
var byte FlagHolders[8];


replication
{
	reliable if ( Role == ROLE_Authority )
		Teams, NumTeams, TC_None, TC_Spectator, TC_First,
		TC_Red, TC_Blue, TC_Green, TC_Yellow, TC_Last;
}



// DLL: These Get* functions were taken from NnCTFGame.  I might move all of them
//   over here, I just don't feel like thinking about it too much right now.  :-)
function int GetTeamNumForName(String S)
{ 
	local int i;
	
	for (i = TC_First; i <= TC_Last; i++)
	{
		if (Teams[i] != None && S ~= Teams[i].TeamName)
		{
			return i;
		}
	}
	
	if (S ~= Teams[TC_Spectator].TeamName)
		return TC_Spectator;
	
	return(TC_None);
}

function string GetTeamNameForNum(int i)
{
	if (Teams[i] != None)
		return(Teams[i].TeamName);
	else
		return("None");
}

defaultproperties
{
}
