//=============================================================================
// NnGameOptionsMenu.
//=============================================================================
class NnGameOptionsMenu expands UnrealLongMenu;


//var() class<GameInfo> GameClass;
var	  GameInfo	GameType;


// 1 - Bonus Scoring Menu
// 2 - Rune Configuration Menu
// 3 - Misc Gameplay Options
// 4 - Scoring Limits Menu
// 5 - Advanced Options


function InitConfig(GameInfo G)
{
	GameType = G;
}


function bool ProcessSelection()
{
	local Menu ChildMenu;
	
	if ( Selection == 1 )
		ChildMenu = spawn(class'NnBonusScoringMenu', owner);
	else if ( Selection == 2 )
		ChildMenu = spawn(class'NnRuneConfigMenu', owner);
	else if ( Selection == 3 )
		ChildMenu = spawn(class'NnMiscGameplayOptionsMenu', owner);
	else if ( Selection == 4 )
		ChildMenu = spawn(class'NnScoringLimitsMenu', owner);
	else if ( Selection == 5 )
		ChildMenu = spawn(class'NnAdvancedOptionsMenu', owner);
	else
		return false;
	
	if ( ChildMenu != None )
	{
		NnGameOptionsMenu(ChildMenu).InitConfig(GameType);
		HUD(Owner).MainMenu = ChildMenu;
		ChildMenu.ParentMenu = self;
		ChildMenu.PlayerOwner = PlayerOwner;
	} else
		log("NnCTF: NnGameOptionsMenu: ProcessSelection(): ERROR: ChildMenu == None");
	
	return true;
}


function DrawOptions(canvas Canvas, int StartX, int StartY, int Spacing)
{
	local int i;
	
	for (i=1; i<MenuLength+1; i++ )
	{
		MenuList[i] = Default.MenuList[i];
	}
	
	DrawList(Canvas, false, Spacing, StartX, StartY);  
}


function DrawValues(canvas Canvas, int StartX, int StartY, int Spacing)
{
	local int i;
	
	for (i=1; i<MenuLength+1; i++ )
	{
		MenuList[i] = "";
	}
	
	DrawList(Canvas, false, Spacing, StartX, StartY);
}


// Modified From: UnrealShare.UnrealGameOptionsMenu.DrawMenu()
function DrawMenu(canvas Canvas)
{
	local int StartX, StartY, Spacing;

	DrawBackGround(Canvas, false);

	StartX = Max(40, 0.5 * Canvas.ClipX - 115);

	if ( (MenuLength < 6) || (Canvas.ClipY > 240) )
	{
		DrawTitle(Canvas);
		Spacing = Clamp(0.04 * Canvas.ClipY, 12, 32);
		StartY = Max(40, 0.5 * (Canvas.ClipY - MenuLength * Spacing - 128));
	}
	else
	{
		Spacing = Clamp(0.04 * Canvas.ClipY, 11, 32);
		StartY = Max(4, 0.5 * (Canvas.ClipY - MenuLength * Spacing - 128));
	}
	DrawOptions(Canvas, StartX, StartY, Spacing);
	DrawValues(Canvas, StartX, StartY, Spacing);		
	DrawHelpPanel(Canvas, StartY + MenuLength * Spacing + 4, 228);
}

defaultproperties
{
     MenuLength=5
     HelpMessage(1)=""
     MenuList(1)="Bonus Scoring Menu"
     MenuList(2)="Rune Configuration Menu"
     MenuList(3)="Misc Gameplay Options"
     MenuList(4)="Scoring Limits Menu"
     MenuList(5)="Advanced Options"
     MenuTitle="NNCTF OPTIONS"
}
