//=============================================================================
// NnFlagBase.
//=============================================================================
class NnFlagBase expands Decoration;

/*
#exec TEXTURE IMPORT NAME=BlueBarrel FILE=TEXTURES\FLAGS\BlueBarrel.PCX GROUP="Flags" MIPS=OFF
#exec TEXTURE IMPORT NAME=GreenBarrel FILE=TEXTURES\FLAGS\GreenBarrel.PCX GROUP="Flags" MIPS=OFF
#exec TEXTURE IMPORT NAME=RedBarrel FILE=TEXTURES\FLAGS\RedBarrel.PCX GROUP="Flags" MIPS=OFF
#exec TEXTURE IMPORT NAME=YellowBarrel FILE=TEXTURES\FLAGS\YellowBarrel.PCX GROUP="Flags" MIPS=OFF
*/

var Flag				OwnerFlag;

var() Sound				ScoredSnd;
var() class<Effects>	ScoredEffectClass;
var vector				ScoredEffectLocation;
var float				ScoreTime;

replication
{
	reliable if( Role==ROLE_Authority )
		OwnerFlag;
}


function PreBeginPlay()
{
	ScoredEffectLocation = Location;
}


function Bump( actor Other )
{
	if ( Pawn(Other) != None )
	{
		//log(class$": Bump(): Other="$Other);
		OwnerFlag.BaseHit(Other);
	}
}

function Touch( actor Other )
{
	if ( Pawn(Other) != None )
	{
		//log(class$": Touch(): Other="$Other);
		OwnerFlag.BaseHit(Other);
	}
}

function bool ValidTouch( actor Other )
{
	if ( Pawn(Owner) != None )
	{
		if ( Pawn(Other).PlayerReplicationInfo.TeamName ~= OwnerFlag.TeamInfo.TeamName )
		{
			return true;
		}
	}
	
	return false;
}

event float BotDesireability( pawn Bot )
{
	local Inventory AlreadyHas;
	local float desire;

	if (Bot.PlayerReplicationInfo.TeamName ~= string(OwnerFlag.TeamName))
		return 20;
	else
		return 0;
}

function SetVisibility( bool bToggle )
{
	//log(class$": SetVisibility(): bToggle="$bToggle);

	bBlockActors = bToggle;
	bBlockPlayers = bToggle;
	bHidden = !bToggle;
}

function Scored()
{
	PlayScored();
}

function PlayScored()
{
	local vector tmpLoc;
	local Effects tmpEffect;
	
	//log(class$": PlayScored(): Location="$ScoredEffectLocation);

	spawn(ScoredEffectClass,,,ScoredEffectLocation);
}

auto state Idle
{
	function Landed( vector HitNormal )
	{
		SetPhysics(PHYS_None);
	}
}

defaultproperties
{
     ScoredEffectClass=Class'UnrealShare.BallExplosion'
     bStatic=False
     bIsItemGoal=True
     bCollideWhenPlacing=True
     bStasis=False
     Physics=PHYS_Falling
     DrawType=DT_Mesh
     Skin=Texture'UnrealShare.Skins.JBarrel1'
     Mesh=LodMesh'UnrealShare.BarrelM'
     bAlwaysRelevant=True
     bGameRelevant=True
     CollisionRadius=24.000000
     CollisionHeight=29.000000
     bCollideActors=True
     bCollideWorld=True
     Mass=100.000000
}
