//=============================================================================
// NnCTFTeamInfo.
//=============================================================================
class NnCTFTeamInfo expands TeamInfo;

var Flag Flag;
var int Captures;				// How many times this team has captured a flag
var int BeenCaptured;			// How many times has another team captured this team's flag

// JMA: split these apart into R, G, B components
// (structs don't replicate)
var byte TeamColorR;
var byte TeamColorG;
var byte TeamColorB;

var string TeamName;
var int Size;					// number of players on this team in the level
var float Score;				// total score
var int TeamIndex;				// team's reference number

var string FlagStateText;
var name FlagStateName;

// dynamic music variables
var string CurrentMusicStr;
var byte CurrentSection;
var EMusicTransition CurrentTransition;


// JMA: Added Assistant code
var pawn Assistant;


replication
{
	reliable if ( Role == ROLE_Authority )
		TeamColorR, TeamColorG, TeamColorB, Captures, FlagStateText, FlagStateName,
		TeamName, Size, Score, TeamIndex, CurrentMusicStr, CurrentSection,
		CurrentTransition, BeenCaptured;
}


function SetAssistant(pawn Other, float time)
{
	Assistant = Other;
	SetTimer(time, false);
}

function Timer()
{
	Assistant = None;
}

defaultproperties
{
}
