//=============================================================================
// NnCTFRelInfo.
//=============================================================================
class NnCTFRelInfo expands ZoneInfo;

// this actor is always valid on the client side so we
// stash all info that the HUD needs in here

// the first FlagCount number of entries are used, the rest are empty
//var string StateTexts[4];
//var string TeamNames[4];
//var int TeamScores[4];
//var int TeamCaptures[4];
// JMA: split these apart into R, G, B components
// (structs don't replicate)
//var byte TextColorsR[4];
//var byte TextColorsG[4];
//var byte TextColorsB[4];

//var int TeamPlayerCount[4];

//var int FlagCount;				// only for testing the comment

//var int FirstTeam;				// The number to start counting teams at
//var int LastTeam;				// The last number to start counting teams at

//var NnCTFGame gameInfo;

// Darkmatch variables
// DLL: These are set by NnCTFGameInfo and used by CTFPlayer
//var bool		bDarkmatch;
//var float		lightChangePct;


//var string	Names[16];
//var float		Scores[16];
//var byte		NumPlayers;
//var NnCTFHUD	HUDScores;

/*
replication
{
	reliable if ( Role == ROLE_Authority )
		StateTexts, TeamNames, FlagCount, TextColorsR, TextColorsG, TextColorsB, TeamCaptures,
		FirstTeam, LastTeam, TeamPlayerCount;
	unreliable if ( Role == ROLE_Authority )
		TeamScores;
}
*/

/*
function BeginPlay()
{
	local int i, j;
	local NnCTFTeamInfo TI;

	gameInfo = NnCTFGame(Level.Game);
	
	if (gameInfo == None)
		log("NnCTF: ERROR in NnCTFRelInfo(): gameInfo == None");
	
	j = 0;
	for (i = gameInfo.TC_First; i <= gameInfo.TC_Last; i++)
	{
		TI = gameInfo.GetTeamInfoForNum(i);
		if (TI != None)
		{
			TextColorsR[j] = TI.TextColor.R;
			TextColorsG[j] = TI.TextColor.G;
			TextColorsB[j] = TI.TextColor.B;
			TeamNames[j] = TI.TeamName;
			j++;
		}
	}
	FlagCount = gameInfo.GetFlagCount();
	if (FlagCount == 0)
		log("NnCTF: ERROR in NnCTFRelInfo(): FlagCount == 0");
	
	FirstTeam = gameInfo.TC_First - 1;
	LastTeam = gameInfo.TC_Last - 1;

	SetTimer(1.0, True);
}


// DLL: This should probably be optimized to reduce network bandwidth.
function Timer()
{
	local Flag F;
	local NnCTFTeamInfo TI;
	local int i, j;

	j = 0;
	for (i = gameInfo.TC_First; i <= gameInfo.TC_Last; i++)
	{
		TI = gameInfo.GetTeamInfoForNum(i);
		if (TI != None)
		{
			TeamScores[j] = TI.Score;
			TeamCaptures[j] = TI.Captures;
			TeamPlayerCount[j] = TI.Size;
			if (TI.Flag != None)
			{
				StateTexts[j] = TI.Flag.GetStateText();
			}
			j++;
		}
	}
}
*/

defaultproperties
{
     bStatic=False
     bNoDelete=False
}
