//=============================================================================
// NnCTFHUD.
//=============================================================================
class NnCTFHUD expands ITSHUD config(NnCTF);

/*
#exec TEXTURE IMPORT NAME="BlueHUDFlag" FILE="Textures\Icons\BlueHudFlag.pcx" GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME="BlueHUDFlagDim" FILE="Textures\Icons\BlueHudFlagDim.pcx" GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME="GreenHUDFlag" FILE="Textures\Icons\GreenHudFlag.pcx" GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME="GreenHUDFlagDim" FILE="Textures\Icons\GreenHudFlagDim.pcx" GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME="RedHUDFlag" FILE="Textures\Icons\RedHudFlag.pcx" GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME="RedHUDFlagDim" FILE="Textures\Icons\RedHudFlagDim.pcx" GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME="YellowHUDFlag" FILE="Textures\Icons\YellowHudFlag.pcx" GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME="YellowHUDFlagDim" FILE="Textures\Icons\YellowHudFlagDim.pcx" GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME="IconSelectionSmall" FILE="Textures\Icons\IconSelectionSmall.pcx" GROUP="Icons" MIPS=OFF

#exec TEXTURE IMPORT NAME="DW_Pen" FILE="Textures\Misc\dw_pen.pcx" GROUP="Misc" MIPS=OFF

#exec TEXTURE IMPORT NAME="HUDBarMeasure" FILE="Textures\Misc\HUDBarMeasure.pcx" GROUP="Misc" MIPS=OFF
#exec TEXTURE IMPORT NAME="HUDBar" FILE="Textures\Misc\HUDBar.pcx" GROUP="Misc" MIPS=OFF

#exec TEXTURE IMPORT NAME="TargetGreenSmall" FILE="Textures\Misc\TargetGreenSmall.pcx" GROUP="Misc" MIPS=OFF
#exec TEXTURE IMPORT NAME="TargetRedLocked" FILE="Textures\Misc\TargetRedLocked.pcx" GROUP="Misc" MIPS=OFF
#exec TEXTURE IMPORT NAME="TargetRedSmall" FILE="Textures\Misc\TargetRedSmall.pcx" GROUP="Misc" MIPS=OFF
*/

var() float		InfoFlagBoxWidth;
var() float		InfoFlagBoxHeight;

var() config color		RuneLabelColor;

var() config color		ValueBodyBGColor;
var() config color		ValueLabelBGColor;
var() config color		ValueLabelTextColor;

var() config float		HeaderSizeYNormal, HeaderSizeYSmall, HeaderSizeYNone;

var() config color		SeparatorColor;

// Ob1: ITSHUD bracket drawing constants
const BracketXY			= 42; 		// XY dimensions of the bracket
const BracketOffsetXY	= 21;		// XY offset (BracketXY / 2)
const BracketSize		= 10.5;		// Bracket size (BracketXY / 4)

// Modified from UnrealShare.UnrealHUD.Tick()
simulated function Tick(float DeltaTime)
{
	IdentifyFadeTime -= DeltaTime;
	if (IdentifyFadeTime < 0.0)
		IdentifyFadeTime = 0.0;

	if ( !PlayerPawn(Owner).bShowMenu )
	{
		MOTDFadeOutTime -= DeltaTime * 45;
		if (MOTDFadeOutTime < 0.0)
			MOTDFadeOutTime = 0.0;
	}
}


simulated function PostRender(canvas Canvas)
{
	local float StartX, StartY;
	local float tmpY;
	
	if (!CTFPlayer(Owner).bNoITSHUD)
		Super.PostRender(Canvas);
	else
		Super(UnrealHUD).PostRender(Canvas);
	
	if ( HudMode <= 4 &&
	     !PlayerPawn(Owner).bShowMenu &&
	     !PlayerPawn(Owner).bShowScores )
	{
		// Draw the Team Info Display
		if (!CTFPlayer(Owner).bNoTeamInfo)
		{
			StartX = Canvas.ClipX - InfoFlagBoxWidth - 4;
			StartY = 36;
			DrawFlagInfoDisplay(Canvas, StartX, StartY);
		}
		
		// Draw the Runes Info Display
		if (!CTFPlayer(Owner).bNoRunesInfo)
		{
			DrawRuneInfoDisplay(Canvas, 0, 48);
		}
	}
}

//-----------------------------------------------------------------------------
// Ob1: no point drawing ammo etc. if player is spectating

simulated function DrawHealth(Canvas Canvas, int X, int Y)
{
	if (CTFPlayer(Owner).IsInState('Spectating'))
		return;
	super.DrawHealth( Canvas, X, Y );
}

simulated function DrawAmmo(Canvas Canvas, int X, int Y)
{
	if (CTFPlayer(Owner).IsInState('Spectating'))
		return;
	super.DrawAmmo(Canvas, X, Y);
}

simulated function DrawInventory(Canvas Canvas, int X, int Y, bool bDrawOne)
{
	if (CTFPlayer(Owner).IsInState('Spectating'))
		return;
	super.DrawInventory(Canvas, X, Y, bDrawOne);
}

simulated event RenderOverlays( canvas Canvas )
{
	if (CTFPlayer(Owner).IsInState('Spectating'))
		return;
	super.RenderOverlays(Canvas);
}
//-----------------------------------------------------------------------------


simulated function DrawFragCount(Canvas Canvas, int X, int Y)
{
	local texture SkullTexture;

	if (CTFPlayer(Owner).IsInState('Spectating'))
		return;

	SkullTexture = texture(DynamicLoadObject( "UnrealShare."$Pawn(Owner).PlayerReplicationInfo.TeamName$"Skull", class'texture'));
	if ( SkullTexture == None )
		SkullTexture = texture'IconSkull';

	DrawSkull(Canvas, X, Y, SkullTexture);
}

function DrawSkull(Canvas Canvas, int X, int Y, texture SkullTexture)
{ 
	Canvas.SetPos(X,Y);
	Canvas.DrawIcon(SkullTexture, 1.0);	
	Canvas.CurX -= 19;
	Canvas.CurY += 23;
	Canvas.Font = Font'TinyWhiteFont';	
	if (Pawn(Owner).PlayerReplicationInfo.Score<100) Canvas.CurX+=6;
	if (Pawn(Owner).PlayerReplicationInfo.Score<10) Canvas.CurX+=6;	
	if (Pawn(Owner).PlayerReplicationInfo.Score<0) Canvas.CurX-=6;
	Canvas.DrawText(int(Pawn(Owner).PlayerReplicationInfo.Score),False);
				
}


// Used to draw the targeting computer (and see if it should even be drawn)
simulated function
DrawIdentifyInfo(canvas Canvas, float PosX, float PosY)
{
	local NnTargetingComputer TC;
	
	// Check to see if the targeting computer should be displayed.  This will
	// only happen if the owner's bNoTargetingComputer variable is false and
	// the owner's TargetingComputer variable (which is a pointer to the player's
	// NnTargetingComputer object) is not 'None'.
	if ( !CTFPlayer(Owner).bNoTargetingComputer &&
	     CTFPlayer(Owner).TargetingComputer != None )
		if ( CTFPlayer(Owner).TargetingComputer.bActive )
			TC = CTFPlayer(Owner).TargetingComputer;
	
	if ( TC == None )
	{
		Super.DrawIdentifyInfo(Canvas, PosX, PosY);
	} else {
		if (!TraceIdentify(Canvas))
			return;
			
		TC = CTFPlayer(Owner).TargetingComputer;
		TC.DrawTC(Canvas, IdentifyTarget);
	}
}

simulated function
DrawRuneInfoDisplay(canvas canvas, float X, float Y, optional bool bHorizontal)
{
	local int i;
	local Inventory Inv;
	local float StartX, StartY, IconWidth, IconHeight, OffX;
	local color OldColor;
	
	IconWidth = 32;
	IconHeight = 32;
	
	for ( Inv=Owner.Inventory; Inv!=None; Inv=Inv.Inventory )
	{
		if ( Inv.IsA('Runes') )
		{
			if (bHorizontal)
			{
				StartX = X + (i * IconWidth);
				StartY = Y;
			} else {
				StartX = X;
				StartY = Y + (i * IconHeight);
			}
			i++;
			
			Canvas.SetPos(StartX, StartY);
			if (Inv.Icon != None)
				Canvas.DrawIcon(Inv.Icon, 1.0);

			Canvas.Font = Font'SmallFont';
			OldColor = Canvas.DrawColor;
			Canvas.DrawColor = RuneLabelColor;
			if (Inv.Charge >= 100)
				OffX = 14;
			else
				OffX = 20;
			Canvas.SetPos(StartX+OffX, StartY+24);
			Canvas.DrawText(Inv.Charge);
			Canvas.DrawColor = OldColor;
		}
	}
}


simulated function
DrawFlagInfoDisplay(canvas canvas, float X, float Y)
{
	local texture FlagIcon, FlagIconDim;
	local int i, j, HeaderType;
	local NnGameReplicationInfo NnGRI;
	local float tmpHeight;
	local byte OldStyle;
	local color OldColor;
	
	local float StartX, StartY, SpaceX, SpaceY, ColX;
	local float CurX, CurY, HeaderSizeY, InfoOffsetX;
	
	NnGRI = CTFPlayer(Owner).NnGRI;
	
	if ( NnGRI == None )
		return;
	
	// Set up vars
	StartX = 4;
	StartY = 20;
	SpaceY = 28;

	// Draw the background box
	if ( Canvas.SizeY < 300 )
	{
		HeaderType = 2;
		HeaderSizeY = HeaderSizeYNone;
	}
	else if ( Canvas.SizeY < 384 )
	{
		HeaderType = 1;
		HeaderSizeY = HeaderSizeYSmall;
	}
	else
	{
		HeaderType = 0;
		HeaderSizeY = HeaderSizeYNormal;
	}
	StartY -= (HeaderSizeYNormal - HeaderSizeY);

	if ( HeaderType != 0 )
	{
		SpaceY = 18;
	}
	
	tmpHeight = (4 + HeaderSizeY) + (NnGRI.NumTeams * SpaceY);
	InternalDeathDrawValueBox(Canvas, X, Y, InfoFlagBoxWidth, tmpHeight, "Teams", HeaderType);

	
	j=0;
	for (i=NnGRI.TC_First; i<=NnGRI.TC_Last; i++)
	{
		j = i - NnGRI.TC_First;
		if (NnGRI.Teams[i] == None)
			continue;

		CurX = X + StartX;
		CurY = Y + StartY + (j*SpaceY);

		// Draw the team separator
		if ( j != 0 )
		{
			OldColor = Canvas.DrawColor;
			OldStyle = Canvas.Style;
			
			if ( HeaderType == 0 )
				Canvas.SetPos(CurX+2, CurY-3);
			else
				Canvas.SetPos(CurX+2, CurY-1);
			Canvas.Style = 3;	// STY_Translucent
			Canvas.DrawColor = SeparatorColor;
			Canvas.DrawRect( texture'DW_Pen', InfoFlagBoxWidth-11, 1);
			
			Canvas.DrawColor = OldColor;
			Canvas.Style = OldStyle;
		}
		
		OldColor = Canvas.DrawColor;
		if ( HeaderType == 0 )
		{
			if ( IsFlagDim(NnGRI.Teams[i]) )
				FlagIcon = texture( DynamicLoadObject("NnCTFmedia."$NnGRI.Teams[i].TeamName$"HUDFlag", class'texture') );
			else
				FlagIcon = texture( DynamicLoadObject("NnCTFmedia."$NnGRI.Teams[i].TeamName$"HUDFlagDim", class'texture') );
			
			Canvas.SetPos(CurX, CurY);
			Canvas.DrawIcon(FlagIcon, 1.0);
			
			if ( Pawn(Owner).PlayerReplicationInfo.Team == i )
			{
				OldStyle = Canvas.Style;
				Canvas.Style = 3;			// STY_Translucent
				Canvas.SetPos(CurX, CurY);
				Canvas.DrawIcon(texture'IconSelectionSmall', 1.0);
				Canvas.Style = OldStyle;
			}
			
			Canvas.SetPos(CurX+20, CurY+3);
		} else {
			Canvas.SetPos(CurX, CurY);
			Canvas.DrawColor.R = NnGRI.Teams[i].TeamColorR;
			Canvas.DrawColor.G = NnGRI.Teams[i].TeamColorG;
			Canvas.DrawColor.B = NnGRI.Teams[i].TeamColorB;
		}
		Canvas.Font = Font'SmallFont';
		Canvas.DrawText(NnGRI.Teams[i].FlagStateText);
		Canvas.DrawColor = OldColor;
		
		if ( HeaderType == 0 )
			Canvas.SetPos(CurX, CurY+16);
		else
			Canvas.SetPos(CurX, CurY+7);
		Canvas.DrawText("Score: "$NnGRI.Teams[i].Captures$"/"$int(NnGRI.Teams[i].Score));
	}
}


simulated function bool
IsFlagDim( NnCTFTeamInfo NnTI )
{
	if ( !(NnTI.FlagStateName == 'InBase') )
		return false;
	
	return true;
}


simulated function DrawITSInfo(canvas Canvas)
{
	local Pawn p;
	local PlayerPawn player;
	local vector vecPawnView;
	local float fX;
	local float fY;
	local float RangeToTarget;
	local float DistanceScale;

	local vector X, Y, Z;

	player = PlayerPawn(Owner);
	GetAxes(player.ViewRotation, X, Y, Z);

	//foreach RadiusActors(Class'Pawn', p, ITS_Range, player.Location)
	foreach VisibleActors(class'Pawn', p, , player.Location)
	{
		// DLL: An ITSHUD box shouldn't be drawn for an invisible player.
		//if ( p.FindInventoryType(class'Invisibility') != None )
		if ( p.bHidden )
			continue;

		// Get a vector from the player to the pawn
		vecPawnView = p.Location - player.Location - (player.EyeHeight * vect(0,0,1));
	
		//***********************************************************************************
		// TODO:  make test more comprehensive.  Don't allow flys or carcasses for instance.
		//***********************************************************************************
		if(IsValidTarget(vecPawnView, X, p))  // note that vecPawnView Dot X > 0 ensures that the target is in front of you.
		{
			// range to the pawn
			RangeToTarget = VSize(p.Location - player.Location);
			
			//************************************************************
			// TODO:  replace '640' with '10 * HeightOfTexture'
			//************************************************************
			DistanceScale = (640 / RangeToTarget) * 90 / player.FOVAngle;
			
			//************************************************************
			//From Tim (9/27/98):
			//
			//	Xscreen = Xresolution/2 + Xworld * Zprojection / Zworld
			//	Yscreen = Yresolution/2 + Yworld * Zprojection / Zworld
			//
			//	Zprojection = Xresolution * arctan(FieldOfViewAngle) / 2
			//
			//*************************************************************
			
			//**************************************************************************
			// Mac (9/30/98):  Hmm.  Figured it out.  Looks like Tim just made 3 minor
			// little goofs in his email to me, which I didn't adequately analyze.
			//
			// Here is the CORRECT equation for Zprojection:
			//
			//     Zprojection = (Xresolution / 2) / ( tan(FieldOfViewAngle / 2) )
			// 
			//**************************************************************************
			
			// TODO:  replace '(32 * DistanceScale)' with '(HeightOfTexture / 2 * DistanceScale)'		
			fX = (Canvas.ClipX / 2) + ((vecPawnView Dot Y)) * ((Canvas.ClipX / 2) / tan(player.FOVAngle * Pi / 360)) / (vecPawnView Dot X);
			fY = (Canvas.ClipY / 2) + (-(vecPawnView Dot Z)) * ((Canvas.ClipX / 2) / tan(player.FOVAngle * Pi / 360)) / (vecPawnView Dot X);
			
			// draw stuff!
			DrawTargetInfo(Canvas, fX, fY, DistanceScale, RangeToTarget, p);
		}
	}
}


function DrawTargetInfo(Canvas canvas, float screenX, float screenY, 
                        float DistanceScale, float RangeToTarget, Pawn target)
{
	local NnPlayerReplicationInfo NnPRI;
	local float XL, YL;
	
	NnPRI = NnPlayerReplicationInfo(target.PlayerReplicationInfo);
	
	if (NnPRI == None)
		return;
	
	// draw range to target info
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.Font = Canvas.SmallFont;
	Canvas.DrawColor.R = NnPRI.TeamColorR;
	Canvas.DrawColor.G = NnPRI.TeamColorG;
	Canvas.DrawColor.B = NnPRI.TeamColorB;

	//*****************************************
	// TODO:  change '64' to 'HeightOfTexture'
	//
	// Ob1: Changed '64' to 'BracketSizeXY' (=42)
	//	 and 32 to 'BracketOffsetXY' (=21)
	//*****************************************
	Canvas.SetPos(screenX - (BracketOffsetXY * DistanceScale), screenY + (BracketOffsetXY * DistanceScale) + 2);
	Canvas.StrLen(int(RangeToTarget)$"u", XL, YL);
	/*if ( ((Canvas.CurX + XL) >= Canvas.ClipX) 
		&& ((screenX - (BracketOffsetXY * DistanceScale)) < Canvas.ClipX) )
	{
		Canvas.CurX -= (Canvas.CurX + XL - Canvas.ClipX);
	}*/
	if ( ((Canvas.CurX + XL) < Canvas.ClipX) && (Canvas.CurX > 0) )
		Canvas.DrawText(int(RangeToTarget) $ "u", false);
		
	//**********************
	// draw the target icon
	//**********************
	//Canvas.DrawColor.r = 0;
	//Canvas.DrawColor.g = 195;
	//Canvas.DrawColor.b = 0;

	//***************************************************************
	// example of how to use a texture instead of drawing primatives
	//***************************************************************
	// Canvas.SetPos(screenX - (32 * DistanceScale), screenY - (32 * DistanceScale));		
	// Canvas.DrawIcon(texture'GreenBracket', DistanceScale);

	//******************************************
	// example of how to use drawing primatives
	//******************************************
	//Canvas.DrawColor = TargetingColor;
	Canvas.SetPos(screenX - (BracketOffsetXY * DistanceScale), screenY - (BracketOffsetXY * DistanceScale));
	ITSDrawBracket(Canvas, BracketXY * DistanceScale, BracketXY * DistanceScale, BracketSize * DistanceScale);
	
	Canvas.SetPos((screenX - (BracketOffsetXY * DistanceScale))+2, (screenY - (BracketOffsetXY * DistanceScale)) - 10);
	Canvas.Font = Font'SmallFont';
	Canvas.StrLen(NnPRI.PlayerName, XL, YL);
	/*if ( ((Canvas.CurX + XL) >= Canvas.ClipX) 
		&& ((screenX - (BracketOffsetXY * DistanceScale)+2) < Canvas.ClipX) )
	{
		Canvas.CurX -= (Canvas.CurX + XL - Canvas.ClipX);
	}*/
	if ( ((Canvas.CurX + XL) < Canvas.ClipX) && (Canvas.CurX > 0) )
		Canvas.DrawText(NnPRI.PlayerName);
	
	//Canvas.DrawColor = COLOR_Yellow;
	//Canvas.SetPos(screenX, screenY);
	
	// This command draws an arc from 0 to 360 degrees (a full circle), with a step value
	// of 2 degrees, and uses scaling.  On my 512x[whatever] Voodoo display, this gives the
	// best solid circle with respect to processing time.  Any smaller of an increment doesn't
	// give you a good enough improvment for the added running time cost.
	//ITSDrawArc(canvas, 20, 0, (360 * PI / 180), (2 * PI / 180), true, DistanceScale);
	
	// reset the drawing style -- IMPORTANT (i think...)
	Canvas.Style = 1;
}


// Taken from: DeathWatch.DeathWatch_HUD
final simulated function 
DwFillRect(canvas canvas, texture tex, float width, float height)
{
    local float X, Y;
    X = canvas.CurX;
    Y = canvas.CurY;
    canvas.DrawRect(tex, width, height);
    canvas.SetPos(X, Y);
}


// Taken from: DeathWatch.DeathWatch_HUD
final simulated function 
DwDrawRect(canvas canvas, float width, float height)
{
    local float X, Y;
    X = canvas.CurX;
    Y = canvas.CurY;
    canvas.DrawRect(Texture'DW_Pen', PenWidth, height);
    canvas.DrawRect(Texture'DW_Pen', width, PenHeight);
    canvas.SetPos(X + width, Y);
    canvas.DrawRect(Texture'DW_Pen', PenWidth, height);
    canvas.SetPos(X, Y + height);
    canvas.DrawRect(Texture'DW_Pen', width+1, PenHeight);
    canvas.SetPos(X, Y);
}


// Taken from: DeathWatch.DeathWatch_HUD
final simulated function 
DwDrawLine(Canvas canvas, Direction direction, float size)
{
    local float X, Y;
    // Save current position
    X = canvas.CurX;
    Y = canvas.CurY;
    switch (direction) {
      case DIR_Up:
	  canvas.SetPos(X, Y - size);
	  canvas.DrawRect(Texture'DW_Pen', PenWidth, size);
	  break;
      case DIR_Down:
	  canvas.DrawRect(Texture'DW_Pen', PenWidth, size);
	  break;
      case DIR_Left:
	  canvas.SetPos(X - size, Y);
	  canvas.DrawRect(Texture'DW_Pen', size, PenHeight);
	  break;
      case DIR_Right:
	  canvas.DrawRect(Texture'DW_Pen', size, PenHeight);
	  break;
    }
    // Restore position
    canvas.SetPos(X, Y);
}


// Modified from: DeathWatch.DeathWatch_HUD
simulated function
InternalDeathDrawValueBox(Canvas Canvas, float X, float Y, float width, float height,
			  coerce string label, optional byte HeaderType)
{
    local int SavedStyle, HeaderSizeY;
    local color SavedColor;

	// DLL: HeaderType guide
	// 0 - Normal Header
	// 1 - Small Header
	// 2 - No Header

	switch ( HeaderType )
	{
		case 0:
			HeaderSizeY = HeaderSizeYNormal;
			break;
		case 1:
			HeaderSizeY = HeaderSizeYSmall;
			break;
		case 2:
			HeaderSizeY = HeaderSizeYNone;
			break;
	}

    SavedStyle = Canvas.Style;
	SavedColor = Canvas.DrawColor;

	Canvas.style = 3;	// STY_Translucent
    // Draw header
    if ( HeaderType != 2 )
    {
    	Canvas.SetPos(x, y);
    	//Canvas.style = 3; // STY_Translucent
    	// Canvas.DrawColor = COLOR_GhostBlue;
    	Canvas.DrawColor = ValueLabelBGColor;
    	DwFillRect(Canvas, Texture'DW_Pen', width, HeaderSizeY);
    }

    // Draw body
    // Canvas.DrawColor = COLOR_DarkBlue;
    Canvas.DrawColor = ValueBodyBGColor;
    Canvas.SetPos(x, y + HeaderSizeY);
    DwFillRect(Canvas, Texture'DW_Pen', width, height - HeaderSizeY);
    
    // Draw frame
    // Canvas.DrawColor = COLOR_GhostBlue;
    Canvas.DrawColor = ValueLabelBGColor;
    Canvas.SetPos(x, y);
    DwDrawRect(Canvas, width, height);
    if ( HeaderType != 2 )
    {
    	Canvas.SetPos(x, y + HeaderSizeY);
    	DwDrawLine(Canvas, DIR_Right, width);
    }

    // Draw Label
    Canvas.Style = 1;
    if ( HeaderType != 2 )
    {
    	if ( HeaderType == 0 )
    	{
    		Canvas.Font = Canvas.MedFont;
    		Canvas.SetPos(x + 4, y + 4);
    	}
    	else
    	{
    		Canvas.Font = Canvas.SmallFont;
    		Canvas.SetPos(x + 4, y + 1);
    	}
    	Canvas.DrawColor = ValueLabelTextColor;
    	Canvas.DrawText(label);
    }
    
    Canvas.Style = SavedStyle;
    Canvas.DrawColor = SavedColor;
    
    //Canvas.Reset();
}

defaultproperties
{
     InfoFlagBoxWidth=80.000000
     InfoFlagBoxHeight=80.000000
     RuneLabelColor=(R=192,G=192,B=192)
     ValueBodyBGColor=(B=64)
     ValueLabelBGColor=(R=50,G=50,B=128)
     ValueLabelTextColor=(R=255,G=255,B=255)
     HeaderSizeYNormal=16.000000
     HeaderSizeYSmall=10.000000
     SeparatorColor=(G=64,B=128)
     MainMenuType=Class'NnCTF.NnTeamSelectMenu'
}
