//=============================================================================
// NnBonusScoringMenu.
//=============================================================================
class NnBonusScoringMenu expands NnGameOptionsMenu;

// 1 - teamCaptureBonus
// 2 - playerCaptureBonus
// 3 - assistBonus
// 4 - defendBonus
// 5 - fragCarrierBonus

function bool ProcessLeft()
{
	if (Selection == 1)
		NnCTFGame(GameType).teamCaptureBonus = FMax(0, NnCTFGame(GameType).teamCaptureBonus - 1.0);
	else if (Selection == 2)
		NnCTFGame(GameType).playerCaptureBonus = FMax(0, NnCTFGame(GameType).playerCaptureBonus - 1.0);
	else if (Selection == 3)
		NnCTFGame(GameType).assistBonus = FMax(0, NnCTFGame(GameType).assistBonus - 1.0);
	else if (Selection == 4)
		NnCTFGame(GameType).defendBonus = FMax(0, NnCTFGame(GameType).defendBonus - 1.0);
	else if (Selection == 5)
		NnCTFGame(GameType).fragCarrierBonus = FMax(0, NnCTFGame(GameType).fragCarrierBonus - 1.0);
	else
		return false;

	return true;
}

function bool ProcessRight()
{
	if (Selection == 1)
		NnCTFGame(GameType).teamCaptureBonus += 1.0;
	else if (Selection == 2)
		NnCTFGame(GameType).playerCaptureBonus += 1.0;
	else if (Selection == 3)
		NnCTFGame(GameType).assistBonus += 1.0;
	else if (Selection == 4)
		NnCTFGame(GameType).defendBonus += 1.0;
	else if (Selection == 5)
		NnCTFGame(GameType).fragCarrierBonus += 1.0;
	else
		return false;
	
	return true;
}

function DrawValues(canvas Canvas, int StartX, int StartY, int Spacing)
{
	local NnCTFGame NNGame;

	NNGame = NnCTFGame(GameType);

	// set up values
	MenuList[1] = string(int(NNGame.teamCaptureBonus));
	MenuList[2] = string(int(NNGame.playerCaptureBonus));
	MenuList[3] = string(int(NNGame.assistBonus));
	MenuList[4] = string(int(NNGame.defendBonus));
	MenuList[5] = string(int(NNGame.fragCarrierBonus));

	DrawList(Canvas, false, Spacing, StartX + 160, StartY);  
}

defaultproperties
{
     MenuList(1)="Team Capture Bonus"
     MenuList(2)="Player Capture Bonus"
     MenuList(3)="Assist Bonus"
     MenuList(4)="Defend Bonus"
     MenuList(5)="Frag Carrier Bonus"
     MenuTitle="BONUS POINTS"
}
