//=============================================================================
// NnAdvancedOptionsMenu.
//=============================================================================
class NnAdvancedOptionsMenu expands NnGameOptionsMenu;

// 1 - bNoDebugMessages
// 2 - bIgnoreLevelPrefs
// 3 - defendRadius
// 4 - assistTime
// 5 - bUseCustomSkins


function bool ProcessLeft()
{
	if ( Selection == 1 )
		NnCTFGame(GameType).bNoDebugMessages = !NnCTFGame(GameType).bNoDebugMessages;
	else if ( Selection == 2 )
		NnCTFGame(GameType).bIgnoreLevelPrefs = !NnCTFGame(GameType).bIgnoreLevelPrefs;
	else if ( Selection == 3 )
		NnCTFGame(GameType).defendRadius = FMax(0, NnCTFGame(GameType).defendRadius - 5);
	else if ( Selection == 4 )
		NnCTFGame(GameType).assistTime = FMax(0, NnCTFGame(GameType).assistTime - 0.5);
	else if ( Selection == 5 )
		NnCTFGame(GameType).bUseCustomSkins = !NnCTFGame(GameType).bUseCustomSkins;
	else if ( Selection == 6 )
		NnCTFGame(GameType).bBotsCanCarryFlags = !NnCTFGame(GameType).bBotsCanCarryFlags;
	else
		return false;
	
	return true;
}


function bool ProcessRight()
{
	if ( Selection == 1 )
		NnCTFGame(GameType).bNoDebugMessages = !NnCTFGame(GameType).bNoDebugMessages;
	else if ( Selection == 2 )
		NnCTFGame(GameType).bIgnoreLevelPrefs = !NnCTFGame(GameType).bIgnoreLevelPrefs;
	else if ( Selection == 3 )
		NnCTFGame(GameType).defendRadius += 5;
	else if ( Selection == 4 )
		NnCTFGame(GameType).assistTime += 0.5;
	else if ( Selection == 5 )
		NnCTFGame(GameType).bUseCustomSkins = !NnCTFGame(GameType).bUseCustomSkins;
	else if ( Selection == 6 )
		NnCTFGame(GameType).bBotsCanCarryFlags = !NnCTFGame(GameType).bBotsCanCarryFlags;
	else
		return false;
	
	return true;
}


function bool ProcessSelection()
{
	if ( Selection == 1 )
		NnCTFGame(GameType).bNoDebugMessages = !NnCTFGame(GameType).bNoDebugMessages;
	else if ( Selection == 2 )
		NnCTFGame(GameType).bIgnoreLevelPrefs = !NnCTFGame(GameType).bIgnoreLevelPrefs;
	else if ( Selection == 3 );
	else if ( Selection == 4 );
	else if ( Selection == 5 )
		NnCTFGame(GameType).bUseCustomSkins = !NnCTFGame(GameType).bUseCustomSkins;
	else
		return false;
	
	return true;
}


function bool ProcessYes()
{
	if ( Selection == 1 )
		NnCTFGame(GameType).bNoDebugMessages = true;
	else if ( Selection == 2 )
		NnCTFGame(GameType).bIgnoreLevelPrefs = true;
	else if ( Selection == 3 );
	else if ( Selection == 4 );
	else if ( Selection == 5 )
		NnCTFGame(GameType).bUseCustomSkins = true;
	else if ( Selection == 6 )
		NnCTFGame(GameType).bBotsCanCarryFlags = true;
	else
		return false;
	
	return true;
}


function bool ProcessNo()
{
	if ( Selection == 1 )
		NnCTFGame(GameType).bNoDebugMessages = false;
	else if ( Selection == 2 )
		NnCTFGame(GameType).bIgnoreLevelPrefs = false;
	else if ( Selection == 3 );
	else if ( Selection == 4 );
	else if ( Selection == 5 )
		NnCTFGame(GameType).bUseCustomSkins = false;
	else if ( Selection == 6 )
		NnCTFGame(GameType).bBotsCanCarryFlags = false;
	else
		return false;
	
	return true;
}


function DrawValues(canvas Canvas, int StartX, int StartY, int Spacing)
{
	local NnCTFGame NNGame;

	NNGame = NnCTFGame(GameType);

	// set up values
	MenuList[1] = string(NNGame.bNoDebugMessages);
	MenuList[2] = string(NNGame.bNoTeamStartFind);
	MenuList[3] = string(int(NNGame.defendRadius));
	MenuList[4] = string(NNGame.assistTime);
	MenuList[5] = string(NNGame.bUseCustomSkins);
	MenuList[6] = string(NNGame.bBotsCanCarryFlags);
	
	DrawList(Canvas, false, Spacing, StartX + 160, StartY);
}

defaultproperties
{
     MenuLength=6
     HelpMessage(1)="Turn on/off some debugging messages (generated by NnCTFGame.)"
     HelpMessage(2)="Ignore any level specific preferences."
     HelpMessage(3)="The radius used to calculate which players are considered "
     HelpMessage(4)="The amount of time (between a kill and a capture) used to calculate who get assist bonus points."
     HelpMessage(5)="Should NnCTF custom skins be used?"
     HelpMessage(6)="Should bots be allowed to pick up and carry flags?"
     MenuList(1)="No Debug Messages"
     MenuList(2)="Ignore Level Prefs"
     MenuList(3)="Defend Radius"
     MenuList(4)="Assist Time"
     MenuList(5)="Use Custom Skins"
     MenuList(6)="Bots Can Carry Flags"
     MenuTitle="ADVANCED OPTIONS"
}
