//=============================================================================
// Haste.
//=============================================================================
class Haste expands Runes;

/*
// JMA: rewrote this a bit
#exec MESH IMPORT MESH=rune1 ANIVFILE=MODELS\rune1_a.3d DATAFILE=MODELS\rune1_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=rune1 X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=rune1 SEQ=All   STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=rune1 SEQ=rune1 STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=rune1 MESH=rune1
#exec MESHMAP SCALE MESHMAP=rune1 X=0.1 Y=0.1 Z=0.2

#exec MESHMAP SETTEXTURE MESHMAP=rune1 NUM=1 TEXTURE=Jrune

#exec AUDIO IMPORT FILE="Sounds\Runes\Haste.wav" NAME="Haste" GROUP="Runes"
*/

//var float OldAnimRate;


function PickupFunction(Pawn Other)
{
	//log("NnCTF: Haste: PickupFunction()");
	GotoState('Hasting');
	Super.PickupFunction(Other);
}

function SetPRIAmt( int SetTo )
{
	NnPlayerReplicationInfo(Pawn(Owner).PlayerReplicationInfo).HasteAmt = SetTo;
}

function int GetPRIAmt()
{
	return NnPlayerReplicationInfo(Pawn(Owner).PlayerReplicationInfo).HasteAmt;
}

function Fire( float F )
{
	//Owner.PlaySound(ActivateSound, SLOT_Interact, 4.0);
	Owner.PlaySound(ActivateSound,,4.0);
	Super.Fire(F);
}

function AltFire( float F )
{
	Owner.PlaySound(ActivateSound,,4.0);
	Super.AltFire(F);
}

state Hasting
{
	function Tick(float deltatime)
	{
		local Weapon wep;

		if (Pawn(Owner) == None)
			return;		// how the heck did we get here?
			
		wep = Pawn(Owner).Weapon;
		
		if (wep != None && 												// has to have a weapon
			wep.IsAnimating() &&										// has to be animating
			(wep.IsInState('NormalFire') || wep.IsInState('AltFiring')))	// has to be firing
		{
			// OldAnimRate == AnimRate until the animation changes
			// (or we explicitly change AnimRate)
			if (wep.OldAnimRate == wep.AnimRate)								
			{
				wep.AnimRate *= (1 + GetMultiplier());		// increase the speed
/*
				wep.AnimRate += 0.001;		// make sure that we don't
											// miss an animation change because
											// one animation runs at exactly
											// twice the speed of the 
											// previous one
				wep.OldAnimRate = wep.AnimRate;
*/
			}
			if (wep.IsA('GESBioRifle') && wep.IsInState('AltFiring'))
			{
				// messes up biorifle in secondary fire mode
				wep.Tick(deltatime);
			}
		}
	}
	
	function BeginState()
	{
		Enable('Tick');
	}
}

defaultproperties
{
     ItemName="Haste"
     PickupViewMesh=LodMesh'NnCTFMedia.rune1'
     ActivateSound=Sound'NnCTFMedia.Runes.Haste'
     Icon=Texture'UnrealShare.Icons.I_ClipAmmo'
     Physics=PHYS_Falling
     Texture=Texture'Engine.S_Inventory'
     Skin=None
     Mesh=LodMesh'NnCTFMedia.rune1'
     DrawScale=16.000000
}
