//=============================================================================
// DummyInfo.
//=============================================================================
class DummyInfo expands Info;

// DLL: This entire class is a total and utter hack.  Just ignore it.


var int Current;
var bool bLocked;

const MAX_ITEMS = 24;
var string PlayerNames[24];
var string TeamNames[24];
var CTFDummy Dummies[24];

var struct SRuneAmt
{
	var int HasteAmt;
	var int RegenAmt;
	var int ResistAmt;
	var int StrengthAmt;
} RuneAmt[24];

function SetUpDummy(string PlayerName, string TeamName, out CTFDummy dummy,
                    optional int HasteAmt,
                    optional int RegenAmt,
                    optional int ResistAmt,
                    optional int StrengthAmt)
{
	if (Current == MAX_ITEMS)
		return;
	
	PlayerNames[Current] = PlayerName;
	TeamNames[Current] = TeamName;
	Dummies[Current] = dummy;
	
	RuneAmt[Current].HasteAmt = HasteAmt;
	RuneAmt[Current].RegenAmt = RegenAmt;
	RuneAmt[Current].ResistAmt = ResistAmt;
	RuneAmt[Current].StrengthAmt = StrengthAmt;
	
	NnCTFGame(Level.Game).AddDefaultInventory(dummy);
	
	Current++;
}


function Wait()
{
	SetTimer(0.1, true);
}


function Timer()
{
	local int i;
	
	if (!NnCTFGame(Level.Game).bGameIsSetup) {
		log("Dummy: Waiting to be set up.");
		return;
	}
	
	log("Dummy: Setting up dummies.");
	
	for	(i=0; i<Current; i++)
	{
		ProcessEntry(i);
	}
	
	Current = 0;
	
	Disable('Timer');
	//self.Destroy();
}

function ProcessEntry(int index)
{
	local int i;
	local NnGameReplicationInfo NnGRI;
	local NnPlayerReplicationInfo DummyInfo;
	local NnCTFTeamInfo TI;
	
	
	NnGRI = NnGameReplicationInfo(Level.Game.GameReplicationInfo);
	
	for (i=0; i<=NnGRI.NumTeams; i++)
	{
		if (TeamNames[index] ~= NnGRI.Teams[i].TeamName) {
			log("Dummy: Team Found");
			TI = NnGRI.Teams[i];
		} else {
			log("Dummy: Passed by Team: "$i$", "$NnGRI.Teams[i].TeamName);
		}
	}
	
	if (Dummies[index].PlayerReplicationInfo == None)
	{
		log("OpenMdTest: SetUpDummy(): "$Dummies[index].name$" has a PRI info of None");
		Dummies[index].PlayerReplicationInfo = spawn(class'NnPlayerReplicationInfo', Dummies[index]);
	}
	
	DummyInfo = NnPlayerReplicationInfo(Dummies[index].PlayerReplicationInfo);
	
	if (DummyInfo == None)
	{
		log("OpenMdTest: SetUpDummy(): "$Dummies[index].name$" still has a PRI info of None");
	}
	
	DummyInfo.PlayerName = PlayerNames[index];
	DummyInfo.TeamName = TI.TeamName;
	DummyInfo.Team = TI.TeamIndex;
	DummyInfo.TeamColorR = TI.TeamColorR;
	DummyInfo.TeamColorG = TI.TeamColorG;
	DummyInfo.TeamColorB = TI.TeamColorB;
	
	DummyInfo.HasteAmt = RuneAmt[index].HasteAmt;
	DummyInfo.RegenAmt = RuneAmt[index].RegenAmt;
	DummyInfo.ResistAmt = RuneAmt[index].ResistAmt;
	DummyInfo.StrengthAmt = RuneAmt[index].StrengthAmt;
		
	log("Dummy TeamName: "$TI.TeamName);
	log("Dummy Color: "$TI.TeamColorR$", "$TI.TeamColorG$", "$TI.TeamColorB);
	
}

defaultproperties
{
}
