//=============================================================================
// NnImportedMediaInfo.
//=============================================================================
class NnImportedMediaInfo expands Info;

//=============================================================================
// Flag.
//=============================================================================
// the model
#exec MESH IMPORT MESH=NnCTFFlag ANIVFILE=MODELS\flag_a.3d DATAFILE=MODELS\flag_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=NnCTFFlag X=0 Y=240 Z=0 YAW=64 PITCH=0 ROLL=0
 
#exec MESH SEQUENCE MESH=NnCTFFlag SEQ=All   STARTFRAME=0 NUMFRAMES=15
#exec MESH SEQUENCE MESH=NnCTFFlag SEQ=Wave STARTFRAME=0 NUMFRAMES=15
 
#exec MESHMAP SCALE MESHMAP=NnCTFFlag X=0.1 Y=0.1 Z=0.2
 
// the textures for the subclasses
#exec TEXTURE IMPORT NAME=NnCTFBlueflag FILE=TEXTURES\FLAGS\BlueFlag.PCX GROUP="Flags" MIPS=OFF
#exec TEXTURE IMPORT NAME=NnCTFGreenFlag FILE=TEXTURES\FLAGS\GreenFlag.PCX GROUP="Flags" MIPS=OFF
#exec TEXTURE IMPORT NAME=NnCTFRedFlag FILE=TEXTURES\FLAGS\RedFlag.PCX GROUP="Flags" MIPS=OFF
#exec TEXTURE IMPORT NAME=NnCTFYellowFlag FILE=TEXTURES\FLAGS\YellowFlag.PCX GROUP="Flags" MIPS=OFF

// sounds
#exec AUDIO IMPORT FILE="Sounds\Captured\Buzzer.WAV" NAME="Buzzer" GROUP="Captured"
#exec AUDIO IMPORT FILE="Sounds\Stolen\CTFSiren2.WAV" NAME="CTFSiren1" GROUP="Stolen"


//=============================================================================
// Runes.
//=============================================================================

// The texture
#exec TEXTURE IMPORT NAME=Jrune FILE=TEXTURES\Skins\rune.PCX GROUP=Skins FLAGS=2 // TempMaterial

// The pickup sound
#exec AUDIO IMPORT FILE="Sounds\Runes\RunePickup.WAV" NAME="RunePickup" GROUP="Runes"


//=============================================================================
// Haste.
//=============================================================================

#exec MESH IMPORT MESH=rune1 ANIVFILE=MODELS\rune1_a.3d DATAFILE=MODELS\rune1_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=rune1 X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=rune1 SEQ=All   STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=rune1 SEQ=rune1 STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=rune1 MESH=rune1
#exec MESHMAP SCALE MESHMAP=rune1 X=0.1 Y=0.1 Z=0.2

#exec MESHMAP SETTEXTURE MESHMAP=rune1 NUM=1 TEXTURE=Jrune

#exec AUDIO IMPORT FILE="Sounds\Runes\Haste.wav" NAME="Haste" GROUP="Runes"


//=============================================================================
// Regen.
//=============================================================================

#exec MESH IMPORT MESH=rune3 ANIVFILE=MODELS\rune3_a.3d DATAFILE=MODELS\rune3_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=rune3 X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=rune3 SEQ=All   STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=rune3 SEQ=rune3 STARTFRAME=0 NUMFRAMES=1

//#exec TEXTURE IMPORT NAME=Jrune31 FILE=MODELS\rune31.PCX GROUP=Skins FLAGS=2 // TempMaterial

#exec MESHMAP NEW   MESHMAP=rune3 MESH=rune3
#exec MESHMAP SCALE MESHMAP=rune3 X=0.1 Y=0.1 Z=0.2

#exec MESHMAP SETTEXTURE MESHMAP=rune3 NUM=1 TEXTURE=Jrune

#exec AUDIO IMPORT FILE="Sounds\Runes\Regen.wav" NAME="Regen" GROUP="Runes"


//=============================================================================
// Resist.
//=============================================================================

#exec MESH IMPORT MESH=rune2 ANIVFILE=MODELS\rune2_a.3d DATAFILE=MODELS\rune2_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=rune2 X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=rune2 SEQ=All   STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=rune2 SEQ=rune2 STARTFRAME=0 NUMFRAMES=1

//#exec TEXTURE IMPORT NAME=Jrune21 FILE=MODELS\rune21.PCX GROUP=Skins FLAGS=2 // TempMaterial

#exec MESHMAP NEW   MESHMAP=rune2 MESH=rune2
#exec MESHMAP SCALE MESHMAP=rune2 X=0.1 Y=0.1 Z=0.2

#exec MESHMAP SETTEXTURE MESHMAP=rune2 NUM=1 TEXTURE=Jrune

#exec AUDIO IMPORT FILE="Sounds\Runes\Resist.wav" NAME="Resist" GROUP="Runes"


//=============================================================================
// Strength.
//=============================================================================

#exec MESH IMPORT MESH=rune4 ANIVFILE=MODELS\rune4_a.3d DATAFILE=MODELS\rune4_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=rune4 X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=rune4 SEQ=All   STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=rune4 SEQ=rune4 STARTFRAME=0 NUMFRAMES=1

//#exec TEXTURE IMPORT NAME=Jrune41 FILE=MODELS\rune41.PCX GROUP=Skins FLAGS=2 // TempMaterial

#exec MESHMAP NEW   MESHMAP=rune4 MESH=rune4
#exec MESHMAP SCALE MESHMAP=rune4 X=0.1 Y=0.1 Z=0.2

#exec MESHMAP SETTEXTURE MESHMAP=rune4 NUM=1 TEXTURE=Jrune

#exec AUDIO IMPORT FILE="Sounds\Runes\Strength.wav" NAME="Strength" GROUP="Runes"


//=============================================================================
// NnCTFHUD.
//=============================================================================

#exec TEXTURE IMPORT NAME="BlueHUDFlag" FILE="Textures\Icons\BlueHudFlag.pcx" GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME="BlueHUDFlagDim" FILE="Textures\Icons\BlueHudFlagDim.pcx" GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME="GreenHUDFlag" FILE="Textures\Icons\GreenHudFlag.pcx" GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME="GreenHUDFlagDim" FILE="Textures\Icons\GreenHudFlagDim.pcx" GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME="RedHUDFlag" FILE="Textures\Icons\RedHudFlag.pcx" GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME="RedHUDFlagDim" FILE="Textures\Icons\RedHudFlagDim.pcx" GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME="YellowHUDFlag" FILE="Textures\Icons\YellowHudFlag.pcx" GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME="YellowHUDFlagDim" FILE="Textures\Icons\YellowHudFlagDim.pcx" GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME="IconSelectionSmall" FILE="Textures\Icons\IconSelectionSmall.pcx" GROUP="Icons" MIPS=OFF

#exec TEXTURE IMPORT NAME="DW_Pen" FILE="Textures\Misc\dw_pen.pcx" GROUP="Misc" MIPS=OFF

#exec TEXTURE IMPORT NAME="HUDBarMeasure" FILE="Textures\Misc\HUDBarMeasure.pcx" GROUP="Misc" MIPS=OFF
#exec TEXTURE IMPORT NAME="HUDBar" FILE="Textures\Misc\HUDBar.pcx" GROUP="Misc" MIPS=OFF

#exec TEXTURE IMPORT NAME="TargetGreenSmall" FILE="Textures\Misc\TargetGreenSmall.pcx" GROUP="Misc" MIPS=OFF
#exec TEXTURE IMPORT NAME="TargetRedLocked" FILE="Textures\Misc\TargetRedLocked.pcx" GROUP="Misc" MIPS=OFF
#exec TEXTURE IMPORT NAME="TargetRedSmall" FILE="Textures\Misc\TargetRedSmall.pcx" GROUP="Misc" MIPS=OFF


//=============================================================================
// NnFlagBase.
//=============================================================================

#exec TEXTURE IMPORT NAME=BlueBarrel FILE=TEXTURES\FLAGS\BlueBarrel.PCX GROUP="Flags" MIPS=OFF
#exec TEXTURE IMPORT NAME=GreenBarrel FILE=TEXTURES\FLAGS\GreenBarrel.PCX GROUP="Flags" MIPS=OFF
#exec TEXTURE IMPORT NAME=RedBarrel FILE=TEXTURES\FLAGS\RedBarrel.PCX GROUP="Flags" MIPS=OFF
#exec TEXTURE IMPORT NAME=YellowBarrel FILE=TEXTURES\FLAGS\YellowBarrel.PCX GROUP="Flags" MIPS=OFF


//=============================================================================
// Quad.
//=============================================================================

#exec TEXTURE IMPORT NAME=QuadSkin FILE=Textures\Skins\Quadskin.PCX GROUP="Skins"


//=============================================================================
// ITSHUD.
//=============================================================================
// Ob1: ISTHUD now uses 'dw_pen' instead of 'ITS_Pen'
//#exec TEXTURE IMPORT Name=GreenBracket FILE=Textures\ITSHUD\Green_Bracket.PCX MIPS=OFF
//#exec TEXTURE IMPORT Name=ITS_Pen FILE=Textures\ITSHUD\ITS_Pen.PCX MIPS=OFF Flags=2

defaultproperties
{
}
