//=============================================================================
// PlayerPawnSoundInfo.
//=============================================================================
class PlayerPawnSoundInfo extends PawnSoundInfo;

// from Engine.PlayerPawn (Unreal v2.25f)
static function PlayerLanded(pawn Other, vector HitNormal)
{
	/*if ( Other.Role == ROLE_Authority )
		Other.PlaySound(default.Land, SLOT_Interact, 0.3, false, 800, 1.0);
	if ( PlayerPawn(Other).bUpdating )
		return;
	Other.TakeFallingDamage();
	PlayerPawn(Other).bJustLanded = true;*/
	if ( Other.Role == ROLE_Authority )
		Other.PlaySound(default.Land, SLOT_Interact, 0.3, false, 800, 1.0);
	if (Other.Velocity.Z < -1.4 * Other.JumpZ)
	{
		Other.MakeNoise(-0.5 * Other.Velocity.Z/(FMax(Other.JumpZ, 150.0)));
		if (Other.Velocity.Z <= -1100)
		{
			if ( (Other.Velocity.Z < -2000) && (Other.ReducedDamageType != 'All') )
				Other.TakeDamage(1000, None, Other.Location, vect(0,0,0), 'fell');
			else if ( Other.Role == ROLE_Authority )
				Other.TakeDamage(-0.15 * (Other.Velocity.Z + 1050), Other, Other.Location, vect(0,0,0), 'fell');
		}
	}
	else if ( (Other.Level.Game != None) && (Other.Level.Game.Difficulty > 1) && (Other.Velocity.Z > 0.5 * Other.JumpZ) )
		Other.MakeNoise(0.1 * Other.Level.Game.Difficulty);
	Other.bJustLanded = true;
}

static function Dodge(pawn Other, eDodgeDir DodgeMove)
{
	local vector X,Y,Z;

	if ( PlayerPawn(Other).bIsCrouching || (Other.Physics != PHYS_Walking) )
		return;

	GetAxes(Other.Rotation,X,Y,Z);
	if (DodgeMove == DODGE_Forward)
		Other.Velocity = 1.5*Other.GroundSpeed*X + (Other.Velocity Dot Y)*Y;
	else if (DodgeMove == DODGE_Back)
		Other.Velocity = -1.5*Other.GroundSpeed*X + (Other.Velocity Dot Y)*Y;
	else if (DodgeMove == DODGE_Left)
		Other.Velocity = 1.5*Other.GroundSpeed*Y + (Other.Velocity Dot X)*X;
	else if (DodgeMove == DODGE_Right)
		Other.Velocity = -1.5*Other.GroundSpeed*Y + (Other.Velocity Dot X)*X;

	Other.Velocity.Z = 160;
	if ( Other.Role == ROLE_Authority )
		Other.PlaySound(default.JumpSound, SLOT_Talk, 1.0, true, 800, 1.0 );
	PlayerPawn(Other).PlayDodge(DodgeMove);
	PlayerPawn(Other).DodgeDir = DODGE_Active;
	Other.SetPhysics(PHYS_Falling);
}

static function DoJump(pawn Other, optional float F )
{
	if ( Other.CarriedDecoration != None )
		return;
	if ( !PlayerPawn(Other).bIsCrouching && (Other.Physics == PHYS_Walking) )
	{
		if ( Other.Role == ROLE_Authority )
			Other.PlaySound(default.JumpSound, SLOT_Talk, 1.5, true, 1200, 1.0 );
		if ( (Other.Level.Game != None) && (Other.Level.Game.Difficulty > 0) )
			Other.MakeNoise(0.1 * Other.Level.Game.Difficulty);
		Other.PlayInAir();
		if ( PlayerPawn(Other).bCountJumps && (Other.Role == ROLE_Authority) )
			PlayerPawn(Other).Inventory.OwnerJumped();
		Other.Velocity.Z = Other.JumpZ;
		if ( Other.Base != Other.Level )
			Other.Velocity.Z += Other.Base.Velocity.Z;
		Other.SetPhysics(PHYS_Falling);
	}
}

defaultproperties
{
}