//=============================================================================
// DPMSExamplePlayer.
//=============================================================================
class DPMSExamplePlayer extends DynamicPlayer;


// player changed class
function ServerChangeMeshClass(class<Pawn> NewPlayerClass)
{
	if (NewPlayerClass.default.mesh == MeshInfo.default.PlayerMesh)
	{
		Log("ServerChangeClass(): New mesh is same as current, ending function.");
		Log("NewPlayerClass: "$NewPlayerClass$"   Mesh: "$NewPlayerClass.default.mesh);
		Log("MeshInfo: "$MeshInfo$"   Mesh: "$MeshInfo.default.PlayerMesh);
		return;
	}

	// change class
	Log("ServerChangeClass(): Changing player class...");
	DPMSExampleGame(Level.Game).ChangeMeshClass(self, NewPlayerClass);
	MeshInfo.static.CheckMesh(self); // force mesh to update
	UpdateVoicePack();
	PlayWaiting();
}

defaultproperties
{
	DefaultClassPackage="BotPack."
}