//=============================================================================
// PlayerPawnMeshInfo.
//=============================================================================
class PlayerPawnMeshInfo extends PawnMeshInfo;

// from Engine.PlayerPawn (UT v4.02)
static function Taunt(pawn Other, name Sequence )
{
	CheckMesh(Other);

	if ( StaticGetAnimGroup(Sequence) == 'Gesture' )
	{
		PlayerPawn(Other).ServerTaunt(Sequence);
		Other.PlayAnim(Sequence, 0.7, 0.2);
	}
}

static function SwimAnimUpdate(pawn Other, bool bNotForward)
{
	CheckMesh(Other);

	if ( !PlayerPawn(Other).bAnimTransition && (StaticGetAnimGroup(Other.AnimSequence) != 'Gesture') )
	{
		if ( bNotForward )
	 	{
		 	 if ( StaticGetAnimGroup(Other.AnimSequence) != 'Waiting' )
				Other.TweenToWaiting(0.1);
		}
		else if ( StaticGetAnimGroup(Other.AnimSequence) == 'Waiting' )
			Other.TweenToSwimming(0.1);
	}
}

// PlayerWalking.AnimEnd
static function WalkingAnimEnd(pawn Other)
{
	local name MyAnimGroup;

	CheckMesh(Other);

	PlayerPawn(Other).bAnimTransition = false;
	if (Other.Physics == PHYS_Walking)
	{
		if (PlayerPawn(Other).bIsCrouching)
		{
			if ( !PlayerPawn(Other).bIsTurning && ((Other.Velocity.X * Other.Velocity.X + Other.Velocity.Y * Other.Velocity.Y) < 1000) )
				PlayDuck(Other);
			else
				PlayCrawling(Other);
		}
		else
		{
			MyAnimGroup = StaticGetAnimGroup(Other.AnimSequence);
			if ((Other.Velocity.X * Other.Velocity.X + Other.Velocity.Y * Other.Velocity.Y) < 1000)
			{
				if ( MyAnimGroup == 'Waiting' )
					PlayWaiting(Other);
				else
				{
					PlayerPawn(Other).bAnimTransition = true;
					TweenToWaiting(Other,0.2);
				}
			}
			else if (Other.bIsWalking)
			{
				if ( (MyAnimGroup == 'Waiting') || (MyAnimGroup == 'Landing') || (MyAnimGroup == 'Gesture') || (MyAnimGroup == 'TakeHit')  )
				{
					TweenToWalking(Other,0.1);
					PlayerPawn(Other).bAnimTransition = true;
				}
				else
					PlayWalking(Other);
			}
			else
			{
				if ( (MyAnimGroup == 'Waiting') || (MyAnimGroup == 'Landing') || (MyAnimGroup == 'Gesture') || (MyAnimGroup == 'TakeHit')  )
				{
					PlayerPawn(Other).bAnimTransition = true;
					TweenToRunning(Other,0.1);
				}
				else
					PlayRunning(Other);
			}
		}
	}
	else
		PlayInAir(Other);
}

// PlayerWalking.ProcessMove
static function WalkingProcessMove(pawn Other, float DeltaTime, vector NewAccel, eDodgeDir DodgeMove, rotator DeltaRot)
{
	local vector OldAccel;

	CheckMesh(Other);

	OldAccel = Other.Acceleration;
	Other.Acceleration = NewAccel;
	PlayerPawn(Other).bIsTurning = ( Abs(DeltaRot.Yaw/DeltaTime) > 5000 );
	if ( (DodgeMove == DODGE_Active) && (Other.Physics == PHYS_Falling) )
		Other.DodgeDir = DODGE_Active;
	else if ( (DodgeMove != DODGE_None) && (DodgeMove < DODGE_Active) )
		Dodge(Other, DodgeMove);

	if ( PlayerPawn(Other).bPressedJump )
		PlayerPawn(Other).DoJump();
	if ( (Other.Physics == PHYS_Walking) && (StaticGetAnimGroup(Other.AnimSequence) != 'Dodge') )
	{
		if (!PlayerPawn(Other).bIsCrouching)
		{
			if (Other.bDuck != 0)
			{
				PlayerPawn(Other).bIsCrouching = true;
				PlayDuck(Other);
			}
		}
		else if (Other.bDuck == 0)
		{
			OldAccel = vect(0,0,0);
			PlayerPawn(Other).bIsCrouching = false;
			TweenToRunning(Other, 0.1);
		}

		if ( !PlayerPawn(Other).bIsCrouching )
		{
			if ( (!PlayerPawn(Other).bAnimTransition || (PlayerPawn(Other).AnimFrame > 0)) && (StaticGetAnimGroup(Other.AnimSequence) != 'Landing') )
			{
				if ( Other.Acceleration != vect(0,0,0) )
				{
					if ( (StaticGetAnimGroup(Other.AnimSequence) == 'Waiting') || (StaticGetAnimGroup(Other.AnimSequence) == 'Gesture') || (StaticGetAnimGroup(Other.AnimSequence) == 'TakeHit') )
					{
						PlayerPawn(Other).bAnimTransition = true;
						TweenToRunning(Other, 0.1);
					}
				}
				else if ( (Other.Velocity.X * Other.Velocity.X + Other.Velocity.Y * Other.Velocity.Y < 1000)
					&& (StaticGetAnimGroup(Other.AnimSequence) != 'Gesture') )
				{
					if ( StaticGetAnimGroup(Other.AnimSequence) == 'Waiting' )
					{
						if ( PlayerPawn(Other).bIsTurning && (Other.AnimFrame >= 0) )
						{
							PlayerPawn(Other).bAnimTransition = true;
							PlayTurning(Other);
						}
					}
					else if ( !PlayerPawn(Other).bIsTurning )
					{
						PlayerPawn(Other).bAnimTransition = true;
						TweenToWaiting(Other, 0.2);
					}
				}
			}
		}
		else
		{
			if ( (OldAccel == vect(0,0,0)) && (Other.Acceleration != vect(0,0,0)) )
				PlayCrawling(Other);
			else if ( !PlayerPawn(Other).bIsTurning && (Other.Acceleration == vect(0,0,0)) && (Other.AnimFrame > 0.1) )
				PlayDuck(Other);
		}
	}
}

// PlayerWalking.PlayerMove
static function WalkingPlayerMove(pawn Other, float DeltaTime )
{
	local vector X,Y,Z, NewAccel;
	local EDodgeDir OldDodge;
	local eDodgeDir DodgeMove;
	local rotator OldRotation;
	local float Speed2D;
	local bool	bSaveJump;
	local name AnimGroupName;

	CheckMesh(Other);

	GetAxes(Other.Rotation,X,Y,Z);

	PlayerPawn(Other).aForward *= 0.4;
	PlayerPawn(Other).aStrafe  *= 0.4;
	PlayerPawn(Other).aLookup  *= 0.24;
	PlayerPawn(Other).aTurn    *= 0.24;

	// Update acceleration.
	NewAccel = PlayerPawn(Other).aForward*X + PlayerPawn(Other).aStrafe*Y;
	NewAccel.Z = 0;
	// Check for Dodge move
	if ( Other.DodgeDir == DODGE_Active )
		DodgeMove = DODGE_Active;
	else
		DodgeMove = DODGE_None;
	if (PlayerPawn(Other).DodgeClickTime > 0.0)
	{
		if ( Other.DodgeDir < DODGE_Active )
		{
			OldDodge = Other.DodgeDir;
			Other.DodgeDir = DODGE_None;
			if (PlayerPawn(Other).bEdgeForward && PlayerPawn(Other).bWasForward)
				Other.DodgeDir = DODGE_Forward;
			if (PlayerPawn(Other).bEdgeBack && PlayerPawn(Other).bWasBack)
				Other.DodgeDir = DODGE_Back;
			if (PlayerPawn(Other).bEdgeLeft && PlayerPawn(Other).bWasLeft)
				Other.DodgeDir = DODGE_Left;
			if (PlayerPawn(Other).bEdgeRight && PlayerPawn(Other).bWasRight)
				Other.DodgeDir = DODGE_Right;
			if ( Other.DodgeDir == DODGE_None)
				Other.DodgeDir = OldDodge;
			else if ( Other.DodgeDir != OldDodge )
				PlayerPawn(Other).DodgeClickTimer = PlayerPawn(Other).DodgeClickTime + 0.5 * DeltaTime;
			else
				DodgeMove = Other.DodgeDir;
		}

		if (Other.DodgeDir == DODGE_Done)
		{
			PlayerPawn(Other).DodgeClickTimer -= DeltaTime;
			if (PlayerPawn(Other).DodgeClickTimer < -0.35)
			{
				Other.DodgeDir = DODGE_None;
				PlayerPawn(Other).DodgeClickTimer = PlayerPawn(Other).DodgeClickTime;
			}
		}
		else if ((Other.DodgeDir != DODGE_None) && (Other.DodgeDir != DODGE_Active))
		{
			PlayerPawn(Other).DodgeClickTimer -= DeltaTime;
			if (PlayerPawn(Other).DodgeClickTimer < 0)
			{
				Other.DodgeDir = DODGE_None;
				PlayerPawn(Other).DodgeClickTimer = PlayerPawn(Other).DodgeClickTime;
			}
		}
	}

	AnimGroupName = StaticGetAnimGroup(Other.AnimSequence);
	if ( (Other.Physics == PHYS_Walking) && (AnimGroupName != 'Dodge') )
	{
		//if walking, look up/down stairs - unless player is rotating view
		if ( !PlayerPawn(Other).bKeyboardLook && (Other.bLook == 0) )
		{
			if ( PlayerPawn(Other).bLookUpStairs )
				Other.ViewRotation.Pitch = Other.FindStairRotation(deltaTime);
			else if ( PlayerPawn(Other).bCenterView )
			{
				Other.ViewRotation.Pitch = Other.ViewRotation.Pitch & 65535;
				if (Other.ViewRotation.Pitch > 32768)
					Other.ViewRotation.Pitch -= 65536;
				Other.ViewRotation.Pitch = Other.ViewRotation.Pitch * (1 - 12 * FMin(0.0833, deltaTime));
				if ( Abs(Other.ViewRotation.Pitch) < 1000 )
					Other.ViewRotation.Pitch = 0;
			}
		}

		Speed2D = Sqrt(Other.Velocity.X * Other.Velocity.X + Other.Velocity.Y * Other.Velocity.Y);
		//add bobbing when walking
		if ( !PlayerPawn(Other).bShowMenu )
			PlayerPawn(Other).CheckBob(DeltaTime, Speed2D, Y);
	}
	else if ( !PlayerPawn(Other).bShowMenu )
	{
		PlayerPawn(Other).BobTime = 0;
		Other.WalkBob = Other.WalkBob * (1 - FMin(1, 8 * deltatime));
	}

	// Update rotation.
	OldRotation = Other.Rotation;
	PlayerPawn(Other).UpdateRotation(DeltaTime, 1);

	if ( PlayerPawn(Other).bPressedJump && (AnimGroupName == 'Dodge') )
	{
		bSaveJump = true;
		PlayerPawn(Other).bPressedJump = false;
	}
	else
		bSaveJump = false;

	if ( Other.Role < ROLE_Authority ) // then save this move and replicate it
		PlayerPawn(Other).ReplicateMove(DeltaTime, NewAccel, DodgeMove, OldRotation - Other.Rotation);
	else
		PlayerPawn(Other).ProcessMove(DeltaTime, NewAccel, DodgeMove, OldRotation - Other.Rotation);
	PlayerPawn(Other).bPressedJump = bSaveJump;
}

// PlayerSwimming.AnimEnd
static function SwimAnimEnd(pawn Other)
{
	local vector X,Y,Z;

	CheckMesh(Other);

	GetAxes(Other.Rotation, X,Y,Z);
	if ( (Other.Acceleration Dot X) <= 0 )
	{
		if ( StaticGetAnimGroup(Other.AnimSequence) == 'TakeHit' )
		{
			PlayerPawn(Other).bAnimTransition = true;
			Other.TweenToWaiting(0.2);
		}
		else
			Other.PlayWaiting();
	}
	else
	{
		if ( StaticGetAnimGroup(Other.AnimSequence) == 'TakeHit' )
		{
			PlayerPawn(Other).bAnimTransition = true;
			Other.TweenToSwimming(0.2);
		}
		else
			//Other.PlaySwimming();
			PlaySwimming(Other);
	}
}

defaultproperties
{
}