/*=============================================================================
	USetupDefinitionWindows.h: Unreal Windows setup.
	Copyright 1997-1999 Epic Games, Inc. All Rights Reserved.

Revision history:
	* Created by Tim Sweeney.
=============================================================================*/

/*-----------------------------------------------------------------------------
	USetupDefinitionWindows.
-----------------------------------------------------------------------------*/

class USetupDefinitionWindows : public USetupDefinition
{
	DECLARE_CLASS(USetupDefinitionWindows,USetupDefinition,CLASS_Config|CLASS_Localized|CLASS_PerObjectConfig)

	// Windows related variables.
	FString WinPath;
	FString	WinSysPath;
	FString	DesktopPath;
	FString	ProgramsPath;
	FString	FavoritesPath;
	FString	StartupPath;
	FString	CommonProgramsPath;
	FString	CommonFavoritesPath;
	FString CommonStartupPath;
	HANDLE  hWndManager;

	// Functions.
	USetupDefinitionWindows();
	void SetupFormatStrings();
	void ProcessPostCopy( FString Key, FString Value, UBOOL Selected, FInstallPoll* Poll );
	virtual void PreExit();
};

/*-----------------------------------------------------------------------------
	The End.
-----------------------------------------------------------------------------*/
