// ===================================================================
// The Vomitron version 1.0 (The KennyGCD)
// By Zarniwoop (Jess Crable)
// 
// This idea came from the sick mind of Berz, from Quad Design
// (http://www.planetquake.com/quad)
// 
// ===================================================================
// 
// Description:
// 
// The Vomitron is an idea that originally came from Berz, who wanted
// a way to vomit as a player. Rather than modifying the playerclasses
// I felt it was easiest (and funniest) to use this approach:
// 
// You pick the Vomitron up as if it is a voicebox, and you activate it
// in the same manner.  Once activated, the machine begins to play a
// KennyG CD that always results in nausea and vomiting.  Vomiting may
// not be healthy, but you'll be vomiting gib-like projectiles with
// blood explosions that can kill your enemies.  Unfortunately you have
// no control over your vomiting- you can only aim.  
// 
// The idea of using a KennyG song came from Berz, as well.
// Future versions of the Vomitron may include excerpts from other
// horribly annoying things (in a similar manner to the OddBox).
// 
// Submit any bug reports or problems to zarniwoop@planetunreal.com 
// 
// I'm not responsible for any real-life vomiting occuring from hearing
// the excerpt from the KennyG song.
// 
// Go to http://www.planetunreal.com/oddities for more small, unique
// Unreal modifications!
//  
// -------------------------------------------------------------------
// Files:
//  
// Vomitron.u ------>  Put this in your unreal\system directory
//  
// Usage (Important!):
// 
// Type "summon Vomitron.KennyGCD" in order for one to appear!
// 
// -------------------------------------------------------------------
// 
// /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\
// Legal:
// The Vomitron modification and classes contained within this
// modifcation are Copyright (c) 1998, Jess Crable (Zarniwoop).
// You can use the Vomitron in your own levels or modifications, 
// and don't need permission from the author. You MUST give credit
// to the author, though, if you do use this modification.  
//  
// The music that comes with this modification comes from a public
// domain file.
// 
// Also, do not modify this modification without permission from the
// author first. Finally, do not include the Vomitron modification on
// any CD-ROM without the author's permission.
// /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\
// 
// ..Zarniwoop
//   http://www.planetunreal.com/oddities
//   zarniwoop@planetunreal.com

class KennyGCD expands Pickup;

#exec TEXTURE IMPORT NAME=I_VoiceBox FILE=TEXTURES\HUD\i_voice.PCX GROUP="Icons" MIPS=OFF

#exec AUDIO IMPORT FILE="Sounds\Pickups\VOICEB1.WAV" NAME="VoiceSnd" GROUP="Pickups"
#exec AUDIO IMPORT FILE="Sounds\automag\shot.WAV" NAME="shot" GROUP="AutoMag"
#exec AUDIO IMPORT FILE="Sounds\stinger\sshot10d.WAV" NAME="StingerFire" GROUP="Stinger"
#exec AUDIO IMPORT FILE="Sounds\flak\shot1.WAV" NAME="shot1" GROUP="flak"
#exec AUDIO IMPORT FILE="Sounds\flak\Explode1.WAV" NAME="Explode1" GROUP="flak"
#exec AUDIO IMPORT FILE="Sounds\flak\expl2.WAV" NAME="expl2" GROUP="flak"

#exec MESH IMPORT MESH=VoiceBoxMesh ANIVFILE=MODELS\voice_a.3D DATAFILE=MODELS\voice_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=VoiceBoxMesh X=0 Y=0 Z=-15 YAW=64
#exec MESH SEQUENCE MESH=VoiceBoxMesh SEQ=All   STARTFRAME=0  NUMFRAMES=10
#exec MESH SEQUENCE MESH=VoiceBoxMesh SEQ=Pulse STARTFRAME=0  NUMFRAMES=10
#exec TEXTURE IMPORT NAME=Ainv1 FILE=MODELS\inv.PCX GROUP="Skins"
#exec MESHMAP SCALE MESHMAP=VoiceBoxMesh X=0.04 Y=0.04 Z=0.08
#exec MESHMAP SETTEXTURE MESHMAP=VoiceBoxMesh NUM=1 TEXTURE=Ainv1

// These are custom sounds for the Vomitron. They were imported from the
// directory Unreal\sounds\vomitron..

#exec AUDIO IMPORT FILE="Sounds\vomitron\KennyG.WAV" NAME="KennyG" GROUP="Vomitron"
#exec AUDIO IMPORT FILE="Sounds\vomitron\Puke1.WAV" NAME="Puke1" GROUP="Vomitron"


// The Victim- the person activating the Vomitron.	
var pawn Victim;

var int Count;

// Once the Vomitron exists, initialize the variables.
function BeginPlay()
{
	Count=0;
	Victim=Pawn(Owner);
}
	
// Once the player activates the Vomitron this state is called.

state Activated
{
	
	function BeginState()
	{
		// Make the Vomitron invisible.
		
		Mesh=None;
		
		// Move to the Victim's location, and..
		
		SetLocation(Victim.Location);
		
		// Attach itself to the Victim (they can't see it).
		
		SetBase(Victim);
		
		// Begin playing one of the custom sounds imported.

		PlaySound(sound'KennyG', SLOT_Talk, 5.12 * Mass,, 1000);

		// Set the timer to 5.5- don't cycle through it continually
		// (that's what the "False" is for).
		
		SetTimer(5.5, False);		
	}

	function Timer()
	{
		// The time has passed, head to the Vomiting state!
		
		GotoState('Vomiting');
	}
}

state Vomiting
{
	function BeginState()
	{
		// Set a new Timer; this one will be longer- it represents
		// the duration of the vomiting spasms.
		
		SetTimer(19.3, False);
	}

	function Timer()
	{
		// Once time is up, run the function to destroy itself.
		
		Evaporate();
	}
	
	function Evaporate()
	{
		// Make sure the player's view stops shaking.
		
		PlayerPawn(Owner).ShakeView(0,0,0);
		
		// Destroy itself!
		Destroy();
	}

	function Tick (float DeltaTime)
	{
		// Randomly call the shake routine to distort the Victim's
		// view as they vomit.
				
		if (FRand() < 0.2)	
		if (FRand() < 0.2)
		{
		ShakePuker();
		}	
		}

	function ShakePuker()
	{
		// Define some local variables. The first is the actual
		// Gib Projectile, while the next represents how hard the
		// victim's view is shaking.
	
		local GibProjectile carc;
		local float Shake;

		// Play the second imported sound, the puking noise.
		Owner.PlaySound(sound'Puke1', SLOT_Talk, 4*TransientSoundVolume);

		// Set shake to a high value, their view should shake a lot.
		shake =  2500;

		// If it's a PlayerPawn (and not a monster, bot, etc.), shake
		// their view.

		if (PlayerPawn(Owner) != None)
		{
		
		// This calls the ShakeView function located in the PlayerPawn
		// class. The first parameter is the duration, while the second
		// and third parameters control the amount of shaking (RollMag
		// and VertMag in that order).
        //
        // Here's the function's definition straight from the PlayerPawn
        // class:
        //
		// function ShakeView( float shaketime, float RollMag, float vertmag)
		
		PlayerPawn(Owner).ShakeView( 6, shake, 0.05 * shake);
		}

		// Randomness associated with vomiting projectiles or not.
		
		if (FRand() < 0.4)
		{
		
		// If they're a SkaarjPlayer, they are a little taller, so
		// you need to spawn the gib and vomit trail a little higher or
		// it will look like he's vomiting from his neck!
		
		if (PlayerPawn(Owner).IsA('SkaarjPlayer') || Pawn(Owner).IsA('SkaarjPlayerBot'))
		{
			carc=Spawn(class 'GibProjectile',,, Owner.Location + CollisionHeight * vect(0,0,5.8), Owner.Rotation);

			// Randomly adjust the gib's drawscale (size).

			if (FRand() < 0.2)
			carc.DrawScale *=2;
		}
		
		// If it's not a SkaarjPlayer, spawn the gib from a location that
		// makes it look like they are vomiting.
		
		else
		{
		carc = Spawn(class 'GibProjectile',,, Owner.Location + CollisionHeight * vect(0,0,2.8), Owner.Rotation );

		// Random adjust the gib's drawscale (size).

		if (FRand() < 0.2)
		carc.DrawScale *= 2;
		}
		}			
}			
}


// If a player tries to deactivate the Vomitron (it's a CD after
// all, right?) it'll automatically reactivate. You can sort of
// control when your vomiting starts using this, but you'll have
// endure more KennyG sounds, as well! :(

state Deactivated
{
	Function BeginState()
	{
	GotoState('Activated');
	}
}
	

defaultproperties
{
     bCanHaveMultipleCopies=True
     bActivatable=True
     bDisplayableInv=True
     PickupMessage="You got a brand new KennyG CD!"
     PickupViewMesh=Mesh'UnrealI.VoiceBoxMesh'
     Icon=Texture'UnrealI.Icons.RedSkull'
     M_Deactivated="reset!"
     Mesh=Mesh'UnrealI.VoiceBoxMesh'
     AmbientGlow=64
     bMeshCurvy=False
     TransientSoundVolume=2.000000
     CollisionRadius=18.000000
     CollisionHeight=8.000000
}
