//=============================================================================
// The OddBoxes version 3.0:
// OddBox1 (Also Known as the dreaded "Hanson Mine")
// OddBox2 (Also Known as the dreaded "SpiceGirls Mine")
// (c) 1998 by Zarniwoop (Jess Crable):
// ===================================================================
// The OddBoxes are modified versions of the VoiceBox for Unreal. There
// will be several of these available in the future. They will each 
// have unique sounds and some features.
// 
// OddBox1 is also known as the "Hanson Mine". This device is thrown
// in the same manner that the VoiceBox is. The "Hanson Mine" will land
// on the ground and wait for some poor victim to step on it.  Once
// triggered, the OddBox will stick to its victim and play horrible
// excerpts from... Guess! (Look at the name)
// 
// OddBox2 is, in my opinion, a fate just as horrifying OddBox1's.
// Instead of Hanson, this one plays clips from a Spice Girls song.
//
// This is version 3.0.
// 
// Hit <TAB> during a game, and type "summon oddbox.oddbox1" to get
// ahold of the Hanson Mine! 
// 
// Hit <TAB> during a game, and type "summon oddbox.oddbox2" to get
// ahold of the Spice Girls Mine!
// -------------------------------------------------------------------
// Files: OddBox.u   -> Put this in your Unreal/system directory.
// ==================================================================
// 
// Go to www.planetunreal.com/oddities for more small, unique Unreal
// modifications!
// 
// /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\
// Legal:
// The OddBox modification and classes contained within this
// modifcation are Copyright (c) 1998, Jess Crable (Zarniwoop).
// You can use the OddBox modification in your own levels or
// modifications, and don't need permission from the author. You
// MUST give credit to the author, though, if you do use this
// mod.  
// 
// Also, do not modify this modification without permission from the
// author first. Finally, do not include the OddBox modification on
// any CD-ROM without the author's permission.
// The sounds that come with this modification are from public domain
// ".wav" files.
// /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\
// 
// ..Zarniwoop
//   http://www.planetunreal.com/oddities
//   zarniwoop@planetunreal.com



class OddBox1 expands VoiceBox;

// This will import the new sounds to your ".U" file. In this case, it imported
// sounds from my unreal/sounds/oddbox directory.

#exec AUDIO IMPORT FILE="Sounds\oddbox\hanson1.WAV" NAME="hanson1" GROUP="OddBox1"
#exec AUDIO IMPORT FILE="Sounds\oddbox\hanson2.WAV" NAME="hanson2" GROUP="OddBox1"
#exec AUDIO IMPORT FILE="Sounds\oddbox\hanson3.WAV" NAME="hanson3" GROUP="OddBox1"																		

// The victim is the player to whom the OddBox is attached.

var Pawn Victim;

function BeginPlay()
{
	// Execute the parent class's BeginPlay function.
	
	Super.BeginPlay();
	
	// Set it to falling (without this, it would spawn and appear to
	// be hanging in midair before you pick it up.
	
	SetPhysics(PHYS_Falling);
}

// Most (but not all) of this comes from the generic VoiceBox
// Activated state. I had to make some changes, though, since
// the OddBox behaves differently.

state Activated  // Delete from inventory and toss in front of player.
{

	function HitWall (vector HitNormal, actor Wall)
	{
		Velocity = 0.5*(( Velocity dot HitNormal ) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
		PlaySound(Sound 'GrenadeFloor', SLOT_Misc, VSize(Velocity)/1300 );
	
		// If it's moving slowly enough, stop bouncing, stop moving,
		// and head to the Waiting state.
		
		If (VSize(Velocity) < 20)
		{
			bBounce = False;
			SetPhysics(PHYS_None);
			GotoState('Waiting');
		}
	}
	
// Most of what follows under "Begin" comes from the VoiceBox, too.
// This is what happens when it's activated and thrown from the player.

Begin:
	// Get the player's view rotation so it knows where to throw from.

	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);

	// Set its new location before thrown..
	SetLocation(Pawn(Owner).Location+X*10+Y*8-Z*20);
    Enable('Touch');
	bBounce=True;	
	// Set up the new velocity, rotation, etc. for the OddBox..
	Velocity = Owner.Velocity + Vector(Owner.Rotation) * 150.0;
	Velocity.z += 240;         
	DesiredRotation = RotRand();
	RotationRate.Yaw = 20000*FRand() - 10000;
	RespawnTime = 60.0; 
	SetPhysics(PHYS_Falling);
	RemoteRole = ROLE_DumbProxy;
	BecomePickup();
	bCollideWorld = true;
	// Adjust the player's inventory..
	Pawn(Owner).NextItem();
	if (Pawn(Owner).SelectedItem == Self) Pawn(Owner).SelectedItem=None;	
	Owner.PlaySound(ActivateSound);		
	// Remove itself from the inventory..
	Pawn(Owner).DeleteInventory(Self);	
	bStasis=false;
}

state Waiting
{
	// The first thing that happens here is the OddBox's appearance
	// shifts to translucent, so it won't be as easily noticeable on
	// the ground (making people more prone to running over it). 
	// It then calls (loops) the Timer function at a fast rate; each
	// time the timer is called the OddBox's DrawScale diminishes 
	// until it's about 70% of its normal size.
	
	function BeginState()
	{
		Style=STY_Translucent;
		SetTimer(0.1, True);
	}
	
	function Timer()
	{
		if (DrawScale > 0.7)
			DrawScale -= 0.01;
	}
	
	// When some poor sap runs over the OddBox...
	function Touch(Actor Other)
	{
		// First, turn solid again.
		
		Style=STY_Normal;

		// Attach itself to the person or monster and head to the
		// Playing state.
		
		if (Pawn(Other) != NONE)
		{
		SetOwner(Other);
		SetBase(Other);
		GotoState('Playing');
		}
	}

}

state Playing
{
	
	// Similar to the Waiting state, this state starts with a looping
	// timer call at a fast rate. The OddBox also starts pulsing, using
	// the VoiceBox's pulse animation.
	function BeginState()
	{
		bStasis = false;
		SetTimer(0.1,True);
		LoopAnim('Pulse');
	}	

	// The timer does a few things here.
	function Timer()
	{
		local int i;

		// If the size of the OddBox isn't 3 times the normal VoiceBox
		// size, keep growing! This makes it more annoying.

		if (DrawScale < 3.0)
			DrawScale += 0.1;

		// Set up a loop, this is the same loop that the VoiceBox uses.
		// It picks one of the sounds and plays it with a random volume.
		// BattleSounds[] is inherited from the VoiceBox- it has 10 slots.
		// Rather than limiting the slots, I left it at 10 in case of future
		// sounds that might be added.

		for (i=0 ; i<10 ; i++) 
			if (FRand()<0.05 && BattleSounds[i]!=None) 
			PlaySound(BattleSounds[i], SLOT_TALK, FRand()/2+0.9);

		// Now the OddBox's charge is lowered.  Once the charge
		// reaches 0, the OddBox is killed.  

		Charge--;

		// Check the charge and the owner's health; if the charge
		// is 0 or he or she is dead, kill the box.
		
		if (Charge<=0 || Pawn(Owner).Health <= 0) 
		KillBox();
	}
	
	function KillBox()
	{
		// Generate a little puff of smoke.
		spawn(class'RisingSpriteSmokePuff',,,Location + vect(0,0,1)*16); 

		// Play the sound of one of the female players dying. This
		// may need to be modified in 20 years when the members of
		// Hanson hit puberty.
		
		PlaySound(sound'death3cfem', SLOT_Talk, FRand()/2+0.5);																				
		Destroy();
	}		

}

defaultproperties
{
     BattleSounds(0)=Sound'Oddbox.OddBox1.hanson1'
     BattleSounds(1)=Sound'Oddbox.OddBox1.hanson2'
     BattleSounds(2)=Sound'Oddbox.OddBox1.hanson3'
     BattleSounds(3)=None
     BattleSounds(4)=None
     BattleSounds(5)=None
     BattleSounds(6)=None
     BattleSounds(7)=None
     BattleSounds(8)=None
     BattleSounds(9)=None
     PickupMessage="You got a Hanson Mine!"
     Charge=200
     SoundVolume=49
     SoundPitch=37
     AmbientSound=Sound'UnrealI.General.BRocket'
}
