//=============================================================================
// NoWeapon - Starts the player without the Dispersion Pistol
//
// GreyGore
//	greygore@unrealized.com
//	http://www.unrealized.com/
//
// I created this file in response to the number of requests I've gotten about
//	creating a level where the player starts without the Dispersion Pistol.
//
// Since Epic shipped Unreal without having a way to turn off the default
//	weapon short of using VRikersGame (with the associated view and health
//	changes), I decided to take a few minutes and whip this class up.
//
// Please feel free to include this file in any maps you create, you don't
//	even have to credit me, just keep visiting Unrealized!
//
// To use this file you need to do three things:
//
// 1. To use the NoWeapon class in UnrealEd, open up your Unreal.ini file in
//		your favorite text editor. Find the section labelled:
//			
//			[EditPackages]
//
//		and add 'NoWeapon' (minus the quotes) to the first available slot.
//
// 2. In the level you want to change the Default Weapon for, go to the
//		Options menu and select Level Properties (or press F6). You want to
//		edit the following Property:
//
//			LevelInfo->DefaultGameType
//
//		Change this from None to the NoWeapon class found in:
//
//			Info->GameInfo->UnrealGameInfo
//
// 3. Lastly, you need to include the NoWeapon.u file with every level that
//		utilizes it. Instruct the user to place the NoWeapon.u file in their
//		Unreal\System directory and they should be able to play your level!
//
// Please email me (greygore@unrealized.com) if you have any problems!
//
//=============================================================================
class NoWeapon expands UnrealGameInfo;

function AddDefaultInventory(pawn PlayerPawn)
{
	return;
}

function bool PickupQuery(Pawn Other, Inventory item)
{
	if ( item.IsA('DispersionPistol') )
		DefaultWeapon = class'DispersionPistol';
	return Super.PickupQuery(Other, item);
}

defaultproperties
{
}
