//=============================================================================
// TeamMover - A mover than triggers only if the team number of the actor
// trying to activate it is the same as Team.
//
// Supports the BumpOpenTimed, BumpButton, and StandOpenTimed states.
//
// Written by Adam W. Stiles - inspired by the KeyMover class posted at
//   Chimeric - http://www.planetunreal.com/chimeric
// Reuse permitted, distribution permitted as long as original documentation
//   remains intact.  
// This code MAY be used as a basis for other mods - please include a note
//   with a link to http://www.planetunreal.com/muad  so that people know
//   what code it was based on! :)
//=============================================================================
class TeamMover expands Mover;

var() byte Team;

state() BumpOpenTimed
{
	function Bump(actor Other)
	{
		// Check to see if this is a Team Game, if not then there is no
		// need to be using a TeamMover - do nothing and exit
		if (!Level.Game.IsA('TeamGamePlus'))
			return;

		// First check to make sure this is a Pawn
		if (Other.IsA('Pawn'))
		{
			// If so, check the team of the instigator.  If same team
			// then use the regular mover Bump() function
			if (TeamGamePlus(Level.Game).IsOnTeam(Other.Instigator, Team))
			{
				Super.Bump(Other);
			}
		}
	}
}

state() BumpButton
{
	function Bump(actor Other)
	{
		// Check to see if this is a Team Game, if not then there is no
		// need to be using a TeamMover - do nothing and exit
		if (!Level.Game.IsA('TeamGamePlus'))
			return;
			
		// First check to make sure this is a Pawn
		if (Other.IsA('Pawn'))
		{
			// If so, check the team of the instigator.  If same team
			// then use the regular mover Bump() function
			if (TeamGamePlus(Level.Game).IsOnTeam(Other.Instigator, Team))
			{
				Super.Bump(Other);
			}
		}
	}
}

state() StandOpenTimed
{
	function Attach(actor Other)
	{
		// Check to see if this is a Team Game, if not then there is no
		// need to be using a TeamMover - do nothing and exit
		if (!Level.Game.IsA('TeamGamePlus'))
			return;
			
		// First check to make sure this is a Pawn
		if (Other.IsA('Pawn'))
		{
			// If so, check the team of the instigator.  If same team
			// then use the regular mover Attach() function
			if (TeamGamePlus(Level.Game).IsOnTeam(Other.Instigator, Team))
			{
				Super.Attach(Other);
			}
		}
	}
}
