//=============================================================================
// NaliSorcerer.
// Copyright (c), 1998 Christopher Gariando
//
// Version 1.0
//
// Author: Chris "tacosalad" Gariando
// Contact: seegar@wolfenet.com
//
// Known Issues:
//	None at this time.  If you run into any bugs, please e-mail me 
//	at seegar@wolfenet.com
//
//
// IMPORTANT!
//  taco-NaliSorc.utx must be in your unreal/textures directory. NaliSorcerer uses
//	this file not only for the modified skins, but the texture
//	map used for SKILL_Fade is also contained in this file.
//
//
// Class Info:
//	I tried to make the Sorcerer as configurable as possible, so that
//	mappers who were unfamiliar with unrealscript could easily create subclasses
//	without having to write any new code. By editing the Properties
//	you can change things like: SpellType, SpellLevel, SkillType, MeleeDamage
//  and so on.
//
//	Spells:
//
//		Energy Bolt - Fires 2-5 projectiles(Depends on SpellLevel) that
//			inflict 7 points of damage each.
//
//		Flame Strike - Fires 2-5 projectiles(Depends on SpellLevel) that
//			inflict 10 points of damage	each.
//
//		Anti Matter Blast - Fires 2-5 projectiles(Depends on SpellLevel)
//			that inflict 13 points of damage each.
//
//		Ice Storm - Fires 4-18 projectiles(Depends on SpellLevel) that
//			inflict 5 points of damage each.
//
//	Skills:
//
//		Heal - Heals 7-110 points of damage(Depends on SpellLevel)
//
//		Stun - Inflicts minor damage and knocks target backwards.
//
//		Fade - Becomes invisible until Health falls below a certain point.
//
//	Melee:
//
//		Psionic Shockwave - Creates a concentrated burst of psionic energy
//			that causes damage to all creatures within range.
//
//
// Story:
//	Four Nali clans, outcast for practicing the black art, now compete for
//	control of their world and beyond... (that's it.. I'm not much of a
//	story teller)
//
//
// Special Notes:
//	If you expand on the NaliSorcerer class, please be sure to save your
// 	new classes to a new package. If you don't, upgrading to newer versions
//  of the taco-Pawns package could wipe out any classes you've created.
//
//
// Legal:
//	The taco-NaliSorc package may only be transmitted by electronic means.
//  You may deploy the taco-NaliSorc package with your user created level
//  without notifying the author, but you MUST GIVE CREDIT TO THE AUTHOR.
//  You MAY NOT modify the taco-NaliSorc package, in whole or in part, without
//  express written permission from the author.  You MAY NOT include the taco-NaliSorc
//  package on a CD-ROM, in whole or in part, without express written permission
//  of the author.  If you deploy the taco-NaliSorc package, it must be the complete
//  package, as described in the package.manifest file.
//  You MAY use the code within the taco-NaliSorc package as a basis for your
//  own classes as long as you GIVE CREDIT TO THE AUTHOR.
//  This package and every class in this package is Copyright (c) 1998, Christopher Gariando.
//
//  ENJOY!
//
//  Thanks go to Brandon "GreenMarine" Reinhart for the legal verbage.
//
//=============================================================================
class NaliSorcerer expands Nali abstract;

//=============================================================================
// Let's declare some variables

var() byte MeleeDamage;

var() enum ESpellLevel
{
	SPELLLEVEL_Novice,
	SPELLLEVEL_Adept,
	SPELLLEVEL_Master,
	SPELLLEVEL_God,
} SpellLevel;

var() enum ESpell
{
	SPELL_EnergyBolt,
	SPELL_FlameStrike,
	SPELL_AntiMatterBlast,
	SPELL_IceStorm
} SpellAttack;

var() enum ESkills
{
	SKILL_Heal,
	SKILL_Stun,
	SKILL_Fade,
} SpecialSkill;

var bool faded;
var byte defaultHealth;
var texture textContainer;

//=============================================================================
// Okay. Let's get started!

function PostBeginPlay()
{
	DefaultHealth = Health;		// Remember what the default health is, cuz SKILL_Fade is based on this
	textContainer = Skin;		// Remember what the default Skin is, cuz it changes when SKILL_Fade is used.
	
	Super.PostBeginPlay();
	bCanSpeak = true;
	if ( Orders == 'Ambushing' )
		AnimSequence = 'Levitate';
}

//=============================================================================
// Adjusted Nali AI (I'm not a WUSS Anymore!!)

function eAttitude AttitudeWithFear()
{
	return ATTITUDE_Hate;
}

function Killed(pawn Killer, pawn Other, name damageType)
{
	if ((Nali(Other) != None) && Killer.bIsPlayer)
		AttitudeToPlayer = ATTITUDE_Hate;
	Super.Killed(Killer, Other, damageType);
}

function damageAttitudeTo(pawn Other)
{
	local eAttitude OldAttitude;
	
	if ((Other == Self) || (Other == None) || (FlockPawn(Other) != None))
		return;
	if (Other.bIsPlayer)
		AttitudeToPlayer = ATTITUDE_Hate;
	else if (ScriptedPawn(Other) == None)
		Hated = Other;
	SetEnemy(Other);
}

function eAttitude AttitudeToCreature(Pawn Other)
{
	if (Other.IsA('NaliSorcerer'))
		return ATTITUDE_Ignore;
	else
		return ATTITUDE_Hate;
}

//=============================================================================
// My combat move is 'run' while the other Nali 'walk'.

function PlayCombatMove()
{

	if ((faded == True) && (Health < defaultHealth/3))
		UnFade();

	if (Region.Zone.bWaterZone)
	{
		PlaySwimming();
		return;
	}
	LoopAnim('Run', -1.3/GroundSpeed,,0.4);
}

//=============================================================================
// You want a piece of me?

function PlayChallenge()
{
	if (Region.Zone.bWaterZone)
	{
		PlaySwimming();
		return;
	}
	else 
		PlayAnim('Breath');
		PlaySound(Breath, SLOT_Interact,,,2000);
}

//=============================================================================
// You want a piece of me? - Part 2

function PlayThreatening()
{
	if (Region.Zone.bWaterZone)
	{
		PlaySwimming();
		return;
	}
	else 
		PlayAnim('Breath');
		PlaySound(Sweat, SLOT_Interact,,,2000);
}

//=============================================================================
// Better luck next time, Grasshopper.

function PlayVictoryDance()
{
	PlayAnim('Bow2');
}
//=============================================================================
// I can cast spells!

function SpawnEnergyBolt()
{
	local int i;
	local vector projStart,X,Y,Z;
	local Rotator AltRotation;

	PlayAnim('Pray');
	PlaySound(sound'CannonShot', SLOT_Interact,,,2000);
	if (faded == False)
		Spawn( class'TazerExplosion',,,Location);
	
	// log("Casting Flame Strike");
	
	if (SpellLevel == SPELLLEVEL_Novice)
		for (i = 0; i< 2; i++)
		{
			projStart = Location + 0.9 * CollisionRadius * X + 0.9 * CollisionRadius * Y + 0.4 * CollisionHeight * Z;
			AltRotation = AdjustAim(ProjectileSpeed, projStart, 100, bLeadTarget, bWarnTarget); 
			AltRotation.Pitch += FRand()*500-250;
			AltRotation.Yaw += FRand()*500-250;
			AltRotation.Roll += FRand()*1000-500; 
			spawn(class'tacoEBolt',self,'',projStart, AltRotation);
		}
	if (SpellLevel == SPELLLEVEL_Adept)
	{
		for (i = 0; i< 3; i++)
		{
			projStart = Location + 0.9 * CollisionRadius * X + 0.9 * CollisionRadius * Y + 0.4 * CollisionHeight * Z;
			AltRotation = AdjustAim(ProjectileSpeed, projStart, 100, bLeadTarget, bWarnTarget); 
			AltRotation.Pitch += FRand()*500-250;
			AltRotation.Yaw += FRand()*500-250;
			AltRotation.Roll += FRand()*1000-500; 
			spawn(class'tacoEBolt',self,'',projStart, AltRotation);
		}
	}
	if (SpellLevel == SPELLLEVEL_Master)
	{
		for (i = 0; i< 4; i++)
		{
			projStart = Location + 0.9 * CollisionRadius * X + 0.9 * CollisionRadius * Y + 0.4 * CollisionHeight * Z;
			AltRotation = AdjustAim(ProjectileSpeed, projStart, 100, bLeadTarget, bWarnTarget); 
			AltRotation.Pitch += FRand()*500-250;
			AltRotation.Yaw += FRand()*500-250;
			AltRotation.Roll += FRand()*1000-500; 
			spawn(class'tacoEBolt',self,'',projStart, AltRotation);
		}
	}
	if (SpellLevel == SPELLLEVEL_God)
	{
		for (i = 0; i< 5; i++)
		{
			projStart = Location + 0.9 * CollisionRadius * X + 0.9 * CollisionRadius * Y + 0.4 * CollisionHeight * Z;
			AltRotation = AdjustAim(ProjectileSpeed, projStart, 100, bLeadTarget, bWarnTarget); 
			AltRotation.Pitch += FRand()*500-250;
			AltRotation.Yaw += FRand()*500-250;
			AltRotation.Roll += FRand()*1000-500; 
			spawn(class'tacoEBolt',self,'',projStart, AltRotation);
		}
	}
}

function SpawnFlameStrike()
{
	local int i;
	local vector projStart,X,Y,Z;
	local Rotator AltRotation;

	PlayAnim('Pray');
	PlaySound(sound'Expl03', SLOT_Interact,,,2000);
	if (faded == False)
		Spawn( class'RingExplosion3',,,Location);
	
	// log("Casting Flame Strike");
	
	if (SpellLevel == SPELLLEVEL_Novice)
		for (i = 0; i< 2; i++)
		{
			projStart = Location + 0.9 * CollisionRadius * X + 0.9 * CollisionRadius * Y + 0.4 * CollisionHeight * Z;
			AltRotation = AdjustAim(ProjectileSpeed, projStart, 100, bLeadTarget, bWarnTarget); 
			AltRotation.Pitch += FRand()*500-250;
			AltRotation.Yaw += FRand()*500-250;
			AltRotation.Roll += FRand()*1000-500; 
			spawn(class'tacoFStrike',self,'',projStart, AltRotation);
		}
	if (SpellLevel == SPELLLEVEL_Adept)
	{
		for (i = 0; i< 3; i++)
		{
			projStart = Location + 0.9 * CollisionRadius * X + 0.9 * CollisionRadius * Y + 0.4 * CollisionHeight * Z;
			AltRotation = AdjustAim(ProjectileSpeed, projStart, 100, bLeadTarget, bWarnTarget); 
			AltRotation.Pitch += FRand()*500-250;
			AltRotation.Yaw += FRand()*500-250;
			AltRotation.Roll += FRand()*1000-500; 
			spawn(class'tacoFStrike',self,'',projStart, AltRotation);
		}
	}
	if (SpellLevel == SPELLLEVEL_Master)
	{
		for (i = 0; i< 4; i++)
		{
			projStart = Location + 0.9 * CollisionRadius * X + 0.9 * CollisionRadius * Y + 0.4 * CollisionHeight * Z;
			AltRotation = AdjustAim(ProjectileSpeed, projStart, 100, bLeadTarget, bWarnTarget); 
			AltRotation.Pitch += FRand()*500-250;
			AltRotation.Yaw += FRand()*500-250;
			AltRotation.Roll += FRand()*1000-500; 
			spawn(class'tacoFStrike',self,'',projStart, AltRotation);
		}
	}
	if (SpellLevel == SPELLLEVEL_God)
	{
		for (i = 0; i< 5; i++)
		{
			projStart = Location + 0.9 * CollisionRadius * X + 0.9 * CollisionRadius * Y + 0.4 * CollisionHeight * Z;
			AltRotation = AdjustAim(ProjectileSpeed, projStart, 100, bLeadTarget, bWarnTarget); 
			AltRotation.Pitch += FRand()*500-250;
			AltRotation.Yaw += FRand()*500-250;
			AltRotation.Roll += FRand()*1000-500; 
			spawn(class'tacoFStrike',self,'',projStart, AltRotation);
		}
	}
}

function SpawnIceStorm()
{
	local int i;
	local vector Start,X,Y,Z;
	local Rotator StartRot, AltRotation;

	StartRot = Rotation;
	Start = Location;
	
	PlayAnim('Pray');
	PlaySound(sound'Expla02', SLOT_Interact,,,2000);
	if (faded == False)
		Spawn( class'ParticleBurst2',,,Location);
	
	// log("Casting Ice Storm");
	
	if (SpellLevel == SPELLLEVEL_Novice)
	{
		for (i = 0; i< 4; i++)
		{
			AltRotation = StartRot;
			AltRotation.Pitch += FRand()*2000-1000;
			AltRotation.Yaw += FRand()*2000-1000;
			AltRotation.Roll += FRand()*2000-1000;				
			Spawn(class'tacoIceShard',,, Start - 2 * VRand(), AltRotation);
		}
	}
	if (SpellLevel == SPELLLEVEL_Adept)
	{
		for (i = 0; i< 8; i++)
		{
			AltRotation = StartRot;
			AltRotation.Pitch += FRand()*2000-1000;
			AltRotation.Yaw += FRand()*2000-1000;
			AltRotation.Roll += FRand()*2000-1000;				
			Spawn(class'tacoIceShard',,, Start - 2 * VRand(), AltRotation);
		}
	}
	if (SpellLevel == SPELLLEVEL_Master)
	{
		for (i = 0; i< 12; i++)
		{
			AltRotation = StartRot;
			AltRotation.Pitch += FRand()*2000-1000;
			AltRotation.Yaw += FRand()*2000-1000;
			AltRotation.Roll += FRand()*2000-1000;				
			Spawn(class'tacoIceShard',,, Start - 2 * VRand(), AltRotation);
		}
	}
	if (SpellLevel == SPELLLEVEL_God)
	{
		for (i = 0; i< 18; i++)
		{
			AltRotation = StartRot;
			AltRotation.Pitch += FRand()*2000-1000;
			AltRotation.Yaw += FRand()*2000-1000;
			AltRotation.Roll += FRand()*2000-1000;				
			Spawn(class'tacoIceShard',,, Start - 2 * VRand(), AltRotation);
		}
	}
}

function SpawnAntiMatterBlast()
{
	local int i;
	local vector projStart,X,Y,Z;
	local Rotator AltRotation;

	PlayAnim('Pray');
	PlaySound(sound'SpecialExpl', SLOT_Interact,,,2000);
	if (faded == False)
		Spawn(class'WaterRing',,,Location);

	// log("Casting AntiMatter");
	
	if (SpellLevel == SPELLLEVEL_Novice)
	{
		for (i = 0; i< 2; i++)
		{
			projStart = Location + 0.9 * CollisionRadius * X + 0.9 * CollisionRadius * Y + 0.4 * CollisionHeight * Z;
			AltRotation = AdjustAim(ProjectileSpeed, projStart, 100, bLeadTarget, bWarnTarget); 
			AltRotation.Pitch += FRand()*500-250;
			AltRotation.Yaw += FRand()*500-250;
			AltRotation.Roll += FRand()*1000-500; 
			spawn(class'tacoAntiMatter',self,'',projStart, AltRotation);
		}
	}
	if (SpellLevel == SPELLLEVEL_Adept)
	{
		for (i = 0; i< 3; i++)
		{
			projStart = Location + 0.9 * CollisionRadius * X + 0.9 * CollisionRadius * Y + 0.4 * CollisionHeight * Z;
			AltRotation = AdjustAim(ProjectileSpeed, projStart, 100, bLeadTarget, bWarnTarget); 
			AltRotation.Pitch += FRand()*500-250;
			AltRotation.Yaw += FRand()*500-250;
			AltRotation.Roll += FRand()*1000-500; 
			spawn(class'tacoAntiMatter',self,'',projStart, AltRotation);
		}
	}
	if (SpellLevel == SPELLLEVEL_Master)
	{
		for (i = 0; i< 4; i++)
		{
			projStart = Location + 0.9 * CollisionRadius * X + 0.9 * CollisionRadius * Y + 0.4 * CollisionHeight * Z;
			AltRotation = AdjustAim(ProjectileSpeed, projStart, 100, bLeadTarget, bWarnTarget); 
			AltRotation.Pitch += FRand()*500-250;
			AltRotation.Yaw += FRand()*500-250;
			AltRotation.Roll += FRand()*1000-500; 
			spawn(class'tacoAntiMatter',self,'',projStart, AltRotation);
		}
	}
	if (SpellLevel == SPELLLEVEL_God)
	{
		for (i = 0; i< 5; i++)
		{
			projStart = Location + 0.9 * CollisionRadius * X + 0.9 * CollisionRadius * Y + 0.4 * CollisionHeight * Z;
			AltRotation = AdjustAim(ProjectileSpeed, projStart, 100, bLeadTarget, bWarnTarget); 
			AltRotation.Pitch += FRand()*500-250;
			AltRotation.Yaw += FRand()*500-250;
			AltRotation.Roll += FRand()*1000-500; 
			spawn(class'tacoAntiMatter',self,'',projStart, AltRotation);
		}
	}
}

//=============================================================================
// This will knock you out of your socks!

function CastStun()
{
	local rotator FireRotation;
	local vector X,Y,Z, projStart;

	PlayAnim('Spell');
	Spawn(class'Tazerexplosion',,,Location);
	
	// log("I am tossing you around like a rag doll");

	GetAxes(Rotation,X,Y,Z);
	MakeNoise(1.0);
	projStart = Location + 0.9 * CollisionRadius * X + 0.9 * CollisionRadius * Y + 0.4 * CollisionHeight * Z;
	FireRotation = AdjustAim(ProjectileSpeed, projStart, 400, bLeadTarget, bWarnTarget);  
	spawn(class'tacoStunProj',self,'',projStart, FireRotation);
}

//=============================================================================
// I can Heal Myself!

function CastHealing()
{
	
	PlayAnim('Spell');
	Spawn( class'tacoHealEffect',,,Location);
	PlaySound(sound'Teleport1', SLOT_Interact,,,2000);
	
	// log("I am healing");
	
	if (SpellLevel == SPELLLEVEL_Novice)
		Health = Health + (1 + Rand(6) * 7);
		
	if (SpellLevel == SPELLLEVEL_Adept)
		Health = Health + (3 + Rand(6)) * 7;
		
	if (SpellLevel == SPELLLEVEL_Master)
		Health = Health + (5 + Rand(6)) * 7;
		
	if (SpellLevel == SPELLLEVEL_God)
		Health = Health + (5 + Rand(6)) * 10;
	
	// log(Health);
	
	// log("Done Healing");
}

//=============================================================================
// Now you see me, now you don't.

function CastFade()
{
	
	PlayAnim('Spell');
	Spawn( class'tacoHealEffect',,,Location);
	PlaySound(sound'RespawnSound', SLOT_Interact,,,2000);
	
	// log("Cloaking device activated, Captain");
	
	Skin = texture'NaliSorcF';
	Style = STY_Translucent;
	AmbientGlow = 255;
	ScaleGlow = 2.0;
	
	faded = True;
}

function UnFade()
{

	Spawn( class'tacoHealEffect',,,Location);
	PlaySound(sound'RespawnSound', SLOT_Interact,,,2000);
	// log("Not enought power left for cloaking device");

	Skin = textContainer;
	Style = STY_None;
	AmbientGlow = 0;
	ScaleGlow = 1.0;
	
	faded = False;
}

//=============================================================================
// My melee attack is slow but good.

function PlayMeleeAttack()
{
	if ((Health < 50) && (SpecialSkill == SKILL_Heal))
		CastHealing();
	else
	{
		Spawn(class'Tazerexplosion',,,Location);
		
		// log("Start melee attack");
		
		PlayAnim('Spell');
 		MeleeDamageTarget(MeleeDamage, (MeleeDamage * 900 * Normal(Target.Location - Location)));
 	}
}

//=============================================================================
// Perform Ranged Attack

state RangedAttack
{
ignores SeePlayer, HearNoise;

	function PlayRangedAttack()
	{
		local float dist;
		local float attackType;
		
		log(Health);
		log(defaultHealth);
		
		dist = VSize(Target.Location - Location + vect(0,0,1) * (CollisionHeight - Target.CollisionHeight));

		Disable('Bump');
		
		// is it time to heal?  If so, and we can then DO IT!
		
		if ((Health < defaultHealth/3) && (SpecialSkill == SKILL_Heal))
			CastHealing();
		
		// Can we cast Fade? Are we gonna? If so, DO IT!
		
		if ((Rand(11) >= 7) && (SpecialSkill == SKILL_Fade) && (faded == False) && (Health > defaultHealth/2))
			CastFade();
		
		// Can we stun? Are we close enough? If so, DO IT!
		
		else if ((dist < 180 + CollisionRadius + Target.CollisionRadius) && (SpecialSkill == SKILL_Stun) && (FRand() < 0.7))
			CastStun();
	
		else if (SpellAttack == SPELL_EnergyBolt)
			SpawnEnergyBolt();
			
		else if (SpellAttack == SPELL_AntiMatterBlast)
			SpawnAntiMatterBlast();
				
		else if (SpellAttack == SPELL_IceStorm)
			SpawnIceStorm();
			
		else if (SpellAttack == SPELL_FlameStrike)
			SpawnFlameStrike();
		else
			return;
	}
}

//=============================================================================
// I will not teleport out, but wait to fight again!

state FadeOut
{
	ignores HitWall, EnemyNotVisible, HearNoise, SeePlayer;

	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
							Vector momentum, name damageType)
	{
		Global.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);
		if ( health <= 0 )
			return;
		if (NextState == 'TakeHit')
		{
			NextState = 'Attacking'; 
			NextLabel = 'Begin';
			GotoState('TakeHit'); 
		}
		else if ( Enemy != None )
			GotoState('Attacking');
	}
	
	function Tick(float DeltaTime)
	{
		gotostate('Guarding');
	}

	function BeginState()
	{
		bFading = false;
		Disable('Tick');
	}

	function EndState()
	{
		bUnlit = false;
		Style = STY_Normal;
		ScaleGlow = 1.0;
		fatness = Default.fatness;
	}

Begin:
	Acceleration = Vect(0,0,0);
	if ( NearWall(100) )
	{
		PlayTurning();
		TurnTo(Focus);
	}
	PlayAnim('Levitate', 0.3, 1.0);
	FinishAnim();
	PlayAnim('Levitate', 0.3);
	FinishAnim();
	LoopAnim('Levitate', 0.3);
	Enable('Tick');
}

defaultproperties
{
     SpellLevel=SPELLLEVEL_Master
     SpellAttack=SPELL_AntiMatterBlast
     Aggressiveness=0.400000
     bCanStrafe=True
     JumpZ=325.000000
     Health=185
     AttitudeToPlayer=ATTITUDE_Hate
     CombatStyle=0.400000
     Skin=Texture'taco-NaliSorc.Skins.NaliSorc1'
}
