// TimeHUDDlg.cpp : implementation file
//

#include "stdafx.h"
#include "TimeHUD.h"
#include "TimeHUDDlg.h"
#include "Threads.h"
//#include "LaunchTribes.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTimeHUDDlg dialog

CTimeHUDDlg::CTimeHUDDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTimeHUDDlg::IDD, pParent),
	m_mutex(FALSE, NULL)
{
	//{{AFX_DATA_INIT(CTimeHUDDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_pUpdateThread = NULL;
	m_pLaunchThread = NULL;
}

void CTimeHUDDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTimeHUDDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTimeHUDDlg, CDialog)
	//{{AFX_MSG_MAP(CTimeHUDDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTimeHUDDlg message handlers

BOOL CTimeHUDDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	_tzset();
	
	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	m_pLaunchThread = (CLaunchThread*)
		AfxBeginThread(RUNTIME_CLASS(CLaunchThread), THREAD_PRIORITY_NORMAL,
			0, CREATE_SUSPENDED);
	m_pLaunchThread->SetOwner(this);
	m_pLaunchThread->cCmdLine = GetCommandLine();
	m_pLaunchThread->ResumeThread();

	m_pUpdateThread = (CUpdateThread*)
		AfxBeginThread(RUNTIME_CLASS(CUpdateThread), THREAD_PRIORITY_NORMAL,
			0, CREATE_SUSPENDED);
	m_pUpdateThread->SetOwner(this);
	m_pUpdateThread->ResumeThread();

//	pParamData->pParent = GetSafeHwnd();
//	pParamData->cCmdLine = GetCommandLine();
//	AfxBeginThread(RunTribes, pParamData);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CTimeHUDDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CTimeHUDDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CTimeHUDDlg::OnClose()
{
	int nCount = 0;
	DWORD dwStatus;

	if (m_pUpdateThread != NULL)
	{
		VERIFY(::GetExitCodeThread(m_pUpdateThread->m_hThread, &dwStatus));
		if (dwStatus == STILL_ACTIVE)
		{
			nCount++;
			m_pUpdateThread->m_bDone = TRUE;
		}
		else
		{
			delete m_pUpdateThread;
			m_pUpdateThread = NULL;
		}
	}

	if (m_pLaunchThread != NULL)
	{
		VERIFY(::GetExitCodeThread(m_pLaunchThread->m_hThread, &dwStatus));
		if (dwStatus == STILL_ACTIVE)
		{
			nCount++;
			m_pLaunchThread->m_bDone = TRUE;
		}
		else
		{
			delete m_pLaunchThread;
			m_pLaunchThread = NULL;
		}
	}

	if (nCount == 0)
		CDialog::OnClose();
	else
		PostMessage(WM_CLOSE, 0, 0);
}
