// INCOMING! 5.0 Script by GrymReaper (GrymReaper@netlane.com)
// Press 4 number keys in order to tell your teammates how 
// many enemies of what type are coming from what direction
// to what location.
//
// You MUST have the Presto Pack and |HH|Crunchy's ObjectiveHUD to use this!
// Get them here: http://www.planetstarsiege.com/Presto
//
// To set map specific locations manually, go to the console and type:
// SetMap("mapname"); where mapname is the name of 
// the map (duh! :) Make sure the map name is spelled exactly 
// as it is below. You MUST get the command exactly right! 
// Currently supported maps: 
// Anthill, BloodyVengeance, Broadside and Blastside, Citadels,
// DangerousCrossing, DeathKnell, Desert_Of_Death, Iceridge, 
// Raindance, Rollercoaster, Scarabrae, Siege, Snowblind, 
// Stonehenge, Towers, and generic map locations.
//
// Installation: Add 'exec("Incoming.cs");' to your autoexec.cs 
//
// WARNING: This WILL bind all Numpad # keys to the Incoming functions!
//          If you already HAVE functions bound to those keys, I suggest
//          rebinding them. See below.        
// 
// Format: Press the # of enemies incoming, then the type, then 
//         the direction, and finally the place to which they are heading.
//
//     Number                  Type                 	       Direction
//   7   8 Unknown    Artillery  Flyer   Transport    Northwest  North  Northeast
//
//   4   5   6         Sniper  <Cancel>  Unknown         West   <Cancel>  East
//
//   1   2   3         Light    Medium     Heavy      Southwest  South  Southeast
//
//                    Location
//   Our Generators   Our Flag    Enemy Base     Note: These are the Generic key bindings, only.
//   				                       Certain maps, listed above, have special locations.
//      Our Tower     <Cancel>  The Objective	       Look in the following function for each map's key 
//		         	                       locations.
//      Our Base      Our Roof     Our Porch	    
//						   
// Example: Pressing 1, 4, 6, 4, when using Generic messages,
//          would say "1 sniper is east of our tower!"
//          Pressing 3, 2, 7, 1, when using Citadels messages
//          would say "3 medium enemies are northwest of the West Citadel!"

// Set the following keys to what keys you'd like to control Incoming.
// Default binding matches the one shown for the Keypad above.

		
if (included("newopts\\newopts.cs") != 1)
{
$IncomingKey1 = "numpad1";
$IncomingKey2 = "numpad2";
$IncomingKey3 = "numpad3";
$IncomingKey4 = "numpad4";
$IncomingKey5 = "numpad5";
$IncomingKey6 = "numpad6";
$IncomingKey7 = "numpad7";
$IncomingKey8 = "numpad8";
$IncomingKey9 = "numpad9";

		bindKey(play, $IncomingKey1, "IncomingEnemies(1,\"light\",\"southwest\",$location[1]);");
		bindKey(play, $IncomingKey2, "IncomingEnemies(2,\"medium\",\"south\",$location[2]);");
		bindKey(play, $IncomingKey3, "IncomingEnemies(3,\"heavy\",\"southeast\",$location[3]);");
		bindKey(play, $IncomingKey4, "IncomingEnemies(4,\"sniper\",\"west\",$location[4]);");
		bindKey(play, $IncomingKey5, "IncomingEnemies(5,\"cancel\",\"cancel\",\"cancel\");");
		bindKey(play, $IncomingKey6, "IncomingEnemies(6,\"\",\"east\",$location[6]);");
		bindKey(play, $IncomingKey7, "IncomingEnemies(7,\"artillery\",\"northwest\",$location[7]);");
		bindKey(play, $IncomingKey8, "IncomingEnemies(8,\"flyer\",\"north\",$location[8]);");
		bindKey(play, $IncomingKey9, "IncomingEnemies(\"An unknown number of\",\"transport\",\"northeast\",$location[9]);");

}

// To write new map specific locations, use this format:
//
//   else if(%missionName == "Your Map Here")
//   {
//   $location[1] = "our base";
//   $location[2] = "our roof";
//   $location[3] = "our porch";
//   $location[4] = "our tower";
//   $location[6] = "the objective";
//   $location[7] = "our generators";
//   $location[8] = "our flag";
//   $location[9] = "the enemy base";
//   }  
//
//  and add the code to the bottom of the following Function (before the last block of else { ... } stuff)

function SetMap(%server, %missionName, $ServerMissionType)
{
  	if(%missionName == "Anthill")
  	{
  	$location[1] = "our base";
  	$location[2] = "the South Structure entrance";
  	$location[3] = "the Structure switch";
  	$location[4] = "the West Structure entrance";
  	$location[6] = "the East Structure entrance";
  	$location[7] = "the central Pulse Sensor";
  	$location[8] = "the North Structure entrance";
  	$location[9] = "the Structure elevator";
  	}
  	else if(%missionName == "BloodyVengeance")
  	{	
  	$location[1] = "our base";
  	$location[2] = "our entrance";
  	$location[3] = "behind our base";
  	$location[4] = "our western tower";
  	$location[6] = "our eastern tower";
  	$location[7] = "the nearest ravine";
  	$location[8] = "the central mountain";
  	$location[9] = "the far ravine";
  	}
  	else if(%missionName == "Broadside" || %missionName == "Blastside")
  	{
  	$location[1] = "our base";
  	$location[2] = "our roof";
  	$location[3] = "our porch";
  	$location[4] = "our flag";
  	$location[6] = "the stations";
  	$location[7] = "our generators";
  	$location[8] = "the rear of our base";
  	$location[9] = "the central hill";
  	}  
  	else if(%missionName == "Citadels")
  	{
  	$location[1] = "our base";
  	$location[2] = "our vehicle pad";
  	$location[3] = "the enemy base";
  	$location[4] = "the South Desert";
  	$location[6] = "the North Desert";
  	$location[7] = "the nearest citadel";
  	$location[8] = "the central citadel";
  	$location[9] = "the far citadel";
  	}
  	else if(%missionName == "DangerousCrossing")
  	{
  	$location[1] = "our base";
  	$location[2] = "our roof";
  	$location[3] = "our rear Inventory station";
  	$location[4] = "our far Pulse Sensor";
  	$location[6] = "the center hill";
  	$location[7] = "our bridge";
  	$location[8] = "the mountains to the west";
  	$location[9] = "the mountains to the east";
  	}  
  	else if(%missionName == "DeathKnell")
  	{
  	$location[1] = "our base";
  	$location[2] = "our roof";
  	$location[3] = "our hallways";
  	$location[4] = "the east Flag Tower";
  	$location[6] = "the west Flag Tower";
  	$location[7] = "our generators";
  	$location[8] = "our flags";
  	$location[9] = "the enemy base";
  	}
  	else if(%missionName == "Desert_Of_Death")
  	{
  	$location[1] = "our base";
  	$location[2] = "our flag";
  	$location[3] = "our turrets";
  	$location[4] = "our pulse sensor";
  	$location[6] = "the energy pack";
  	$location[7] = "the repair pack";
  	$location[8] = "the ammo ruins";
  	$location[9] = "the central ruins";
  	}  
  	else if(%missionName == "Iceridge")
  	{
  	$location[1] = "our base";
  	$location[2] = "our roof";
  	$location[3] = "our flag";
  	$location[4] = "our generators";
  	$location[6] = "our plasma turret pad";
  	$location[7] = "the central hill";
  	$location[8] = "the mountains to the west";
  	$location[9] = "the mountains to the east";
  	}  
  	else if(%missionName == "Raindance")
  	{
  	$location[1] = "our base";
  	$location[2] = "our turrets";
  	$location[3] = "our flag";
  	$location[4] = "our generators";
  	$location[6] = "our vehicle pad";
  	$location[7] = "the bridge";
  	$location[8] = "the mountains to the west";
  	$location[9] = "the mountains to the east";
  	}  
  	else if(%missionName == "Rollercoaster")
  	{
  	$location[1] = "our base";
  	$location[2] = "our flag";
  	$location[3] = "our vehicle pad";
  	$location[4] = "the area under our base";
  	$location[6] = "the mountains behind our base";
  	$location[7] = "the nearest mountains";
  	$location[8] = "the central desert";
  	$location[9] = "the far mountains";
  	}
  	else if(%missionName == "Scarabrae")
  	{
  	$location[1] = "our base";
  	$location[2] = "our roof";
  	$location[3] = "our porch";
  	$location[4] = "our flag";
  	$location[6] = "our generators";
  	$location[7] = "the Watch Tower";
  	$location[8] = "our mountain";
  	$location[9] = "the enemy base";
  	}
  	else if(%missionName == "Scarabrae")
  	{
  	$location[1] = "our base";
  	$location[2] = "our generators";
  	$location[3] = "our roof";
  	$location[4] = "our turrets";
  	$location[6] = "our entrances";
  	$location[7] = "the Mortar Bunker";
  	$location[8] = "the mountain behind our base";
  	$location[9] = "the area under our base";
  	}
  	else if(%missionName == "Snowblind")
  	{
  	$location[1] = "our base";
  	$location[2] = "our roof";
  	$location[3] = "our porch";
  	$location[4] = "our flag";
  	$location[6] = "our tower";
  	$location[7] = "our mountain";
  	$location[8] = "the enemy tower";
  	$location[9] = "the enemy base";
  	}  
  	else if(%missionName == "Stonehenge")
  	{
  	$location[1] = "our base";
  	$location[2] = "our flag";
  	$location[3] = "our roof";
  	$location[4] = "our plasma turret";
  	$location[6] = "the drop shaft";
  	$location[7] = "the ravine west of our base";
  	$location[8] = "the center tower";
  	$location[9] = "the ravine east of our base";
  	}  
  	else if(%missionName == "Towers")
  	{
  	$location[1] = "the Southwest Tower";
  	$location[2] = "the South Tower";
  	$location[3] = "our spawn point";
  	$location[4] = "the central plain";
  	$location[6] = "the East Tower";
  	$location[7] = "the Northwest Tower";
  	$location[8] = "the North Tower";
  	$location[9] = "the enemy spawn point";
	}
  	else // If the map name doesn't match any of the previously noted ones, use the generic locations.
  	{
  	$location[1] = "our base";
  	$location[2] = "our roof";
  	$location[3] = "our porch";
  	$location[4] = "our tower";
  	$location[6] = "the objective";
  	$location[7] = "our generators";
  	$location[8] = "our flag";
  	$location[9] = "the enemy base";
  	}  
}

Event::Attach(eventMissionInfo, SetMap);

function IncomingKey1()
{
	IncomingEnemies(1,"light","southwest",$location[1]);
}

function IncomingKey2()
{
	IncomingEnemies(2,"medium","south",$location[2]);
}

function IncomingKey3()
{
	IncomingEnemies(3,"heavy","southeast",$location[3]);
}

function IncomingKey4()
{
	IncomingEnemies(4,"sniper","west",$location[4]);
}

function IncomingKey5()
{
	IncomingEnemies(5,"cancel","cancel","cancel");
}

function IncomingKey6()
{
	IncomingEnemies(6,"","east",$location[6]);
}

function IncomingKey7()
{
	IncomingEnemies(7,"artillery","northwest",$location[7]);
}

function IncomingKey8()
{
	IncomingEnemies(8,"flyer","north",$location[8]);
}

function IncomingKey9()
{
	IncomingEnemies("An unknown number of","transport","northeast",$location[9]);
}

SetMap("","","");

function ResetIncomingEnemies()
{
	$NumberSet = false;
  	$TypeSet = false;
  	$LocationSet = false;
	Client::centerPrint("", 1);
}  	

function IncomingEnemies(%number, %type, %direction, %location)
{
	if($NumberSet && !$TypeSet && !$LocationSet)
  	{
  	if(%type == "cancel")
	  	{
		ResetIncomingEnemies();
		return;
  		}
  	else
	        {
  		$type = %type;
	        if($type == "sniper" || $type == "flyer" || $type == "transport")
        	   {
	   	   $grammar = "";
	           if($number > 1)
              	   $type = $type @ "s";
		   }
  		if($type != "" && $type != "sniper" && $type != "snipers" && $type != "flyer" && $type != "flyers" && $type != "transport" && $type != "transports") 
	   	   $type = $type @ " ";
	       	$NumberSet = true;
        	$TypeSet = true;
        	$DirectionSet = false;
        	Client::centerPrint("<jc><f1>" @ $number @ " " @ $type @ $grammar @ $be @ "<f0>\n7 = <f1>Northwest<f0> 8 = <f1>North<f0> 9 = <f1>Northeast<f0>\n4 = <f1>West<f0> 5 = <f2>Cancel<f0> 6 = <f1>East<f0>\n 1 = <f1>Southwest<f0> 2 = <f1>South<f0> 3 = <f1>Southeast<f0>", 1);
  		return;
  		}
  	}
	else if($NumberSet && $TypeSet && !$DirectionSet)
  	{
		if(%direction == "cancel")
		{
		ResetIncomingEnemies();
		return;
		}
		else
		{
		$direction = %direction;
		$NumberSet = true;
  		$TypeSet = true;
  		$DirectionSet = true;
        	Client::centerPrint("<jc><f1>" @ $number @ " " @ $type @ $grammar @ $be @ " " @ $direction @ " of<f0>\n7 = <f1>" @ $location[7] @ "<f0> 8 = <f1>" @ $location[8] @ "<f0> 9 = <f1>" @ $location[9] @ "<f0>\n4 = <f1>" @ $location[4] @ "<f0> 5 = <f2>Cancel<f0> 6 = <f1>" @ $location[6] @ "<f0>\n1 = <f1>" @ $location[1] @ "<f0> 2 = <f1>" @ $location[2] @ "<f0> 3 = <f1>" @ $location[3], 1);
  		}
  	}
	else if($NumberSet && $TypeSet && $DirectionSet)
  	{
		if(%location == "cancel")
        	{
        	ResetIncomingEnemies();
		return;
        	}
        	else
        	{
	        $location = %location;
	        Say::Team(defendIncoming, $number @ " " @ $type @ $grammar @ $be @ " " @ $direction @  " of " @ $location @ "!");
		Client::centerPrint("<jc><f1>" @ $number @ " " @ $type @ $grammar @ $be @ " " @ $direction @  " of " @ $location @ "!", 1);
        	schedule("Client::centerPrint(\"\", 1);", 5);
		$NumberSet = false;
  		$TypeSet = false;
  		$LocationSet = false;
		}
  	}	
	else if(!$NumberSet && !$TypeSet && !$LocationSet)
  	{
		$number = %number;
		if($number == 1)
		{
		$grammar = "enemy";
		$be = " is";
	        }
		else 
		{
		$grammar = "enemies";
		$be = " are";
		}
	  	$NumberSet = true;
	  	$TypeSet = false;
	  	$DirectionSet = false;
	  	Client::centerPrint("<jc><f1>" @ $number @ "<f0>\n 7 = <f1>Artillery<f0> 8 = <f1>Flyer<f0> 9 = <f1>Transport<f0>\n4 = <f1>Sniper<f0> 5 = <f2>Cancel<f0> 6 = <f1>Unknown<f0>\n    1 = <f1>Light<f0> 2 = <f1>Medium<f0> 3 = <f1>Heavy<f0>", 1);
  	}
}
if (included("newopts\\newopts.cs") == 1)
{
NewOpts::register("Incoming",
				  "config\\GrymReaper\\Incoming.gui",
				  "",
				  "",
				  TRUE);
NewOpts::register("Incoming2",
				  "config\\GrymReaper\\Incoming2.gui",
				  "",
				  "",
				  TRUE);
Include("GrymReaper\\IncomingHelp.cs");
}

