// VKTRHud v0.35 - Handles D&D, DM, C&H, F&R, CTF mission types 
// (no multi-team missions supported yet)
// __________________________________________________________________________
// By: VKTR (jgill@on.aibn.com)
// __________________________________________________________________________

// The key that toggles VKTRHUD on/off
$VHud::ToggleKey = "alt o";

// indicate how big each row is... best leave these alone.
$VHud::Dimensions = "120 17";

// $VHud::Position is where the HUD is... $VHud::Dimensions (Presto format)
// sorry to all you who got this before, I changed this ...it overlapped 
// DynHUD :)
$VHud::Position = "100% 100%";

// set to true to attach VKTRHUD to TeamHUD
$VHud::DockToTeamHUD = true;

if (($VHud::DockToTeamHUD) && (included("presto\\teamhud.cs"))) {
	$VHud::Position = "100% top(hudTeam)";
} else
	$VHud::DockToTeamHUD = false;

// Displayed by default?
$VHud::Display = true;

// Init EVERYTHING to no data.
$VHud::Data[VHud0] = "";	// Friendly Destroy Data
$VHud::Data[VHud1] = "";	// Enemy Destroy Data
$VHud::Data[VHud2] = "";	// Friendly CTF Data
$VHud::Data[VHud3] = "";	// Enemy CTF Data
$VHud::Data[VHud4] = "";	// Global Capture Data

// Line captions on D&D, C&H, F&R mission lines
$VHud::Caption[VHud0] = "Fr:";		// Friendly objectve data
$VHud::Caption[VHud1] = "En:";		// Enemy objective data
$VHud::Caption[VHud2] = "<B0,3:Vektor\\flag_green.bmp>:<f1> ";	// Friendly CTF
$VHud::Caption[VHud3] = "<B0,3:Vektor\\flag_red.bmp>:<f1> ";	// Enemy CTF
$VHud::Caption[VHud4] = "Cap:";		// Global capture (C&H towers, F&R flags) data

// Mission Type Constants
$VHud::CTF = "Capture the Flag";
$VHud::DM = "Deathmatch";
$VHud::DD = "Defend and Destroy";
$VHud::FR = "Find and Retrieve";
$VHud::CH = "Capture and Hold";

include("presto\\event.cs");
include("presto\\HUD.cs");
include("crunchy\\events.cs");
include("crunchy\\ObjectiveTrak.cs");
include("presto\\match.cs");
include("presto\\Teamtrak.cs");

// For determining mission type reliably
$VHud::ServerType = "";
$VHud::ServerTracking = false;
$VHud::ServerRetryCount = 0;

function VHud::Banner() {
	Presto::Addscriptbanner(VHud, 
		"<f0>VektorHUD v0.2\n"@
		"<f1>Objective/CTF tracking HUD\n"@
		"Toggle On/Off key: "@$VHud::ToggleKey@"\n"@
		"<f2>By: VeKToR <f1>jgill@on.aibn.com");
}

function VHud::GetServerType() {
	return $VHud::ServerType;
}

function VHud::Reset() {
	$VHud::Score[0] = 0;
	$VHud::Score[1] = 0;
	$VHud::Kills = 0;
	$VHud::Deaths = 0;
	$VHud::ServerRetryCount = 0;
}

function VHud::OnKillTrak(%attacker, %victim, %weapon) {
	if (%victim == getManagerID()) {
		$VHud::Deaths++;
		HUD::Update(VHudDM);
	} else if (%attacker == getManagerID()) {		
		$VHud::Kills++;
		HUD::Update(VHudDM);
	}
}

function VHud::Init() {
	
	%HudDimY = getword($VHud::Dimensions, 1);

	if (VHud::GetServerType() == $VHud::Dm) {
		if (included("Presto\\KillTrak.cs")) {
			$VHud::Kills = 0;
			$VHud::Deaths = 0;
			if (!HUD::Exists("VHudDM")) 
				HUD::New(VHudDM, "VHud::DMCheck", $VHud::Position @ "-" @ %HudDimY*2, $VHud::Dimensions @ "*2");
			HUD::Display("VHudDM");

			// Attach kill tracking ONLY if we're playing DM.
			Event::Attach(eventKillTrak, VHud::OnKillTrak);
			// (note I don't detach it for other missions - It doesn't take too
			// much processor overhead to increment a variable, and since
			// detaching events can screw up the function order of execution, I
			// just leave it attached!
		}
	} else {
//		All objective types (except DM) are now supported in a single mission.
//		The only exception is CTF flags and F&R flags (which shouldn't both be in a 
//		mission	anyway)
//		echo("D&D, F&R, C&H, CTF!");
	
		$VHud::Score[0] = 0;
		$VHud::Score[1] = 0;
		
		for (%i = 4; %i > -1; %i--) {
			if (!HUD::Exists("VHud"@%i))
				HUD::New("VHud" @ %i, VHud::ShowText, $VHud::Position @ "-" @ (5-%i)*%HudDimY, $VHud::Dimensions);
		}
		VHud::UpdateAll();
	}
}

function VHud::DMCheck() {
	if (VHud::GetServerType() != $VHud::DM)
		return;

	HUD::Display(VHudDM, $VHud::Display);

	// actual game reports efficiency as 0% until a certain amount
	// of kills have been obtained on the server (I think). I didn't want to
	// KillTrak EVERYONE on the entire server, so I just assume that the
	// correct number of kills has been achieved and calculate the efficiency
	// regardless. (lazy? You better believe it!)
	if (($VHud::Kills + $VHud::Deaths) != 0) 
		%eff = floor(($VHud::Kills / ($VHud::Kills + $VHud::Deaths)) * 100);
	else
		%eff = 0;

	HUD::Addtextline(VHudDM, "<B0,2:skull_small.bmp> <f1>K:<f2> " @ $VHud::Kills @ "   <f1>D:<f2> " @ $VHud::Deaths @ "\n<f1>    Eff: <f2>" @ %eff @ "%");
}

function VHud::HandleTeamChange(%clientID) {

	// Don't have to update if it wasn't us changing teams :)
	if (%clientID != getManagerID())
		return;

//	echo("Team Change!");

	if (VHud::GetServerType() != $VHud::DM)
		VHud::UpdateAll();		
}

event::Attach(eventClientChangeTeam, VHud::HandleTeamChange);

function VHud::UpdateFlagCap(%client, %id, %flagteam, %type) {

	// %flagteam points to the team that OWNS the flag
	// that gets captured, not the team that captured it
	// so, we gotta flip 1's to 0's and vice-versa
	%flagteam = 1 - %flagteam;
	
//	echo("Flag Cap'd: " @ %flagteam);
	
	$VHud::Score[%flagteam]++;

	HUD::Update(VHud2);
	HUD::Update(VHud3);
}
event::Attach(eventObjectiveFlagCaptured, VHud::UpdateFlagCap);

// I think Team::Friendly and Team::Enemy are the last of Presto's Teaktrak
// functions left in here (I think)
function VHud::ShowText(%hud) {	
	if ((%hud == "VHud2") || (%hud == "VHud3")) {
		if (%hud == "VHud2")
			%score = "<f2>" @ $VHud::Score[Team::Friendly()];
		else
			%score = "<f2>" @ $VHud::Score[Team::Enemy()];

		HUD::AddtextLine(%hud, $VHud::Caption[%hud] @ $VHud::Data[%hud] @ " <f1>(" @ %score @ "<f1>)");
	} else
		HUD::AddtextLine(%hud, $VHud::Caption[%hud] @ $VHud::Data[%hud]);
	
	return;
}

function VHud::UpdateHUDPlacement(%forcemove) {

	%HudDimY = getword($VHud::Dimensions, 1);

	%offset = 0;
	for (%i = 4; %i > -1; %i--) {
		if ((HUD::GetDisplayed("VHud"@%i)) && ($VHud::Data["VHud"@%i] != "")) {
			%offset += %HudDimY;
			if ((HUD::GetPosition("VHud"@%i) != ($VHud::Position @ "-" @ %offset @ " " @ $VHud::Dimensions)) || (%forcemove == true))
				HUD::Move("VHud"@%i, ($VHud::Position @ "-" @ %offset @ " " @ $VHud::Dimensions));			
			HUD::Display("VHud"@%i, true);
		}
	}
}

// If it's a CTF object, we can save a lot of checking (looping thru every objective)
function VHud::CheckUpdate(%client, %id, %status, %type) {
	if (%type == $Objective::CTF) {

		%textline = Objective::GetNameStripped(%id);
		%textline = Objective::InsertTeamName(%textline);
	
		if ((String::FindSubStr(%textline, "Your") != -1) || (String::FindSubStr(%textline, "your") != -1))
			%team = 1;
		else
			%team = 0;
		
		if (%status == $Objective::Unknown) {
			if (%team == 1)
				$VHud::Data[VHud2] = "???";
			else
				$VHud::Data[VHud3] = "???";
		} else if (%status == $Objective::Enemy)
			$VHud::Data[VHud3] = "home";
		else if (%status == $Objective::Friendly)
			$VHud::Data[VHud2] = "home";
		else if (%status == $Objective::FriendlyCarry) {
			if (%client != getManagerID())
				$VHud::Data[VHud3] = "<f2>" @ Client::Getname(%client);
			else
				$VHud::Data[VHud3] = "<f2>YOU!";
		} else if (%status == $Objective::EnemyCarry)
				$VHud::Data[VHud2] = "<f2>" @ Client::Getname(%client);
		else if (%status == $Objective::Dropped) {
			if (%team == 1)
				$VHud::Data[VHud2] = "field";
			else
				$VHud::Data[VHud3] = "field";
		}
							
		for (%i = 2; %i < 4; %i++) {
			if (($VHud::Data["VHud"@%i] != "") && ($VHud::Display == true)) {
				HUD::Update("VHud" @ %i);
				HUD::Display("VHud" @ %i);		
			} else if (HUD::GetDisplayed("VHud" @ %i) == true)
				HUD::Display("VHud" @ %i, false);		
		}
				
		VHud::UpdateHudPlacement(false);
	} else
		VHud::UpdateAll();

}

// This is the huge icon-string building function.
// Unfortunately, with the icon-based display, changing an objective usually means
// the entire list has to be rebuilt to make things work - the exception being CTF
// data.
function VHud::UpdateAll() {
	// Get status of ALL current objectives, and update the HUDs

	for (%i = 0; %i < 5; %i++)	
		$VHud::Data["VHud"@%i] = "";
	
	%numobj = Objective::Number();

	if (%numobj > 0) {
		for (%ix = 0; %ix < %numobj; %ix++) {
			%status = Objective::GetStatus(%ix);
			%client = Objective::GetClient(%ix);
			%type = Objective::GetType(%ix);
			%textline = Objective::GetNameStripped(%ix);

			if (%type == $Objective::CTF) {
				%textline = Objective::InsertTeamName(%textline);

				if ((String::FindSubStr(%textline, "Your") != -1) || (String::FindSubStr(%textline, "your") != -1))
					%team = 1;
				else
					%team = 0;

				if (%status == $Objective::Unknown) {
					if (%team == 1)
						$VHud::Data[VHud2] = "???";
					else
						$VHud::Data[VHud3] = "???";
				} else if (%status == $Objective::Enemy)
					$VHud::Data[VHud3] = "home";
				else if (%status == $Objective::Friendly)
					$VHud::Data[VHud2] = "home";
				else if (%status == $Objective::FriendlyCarry) {
					if (Objective::GetClient(%ix) != getManagerID())
						$VHud::Data[VHud3] = "<f2>" @ Client::Getname(Objective::GetClient(%ix));
					else
						$VHud::Data[VHud3] = "<f2>YOU!";
				} else if (%status == $Objective::EnemyCarry)
						$VHud::Data[VHud2] = "<f2>" @ Client::Getname(Objective::GetClient(%ix));
				else if (%status == $Objective::Dropped) {
					if (%team == 1)
						$VHud::Data[VHud2] = "field";
					else
						$VHud::Data[VHud3] = "field";
				}
							
				
			} else if (%type == $Objective::DandD) {
				%textline = Objective::InsertTeamName(%textline);

				if ((String::FindSubStr(%textline, "Your") != -1) || (String::FindSubStr(%textline, "your") != -1))
					%team = 1;
				else
					%team = 0;

				if (%team == 0) {
					if (String::findSubStr(%textline, "Turret") != -1) {						
						if (%status == $Objective::Destroyed)
							%symbol = "<B0,0:M_turret_red.bmp>";
						else if (%status == $Objective::Neutral)
							%symbol = "<B0,2:M_turret_green.bmp>";
					} else if (String::findSubStr(%textline, "Solar") != -1 || String::findSubStr(%textline, "Generator") != -1) {
						if (%status == $Objective::Destroyed)
							%symbol = "<B0,0:M_generator_red.bmp>";
						else if (%status == $Objective::Neutral)
							%symbol = "<B0,2:M_generator_green.bmp>";
					} else if (String::findSubStr(%textline, "Station") != -1 || String::findsubstr(%textline, "Command") != -1) {
						if (%status == $Objective::Destroyed)
							%symbol = "<B0,0:M_station_red.bmp>";
						else if (%status == $Objective::Neutral)
							%symbol = "<B0,2:M_station_green.bmp>";
					} else if (String::findSubStr(%textline, "Sensor") != -1) {
						if (%status == $Objective::Destroyed)
							%symbol = "<B0,0:M_motionsensor_red.bmp>";
						else if (%status == $Objective::Neutral)
							%symbol = "<B0,2:M_motionsensor_green.bmp>";
					} else {
						if (%status == $Objective::Destroyed)
							%symbol = "<B0,0:CMD_DamageHigh.bmp>";
						else if (%status == $Objective::Neutral)
							%symbol = "<B0,0:CMD_DamageLow.bmp>";
					}
					$VHud::Data[VHud1] = $VHud::Data[VHud1] @ %symbol;
				}
// _______________________________________________________________________________________
				else if (%team == 1) {
					if (String::findSubStr(%textline, "Turret") != -1) {						
						if (%status == $Objective::Destroyed)
							%symbol = "<B0,0:M_turret_red.bmp>";
						else if (%status == $Objective::Neutral)
							%symbol = "<B0,2:M_turret_green.bmp>";
					} else if (String::findSubStr(%textline, "Solar") != -1 || String::findSubStr(%textline, "Generator") != -1) {
						if (%status == $Objective::Destroyed)
							%symbol = "<B0,0:M_generator_red.bmp>";
						else if (%status == $Objective::Neutral)
							%symbol = "<B0,2:M_generator_green.bmp>";
					} else if (String::findSubStr(%textline, "Station") != -1 || String::findSubStr(%textline, "Command") != -1) {
						if (%status == $Objective::Destroyed)
							%symbol = "<B0,0:M_station_red.bmp>";
						else if (%status == $Objective::Neutral)
							%symbol = "<B0,2:M_station_green.bmp>";
					} else if (String::findSubStr(%textline, "Sensor") != -1) {
						if (%status == $Objective::Destroyed)
							%symbol = "<B0,0:M_motionsensor_red.bmp>";
						else if (%status == $Objective::Neutral)
							%symbol = "<B0,2:M_motionsensor_green.bmp>";
					} else {
						if (%status == $Objective::Destroyed)
							%symbol = "<B0,0:CMD_DamageHigh.bmp>";
						else if (%status == $Objective::Neutral)
							%symbol = "<B0,2:CMD_DamageLow.bmp>";
					}
					$VHud::Data[VHud0] = $VHud::Data[VHud0] @ %symbol;
				}

			} else if (%type == $Objective::CandH) {
				if (%status == $Objective::Enemy) {
					$VHud::Data[VHud4] = $VHud::Data[VHud4] @ "<B0,3:VeKToR\\tower_red.bmp>";
				} else if (%status == $Objective::Friendly) {
					$VHud::Data[VHud4] = $VHud::Data[VHud4] @ "<B0,3:VeKToR\\tower_green.bmp>";
				} else {
					$VHud::Data[VHud4] = $VHud::Data[VHud4] @ "<B0,3:VeKToR\\tower_gray.bmp>";
				}
			} else if (%type == $Objective::FandR) {
				if ((%status == $Objective::Enemy) || (%status == $Objective::EnemyCarry)) {
					$VHud::Data[VHud4] = $VHud::Data[VHud4] @ "<B0,3:VeKToR\\flag_red.bmp>";
				} else if ((%status == $Objective::Friendly) || (%status == $Objective::FriendlyCarry)) {
					$VHud::Data[VHud4] = $VHud::Data[VHud4] @ "<B0,3:VeKToR\\flag_green.bmp>";
				} else {
					$VHud::Data[VHud4] = $VHud::Data[VHud4] @ "<B0,3:VeKToR\\flag_gray.bmp>";
				}
			}
		}
	}
	
	for(%i = 0; %i < 5; %i++) {
		if (($VHud::Data["VHud"@%i] != "") && ($VHud::Display == true)) {
			HUD::Update("VHud" @ %i);
			HUD::Display("VHud" @ %i);		
		} else if (HUD::GetDisplayed("VHud" @ %i) == true)
			HUD::Display("VHud" @ %i, false);		
	}

	VHud::UpdateHUDPlacement(false);
}
event::Attach(eventObjectiveReset, "VHud::UpdateAll");
event::Attach(eventObjectiveLoaded, "VHud::UpdateAll");
event::Attach(eventObjectiveMadeNeutral, "VHud::UpdateAll");
event::Attach(eventObjectiveNew, "VHud::UpdateAll");
event::Attach(eventObjectiveUpdated, VHud::CheckUpdate);

function VHud::Toggle() {
	$VHud::Display = !($VHud::Display);
	
	if (VHud::GetServerType() == $VHud::DM) 
		HUD::Update(VHudDM);
	else
		VHud::UpdateAll();
}

if ($VHud::DockToTeamHUD) {
	Event::Attach(eventTeammateJoined, "VHud::UpdateHUDPlacement(true);");
	Event::Attach(eventTeammateLeft, "VHud::UpdateHUDPlacement(true);");
	Event::Attach(eventClientChangeTeam, "VHud::UpdateHUDPlacement(true);");
}

// Uses a hybrid of Crunchy's new $ObjData::MissionType (stored 
// in MissionPack files) and the icky old method of repeatedly
// polling the server until there's some change in $ServerMissionType
// new code is a lot better than $ServerMissionType alone.

// Love the function name!
function VHud::GetCrunchyMissionInfo() {
//	If we have Crunchy's mission data loaded, we don't need to find
//	the mission type the old way :)
	if (($ObjData::MissionType != "") && ($Objective::Loaded == true)) {
		$VHud::ServerType = $ObjData::MissionType;

		for (%i = 0; %i < 5; %i++)
			HUD::Display("VHud"@%i, false);
		HUD::Display(VHudDM, false);

		VHud::Init();		

		$VHud::ServerTracking = false;
		return true;
	}
	return false;
}

function VHud::UpdateMissionType() {
	if (VHud::GetCrunchyMissionInfo())
		return;

	if (!$VHud::ServerTracking)
		VHud::CheckMissionType();
	
}

function VHud::CheckMissionType() {

	$VHud::ServerTracking = true;
	if (($ServerMissionType != VHud::GetServerType()) && ($ServerMissionType != "")) {
//		echo("found server");
		$VHud::ServerTracking = false;
		// Hide ALL the HUD's (if we're changing types, some
		// HUDs are probably not going to be needed.
		for (%i = 0; %i < 5; %i++)
			HUD::Display("VHud"@%i, false);

		HUD::Display(VHudDM, false);

		$VHud::ServerType = $ServerMissionType;
		VHud::Init();
	} else if ($VHud::ServerRetryCount < 60) {
//		echo("checking server");
		// we don't need to check for more than 2 minutes, GUARANTEED
		// (dosen't matter HOW bad your connection is :) this is mostly for
		// safety (i.e. really laggy servers
		Schedule("VHud::CheckMissionType();", 2);
		$VHud::ServerRetryCount++;
	} else {
		$VHud::ServerTracking = false;
		$VHud::ServerRetryCount = 0;
	}
}

event::attach(eventMissionInfo, "VHud::Reset();VHud::UpdateMissionType();");

bindkey(play, $VHud::ToggleKey, "VHud::Toggle();");