// SplitMSG Custom Filter File. Allows clients to add
// their own custom filters. Just follow the instructions.

// Grouping:
// All filtered messages are filed into groups. For example,
// all messages pertaining to backpacks are filed in the
// "BackPack" group, or station messages in the "Station" group.
// These groups allow more organized sorting of the messages, as
// well as setting up the on-screen menu in the game that allows
// you to turn filtering on/off for certain types of messages.

// As a general rule, it's a good idea to group your custom filter
// messages intelligently. Don't put each message in it's own group
// or all your filters in one giant group, as either will make it hard
// to customize the operation of your SplitMSG window.

// To create a message group, call the 
// SplitMSG::AddMSGGroup(%group, %filter, %display, %letter);
// simply substitute the following information for the above
// values (leave the commas in their place):

// put the name of the group you are creating in place of %group.
// Do not use spaces in the name %group or 

// if you want the group to be filtered by default, enter TRUE in place
// of %filter, otherwise replace it with FALSE

// if you want the group to be displayed on the second window when 
// filtered, replace %display with TRUE, otherwise replace it with
// FALSE

// replace %letter with the letter you want to appear on the menu
// (when changing settings in-game) - each group should have its
// own UNIQUE letter - if you repeat a letter, the second instance
// will NOT be displayed on the menu. (this should ONLY be ONE letter
// no more, no less!)

// So an example that creates a group called "MyGroup", is filtered
// by default, and does not get displayed by default (with a menu
// letter of "m") would be:

// SplitMSG::AddMSGGroup("MyGroup", true, false, "m");

// --------------------------------------------------------------------------------------------

// A group by itself, however, doesn't actually do anything. The
// groups are simply organization for filter messages (what to block
// out from the chat window). In order to actually block out messages,
// you must add filters to the group(s). 
// In order to do this, we use the SplitMSG::FilterMessage(%msg, %group)
// function. For this to work, simply make the following substitutions:

// replace %msg with the text line you want filtered out. More on this
// later.

// replace %group with the name of a group you defined using the
// SplitMSG::AddMSGGroup function (above).

// The text line can be specially formatted to include "wildcards". 
// These wildcards are special symbols that let parts of a message 
// be substituted. These wildcards are allowed to take on ANY value 
// when comparing one message to another.

// for example, the text line "%1 guns down %2" would match the message
// "VeKToR guns down FlyChic" because VeKToR would be substituted in for
// %1 and FlyChic would be substituted for %2. Just make sure to use a 
// different "wildcard" in each space you want something substituted, and
// wildcards MUST be in the form of a percentage sign (%) followed by ONE
// character (no more, no less). So %x would be a valid wildcard, while
// %name1 would not (because its too long). For more info on these wildcards
// consult Presto\Match.cs in the section about Match::ParamString.

// You can also attach SplitMSG messages to events now, but this is as of yet
// an "undocumented" feature :)
// SplitMSG::MessageEvent(%event, %msg);
// where %event is the event to "attach" the message to
// and %msg is the message you want displayed

// If you're still with me...

function SplitMSG::BuildExternalFilters() {

	// Add your groups and filters here.
	// do NOT use the following values

	// Group Names:
	//	"Item-Based", "Station", "Server", "Ungrouped",
	//	"Objective"

	// Menu Letters:
	//	"d", "i", "s", "e", "u", "o"
	
	// now that we've covered that, here's some sample code from my
	// built-in filters (this covers station messages)

	//	SplitMSG::AddMSGGroup("Station", true, false, "s");
	//		SplitMSG::FilterMessage("Station Access %1", "Station");
	//		SplitMSG::FilterMessage("Resupply Complete", "Station");
	//		SplitMSG::FilterMessage("Bought Laser Rifle - Auto buying Energy Pack", "Station");
	//		SplitMSG::FilterMessage("Sold Energy Pack - Auto Selling Laser Rifle", "Station");

}