// ___________________________________________________________________
// SplitMSG - Split Message Boxes!		7/22/99       v1.0b
//		by: VKTR (jgill@on.aibn.com)
// ___________________________________________________________________

// Now supports filtering of other messages (such as Station Access On)
// Fully customizable using SplitMSGFilter.cs (included... just follow
// the instructions)

// -*CAUTION*- This is an advanced option -*CAUTION*-
// Override Presto's KillTrak code - KillTrak should work identically,
// since my version will do EVERYTHING his does, and run my death msg
// filtering code as well. This should reduce processor overhead by about
// 1/2, but might prove to be a compatability problem (maybe) when using 
// other scripts based on KillTrak. That said, enable at yer own risk.
// Set to true (enable Overriding) or false (disable it)
// This isn't in the NewOpts menu in case it causes problems...
$SplitMSG::OverrideKillTrak = true;

// Just in case... don't screw up previous/newer versions
if ($Presto::version != 0.93)
	$SplitMSG::OverrideKillTrak = false;
	
include("Presto\\HUD.cs");
include("Presto\\KillTrak.cs");
include("presto\\Events.cs");
include("Presto\\match.cs");
include("VeKToR\\SplitMSGFilter.cs");
include("presto\\TeamTrak.cs");

// Defaults :)
$SplitMSG::FilterDeathStrings = true;
$SplitMSG::DisplayDeathStrings = true;
$SplitOpts::NumRows = 4;
$SplitOpts::HiLightMe = true;
$SplitOpts::HiLightBuds = true;
$SplitOpts::HudOn = true;
$SplitOpts::FilterTeamDamage = true;

// Omitted from PrestoPack 0.93
// Thx to TeKnOwLeD-G for these (from StatTrak... tracks every conceivable stat :)
KillTrak::DeathMessage("%1 mows down %3 teammate, %2", "Team Kill");
KillTrak::DeathMessage("%1 killed %3 teammate, %2 with a mine.","Team Kill");
KillTrak::DeathMessage("%2 dies.", "Turret");

// NewOpts stuff
if (isfile("config\\SplitOpts.cs")) {
	exec("SplitOpts.cs");

	// Really weird... for some STUPID reason, exporting then reading this
	// variable NEVER works! This should fix it, but I don't know WHY this is
	// necessary, but the var was CONSTANTLY false on my system, no matter what
	// I did... even editing the file manually
	if ($SplitOpts::HudOn == 0)
		$SplitOpts::HudOn = false;
	else if ($SplitOpts::HudOn == 1)
		$SplitOpts::HudOn = true;
}

// Default position on the screen - modified in game by NewOpts now :)
if (included("Presto\\TeamHud.cs"))
	$SplitMSG::Position = "left(hudTeam) top(hudTeam)-height(SplitMSGWindow)";
else
	$SplitMSG::Position = "0% 90%";

// %group is the filtergroup name. %dfilter is the default filtering
// state (true, false). %ddisplay is the default display setting 
// (true/false).
function SplitMSG::AddMSGGroup(%group, %dfilter, %ddisplay, %menuletter) {

	if ((%group == "") || (%menuletter == ""))
		return;

	if ($SplitMSG::group[%group] != "") {
		$SplitMSG::groupfilter[%group] = %dfilter;
		$SplitMSG::groupdisplay[%group] = %ddisplay;
		return;
	}
	
	if ($SplitMSG::NumGroups == "") {
		$SplitMSG::NumGroups = 0;
	} else
		for (%i = 0; %i < $SplitMSG::NumGroups; %i++) 
			if (%group == $SplitMSG::groupindex[%i])
				return;

	$SplitMSG::groupindex[$SplitMSG::NumGroups] = %group;

	// Don't overwrite NewOpts prefs if they're already loaded
	if ($SplitMSG::groupfilter[%group] == "")
		$SplitMSG::groupfilter[%group] = %dfilter;

	if ($SplitMSG::groupdisplay[%group] == "")
		$SplitMSG::groupdisplay[%group] = %ddisplay;

	$SplitMSG::groupNumMessages[%group] = "";
	$SplitMSG::groupMenuLetter[%group] = %menuletter;
	$SplitMSG::NumGroups++;

	FGCombo::AddEntry("SplitOpts::FilterChooser", %group, $SplitMSG::NumGroups);
}


// %msg is the message string, %group is the group to add it to.
function SplitMSG::FilterMessage(%msg, %group) {
	%groupexists = false;

	if ((%group == "") || (%msg == ""))
		return;

	if ($SplitMSG::NumGroups == "") {
		SplitMSG::AddMSGGroup("Ungrouped", true, true, "u");
	} else {
		for(%i = 0; %i < $SplitMSG::NumGroups; %i++) {
			if (%group == $SplitMSG::groupindex[%i])
				%groupexists = true;
		}
	}

	if (%groupexists == false)
		%group = "Ungrouped";

	if ($SplitMSG::groupNumMessages[%group] == "")
		$SplitMSG::groupNumMessages[%group] = 0;

	%num = $SplitMSG::groupNumMessages[%group];
	$SplitMSG::groupMessage[%group, %num] = %msg;
	$SplitMSG::groupNumMessages[%group]++;
}


function SplitMSG::MessageEvent(%event, %msg) {
	Event::Attach(%event, "SplitMSG::PostNewMsg(\"" @ %msg @ "\", false);");
}

// Some of these filters thought up by Plague! Thanx.
function SplitMSG::BuildFilters() {
	if ($SplitMSG::BuiltFilters)
		return;

	FGCombo::clear("SplitOpts::FilterChooser");
	FGCombo::AddEntry("SplitOpts::FilterChooser", "Death Messages", 0);
	$SplitOpts::Filter = 0;

	echo("Building Filters");

	// for messages without a group or with an invalid group
	SplitMSG::AddMSGGroup("Ungrouped", true, true, "u");

	SplitMSG::AddMSGGroup("Item_Based", true, false, "i");
		SplitMSG::FilterMessage("Shield %1", "Item_Based");
		SplitMSG::FilterMessage("AutoRepair %1", "Item_Based");
		SplitMSG::FilterMessage("Sensor Jammer %1", "Item_Based");
		SplitMSG::FilterMessage("Nothing in range", "Item_Based");
		SplitMSG::FilterMessage("Being repaired by%1", "Item_Based");
		SplitMSG::FilterMessage("Repair%1", "Item_Based");
		SplitMSG::FilterMessage("%1received%2", "Item_Based");
		SplitMSG::FilterMessage("Repair done", "Item_Based");
		SplitMSG::FilterMessage("%1deployed", "Item_Based");
		SplitMSG::FilterMessage("Interference%1", "Item_Based");
		SplitMSG::FilterMessage("Unable to deploy%1", "Item_Based");

	SplitMSG::AddMSGGroup("Station", true, false, "s");
		SplitMSG::FilterMessage("Station Access %1", "Station");
		SplitMSG::FilterMessage("Command Access %1", "Station");
		SplitMSG::FilterMessage("Resupply Complete", "Station");
		SplitMSG::FilterMessage("Bought Laser Rifle - Auto buying Energy Pack", "Station");
		SplitMSG::FilterMessage("Sold Energy Pack - Auto Selling Laser Rifle", "Station");
		SplitMSG::FilterMessage("Unit is %1", "Station");
		SplitMSG::FilterMessage("%1couldn't buy%2", "Station"); 
		SplitMSG::FilterMessage("--ACCESS%1", "Station");

	// This whole group was Plague's idea but it's off by default because
	// IMHO it's important when a flag is capped :)
	// (but it's real easy to turn on in-game)
	SplitMSG::AddMSGGroup("Objective", false, true, "o");
		SplitMSG::FilterMessage("%1took the%2", "Objective");
		SplitMSG::FilterMessage("Your team has the%1", "Objective");
		SplitMSG::FilterMessage("Your team's flag has been taken.", "Objective");
		SplitMSG::FilterMessage("Your team's flag was captured.", "Objective");
		SplitMSG::FilterMessage("%1returned the%2", "Objective");
		SplitMSG::FilterMessage("%1was returned to base.", "Objective");
		SplitMSG::FilterMessage("%1captured the%2", "Objective");
		SplitMSG::FilterMessage("%1Receives%2", "Objective");
		SplitMSG::FilterMessage("%1objective%2", "Objective");
		SplitMSG::FilterMessage("%1claimed%2", "Objective");
		SplitMSG::FilterMessage("%1dropped%2", "Objective");

	if (Included("VeKToR\\SplitMSGFilter.cs"))
		SplitMSG::BuildExternalFilters();	

	$SplitMSG::BuiltFilters = true;
}

// Just rebuild the blasted menu each time a setting is changed... easiest
// way to do it!
function SplitMSG::BuildMenu() {

	if ($SplitMSG::BuiltFilters != true)
		SplitMSG::BuildFilters();	

	Menu::New(SplitMenu, "SplitMSG Menu");

	Menu::AddChoice(SplitMenu, "tToggle SplitMSG display", "HUD::ToggleDisplay(SplitMSGWindow); $SplitOpts::HudOn = Hud::GetDisplayed(SplitMSGWindow);");
	Menu::AddMenu(SplitMenu, "fFilter Settings", SplitFilterMenu);
	Menu::AddMenu(SplitMenu, "dDisplay Settings", SplitDisplayMenu);

	Menu::New(SplitFilterMenu, "Filter Settings");
	Menu::New(SplitDisplayMenu, "Display Settings");

	// The only hard-coded filter/display menu code because death
	// messages are already defined by presto in a different way	
	// they use a different handler.
	if ($SplitMSG::FilterDeathStrings)
		%pretext = "Turn off ";
	else
		%pretext = "Turn on ";
	
	Menu::AddChoice(SplitFilterMenu, "d" @ %pretext @ "death filtering", "$SplitMSG::FilterDeathStrings = !$SplitMSG::FilterDeathStrings;SplitMSG::BuildMenu();");

	if ($SplitMSG::DisplayDeathStrings)
		%pretext = "Turn off ";
	else
		%pretext = "Turn on ";
	
	Menu::AddChoice(SplitDisplayMenu, "d" @ %pretext @ "death text display", "$SplitMSG::DisplayDeathStrings = !$SplitMSG::DisplayDeathStrings;SplitMSG::BuildMenu();");

	for (%i = 0; %i < $SplitMSG::NumGroups; %i++) {
		%group = $SplitMSG::groupindex[%i];

		if ($SplitMSG::groupNumMessages[%group] > 0) {
			if ($SplitMSG::groupfilter[%group] == true)
				%pretext = "Turn off ";
			else
				%pretext = "Turn on ";

			Menu::AddChoice(SplitFilterMenu, $SplitMSG::groupMenuLetter[%group] @ %pretext @ %group @ " filtering", "$SplitMSG::groupfilter[" @ %group @ "] = !$SplitMSG::groupfilter[" @ %group @ "];SplitMSG::BuildMenu();");

			if ($SplitMSG::groupdisplay[%group] == true)
				%pretext = "Turn off ";
			else
				%pretext = "Turn on ";
			Menu::AddChoice(SplitDisplayMenu, $SplitMSG::groupMenuLetter[%group] @ %pretext @ %group @ " text display", "$SplitMSG::groupdisplay[" @ %group @ "] = !$SplitMSG::groupdisplay[" @ %group @ "];SplitMSG::BuildMenu();");
		}
	}

}


function SplitMSG::Init() {
	// Clear info
	for (%i = 0; (%i < $SplitOpts::NumRows); %i++) {
		$SplitMSG::Row[%i] = "";
		$SplitMSG::RowHeight[%i] = 1;
		$SplitMSG::Obj[%i] = false;
	}

	// Make the individual FearGuiFormattedText objects to nuke any problem with
	// bitmaps and "\n" spacing :(
	// For now, the HUD gets re-built every time you join a server, otherwise it wont
	// update or even display properly! Hmmm...
	
	if (!Hud::Exists(SplitMSGWindow)) {
		%pos = $SplitMSG::Position;
		deleteobject("Hud::SplitMSGWindow");
	} else
		%pos = getword(Hud::GetPosition(SplitMSGWindow), 0) @ " " @ getword(Hud::GetPosition(SplitMSGWindow), 1);

	if ($Hud::prefs::last::SplitMSGWindow != "")
		$Hud::prefs::last::SplitMSGWindow = getword($Hud::prefs::last::SplitMSGWindow, 0) @ " " @ getword($Hud::prefs::last::SplitMSGWindow, 1) @ " 300 " @ $SplitOpts::NumRows*14;

	HUD::NewFrame(SplitMSGWindow, "SplitMSG::UpdateWindow", %pos @ " 300 " @ $SplitOpts::NumRows*14);
	HudMover::constrainHud(SplitMSGWindow, size);

	// *sigh* in order to get everything re-sizing right, I have to modify Zear's
	// HudMover prefs... but don't worry, I only touch the height/width of the
	// HUD, not the X/Y positions, and the height/width are constrained to the
	// user anyway, so everything works out.
		
	for (%i = 0; %i < $SplitOpts::NumRows; %i++) 
		$SplitMSG::Obj[%i] = HUD::Addobject(SplitMSGWindow, FearGuiFormattedText, 4, (%i * 14)-1, HUD::Width(SplitMSGWindow)-4, (14*($SplitOpts::NumRows - %i))-1);

	// default to true "just in case"
	HUD::Display(SplitMSGWindow, $SplitOpts::HudOn);

	SplitMSG::BuildMenu();	
}



function SplitMSG::UpdateWindow() {

	for (%i = 0; %i < $SplitOpts::NumRows; %i++) {	
		if ($SplitMSG::Row[%i] != "[[NO DATA FOR SPLITMSG]]") {
			control::SetValue(Object::Getname($SplitMSG::Obj[%i]), "<f2>" @ $SplitMSG::Row[%i]);
			control::SetVisible(Object::Getname($SplitMSG::Obj[%i]), true);
		} else {
			control::SetValue(Object::Getname($SplitMSG::Obj[%i]), "");
			control::SetVisible(Object::Getname($SplitMSG::Obj[%i]), false);
		}
	}

	return;
}


function SplitMSG::PostNewMsg(%msg, %skipmsglen) {	
	%msg = String::Trim(%msg);	// Nuke the empty spaces

	// Don't know WHY I didn't think of this before... don't clip it to
	// the length of a line, let it wrap itself and figure out how many
	// lines it takes... just don't do anything with the empty (wrapped)
	// lines. I only have to calculate pixel length ONCE, and sometimes
	// even that can be ignored.
	if (!%skipmsglen) {
		%msglen = String::Pixels(%msg);
	} else
		%msglen = 1;

	%numrows = floor(%msglen / (HUD::Width(SplitMSGWindow)-5))+1;

	if ((%numrows > $SplitOpts::NumRows) || (%numrows < 1))
		return;

	for (%i = 0; %i < ($SplitOpts::NumRows-%numrows); %i++) {
		$SplitMSG::Row[%i] = $SplitMSG::Row[%i+%numrows];
		$SplitMSG::RowHeight[%i] = $SplitMSG::RowHeight[%i+%numrows];
	}

	$SplitMSG::Row[$SplitOpts::Numrows - %numrows] = %msg;
	$SplitMSG::RowHeight[$SplitOpts::Numrows - %numrows] = %numrows;

	if (%numrows > 1)
		for (%i = ($SplitOpts::Numrows-%numrows+1); %i < $SplitOpts::Numrows; %i++)
			$SplitMSG::Row[%i] = "[[NO DATA FOR SPLITMSG]]";

	HUD::Update(SplitMSGWindow);		
}

// Picked these bitmap names off |HH|Crunchy's KillsHUD - thanx!
// whole lookup table looks basically the same :)
// I used some of Crunchy's bitmaps too, nice work.
$SplitMSG::WeaponIcon["Blaster"] = "lr_blaster_on.bmp> ";
$SplitMSG::WeaponIcon["Plasma"] = "lr_plasma_on.bmp> ";
$SplitMSG::WeaponIcon["Chaingun"] = "lr_chain_on.bmp> ";
$SplitMSG::WeaponIcon["Disc Launcher"] = "lr_disk_on.bmp> ";
$SplitMSG::WeaponIcon["Explosives"] = "lr_grenade_on.bmp> ";
$SplitMSG::WeaponIcon["Laser Rifle"] = "lr_sniper_on.bmp> ";
$SplitMSG::WeaponIcon["ELF Gun"] = "lr_energyrifle_on.bmp> ";
$SplitMSG::WeaponIcon["Mortar"] = "lr_mortar_on.bmp> ";

$SplitMSG::WeaponIcon["Turret"] = "vektor\\small_turret_on.bmp> ";
$SplitMSG::WeaponIcon["Vehicle"] = "vektor\\small_vehicle_on.bmp> ";
$SplitMSG::WeaponIcon["Missile"] = "vektor\\small_missile_on.bmp> ";
$SplitMSG::WeaponIcon["Debris"] = "vektor\\small_debris_on.bmp> ";
$SplitMSG::WeaponIcon["Team Kill"] = "vektor\\small_tk_on.bmp> ";
$SplitMSG::WeaponIcon["Suicide"] = "skull_small.bmp> ";

$SplitMSG::WeaponOther = "skull_small.bmp> ";


// Makes death messages shorter, saves filtering/pixel-length
// processor time (cause I don't have to check length!)
function SplitMSG::BuildDeathMsg() {

	if (($KillTrak::victim == 0) || ($KillTrak::killer == 0))
		return;

	if (client::getteam($KillTrak::victim) == Team::Friendly())
		%victimbmp = ",4:M_radar_green.bmp>";
	else
		%victimbmp = ",2:M_radar_red.bmp>";

	if (client::getteam($KillTrak::Killer) == Team::Friendly())
		%killerbmp = ",4:M_radar_green.bmp>";
	else
		%killerbmp = ",2:M_radar_red.bmp>";

	if ($KillTrak::Killer == $KillTrak::Victim) {
		if ($SplitMSG::WeaponIcon[$KillTrak::weapon] != "")
			%msg = "<B0" @ %killerbmp @ Client::Getname($KillTrak::Killer) @ " <B0,2:" @ $SplitMSG::WeaponIcon[$KillTrak::weapon]; 
		else
			%msg = "<B0" @ %killerbmp @ Client::Getname($KillTrak::Killer) @ " <B0,2:" @ $SplitMSG::WeaponOther;
	} else if ($SplitMSG::WeaponIcon[$KillTrak::weapon] != "") 
		%msg = "<B0" @ %killerbmp @ Client::Getname($KillTrak::Killer) @ " <B0,2:" @ $SplitMSG::WeaponIcon[$KillTrak::weapon] @ Client::Getname($KillTrak::Victim) @ "<jr><B6" @ %victimbmp;
	else
		%msg = "<B0" @ %killerbmp @ Client::Getname($KillTrak::Killer) @ " <B0,2:" @ $SplitMSG::WeaponOther @ Client::Getname($KillTrak::Victim) @ "<jr><B6" @ %victimbmp;
	
	if ((($KillTrak::victim == getManagerID()) || ($KillTrak::Killer == getManagerID())) && ($SplitOpts::HiLightMe))
		%msg = "<f1>" @ %msg;
	else if ((included("VeKToR\\BudHud.cs")) && ($SplitOpts::HiLightBuds) && ((BudHud::IDBuddy(client::getname($KillTrak::victim)) != -1) || (BudHud::IDBuddy(client::getname($KillTrak::killer)) != -1)))
		%msg = "<f1>" @ %msg;			

	return %msg;	
}


function SplitMSG::ParseMessage(%client, %message) {

	// Take out "Just harmed teammate" crap if opt is selected
	// Do filter in seperate if, so it the matching doesn't even get
	// evaluated if the option is off...
	if ($SplitOpts::FilterTeamDamage)	
		if ((Match::ParamString(%message, "You just harmed Teammate%1")) || (Match::ParamString(%message, "You took Friendly Fire from%1"))) 
			return mute;

	if (%client != 0)
		return;

	// Cycle thru all known Death Messages and mute it if applicable
	// Note: if it's a DeathMsg, it will be muted... but also thrown
	// into another HUD window, so Don't worry about missing em.
	// Yeah, yeah, this IS how Presto did it... and I have to do
	// it again... eats processor time, but Presto doesn't have any
	// way of checking his filtering results, so...

	// Death strings eat the most processor time, cause there's so many
	// of them!
	if (($SplitMSG::FilterDeathStrings) || ($SplitMSG::OverrideKillTrak))
		for (%i = 0; %i < $KillTrak::numDeaths; %i++) {
			if (Match::ParamString(%message, $KillTrak::death[%i])) {

				// Presto's KillTrak (override) stuff
				// Do NOT give me ANY credit for ANYTHING inbetween these
				// funny hyphen-linez, it's not mine (just copy-pasted out
				// of KillTrak.cs for maintaining compatability even in
				// override mode)
				// -------------------------------------------------------------
				if ($SplitMSG::OverrideKillTrak) {
					$KillTrak::victim = getClientByName(Match::Result(2));
					if ($KillTrak::death[%i, suicide])
						$KillTrak::killer = $KillTrak::victim;
					else	$KillTrak::killer = getClientByName(Match::Result(1));
					$KillTrak::weapon = $KillTrak::death[%i, weapon];
					Event::Trigger(eventKillTrak, $KillTrak::killer, $KillTrak::victim, $KillTrak::weapon);
				}

				// --------------------------------------------------------------

				if ($SplitMSG::FilterDeathStrings) {
					if ($SplitMSG::DisplayDeathStrings) 
						SplitMSG::PostNewMsg(SplitMSG::BuildDeathMsg(), true);
					return mute;
				}
			}
		}

	if ($SplitMSG::BuiltFilters)
		for (%i = 0; %i < $SplitMSG::NumGroups; %i++) {
			%group = $SplitMSG::groupindex[%i];
			if ($SplitMSG::groupFilter[%group])
				for (%j = 0; %j < $SplitMSG::groupNumMessages[%group]; %j++) {
					if (Match::ParamString(%message, $SplitMSG::groupMessage[%group, %j])) {			
						if ($SplitMSG::groupdisplay[%group])
							SplitMSG::PostNewMsg(%message, false);
						return mute;
					}
				}
		}

	return;
        
}

function SplitMSG::RecalcHUD() {
	%disp = HUD::GetDisplayed(SplitMSGWindow);	
	HUD::Move(SplitMSGWindow, HUD::GetPosition(SplitMSGWindow));
	if (%disp)
		HUD::Update(SplitMSGWindow);
}

// Attach all our pretty little events
Event::attach(eventClientMessage, SplitMSG::ParseMessage);
Event::attach(eventConnected, "SplitMSG::Init();");

// Detach Presto's default function IF overriding was enabled for better
// preformance
if ($SplitMSG::OverrideKillTrak) {
	Event::Detach(eventClientMessage, KillTrak::OnClientMessage);
	echo("Detaching Presto's KillTrak :(");
}

// Some HUDs update/resize on clients doing stuff (TeamHUD for one)
// so, to keep everything updated and in its non-overlapping position,
// I just move the HUD to its relative position... will be unnecessary in
// future versions, but until then...
Event::Attach(eventClientJoin, "SplitMSG::RecalcHUD();");
Event::Attach(eventClientDrop, "SplitMSG::RecalcHUD();");
Event::Attach(eventClientChangeTeam, "SplitMSG::RecalcHUD();");

function SplitOpts::FilterChooser() {
	$SplitOpts::Filter = FGCombo::getSelected("SplitOpts::FilterChooser");

	if ($SplitOpts::Filter == 0) {
		control::setvalue("SplitOpts::FilterBox", $SplitMSG::FilterDeathStrings);
		control::setvalue("SplitOpts::DisplayBox", $SplitMSG::FilterDeathStrings);
	} else {
		%groupname = $SplitMSG::groupindex[$SplitOpts::Filter-1];
		control::setvalue("SplitOpts::FilterBox", $SplitMSG::GroupFilter[%groupname]);
		control::setvalue("SplitOpts::DisplayBox", $SplitMSG::GroupDisplay[%groupname]);
	}
}


function SplitOpts::UpdateFilterBox() {
	if ($SplitOpts::Filter == 0) {
		$SplitMSG::FilterDeathStrings = control::getValue("SplitOpts::FilterBox");
	} else {
		%groupname = $SplitMSG::groupindex[$SplitOpts::Filter-1];
		$SplitMSG::GroupFilter[%groupname] = control::getvalue("SplitOpts::FilterBox");
	}
	SplitMSG::BuildMenu();
}


function SplitOpts::UpdateDisplayBox() {
	if ($SplitOpts::Filter == 0) {
		$SplitMSG::DisplayDeathStrings = control::getValue("SplitOpts::DisplayBox");
	} else {
		%groupname = $SplitMSG::groupindex[$SplitOpts::Filter-1];
		$SplitMSG::GroupDisplay[%groupname] = control::getvalue("SplitOpts::DisplayBox");
	}
	SplitMSG::BuildMenu();
}


function SplitOpts::AddRow() {
	if ($SplitOpts::NumRows < 8)
		$SplitOpts::NumRows++;
	else
		$SplitOpts::NumRows = 8;

	Control::SetValue("SplitOpts::DisplayRows", $SplitOpts::NumRows);

	// Rebuild the SplitMSG hud - number o' rows has changes!
	// it'll be cleared too...
	if (Hud::Exists(SplitMSGWindow)) {
		for (%i = 0; (%i < $SplitOpts::NumRows); %i++) {
			$SplitMSG::Row[%i] = "";
			$SplitMSG::RowHeight[%i] = 1;
			$SplitMSG::Obj[%i] = false;
		}

		$disp = HUD::GetDisplayed(SplitMSGWindow);
		HUD::NewFrame(SplitMSGWindow, "SplitMSG::UpdateWindow", getword(Hud::GetPosition(SplitMSGWindow), 0) @ " " @ getword(Hud::GetPosition(SplitMSGWindow), 1) @ " " @ getword(Hud::GetPosition(SplitMSGWindow), 2) @ " " @ $SplitOpts::NumRows @ "*14");
		HUD::Display(SplitMSGWindow, %disp);
		HudMover::constrainHud(SplitMSGWindow, size);
		for (%i = 0; %i < $SplitOpts::NumRows; %i++) 
			$SplitMSG::Obj[%i] = HUD::Addobject(SplitMSGWindow, FearGuiFormattedText, 4, (%i * 14)-1, HUD::Width(SplitMSGWindow)-4, (14*($SplitOpts::NumRows - %i))-1);
	}
}


function SplitOpts::DelRow() {
	if ($SplitOpts::NumRows > 1)
		$SplitOpts::NumRows--;
	else
		$SplitOpts::NumRows = 1;

	Control::SetValue("SplitOpts::DisplayRows", $SplitOpts::NumRows);

	// Rebuild the SplitMSG hud - number o' rows has changes!
	// it'll be cleared too...
	if (Hud::Exists(SplitMSGWindow)) {
		for (%i = 0; (%i < $SplitOpts::NumRows); %i++) {
			$SplitMSG::Row[%i] = "";
			$SplitMSG::RowHeight[%i] = 1;
			$SplitMSG::Obj[%i] = false;
		}

		$disp = HUD::GetDisplayed(SplitMSGWindow);
		HUD::NewFrame(SplitMSGWindow, "SplitMSG::UpdateWindow", getword(Hud::GetPosition(SplitMSGWindow), 0) @ " " @ getword(Hud::GetPosition(SplitMSGWindow), 1) @ " " @ getword(Hud::GetPosition(SplitMSGWindow), 2) @ " " @ $SplitOpts::NumRows @ "*14");
		HUD::Display(SplitMSGWindow, %disp);
		HudMover::constrainHud(SplitMSGWindow, size);
		for (%i = 0; %i < $SplitOpts::NumRows; %i++) 
			$SplitMSG::Obj[%i] = HUD::Addobject(SplitMSGWindow, FearGuiFormattedText, 4, (%i * 14)-1, HUD::Width(SplitMSGWindow)-4, (14*($SplitOpts::NumRows - %i))-1);
	}
}


function SplitOpts::UpdateVisible() {
	if (Hud::Exists(SplitMSGWindow))
		HUD::Display(SplitMSGWindow, $SplitOpts::HudOn);
}


function SplitOpts::OnOpen() {
	FGCombo::SetSelected("SplitOpts::FilterChooser", $SplitOpts::Filter);
	%groupname = $SplitMSG::groupindex[$SplitOpts::Filter-1];

	if ($SplitOpts::NumRows > 8)
		$SplitOpts::NumRows = 8;
	else if ($SplitOpts::NumRows < 1)
		$SplitOpts::NumRows = 1;

	if ($SplitOpts::Filter == 0) {
		control::setvalue("SplitOpts::FilterBox", $SplitMSG::FilterDeathStrings);
		control::setvalue("SplitOpts::DisplayBox", $SplitMSG::DisplayDeathStrings);
	} else {
		control::setvalue("SplitOpts::FilterBox", $SplitMSG::GroupFilter[%groupname]);
		control::setvalue("SplitOpts::DisplayBox", $SplitMSG::GroupDisplay[%groupname]);
	}

	control::setvalue("SplitOpts::DisplayRows", $SplitOpts::NumRows);

	if (included("VeKToR\\BudHud.cs")) {
		control::setvisible("SplitOpts::HiLightBuds", true);		
		control::setvisible("SplitOpts::Label6", true);		
	} else {
		control::setvisible("SplitOpts:::Label6", false);		
		control::setvisible("SplitOpts::HiLightBuds", false);		
		$SplitOpts::HiLightBuds = false;
	}
}


function SplitOpts::OnClose() {

	export("$SplitOpts::*", "config\\SplitOpts.cs", false);
	export("$SplitMSG::groupfilter*", "config\\SplitOpts.cs", true);
	export("$SplitMSG::groupdisplay*", "config\\SplitOpts.cs", true);
	export("$SplitMSG::DisplayDeathStrings", "config\\SplitOpts.cs", true);
	export("$SplitMSG::FilterDeathStrings", "config\\SplitOpts.cs", true);
}
Event::Attach(eventExit, "SplitOpts::OnClose();");

NewOpts::register("SplitMsg Options", "config\\VeKToR\\gui\\SplitOpts.gui", "SplitOpts::OnOpen();", "SplitOpts::OnClose();", TRUE);
SplitMSG::BuildFilters();
