// BudHudMenus.cs - Builds default budhud menus and allows others to add menus of their own.
// ------------------------------------------------------------------------------------------
// Triggers certain events to inform other scripts about 
// information used in assembling the menus
//
// eventBudHudInitMenu 	
//			- the BudHud menu has just been rebuilt, add
//                        your custom menus _NOW_ (not the info, just the
//                        menus)
//
// eventBudHudRebuildClient (%client, %name, %team, %bud)
//			- Updating info for client ID number %client
//			  %name is the client's name
//			  %team is the client's team (-1 if observer)
//			  %bud is the client's buddy index number (-1 if not a bud)
//			  this is called for every client that gets updated.
//
// eventBudHudMenuCleanup
//			- The BudHud menu has finished all the client info
//			  and is about to get rid of any extra variables used
//			  in the creation process. If you have anything else to
//			  do, now's the time. (ie my Remove Bud menu)
//
//
// ------------------------------------------------------------------------------------------
// Function Information
// ------------------------------------------------------------------------------------------
// BudHudMenu::InitMenu(%menutag, %menuname, %ownermenu, %letter)
//	Creates a BudHud Menu. %menutag is a "nickname" for the menu. You will use
//	this tag to reference the menu in other functions. It should be unique - no
//	other menu should have the same tag as yours, otherwise strange things will happen 
//	(ie BudHudTeamMenu) %menuname is a description of the menu. This doesn't have to 
//	unique, but should give the user an idea of what the menu is. This text is what you 
//	see on the BudHud menu as an option linking to your menu (ie "Friendly Waypoint Menu"). 
//	%ownermenu is the menu you want to "connect" your menu to. Your menu list will be 
//	added to this menu (ie BudHudMenu). %letter is the letter you want your menu to be
//	assigned to (ie user presses this letter to get your menu - if you're attaching to a
//	dynamic list-menu, you may want to use non-alphanum characters like " ", ".", ";" 
//	since letters are auto-assigned in these menus)
//
// BudHudMenu::AddOption(%menutag, %description, %action, %prefletter)
//	Adds an option to a menu you've created (with BudHudMenu::Initmenu). %menutag is the
//	same menu tag you gave to the menu you want the option to go in (ie BudHudTeamMenu
//	from above), %description is the description that you want to appear on the menu
//	(ie "KillTrack <player x>"), action is the command you want to be executed when the
//	menu option is selected (ie "VitaMenu::KillTrackPlayer(" @ %name @ ");") %prefletter
//	is the *preferred* letter you'd like to have the option assigned to. If the letter
//	has already been used, it will have another letter auto-assigned to it. The addoption
//	function automatically handles wrapping menu pages, so they fit on any screen size

// ------------------------------------------------------------------------------------------
// All the support code for automatically adding paged-menus
// ------------------------------------------------------------------------------------------

// This is used in the gui. Checking if an observer and displaying the menus is too
// long for one CFGButton value, so I use this function instead.
function BudHudMenu::ShowMenu(%menu, %observertest) {
	if (((%observertest) && (client::getteam(getmanagerid()) != -1)) || (!%observertest)) {
		BudHud::RebuildWaypointMenu();
		Menu::Display(%menu);
	}
}

// Since this menu is re-sized depending on screen dimensions, it's important to use ALL
// the available screen sizes. Since these are NOT implemented in Presto's function, I
// add definitions for some that have been missed here.
$Presto::screenSize["360x288(V)"] = "360 288";
$Presto::screenSize["720x480"] = "720 480";
$Presto::screenSize["720x576"] = "720 576";
$Presto::screenSize["960x720"] = "960 720";

// Adds a budhud submenu to a budhudmenu
// %menutag is a unique menu ID tag (ie "FrWaypointMenu")
// %menuname is the name that will appear when you bring the menu up (ie "Friendly Waypoint Menu")
// %ownermenu is the menu you want to attach your new menu to (ie "BudHudMenu")
// %letter is the letter you want to use to bring up the menu
function BudHudMenu::InitMenu(%menutag, %menuname, %ownermenu, %letter) {
	Menu::New(%menutag @ "0", %menuname);
	Menu::Addmenu(%ownermenu, %letter @ %description, %menutag @ "0");

	// initial values
	$BudMenuData::MenuName[%menutag] = %menuname;
	$BudMenuData::MenuNum[%menutag] = 0;
	$BudMenuData::NumEntries[%menutag] = 0;

	// Clear our "letters used list"
	%wordnum = 0;
	while(%let != -1) {
                %let = getword($BudHud::alphabet, %wordnum);
		%wordnum++;
		%letterused[%let] = false;
	}
}

// Adds an option to a BudHudMenu - takes into consideration generating multiple pages,
// adding the more option, etc.
// %menutag is the unique menu ID tag from above (ie "FrWaypointMenu")
// %description is the 
function BudHudMenu::AddOption(%menutag, %description, %action, %prefletter) {

	// Menu not initialized? Return!
	if (($BudMenuData::MenuNum[%menutag] == "") || ($BudMenuData::NumEntries[%menutag] == "") || ($BudMenuData::menuname[%menutag] == ""))
		return false;


	$BudMenuData::letterused["", %menutag] = true;

        %let = %prefletter;
        if (($BudMenuData::letterused[%let, %menutag]) || (%let == "") || (String::FindSubStr($BudHud::alphabet, %let) == -1)) {
		%wordnum = 0;
		%let = "";
		while($BudMenuData::letterused[%let, %menutag]) {
	                %let = getword($BudHud::Alphabet, %wordnum);
			%wordnum++;

			if (%let == -1)
				break;
		}
	}
		
	$BudMenuData::letterused[%let, %menutag] = true;

	if (($BudMenuData::NumEntries[%menutag] > $BudMenuData::MaxEntries) || (%let == -1)) {
		Menu::AddMenu(%menutag @ $BudMenuData::MenuNum[%menutag], "oMore...", %menutag @ $BudMenuData::MenuNum[%menutag]+1);
		Menu::New(%menutag @ $BudMenuData::MenuNum[%menutag]+1, $BudMenuData::menuname[%menutag]);
		$BudMenuData::MenuNum[%menutag]++;

		// since this is code will be executed AFTER the next client add, 
		// and we increment the NumEntries below, we want it to total 0
		// on the next loop thru, therefore we set it to 0 - 1, or -1.
		$BudMenuData::NumEntries[%menutag] = -1;

		// clear used letters
		%wordnum = 0;
		while(%let2 != -1) {
	                %let2 = getword($BudHud::alphabet, %wordnum);
			%wordnum++;
			$BudMenuData::letterused[%let2, %menutag] = false;
		}

	        %let = %prefletter;
	        if (($BudMenuData::letterused[%let, %menutag]) || (%let == "") || (String::FindSubStr($BudHud::alphabet, %let) == -1)) {
			%wordnum = 0;
			%let = "";
			while($BudMenuData::letterused[%let, %menutag]) {
		                %let = getword($BudHud::Alphabet, %wordnum);
				%wordnum++;

			}
		}
	}

	Menu::AddChoice(%menutag @ $BudMenuData::MenuNum[%menutag], %let @ %description, %action);
	$BudMenuData::NumEntries[%menutag]++;
	return true;
}

// ------------------------------------------------------------------------------------------
// Handles all the events that go into assembling the menus
// ------------------------------------------------------------------------------------------
function BudHud::RebuildWaypointMenu() {

	if (!$BudHudData::NeedUpdate)
		return;	

	// Assume message chat box is at mid-size (don't know how to determine this...)
	// display menus across 3/4 of the screen.
	$BudMenuData::MaxEntries = floor((3/4) * ((getword(Presto::ScreenSize(), 1) - 70) / 14));
	echo($BudMenuData::MaxEntries);

	if ($BudMenuData::MaxEntries < 8)
		$BudMenuData::MaxEntries = 8;

	// Build the base menu. Everything else gets built off of this, or off of menus built
	// off this...
	Menu::New("BudHudMenu", "Waypoint Menu");
	
	Event::Trigger(eventBudHudInitMenu);

	// Builds all the menus except remove bud from list
        for (%i = 2049; %i <= $BudHud::HighestClient; %i++) {

		echo(%i);

		%name = $BudHudData::ClientName[%i];
		%team = $BudHudData::ClientTeam[%i];
                %bud = BudHud::IDBuddy(%name);         

		// Call only if he's a real client (still online), and not yourself!
		if ((%name != "") && (%i != getManagerID()))
			Event::Trigger(eventBudHudRebuildClient, %i, %name, %team, %bud);	
	}

	Event::Trigger(eventBudHudMenuCleanup);

	deletevariables("$BudMenuData::*");
	$BudHudData::NeedUpdate = false;
	debug("    ----------------------------------------------------------");
}


// ------------------------------------------------------------------------------------------
// Creates and hooks all the menus in at their appropriate spot (dependant on observer status :)
// Actually makes the menu info
// ------------------------------------------------------------------------------------------
function BudHudMenu::InitMainMenus() {
	if (client::getteam(getmanagerid()) != -1) {
		BudHudMenu::InitMenu("BudHudTeamMenu", "Waypoint Friendly...", "BudHudMenu", "f");
		BudHudMenu::InitMenu("BudHudEnemyMenu", "Waypoint Enemy...", "BudHudMenu", "e");
		BudHudMenu::InitMenu("BudHudBuddyMenu", "Waypoint Buddy...", "BudHudMenu", "b");
	}

        Menu::AddChoice("BudHudMenu", "mPager Mute Menu...", "BudHud::RebuildMuteMenu(); Menu::Display(BudHudMute);");

	// Manually add - no paged list here.
	if (client::getteam(getmanagerid()) != -1) {
	        Menu::AddChoice("BudHudMenu", "gFriendly Flag Carrier", "Waypoint::Flag(2048, Team::Enemy());");
	        Menu::AddChoice("BudHudMenu", "hEnemy Flag Carrier", "Waypoint::Flag(2048, Team::Friendly());");
	        Menu::AddChoice("BudHudMenu", "cCancel Waypoint", "Waypoint::Cancel();");
	}		

        Menu::Addchoice("BudHudMenu", "qClear BudHud Message Queue", "BudHud::ClearQueue();");
        Menu::Addchoice("BudHudMenu", "oOptions...", "BudHud::OptionsMenu();");

	BudHudMenu::InitMenu("BudHudAddMenu", "Add Buddy to list...", "BudHudOptions", " ");
	BudHudMenu::InitMenu("BudHudRemoveMenu", "Remove Buddy From list...", "BudHudOptions", ";");
	BudHudMenu::InitMenu("BudHudIgnoreMenu", "Ignore a Buddy...", "BudHudOptions", ".");
}
Event::Attach(eventBudHudInitMenu, "BudHudMenu::InitMainMenus();");

// This handles adding information to the menus we just built!
function BudHudMenu::AddInfoToMenu(%i, %name, %team, %bud) {
	if (%team != -1) {

		if ((%team == Team::Friendly()) && (client::getteam(getmanagerid()) != -1))
			BudHudMenu::AddOption("BudHudTeamMenu", %name, "Waypoint::Client(2048, " @ %i @ ", 1, \"Escort \", \"~wescfr\");");				
		else  if (client::getteam(getmanagerid()) != -1) 
			BudHudMenu::AddOption("BudHudEnemyMenu", %name, "Waypoint::Client(2048, " @ %i @ ", 1, \"Kill \", \"~wattway\");");				
		
		if (%bud != -1) {
			if (%team == Team::Friendly()) {
				BudHudMenu::AddOption("BudHudBuddyMenu", %name @ "    (Teammate)", "Waypoint::Client(2048, " @ %i @ ", 2, \"Escort \", \"~wescfr\");", $BudHud::Letter[%bud]);
				BudHudMenu::AddOption("BudHudIgnoreMenu", %name @ "    (Teammate)", "$BudHud::Ignore[" @ %name @ "] = true; $BudHudData::NeedUpdate = true;", $BudHud::Letter[%bud]);
			} else {
				BudHudMenu::AddOption("BudHudBuddyMenu", %name @ "    (Enemy)", "Waypoint::Client(2048, " @ %i @ ", 2, \"Kill \", \"~wattway\");", $BudHud::Letter[%bud]);
				BudHudMenu::AddOption("BudHudIgnoreMenu", %name @ "    (Enemy)", "$BudHud::Ignore[" @ %name @ "] = true; $BudHudData::NeedUpdate = true;", $BudHud::Letter[%bud]);
			}

		} else if ($BudHud::HardCodeIgnore[%name] != true) {

			if ($BudHud::Ignore[%name] == true)
				%teamtext = "    (Ignored)";
			else if (%team == Team::Friendly())
				%teamtext = "    (Teammate)";
			else
				%teamtext = "    (Enemy)";

			if ($BudHud::Ignore[%name] == true)
				BudHudMenu::AddOption("BudHudAddMenu", %name @ %teamtext, "deletevariables(\"$BudHud::Ignore" @ %name @ "\");$BudHudData::NeedUpdate = true;");
			else
				BudHudMenu::AddOption("BudHudAddMenu", %name @ %teamtext, "BudHud::ChooseMenu(\"" @ %name @ "\");$BudHudData::NeedUpdate = true;");

		}
	}
}
Event::attach(eventBudHudRebuildClient, BudHudMenu::AddInfoToMenu);

// Build the remove menu after everything's done
function BudHudMenu::RemoveMenu() {
	for (%t = 0; %t < 2; %t++) {

		if (%t == 0) {
			%permstat = "";
			%iamperm = true;
		} else {
			%iamperm = false;
			%permstat = "    (Temporary)";
		}		

                if (($BudHud::PermFriends[%iamperm] > 0) && ($BudHud::PermFriends[%iamperm] != ""))
                        for (%i = 0; %i < $BudHud::PermFriends[%iamperm]; %i++) {
                                debug("    Adding \"Remove buddy\" entry for " @ $BudHud::PermFriendString[%iamperm, %i]);
				BudHudMenu::AddOption("BudHudRemoveMenu", $BudHud::PermFriendString[%iamperm, %i] @ %permstat, "BudHud::RemoveBuddy(" @ %i @ ", " @ %iamperm @ ");$BudHudData::NeedUpdate = true;");
			}
	}
}
Event::Attach(eventBudHudMenuCleanup, "BudHudMenu::RemoveMenu();");

// ------------------------------------------------------------------------------------------
// Mute Menu stuff
// ------------------------------------------------------------------------------------------

function BudHud::MutePager(%index) {
	$BudHud::Mute[$BudHud::MuteMenu[%index]] = true;

	for (%i = %index; %i < 5; %i++) {
		$BudHud::MuteMenu[%i] = $BudHud::MuteMenu[%i+1];
	}

	$BudHud::MuteMenu[5] = "";
}

function BudHud::RebuildMuteMenu() {
        Menu::New("BudHudMute", "Pager - Mute clients");
	Menu::New("JDCRemoveMutes", "Pager - UnMute clients");	

	%added = false;

	for (%i = 0; %i < 5; %i++)
                if (($BudHud::MuteMenu[%i] != "") && ($BudHudData::ClientName[$BudHud::MuteMenu[%i]] != "") && (!$BudHud::Mute[$BudHud::MuteMenu[%i]]))
                        Menu::Addchoice("BudHudMute", %i+1 @ $BudHudData::ClientName[$BudHud::MuteMenu[%i]], "BudHud::MutePager(" @ %i @ ");");       

	%let = 0;
        for (%i = 2049; %i <= $BudHud::HighestClient; %i++) 
                if ($BudHud::Mute[%i]) {
			if (!%added) {
                                Menu::AddMenu("BudHudMute", "rRemove Mutes", "JDCRemoveMutes");
				%added = true;
			}
		
                        Menu::Addchoice("JDCRemoveMutes", getword($BudHud::alphabet, %let) @ $BudHudData::ClientName[%i], "$BudHud::Mute[" @ %i @ "] = false; BudHud::RebuildMuteMenu(); RemoteBP(2048, \"<jc><f2>\" @ $BudHudData::ClientName[%i] @ \" Un-Muted\", 3);"); 
			%let++;
		}
}

// Adds a client to the pager mute menu, if he's not already there.
function BudHud::AddToMuteMenu(%client) {

	// Note here: the menu is hard-coded at 6 elements, so no dynamic
	// adding here, just keep it simple.

	// check if name is already added so we don't get repeats
	for (%i = 0; %i < 5; %i++)
                if (%client == $BudHud::MuteMenu[%i])
			return;

	debug("Adding \"pager\" mute menu name - " @ $BudHudData::ClientName[%client]);

	// Shift em all down by one.
	for (%i = 4; %i >= 0; %i--)
                $BudHud::MuteMenu[%i+1] = $BudHud::MuteMenu[%i];

        $BudHud::MuteMenu[0] = %client; 
}

// ------------------------------------------------------------------------------------------
// Builds the Options menu - called just before options menu is called.
// ------------------------------------------------------------------------------------------
function BudHud::OptionsMenu() {
	debug("Rebuild options menu");

	// Clear the previous menu to rebuild
	Menu::New("BudHudOptions", "BudHud Options Menu...");

	// gotta re-attach the bud management every time I rebuild :(
	Menu::AddMenu("BudHudOptions", " Add Buddy To List...", "BudHudAddMenu0");
	Menu::AddMenu("BudHudOptions", ".Remove Buddy From List...", "BudHudRemoveMenu0");
	Menu::AddMenu("BudHudOptions", ";Ignore Buddy...", "BudHudIgnoreMenu0");

	debug("Checking PagerActive");
	if ($BudHud::PagerActive)
		%optext = "Disable";
	else
		%optext = "Enable";
	debug("Pager Optext is: " @ %optext @ " adding to menu");
	Menu::Addchoice("BudHudOptions", "p" @ %optext @ " pop-up Pager", "BudHud::ClearQueue(); $BudHud::PagerActive = !$BudHud::PagerActive;");

	debug("Checking SoundActive");
	debug("Rebuild options menu");
	if ($BudHud::SoundActive)
		%optext = "Disable";
	else
		%optext = "Enable";
	debug("Sound optext is: " @ %optext @ " adding to menu");
	Menu::Addchoice("BudHudOptions", "s" @ %optext @ " sounds", "$BudHud::SoundActive = !$BudHud::SoundActive;");

	// show the blasted thing!
	Menu::Display(BudHudOptions);
}

// ------------------------------------------------------------------------------------------
// Builds the perm/temp menu for dynamically adding clients.
// ------------------------------------------------------------------------------------------
function BudHud::ChooseMenu(%name) {
        Menu::New("BudHud::TempChoice", "Add " @ %name @ " to buddy list");

	// Add choices, rebuild menus, etc.
        Menu::Addchoice("BudHud::TempChoice", "tTemporary buddy list", "BudHud::DynAddFriend(\"" @ %name @ "\", false);BudHud::RebuildWaypointMenu();BudHud::RebuildAddMenu();");
        Menu::Addchoice("BudHud::TempChoice", "pPermanent buddy list", "BudHud::DynAddFriend(\"" @ %name @ "\", true);BudHud::RebuildWaypointMenu();BudHud::RebuildAddMenu();");

        Menu::Display("BudHud::TempChoice");
}

function AddFakeClients(%num) {
	for (%i = 0; %i < %num; %i++) {
		$BudHud::HighestClient++;
		$BudHudData::ClientName[$BudHud::HighestClient] = "Player" @ $BudHud::HighestClient;
		$BudHudData::ClientTeam[$BudHud::HighestClient] = Client::GetTeam(getmanagerid());		
	}
	$BudHudData::NeedUpdate = true;
}