/* VOLDIR v1.0
 * by Ludwig Pummer
 * (ludwigp@bigfoot.com or ludwigp@email.com
 *
 * This program extracts filenames out of the .vol files from Dynamix's
 * Starsiege: Tribes game. This file listing is useful for (among other things)
 * extracting files from .vol files using Dynamix's VTEXTRACT.EXE program.
 * Dynamix actually also made a program which gives a file listing of .vol files
 * but their program doesn't allow for redirecting stdout, so if there are more
 * than a screen's length of files, one cannot get a complete listing.
 *
 * Thanks to LabRat (http://labrat1.simplenet.com/sstribes/) for his hints on
 * the .vol file structure.
 *
 * Yes, I know this code is messy. All I know about C programming I learned
 * by skimming reference books and the beginning of my 'A Book on C' book
 * which I haven't had time to study thoroughly.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main(int argc, char *argv[]){
	int x,c,found=0;
    char tmpstr[255], *prefilename;
	long pos, endpos;
	FILE *volfile, *listdest, *debugmsg;

    /* debugmsg=stderr;*/
    debugmsg=fopen("voldir.dbg", "w");

    if(argc==1){
	  printf("VOLDIR v1.0\nby Ludwig Pummer (ludwigp@bigfoot.com ludwigp@email.com)\n\n");
	  printf("Usage:\nvoldir volfile.vol [extractor.bat]\n\n");
	  printf("volfile.vol is the name of the .vol file to get a file listing for.\n");
	  printf("extractor.bat (optional) is the name of the batch file to store extract\n");
      printf("              commands into. The batch file will require that vtextract.exe\n");
	  printf("              be in the current directory or the path.\n");
      exit(1);
	}

	fprintf(debugmsg, "Attempting to open %s...",argv[1]);
	volfile=fopen(argv[1],"r");
    if(volfile==0) {fprintf(stderr, "couldn't open volfile. dying.\n"); exit(1); }
	fprintf(debugmsg, "success!\n");

    if(argc==3){
	  prefilename=malloc(  sizeof(char)  * ( strlen("vtextract    ") + strlen(argv[1]) ) );
      if(prefilename==0) {fprintf(stderr, "couldn't malloc for prefilename. dying.\n"); exit(1); }
      sprintf(tmpstr, "vtextract %s ", argv[1]);
      strcpy(prefilename, tmpstr);
      listdest=fopen(argv[2],"w");
	} else {
	  prefilename=malloc( ( sizeof(char) ) * 2);
      if(prefilename==0) {fprintf(stderr, "couldn't malloc for prefilename. dying.\n"); exit(1); }
      *prefilename=0;
      listdest=stdout;
    }

	fprintf(debugmsg, "starting search. starting position is %lu.\n", ftell(volfile));
	
    fprintf(debugmsg, "Searching for \"vols\" tag, from the bottom...");
	fseek(volfile, -1, SEEK_END);
    fprintf(debugmsg, "seeked to bottom. pos is %lu.\n", ftell(volfile));
	
	while(!found && ftell(volfile) > 0){ 
	  c=getc(volfile);
	  switch (c)
      { case 's': fseek(volfile, -4, SEEK_CUR); fprintf(debugmsg, "found 's' at %lu.\n", ftell(volfile)); break;
	    case 'l': fseek(volfile, -3, SEEK_CUR); fprintf(debugmsg, "found 'l' at %lu.\n", ftell(volfile)); break;
		case 'o': fseek(volfile, -2, SEEK_CUR); fprintf(debugmsg, "found 'o' at %lu.\n", ftell(volfile)); break;
		case 'v': fprintf(debugmsg, "found 'v' at %lu.\n", ftell(volfile));
                  fseek(volfile, -1, SEEK_CUR); for(x=0;x<4;x++) { tmpstr[x]=getc(volfile); } tmpstr[x]=0;
	              if(!strcmp(tmpstr, "vols\0") ) {
                    found=1; pos=ftell(volfile); fprintf(debugmsg, "found 'vols' at %lu.\n", ftell(volfile)); }
				  else if(!strcmp(tmpstr, "voli\0") )
				    fseek(volfile, -5, SEEK_CUR);
				  else
				    fseek(volfile, -5, SEEK_CUR);
				  break;
		default:  fseek(volfile, -5, SEEK_CUR); break;}
	}
    if(!found)
	  { fprintf(stderr, "\"vols\" not found anywhere in file. perhaps its not a volfile?\n");
	  exit(1); }
    pos=ftell(volfile);
	tmpstr[0]=getc(volfile);
	tmpstr[1]=getc(volfile);
	tmpstr[2]=getc(volfile);
	tmpstr[3]=getc(volfile);
    fprintf(debugmsg, "endpos=%lu+%lu+%lu+%lu+%lu-1\n", ftell(volfile),(unsigned char) tmpstr[0],256*((unsigned char) tmpstr[1]),65536*((unsigned char) tmpstr[2]),16777216*((unsigned char) tmpstr[3]));
	endpos=ftell(volfile)+(unsigned char) tmpstr[0]+256*((unsigned char) tmpstr[1])+65536*((unsigned char) tmpstr[2])+16777216*((unsigned char) tmpstr[3])-1;
	fprintf(debugmsg, "current pos is %lu.\n", ftell(volfile));
    fprintf(debugmsg, "endpos is %lu.", endpos);
	
	while(ftell(volfile)<endpos){
	  for(x=0; x<255 && c!=0; tmpstr[x++]=(c=getc(volfile)));
	  fprintf(listdest, "%s%s\n", prefilename, tmpstr);
	  c=1;
	  }
    fclose(debugmsg);
    remove("voldir.dbg");
	
	free(prefilename);

    exit(0);
}
