newObject(PlayChatMenu, ChatMenu, "Root Menu:");
newObject(CommandChatMenu, ChatMenu, "Command Menu");

function setPlayChatMenu(%heading)
{
   $curPlayChatMenu = %heading;
}

function setCommanderChatMenu(%heading)
{
   $curCommanderChatMenu = %heading;
}

function addPlayTeamChat(%text, %msg, %sound)
{
   if(%sound != "")
   {
      %msg = %msg @ "~w" @ %sound;
   }
   if($curPlayChatMenu != "")
   {
      %text = $curPlayChatMenu @ "\\" @ %text;
   }
   addCMCommand(PlayChatMenu, %text, say, 1, %msg);
}

function addPlayChat(%text, %msg, %sound)
{
   if(%sound != "")
   {
      %msg = %msg @ "~w" @ %sound;
   }
   if($curPlayChatMenu != "")
   {
      %text = $curPlayChatMenu @ "\\" @ %text;
   }
   addCMCommand(PlayChatMenu, %text, say, 0, %msg);
}

function addPlayAnim(%text, %anim, %sound)
{
   if($curPlayChatMenu != "")
   {
      %text = $curPlayChatMenu @ "\\" @ %text;
   }
   addCMCommand(PlayChatMenu, %text, messageAndAnimate, %anim, %sound);
}

function addLocal(%text, %sound)
{
   if($curPlayChatMenu != "")
   {
      %text = $curPlayChatMenu @ "\\" @ %text;
   }
   addCMCommand(PlayChatMenu, %text, localMessage, %sound);
}

function addPlayCMDResponse(%text, %action, %msg, %sound)
{
   if(%sound != "")
      %msg = %msg @ "~w" @ %sound;
   if($curPlayChatMenu != "")
      %text = $curPlayChatMenu @ "\\" @ %text;
   addCMCommand(PlayChatMenu, %text, remoteEval, 2048, "CStatus", %action, %msg);
}

function addCommandResponse(%text, %action, %msg, %sound)
{
   if(%sound != "")
      %msg = %msg @ "~w" @ %sound;
   if($curCommanderChatMenu != "")
      %text = $curCommanderChatMenu @ "\\" @ %text;
   addCMCommand(CommandChatMenu, %text, remoteEval, 2048, "CStatus", %action, %msg);
}


function addContextCommand(%text, %type)
{
   if($curCommanderChatMenu != "")
      %text = $curCommanderChatMenu @ "\\" @ %text;
   addCMCommand(CommandChatMenu, %text, contextCommand, %type);
}

function addCommand(%text, %action, %msg, %sound)
{
   if(%sound != "")
      %msg = %msg @ "~w" @ %sound;
   if($curCommanderChatMenu != "")
      %text = $curCommanderChatMenu @ "\\" @ %text;
   addCMCommand(CommandChatMenu, %text, setIssueCommand, %action, %msg);
}

// Player Chat menu

setPlayChatMenu("vOffense");
		addPlayTeamChat("aAttack!","Attack!", attack);
		addPlayTeamChat("nAttack the enemy","Attack the enemy", attenem);
		addPlayTeamChat("bAttack enemy base","Attack the enemy base", attbase);
		addPlayTeamChat("jAttack objective","Attack objective", attobj);
		addPlayTeamChat("kCapture the objective", "Capture the objective!", capobj);
		addPlayTeamChat("sGet the objective", "Get the objective", getobj);
		addPlayTeamChat("wWait for signal", "Wait for my signal to attack.", waitsig);
		addPlayTeamChat("cCease fire", "Cease fire!", cease);
		addPlayTeamChat("mMove out", "Move out.", moveout);
		addPlayTeamChat("rRetreat", "Retreat!", retreat);
		addPlayTeamChat("hHit deck", "Hit the deck!", hitdeck);
		addPlayTeamChat("eRegroup", "Regroup.", regroup);
		addPlayTeamChat("vCover me", "Cover me!", coverme);
		addPlayTeamChat("gGoing offense", "Going offense.", ono);
		addPlayTeamChat("oGoing on offense", "Go on the offensive.", gooff);
		addPlayTeamChat("tTake Cover", "Take cover!", takcovr);
		addPlayTeamChat("xBoard APC", "Board APC.", boarda);
		addPlayTeamChat("zAPC ready", "APC ready to go... waiting for passengers.", waitpas);

setPlayChatMenu("tTarget");
		addPlayTeamChat("aTarget acquired", "Target Acquired", tgtacq);
		addPlayTeamChat("fFire on my target", "Fire on my target", firetgt);
		addPlayTeamChat("nTarget needed", "I need a target.", needtgt);
		addPlayTeamChat("oTarget out of range", "Target out of range.", tgtout);
		addPlayTeamChat("dDestroy Enemy Generator", "Destroy the enemy genarator.", desgen);
		addPlayTeamChat("eEnemy Generator Destroyed", "Enemy generator destroyed.", gendes);
		addPlayTeamChat("tDestroy Enemy Turret", "Destroy enemy turret.", destur);
		addPlayTeamChat("sEnemy Turret Destroyed", "Enemy turret destroyed.", turdes);

setPlayChatMenu("dDefense");
		addPlayTeamChat("iIncoming Enemies", "Incoming enemies!", incom2);
		addPlayTeamChat("aWe're being attacked", "We are being attacked.", basatt);
		addPlayTeamChat("eEnemy is attacking base", "The enemy is attacking our base.", basundr);
		addPlayTeamChat("nNeed more defense", "We need more defense.", needdef);
		addPlayTeamChat("bDefend our base", "Defend our base.", defbase);
		addPlayTeamChat("dDefending base", "Defending our base.", defend);
		addPlayTeamChat("gGo on the defensive", "Go on the defensive.", godef);
		addPlayTeamChat("tBase Taken", "Base is taken.", basetkn);
		addPlayTeamChat("cBase Clear", "Base is secured.", bsclr2);
		addPlayTeamChat("qIs Base Clear?", "Is our base clear?", isbsclr);
		addPlayTeamChat("oDefend Objective", "Defend objective.", defobj);

setPlayChatMenu("fFlag");
		addPlayTeamChat("gFlag gone", "Our flag is not in the base!", flgtkn1);
		addPlayTeamChat("eEnemy has flag", "The enemy has our flag!", flgtkm2);
		addPlayTeamChat("hHave enemy flag", "I have the enemy flag.", haveflg);
		addPlayTeamChat("sFlag secure", "Our flag is secure.", flaghm);
		addPlayTeamChat("rReturn our flag", "Return our flag to base.", retflag);
		addPlayTeamChat("fGet enemy flag", "Get the enemy flag.", geteflg);
		addPlayTeamChat("mFlag mined", "Our flag is mined.", flgmine);
		addPlayTeamChat("cClear mines", "Clear the mines from our flag.", clrflg);
		addPlayTeamChat("dMines cleared", "Mines have been cleared.", mineclr);

setPlayChatMenu("rNeed");
		addPlayTeamChat("rNeed Repairs", "Need repairs.", needrep);
		addPlayTeamChat("aNeed APC Pickup", "I need an APC pickup.", needpku);
		addPlayTeamChat("eNeed Escort", "I need an escort back to base.", needesc);
		addPlayTeamChat("tNeed Ammo", "Can anyone bring me some ammo?", needamo);
		addPlayTeamChat("oRepair Objective", "Repair objective", repobj);




setPlayChatMenu("eTeam");
		addPlayTeamChat("wWatch Shooting", "Watch where your shooting!", wshoot3);
		addPlayTeamChat("dDont know", "I don't know.", dontkno);
		addPlayTeamChat("nNo", "No.", no);
		addPlayTeamChat("yYes", "Yes.", yes);
		addPlayTeamChat("tThanks", "Thanks.", thanks);
		addPlayTeamChat("aNo Problem", "No Problem.", noprob);
		addPlayTeamChat("sSorry", "Sorry.", sorry);
		addPlayTeamChat("]Ready", "Ready", ready);
		addPlayTeamChat("eHelp", "Help!.", help);
		addPlayTeamChat("[Wait", "Wait", wait1);
		addLocal("hHurry station", hurystn);

setPlayChatMenu("gGlobal");
		addPlayChat("zDoh", "Doh!", oops1);
		addPlayChat("oOops", "Oops!", oops2);
		addPlayChat("sShazbot", "Shazbot!", color2);
		addPlayChat("qDamnit", "Damnit!", color6);
		addPlayChat("cCrap", "Ah Crap!", color7);
		addPlayChat("eDuh", "Duh.", dsgst1);
		addPlayChat("xYou Idiot", "You Idiot!", dsgst2);
		addPlayChat("yYawn", "Yawn", dsgst5);
		addPlayChat("mHmmm", "Hmmm...", color3);

setPlayChatMenu("aAnimations");
		addPlayAnim("oOver here", 0, ovrhere);
		addPlayAnim("dMove out of way", 1, outway);
		addPlayAnim("rRetreat", 2, retreat);
		addPlayAnim("sStop", 3, dsgst4);
		addPlayAnim("fSalute", 4, yes);
		addPlayAnim("zKneel Pose", 10);
		addPlayAnim("xStand Pose", 11);
		addPlayAnim("qCelebrate 1", 5, cheer1);
		addPlayAnim("eCelebrate 2", 6, cheer2);
		addPlayAnim("wCelebrate 3", 7, cheer3);
		addPlayAnim("vTaunt 1 - how'd that feel?", 8, taunt10);
		addPlayAnim("gTaunt 2 - Come get some", 9, taunt4);
		addPlayAnim("1Taunt 3 - I've had worse", 8, tautn11);
		addPlayAnim("2Taunt 4 - Dance", 9, taunt3);
		addPlayAnim("3Taunt 5 - Missed Me!", 8, taunt2);
		addPlayAnim("4Taunt 6 - Yoohoo!", 8, taunt1);
		addPlayAnim("hWave - Hi", 12, hello);
		addPlayAnim("bWave - Bye", 12, bye);




setPlayChatMenu("zCommand Response");
	addPlayCMDResponse("aAcknowledged", 1, "Command acknowledged", "acknow");
	addPlayCMDResponse("zCompleted", 0, "Objective complete", "objcomp");
	addPlayCMDResponse("uUnable to complete", 0, "Unable to complete objective", "objxcmp");
	addPlayCMDResponse("bBelay Order", 0, "Belay Order", "belay");
	addPlayCMDResponse("pProceed Aheah", 0, "Proceed Ahead", "proceed");
	addPlayCMDResponse("cOrder Cancelled", 0, "Order cancelled", "ordcan");


// Start Matrix Pack

// Global Matrix:

setPlayChatMenu("1Global Matrix Sounds");
	addPlayChat("aAm I dead?", "Am I dead?", amidead);
	addPlayChat("oApoc, are we online?", "Apoc, are we online?", online);
	addPlayChat("bBeleve it or not...", "Beleve it or not you piece of sh!t you're still gonna burn.", beleve);
	addPlayChat("sStop trying to hit me and hit me!", "Stop trying to hit me and hit me!", stoptry);
	addPlayChat("dDodge this!", "Dodge this!", dodge);
	addPlayChat("hHit me, if you can.", "Hit me, if you can.", canhitme);
	addPlayChat("uHow did I beat you?", "How did I beat you?", howbeat);
	addPlayChat("fI know Kung Fu.", "I know Kung Fu.", kungfu);
	addPlayChat("cI know, they cut the hard line...", "I know, they cut the hard line, there's no time you're going to have to get to another exit.", hardline);
	addPlayChat("kIt means buckle...", "It means buckle your seatbelt Dorthy, 'cuz Kansas...is goin' bye bye.", buckle);
	addPlayChat("jJesus Christ he's fast.", "Jesus Christ he's fast.", hesfast);
	addPlayChat("wMr. Wizard, get me the hell out of here!", "Mr. Wizard, get me the hell out of here!", mrwizard);
	addPlayChat("lNo Lt. your men are already dead.", "No Lt. your men are already dead.", alldead);
	addPlayChat("nNo...I don't beleve it.", "No...I don't beleve it.", nobeleve);
	addPlayChat("yWhy oh why didn't I take the BLUE pill.", "Why oh why didn't I take the BLUE pill.", bluepill);
	addPlayChat("tYou're too fast.", "You're too fast.", toofast);
	addPlayChat("1She got out.", "She got out.", gotout);
	addPlayChat("2Suprise asshole...", "Suprise asshole, I bet you never saw this comming.", suprise);
	addPlayChat("3There is no spoon.", "There is no spoon.", nospoon);
	addPlayChat("4They're not out yet.", "They're not out yet.", notout);
	addPlayChat("5We're in.", "We're in.", wein);
	addPlayChat("6What are you trying to tell me...", "What are you trying to tell me? That I can dodge bullets?", bullets);

// Team Matrix:

setPlayChatMenu("2Team Matrix Sounds");
	addPlayTeamChat("aAm I dead?", "Am I dead?", amidead);
	addPlayTeamChat("oApoc, are we online?", "Apoc, are we online?", online);
	addPlayTeamChat("bBeleve it or not...", "Beleve it or not you piece of sh!t you're still gonna burn.", beleve);
	addPlayTeamChat("sStop trying to hit me and hit me!", "Stop trying to hit me and hit me!", stoptry);
	addPlayTeamChat("dDodge this!", "Dodge this!", dodge);
	addPlayTeamChat("hHit me, if you can.", "Hit me, if you can.", canhitme);
	addPlayTeamChat("uHow did I beat you?", "How did I beat you?", howbeat);
	addPlayTeamChat("fI know Kung Fu.", "I know Kung Fu.", kungfu);
	addPlayTeamChat("cI know, they cut the hard line...", "I know, they cut the hard line, there's no time you're going to have to get to another exit.", hardline);
	addPlayTeamChat("kIt means buckle...", "It means buckle your seatbelt Dorthy, 'cuz Kansas...is goin' bye bye.", buckle);
	addPlayTeamChat("jJesus Christ he's fast.", "Jesus Christ he's fast.", hesfast);
	addPlayTeamChat("wMr. Wizard, get me the hell out of here!", "Mr. Wizard, get me the hell out of here!", mrwizard);
	addPlayTeamChat("lNo Lt. your men are already dead.", "No Lt. your men are already dead.", alldead);
	addPlayTeamChat("nNo...I don't beleve it.", "No...I don't beleve it.", nobeleve);
	addPlayTeamChat("yWhy oh why didn't I take the BLUE pill.", "Why oh why didn't I take the BLUE pill.", bluepill);
	addPlayTeamChat("tYou're too fast.", "You're too fast.", toofast);
	addPlayTeamChat("1She got out.", "She got out.", gotout);
	addPlayTeamChat("2Suprise asshole...", "Suprise asshole, I bet you never saw this comming.", suprise);
	addPlayTeamChat("3There is no spoon.", "There is no spoon.", nospoon);
	addPlayTeamChat("4They're not out yet.", "They're not out yet.", notout);
	addPlayTeamChat("5We're in.", "We're in.", wein);
	addPlayTeamChat("6What are you trying to tell me...", "What are you trying to tell me? That I can dodge bullets?", bullets);

// Misc:

setPlayChatMenu("3Global Misc Sounds");

	addPlayChat("bYou farkin sneaky bastage.", "You farkin' sneaky bastage.", bstge);
	addPlayChat("hHooahh!", "Hooahh!", hoohaa);
	addPlayChat("nNo soup for you!", "No soup for you!", nosoup);

// Grail:

setPlayChatMenu("4Global Holy Grail Sounds");
	addPlayChat("cKeep me covered...", "Keep me covered. What with? Just...keep me covered.", covered);
	addPlayChat("eWhat an ecentric performance.", "What an ecentric performance.", ecentric);
	addPlayChat("fWe'd better not risk another frontal assault.", "We'd better not risk another frontal assault, that rabbits' dynamite.", frontal);
	addPlayChat("gOh Lord...bless this thy hand grenade...", "Oh Lord, bless this thy handgrenade, that with it thou mayst blow thine enemies to tiny bits, in thy mercy", grenade);
	addPlayChat("jJesus Christ!!", "Jesus Christ!!", jc);
	addPlayChat("dAlright, we'll call it a draw.", "Allright, we'll call it a draw.", itsadraw);
	addPlayChat("oOh I see, running away.", "Oh I see, running away eh?", ohisee);
	addPlayChat("wI warned you but did you listen...", "I warned you, but did you listen to me? Ohh, no, you, no, it's just a harmless little bunny, isn't it?", warned);

// Brian:

setPlayChatMenu("5Global Life of Brian Sounds");
	addPlayChat("dOh damn, damn, damn.", "Oh damn, damn, damn.", damndamn);
	addPlayChat("cThis calls for immediate discussion!", "This calls for immediate discussion!", discuss);
	addPlayChat("bYou lucky, lucky bastard.", "You lucky, lucky bastard.", lucky);
	addPlayChat("aSuiside squad, attack!", "Suiside squad, attack!", squad);
	addPlayChat("wThis is a complete waste of time!", "This is a complete waste of time!", waste);

// Show:

setPlayChatMenu("6Global Flying Circus Sounds");
	addPlayChat("aAlbatros!", "Albatros!", albatros);
	addPlayChat("gSo I'd like to leave sir...", "So I'd like to leave sir before I get killed please.", getkilled);
	addPlayChat("bYou bastards, you vicious...", "You bastards, you vicious heartless bastards!", bastards);
	addPlayChat("lI'd like to leave the army please sir...", "I'd like to leave the army please sir. Good heavins man why? It's dangerous!", leavarmy);
	addPlayChat("nHow not to be seen.", "How not to be seen...", notseen);
	addPlayChat("cMr. Nezbit has learned the first lesson of not beeing seen...", "Mr. Nezbit has learned the first lesson ov not beeing seen, not to stand up, however he has chosen a very obvious piece of cover.", obvcover);

// End Matrix Pack


// Commander Menu

function contextIssueCommand(%action, %msg, %sound)
{
   if(%sound != "")
      %msg = %msg @ "~w" @ %sound;
   setIssueCommand(%action, %msg);
}

// $CommandTarget can be one of:

// waypoint
// enemy vehicle
// enemy player
// enemy static
// enemy turret
// enemy sensor
// friendly vehicle
// friendly player
// friendly static
// friendly turret
// friendly sensor


function Commander::StarCommand(%type)
{
   if(%type == "*Attack")
   {
      if($CommandTarget == "enemy static")
			contextIssueCommand(1, "Destroy enemy equipment at waypoint", "attobj"); 
      else if($CommandTarget == "enemy turret")
			contextIssueCommand(1, "Destroy enemy turret at waypoint", "attobj"); 
      else if($CommandTarget == "enemy sensor")
			contextIssueCommand(1, "Destroy enemy sensor at waypoint", "attobj"); 
      else if($CommandTarget == "enemy player" || $CommandTarget == "enemy vehicle")
         contextIssueCommand(1, "Attack enemy " @ $CommandTargetName, "attway");
      else if($CommandTarget == "friendly player")
         contextIssueCommand(1, "Cover " @ $CommandTargetName, "escfr");
      else if($CommandTarget == "friendly vehicle")
         contextIssueCommand(1, "Board APC ", "boarda");
      else
         contextIssueCommand(1, "Attack enemy forces", "attway");
   }
   else if(%type == "*Defend")
   {
		if($CommandTarget == "friendly player")
		   contextIssueCommand(2, "Defend " @ $CommandTargetName, "escfr"); 
		else
		   contextIssueCommand(2, "Defend waypoint", "defway");
   }
   else if(%type == "*Repair")
   {
		if($CommandTarget == "friendly player")
		   contextIssueCommand(2, "Repair " @ $CommandTargetName, "repplyr"); 
		else
		   contextIssueCommand(2, "Repair " @ $CommandTargetName, "repobj");
   }
}

setCommanderChatMenu("");

   addCommand("aAttack", 1, "*Attack");
   addCommand("dDefend", 2, "*Defend");
   addCommand("rRepair", 3, "*Repair");

   setCommanderChatMenu("eDeploy");
		setCommanderChatMenu("eDeploy\\sSensor");
			addCommand("pPulse sensor", 2, "Deploy pulse sensor at waypoint", "deppuls");
			addCommand("jJammer", 2, "Deploy sensor jammer at waypoint", "depjamr");
			addCommand("mMotion sensor", 2, "Deploy motion sensor at waypoint", "depmot");
			addCommand("cCamera", 2, "Deploy camera at waypoint", "depcam");
		setCommanderChatMenu("eDeploy\\aObject");
			addCommand("aAmmo", 2, "Deploy Ammo Station", "depamo");
			addCommand("iInventory", 2, "Deploy Inventory Station", "depinv");
			addCommand("tTurret", 2, "Deploy Turret", "deptur");
			addCommand("bBeacon", 2, "Deploy beacon at waypoint", "depbecn");
		setCommanderChatMenu("eDeploy");
		addCommand("vA.P.C.", 2, "Pilot APC to waypoint", "pilot");

setCommanderChatMenu("kCommand Response");
	addCommandResponse("aAcknwledged", 1, "Command acknowledged", "acknow");
	addCommandResponse("cCompleted", 0, "Objective complete", "objcomp");
	addCommandResponse("uUnable to complete", 0, "Unable to complete objective", "objxcmp");