//************************************************************************
// FILE NAME: voicemenu.cs
// DESCRIPTION: A Panther XL autoexec.cs file for Tribes
// BY: [A3D]Malleus of Clan Assassin 3D
// REAL NAME: Charles Laine
// EMAIL: malleus@clana3d.com
// LAST MODIFIED: March 3, 1999
//
// VERSION: 1.7a
//************************************************************************

$button[1] = "upov0";		//left hat
$button[2] = "rpov0";
$button[3] = "dpov0";
$button[4] = "lpov0";
$button[5] = "button4";		//right hat
$button[6] = "button5";
$button[7] = "button6";
$button[8] = "button7";
$button[9] = "button2";		//top thumb
$button[10] = "button3";	//lower thumb
$button[11] = "button1";	//pinky

$buttonDesc[1]  = "1Hat 1 N -> ";
$buttonDesc[2]  = "2Hat 1 E -> ";
$buttonDesc[3]  = "3Hat 1 S -> ";
$buttonDesc[4]  = "4Hat 1 W -> ";
$buttonDesc[5]  = "5Hat 2 N -> ";
$buttonDesc[6]  = "6Hat 2 E -> ";
$buttonDesc[7]  = "7Hat 2 S -> ";
$buttonDesc[8]  = "8Hat 2 W -> ";
$buttonDesc[9]  = "9Button -> ";
$buttonDesc[10] = "0Pinky -> ";


//************************************************************************
//   function activateVoice()
//
//   sets up the voice command menu for use with the Panther XL hats
//************************************************************************
function activateVoice()
{
	$voiceActivated = 1;

	//clear the old action map
	doMyBinds($deactivateHats);

	//set up the newly cleared action map for editing.
	EditActionMap("playMap.sae");


	bindCommand(joystick0, make,  button12, TO, "deactivateVoice();");
	newObject(PlayChatMenu, ChatMenu, "Root Menu:");
	
	%buttonCount = 1;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Offense");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make,  $button[%buttonCount], TO, "offenesemenu();");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Defense");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make,  $button[%buttonCount], TO, "defenesemenu();");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Flag");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make,  $button[%buttonCount], TO, "flagmenu();");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Target");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make,  $button[%buttonCount], TO, "targetmenu();");
	%buttonCount++;

	setPlayChatMenu(". ");
	addPlayTeamChat("1.", ".", color2);

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Need/Misc Animations");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make,  $button[%buttonCount], TO, "needmenu();");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Team");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make,  $button[%buttonCount], TO, "teammenu();");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "APC");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make,  $button[%buttonCount], TO, "apcmenu();");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Local Animations");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make,  $button[%buttonCount], TO, "animmenu();");
	%buttonCount++;

	setPlayChatMenu(", ");
	addPlayTeamChat("1.", ".", color2);

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Taunt/Cheer");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make,  $button[%buttonCount], TO, "tauntmenu();");

	%buttonCount++;
	setPlayChatMenu("- ");
	addPlayTeamChat("1.", ".", color2);

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Anger");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make,  $button[%buttonCount], TO, "angermenu();");
	%buttonCount++;


	setCMMode(PlayChatMenu, 2);		
}

//************************************************************************
//   function deactivateVoice()
//
//   Turns off the voice menu and restores key mappings
//************************************************************************
function deactivateVoice()
{
	$voiceActivated = 0;

	setCMMode(PlayChatMenu, 0);
	//For some unknown reason, sometimes the CMMode is not reset all the way. 
	//When this happens, it takes multiple hits of the escape key to bring 
	//up the "quit" screen.  By scheduling a second setCMMode here, it
	//clears up this problem.
	schedule("setCMMode(PlayChatMenu, 0);", 0.2);

	schedule("doMyBinds($activateHats);", 0.2);
}


//************************************************************************
//   function playMyVoiceCmd(%to, %msg, %ani)
//
//   plays a sound and deactivateVoices voice menu
//   %to -  0 = everyone, 1 = team, 2 = local, 3=animate 
//   %msg - the text and sound to play
//   %ani - the animation to play.  
//************************************************************************
function playMyVoiceCmd(%to, %msg, %ani)
{
	deactivateVoice();
	playMySound(%to, %msg, %ani);
}
//************************************************************************
//   function offenesemenu()
//************************************************************************
function offenesemenu()
{
	setCMMode(PlayChatMenu, 0);
	EditActionMap("playMap.sae");
	newObject(PlayChatMenu, ChatMenu, "Offense:");

	%buttonCount = 1;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Going offense");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Going offense.~wono\");");
	%buttonCount++;
	
	setPlayChatMenu($buttonDesc[%buttonCount] @  "Cover me");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Cover me.~wcoverme\");");
	%buttonCount++;
	
	setPlayChatMenu($buttonDesc[%buttonCount] @ "Attack");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"ATTACK!~wattack\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Move out");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Move out!~wmoveout\");");
	%buttonCount++;

	setPlayChatMenu(". ");
	addPlayTeamChat("1.", ".", color2);

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Regroup");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Regroup!~wregroup\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @  "Take Cover");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Take cover!~wtakcovr\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Wait for my signal");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Wait for my signal.~wwaitsig\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Cease fire");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Cease fire!~wcease\");");
	%buttonCount++;	

	setPlayChatMenu(", ");
	addPlayTeamChat("1.", ".", color2);

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Go offensive");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Go on the offensive!~wgooff\");");
	%buttonCount++;
	
	setPlayChatMenu("- ");
	addPlayTeamChat("1.", ".", color2);

	setPlayChatMenu($buttonDesc[%buttonCount] @  "Go defensive");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Go on the defensive.~wgodef\");");
	%buttonCount++;
	
	setCMMode(PlayChatMenu, 2);
}


//************************************************************************
//   function defenesemenu()
//************************************************************************
function defenesemenu()
{
	setCMMode(PlayChatMenu, 0);
	EditActionMap("playMap.sae");
	newObject(PlayChatMenu, ChatMenu, "Defense:");

	%buttonCount = 1;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Incoming");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Incoming enemies.~wincom2\");");
	%buttonCount++;
	
	setPlayChatMenu($buttonDesc[%buttonCount] @ "Need more defense");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"We need more defense.~wneeddef\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @  "Being attacked");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"We are being attacked.~wbasatt\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Enemy attacking base");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"The enemy is attacking our base.~wbasundr\");");
	%buttonCount++;

	setPlayChatMenu(". ");
	addPlayTeamChat("1.", ".", color2);

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Defend our base");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Defend our base.~wdefbase\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Defending base");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Defending our base.~wdefend\");");
	%buttonCount++;
	
	setPlayChatMenu($buttonDesc[%buttonCount] @ "Base taken");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Our base has been taken!~wbasetkn\");");
	%buttonCount++;
	
	setPlayChatMenu($buttonDesc[%buttonCount] @ "Base clear");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Our base is clear.~wbsclr2\");");
	%buttonCount++;	

	setPlayChatMenu(", ");
	addPlayTeamChat("1.", ".", color2);

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Is base clear?");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Is our base clear?~wisbsclr\");");
	%buttonCount++;	

	setPlayChatMenu("- ");
	addPlayTeamChat("1.", ".", color2);

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Hit deck?");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"HIT THE DECK!~whitdeck\");");
	%buttonCount++;	

	setCMMode(PlayChatMenu, 2);
}

//************************************************************************
//   function targetmenu()
//************************************************************************
function targetmenu()
{
	setCMMode(PlayChatMenu, 0);
	EditActionMap("playMap.sae");
	newObject(PlayChatMenu, ChatMenu, "Target:");

	%buttonCount = 1;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Target acquired");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Target acquired.~wtgtacq\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @  "Fire on target");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"MORTARS. Fire on my target!~wfiretgt\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Out of range");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"The target is out of range.~wtgtout\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Target needed");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"I have mortar and I need a target.~wneedtgt\");");
	%buttonCount++;

	setPlayChatMenu(". ");
	addPlayTeamChat("1.", ".", color2);

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Generatory destroyed");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Enemy Generator destroyed.~wgendes\");");
	%buttonCount++;
	
	setPlayChatMenu($buttonDesc[%buttonCount] @ "Turret destroyed");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Enemy turret destroyed.~wturdes\");");
	%buttonCount++;	

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Destroy generator");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Destroy the enemy generator.~wdesgen\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Destroy turret");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Destroy enemy turret.~wdestur\");");
	%buttonCount++;

	setCMMode(PlayChatMenu, 2);
}


//************************************************************************
//   function flagmenu()
//************************************************************************
function flagmenu()
{
	setCMMode(PlayChatMenu, 0);
	EditActionMap("playMap.sae");
	newObject(PlayChatMenu, ChatMenu, "Flag:");

	%buttonCount = 1;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Flag gone");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Our flag is not in our base.~wflgtkn1\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @  "Enemy has flag");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"The enemy has our flag.~wflgtkm2\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Have enemy flag");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"I have the enemy flag.~whaveflg\");");
	%buttonCount++;
	
	setPlayChatMenu($buttonDesc[%buttonCount] @ "Flag secure");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Our flag is secure.~wflaghm\");");
	%buttonCount++;

	setPlayChatMenu(". ");
	addPlayTeamChat("1.", ".", color2);

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Return our flag");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Return our flag.~wretflag\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Get enemy flag");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Get the enemy flag.~wgeteflg\");");
	%buttonCount++;
	
	setPlayChatMenu($buttonDesc[%buttonCount] @ "Flag mined");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Our flag is mined.~wflgmine\");");
	%buttonCount++;
	
	setPlayChatMenu($buttonDesc[%buttonCount] @ "Clear mines");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Clear the mines from our flag.~wclrflg\");");
	%buttonCount++;	
	
	setPlayChatMenu(", ");
	addPlayTeamChat("1.", ".", color2);

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Mines cleared");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"The mines have been cleared from our flag.~wmineclr\");");
	%buttonCount++;

	setPlayChatMenu(", ");
	addPlayTeamChat("1.", "-", color2);

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Mine the flag");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Mine our flag now!~wmineflg\");");
	%buttonCount++;

	setCMMode(PlayChatMenu, 2);
}


//************************************************************************
//   function needmenu()
//************************************************************************
function needmenu()
{
	setCMMode(PlayChatMenu, 0);
	EditActionMap("playMap.sae");
	newObject(PlayChatMenu, ChatMenu, "Need/Misc Animations:");

	%buttonCount = 1;

	setPlayChatMenu($buttonDesc[%buttonCount] @  "Move out of way");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($animate, \"outway\", $anim[move]);");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Over here");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($animate, \"ovrhere\", $anim[overhere]);");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Retreat");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($animate, \"retreat\", $anim[retreat]);");
	%buttonCount++;
	
	setPlayChatMenu($buttonDesc[%buttonCount] @ "Stop");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($animate, \"dsgst4\", $anim[stop]);");
	%buttonCount++;

	setPlayChatMenu(". ");
	addPlayTeamChat("1.", ".", color2);

	%buttonCount = 5;
	setPlayChatMenu($buttonDesc[%buttonCount] @ "Need repairs");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Need repairs.~wneedrep\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @  "Need APC");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"I need an APC pickup.~wneedpku\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Need escort");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"I need an escort back to base.~wneedesc\");");
	%buttonCount++;
	
	setPlayChatMenu($buttonDesc[%buttonCount] @ "Need ammo");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"I'm in a heavy. PLEASE BRING AMMO.~wneedamo\");");
	%buttonCount++;

	setPlayChatMenu(", ");
	addPlayTeamChat("1.", ".", color2);

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Kneel");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($animate, \"\",$anim[kneel]);");
	%buttonCount++;
	
	setPlayChatMenu("- ");
	addPlayTeamChat("1.", ".", color2);

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Salute");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($animate, \"\",$anim[salute]);");
	%buttonCount++;

	setCMMode(PlayChatMenu, 2);
}


//************************************************************************
//   function teammenu()
//************************************************************************
function teammenu()
{
	setCMMode(PlayChatMenu, 0);
	EditActionMap("playMap.sae");
	newObject(PlayChatMenu, ChatMenu, "Team:");

	%buttonCount = 1;

	setPlayChatMenu($buttonDesc[%buttonCount] @  "Don\'t know");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"I don\'t know.~wdontkno\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Hurry Station");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($whisper, \"hurystn\");");
	%buttonCount++;
	
	setPlayChatMenu($buttonDesc[%buttonCount] @ "Yes");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Yes.~wyes\");");
	%buttonCount++;
	
	setPlayChatMenu($buttonDesc[%buttonCount] @ "No");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"No.~wno\");");
	%buttonCount++;

	setPlayChatMenu(". ");
	addPlayTeamChat("1.", ".", color2);

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Thanks");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Thanks~wthanks\");");
	%buttonCount++;
	
	setPlayChatMenu($buttonDesc[%buttonCount] @ "Watch shooting");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Watch where you\'re shooting!~wwshoot3\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "No problem");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"No problem.~wnoprob\");");
	%buttonCount++;
	
	setPlayChatMenu($buttonDesc[%buttonCount] @ "Sorry");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Sorry about that.~wsorry\");");
	%buttonCount++;
	
	setPlayChatMenu(", ");
	addPlayTeamChat("1.", ".", color2);

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Hey!!!");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Hey!!!~wwshoot1\");");
	%buttonCount++;
	

	setCMMode(PlayChatMenu, 2);
}


//************************************************************************
//   function apcmenu()
//************************************************************************
function apcmenu()
{
	setCMMode(PlayChatMenu, 0);
	EditActionMap("playMap.sae");
	newObject(PlayChatMenu, ChatMenu, "APC:");

	%buttonCount = 1;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "APC ready");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"APC ready to go.~wwaitpas\");");
	%buttonCount++;
	
	setPlayChatMenu($buttonDesc[%buttonCount] @  "APC Waiting");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"APC Waiting. Please board.~wwait2\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @  "Board APC");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Board APC. Leaving soon.~wboarda\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @  "Wait for me");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"APC... wait for me.  I'm on my way.~wwait1\");");
	%buttonCount++;	
		
	setPlayChatMenu(". ");
	addPlayTeamChat("1.", ".", color2);
	setPlayChatMenu($buttonDesc[%buttonCount] @ "Proceed ahead");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"APC - Proceed ahead. ~wproceed\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Hey! Dammit");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Hey! Dammit, I said wait for me. ~wwshoot1\");");
	%buttonCount++;

	setCMMode(PlayChatMenu, 2);
}

//************************************************************************
//   function angermenu()
//************************************************************************
function angermenu()
{
	setCMMode(PlayChatMenu, 0);
	EditActionMap("playMap.sae");
	newObject(PlayChatMenu, ChatMenu, "Anger:");

	%buttonCount = 1;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Doh");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"DOH!~woops1\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @  "Oops");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Oops.~woops2\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Dammit");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Dammit.~wcolor6\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Crap");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Crap.~wcolor7\");");
	%buttonCount++;

	setPlayChatMenu(". ");
	addPlayTeamChat("1.", ".", color2);

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Duh");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Duh.~wdsgst1\");");
	%buttonCount++;
	
	setPlayChatMenu($buttonDesc[%buttonCount] @ "You idiot");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"You idiot.~wdsgst2\");");
	%buttonCount++;
	
	setPlayChatMenu($buttonDesc[%buttonCount] @ "Hrrmph...");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Hrrmph....~wcolor3\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Aaarrgh...");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Aaarrgh...~wdsgst4\");");
	%buttonCount++;
		
	setPlayChatMenu(", ");
	addPlayTeamChat("1.", ".", color2);

	setPlayChatMenu($buttonDesc[%buttonCount] @ "*Sigh*");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"*Sigh*~wdsgst5\");");
	%buttonCount++;	

	setPlayChatMenu("- ");
	addPlayTeamChat("1.", ".", color2);

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Shazbot");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($team, \"Shazbot.~wcolor2\");");
	%buttonCount++;
	

	setCMMode(PlayChatMenu, 2);
}


//************************************************************************
//   function animmenu()
//************************************************************************
function animmenu()
//these are animations accompanied by sounds.  They are only heard locally to your player.  The first four of 
//these are repeated in the Taunt menu.  There, they are not animated but can be heard globally. 
{
	setCMMode(PlayChatMenu, 0);
	EditActionMap("playMap.sae");
	newObject(PlayChatMenu, ChatMenu, "Local Animations:");

	%buttonCount = 1;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Celeb 1: Yeah!");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($animate, \"cheer1\", $anim[celeb1]);");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @  "Celeb 2: Woohoo!");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($animate, \"cheer2\", $anim[celeb2]);");
	%buttonCount++;
	
	setPlayChatMenu($buttonDesc[%buttonCount] @ "Celeb 3: Allright!");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($animate, \"cheer3\", $anim[celeb3]);");
	%buttonCount++;
	
	setPlayChatMenu($buttonDesc[%buttonCount] @ "Celeb 4: Yoo Hoo!");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($animate, \"taunt1\", $anim[celeb1]);");
	%buttonCount++;

	setPlayChatMenu(". ");
	addPlayTeamChat("1.", ".", color2);

	%buttonCount = 7;	

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Bye");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($animate, \"bye\", $anim[wave]);");
	%buttonCount++;	
	
	setPlayChatMenu($buttonDesc[%buttonCount] @ "Hi");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($animate, \"hello\", $anim[wave]);");
	%buttonCount++;


	setCMMode(PlayChatMenu, 2);
}


//************************************************************************
//   function tauntmenu()
//************************************************************************
function tauntmenu()
{
	setCMMode(PlayChatMenu, 0);
	EditActionMap("playMap.sae");
	newObject(PlayChatMenu, ChatMenu, "Taunt/Cheer:");

	%buttonCount = 1;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Yeah!");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($everyone, \"Yeah!~wcheer1\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @  "Woohoo!");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($everyone, \"Woohoooooo!~wcheer2\");");
	%buttonCount++;
	
	setPlayChatMenu($buttonDesc[%buttonCount] @ "Alright!");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($everyone, \" Alright!~wcheer3\");");
	%buttonCount++;
	
	setPlayChatMenu($buttonDesc[%buttonCount] @ "Yoo Hoo!");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($everyone, \"Yoooo Hoooo!~wtaunt1\");");
	%buttonCount++;

	setPlayChatMenu(". ");
	addPlayTeamChat("1.", ".", color2);

	setPlayChatMenu($buttonDesc[%buttonCount] @ "How\'d that feel");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($everyone, $howdthatfeel @ \"~wtaunt10\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Come get some");
	addPlayTeamChat("1.", ".", color2);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($everyone, $comegetsome @ \"~wtaunt4\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Missed me!");
	addPlayTeamChat("1.", ".", color1);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($everyone, $missedme @ \"~wtaunt2\");");
	%buttonCount++;

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Dance!");
	addPlayTeamChat("1.", ".", color1);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($everyone, $dance @ \"~wtaunt3\");");
	%buttonCount++;

	setPlayChatMenu(", ");
	addPlayTeamChat("1.", ".", color2);

	setPlayChatMenu($buttonDesc[%buttonCount] @ "Oh the pain!");
	addPlayTeamChat("1.", ".", color1);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($everyone, \"Oh the pain, the pain!~wdeath\");");
	%buttonCount++;

	setPlayChatMenu("- ");
	addPlayTeamChat("1.", ".", color2);

	setPlayChatMenu($buttonDesc[%buttonCount] @ "I've had worse!");
	addPlayTeamChat("1.", ".", color1);
	bindCommand(joystick0, make, $button[%buttonCount], TO, "playMyVoiceCmd($everyone, $hadworse @ \"~wtautn11\");");
	%buttonCount++;

	setCMMode(PlayChatMenu, 2);
}