//************************************************************************
// FILE NAME: binds.cs
// DESCRIPTION: A Panther XL autoexec.cs file for Tribes
// BY: [A3D]Malleus of Clan Assassin 3D
// REAL NAME: Charles Laine
// EMAIL: malleus@clana3d.com
// LAST MODIFIED: March 3, 1999
//
// VERSION: 1.7a
//************************************************************************


//************************************************************************
//   function doMyBinds(%disableHats)
//   If disableHats is true, then don't map anything to the PXL hat 
//   switches and upper red thumb button.  This is for implementation
//   of my PXL hat-based voice menu system.
//************************************************************************
function doMyBinds(%disableHats)
{
	//initialize for editing
	//
	//   Note about EditActionMap & NewActionMap...
	//   EditActionMap simply appends your key bindings.  It is non destructive.
	//   NewActionMap, on the other hand, completely trashes your config
	//   and writes over it with the stuff that follows.  For the purposes
	//   of my Panther XL config (and specifically the voice menu stuff)
	//   I must use NewActionMap. With this config, the in-game
	//   key config screens will not work correctly.  This is because
	//   every time you use my PXL voice command stuff, any keys
	//   that you define will be erased and reset with the values
	//   found here in this file.
	NewActionMap("playMap.sae");

	// The following four lines control the sensitivites of your Panther XL.
	// You should adjust these values to something that you are comforatble with.
	// Here's a description of the values that you can change.
	//
	//
	// DeadZone:  This specifies the amount of space around your stick's 
	//            centered position where input from the stick is ignored.  
	//            This is used to adjust the tolereance of your stick so 
	//            that "drift" is eliminated.  If your "guy" moves while 
	//            your joystick is centered, then increase these values 
	//            by increments of .05 until this movement stops.
	//		
	//            The deadzone on your trackball (IDACTION_YAW and IDACTION_PITCH)
	//            should be set to its absolute lowest value.  The lower this 
	//            value is, the more responsive your trackball will be.  As with 
	//            the joystick, adjust the trackball's deadzone until the drift 
	//            stops.	
	//
	// Scale:     Think of the scale for the joystick axis as sort of a "cushion". 
	//            If you set the scale to 100, your stick will be hypersensitive.  
	//            The slightest movement in any direction will result in full 
	//            movement almost immediately.  I have difficulty controlling the 
	//            game this way, and find that it greatly enhances control by 
	//            backing away on this.  I choose a value of 70.  This is purely 
	//            a preference.  Adjust the number lower if you prefer more "throw" 
	//            on the stick for movement.  Adjust the number higher if you prefer 
	//            less stick movement.
	//
	//            The scale for the trackball adjusts the ratio between ball movement 
	//            and the movement within the game I have it set to approximate what 
	//            my control feels like in Quake.  Again, increase the numbers for 
	//            more increased response and vice versa.  In my opinion, the PXL 
	//            works best when set to nearly a 1:1 ratio.  Again, your mileage 
	//            may vary.
	//
	bindAction(joystick0, xAxis0, TO, IDACTION_STRAFE, Center, DeadZone, 0.2, Scale, 70);
	bindAction(joystick0, yAxis0, TO, IDACTION_RUN, Center, DeadZone, 0.2, Scale, 70);
	bindAction(joystick0, slider0, TO, IDACTION_YAW, Center, DeadZone, 0.0035, Scale, 0.57);
	bindAction(joystick0, slider1, TO, IDACTION_PITCH, Flip, Center, DeadZone, 0.0035, Scale, 0.4);

	//PXL bindings
	if((%disableHats) && (isHat($button[fire])))
	{}
	else
	{
		bindCommand(joystick0, make,  $button[fire],		TO, "AmmoCheck();");   
		bindAction(joystick0,  break, $button[fire],		TO, IDACTION_BREAK1);
	}

	if((%disableHats) && (isHat($button[jump])))
	{}
	else
	{
		bindAction(joystick0,  make,  $button[jump],		TO, IDACTION_MOVEUP);	
	}

	if((%disableHats) && (isHat($button[jetpack])))
	{}
	else
	{
		bindAction(joystick0,  make,  $button[jetpack],		TO, IDACTION_JET, 1.000000);
		bindAction(joystick0,  break, $button[jetpack],		TO, IDACTION_JET, 0.000000);
	}

	if((%disableHats) && (isHat($button[shieldjump])))
	{}
	else
	{	
		bindCommand(joystick0, make,  $button[shieldjump],	TO, "ShieldJump();"); 
	}

	if((%disableHats) && (isHat($button[zoom])))
	{}
	else
	{
		bindAction(joystick0,  make,  $button[zoom],		TO, IDACTION_SNIPER_FOV, 1.000000);
		bindAction(joystick0,  break, $button[zoom],		TO, IDACTION_SNIPER_FOV, 0.000000);
	}

	if((%disableHats) && (isHat($button[changezooom])))
	{}
	else
	{
		bindAction(joystick0,  make,  $button[changezooom],	TO, IDACTION_INC_SNIPER_FOV, 1.000000);
		bindAction(joystick0,  break, $button[changezooom],	TO, IDACTION_SNIPER_FOV, 0.000000);
	}

	if((%disableHats) && (isHat($button[getnextweap])))
	{}
	else
	{
		bindCommand(joystick0, make,  $button[getnextweap],	TO, "GetPrevNext('next');");
	}

	if((%disableHats) && (isHat($button[getprevweap])))
	{}
	else
	{
		bindCommand(joystick0, make,  $button[getprevweap],	TO, "GetPrevNext('prev');");
	}

	if((%disableHats) && (isHat($button[getbestweap])))
	{}
	else
	{
		bindCommand(joystick0, make,  $button[getbestweap],	TO, "GetBestWeap();");	
	}

	if((%disableHats) && (isHat($button[repair])))
	{}
	else
	{
		bindCommand(joystick0, make,  $button[repair],		TO, "UseRepairKit();");
	}

	if((%disableHats) && (isHat($button[grenade])))
	{}
	else
	{
		bindCommand(joystick0, make,  $button[grenade],		TO, "throwStart();");
		bindCommand(joystick0, break, $button[grenade],		TO, "ThrowGrenade();");
	}

	if((%disableHats) && (isHat($button[mine])))
	{}
	else
	{
		bindCommand(joystick0, make,  $button[mine],		TO, "throwStart();");
		bindCommand(joystick0, break, $button[mine],		TO, "DeployMine();");
	}

	if((%disableHats) && (isHat($button[packhandler])))
	{}
	else
	{
		bindCommand(joystick0, make,  $button[packhandler],	TO, "PackHandler();");
		bindAction(joystick0,  break, $button[packhandler],	TO, IDACTION_STOP);
	}

	if((%disableHats) && (isHat($button[showscores])))
	{}
	else
	{
		bindAction(joystick0,  make,  $button[showscores],	TO, IDACTION_MENU_PAGE, 1.000000);
	}

	if((%disableHats) && (isHat($button[mapscreen])))
	{}
	else
	{
		bindCommand(joystick0, make,  $button[mapscreen],	TO, "remoteEval(2048, ToggleCommandMode);");
	}

	if((%disableHats) && (isHat($button[chaseview])))
	{}
	else
	{
		bindAction(joystick0,  make,  $button[chaseview],	TO, IDACTION_VIEW);
	}

	if((%disableHats) && (isHat($button[voicemenu])))
	{}
	else
	{
		bindCommand(joystick0, make,  $button[voicemenu],	TO, "activateVoice();");   
	}

	//keyboard bindings
	bindCommand(keyboard0, make, $key[dropweap], TO, "drop(Weapon);");
	bindCommand(keyboard0, make, $key[dropammo], TO, "drop(Ammo);");
	bindCommand(keyboard0, make, $key[droppack], TO, "drop(BackPack);");
	bindCommand(keyboard0, make, $key[dropflag], TO, "drop(Flag);");
	bindCommand(keyboard0, make, $key[killself], TO, "kill();");

	//default stuff
	EditActionMap("playMap.sae");
	bindAction(mouse0,		make,	button1, TO, IDACTION_JET, 1.000000);
	bindAction(mouse0,		break,	button1, TO, IDACTION_JET, 0.000000);
	bindAction(mouse0,		make,	button0, TO, IDACTION_FIRE1);
	bindAction(mouse0,		break,	button0, TO, IDACTION_BREAK1);	
	bindAction(mouse0,		xaxis0,			 TO, IDACTION_YAW, Flip, Scale, 0.000999);
	bindAction(mouse0,		yaxis0,			 TO, IDACTION_PITCH, Flip, Scale, 0.000999);
	bindAction(keyboard0,	make,	"a",	 TO, IDACTION_MOVELEFT, 1.000000);
	bindAction(keyboard0,	break,	"a",	 TO, IDACTION_MOVELEFT, 0.000000);
	bindAction(keyboard0,	make,	"d",	 TO, IDACTION_MOVERIGHT, 1.000000);
	bindAction(keyboard0,	break,	"d",	 TO, IDACTION_MOVERIGHT, 0.000000);
	bindAction(keyboard0,	make,	"s",	 TO, IDACTION_MOVEBACK, 1.000000);
	bindAction(keyboard0,	break,	"s",	 TO, IDACTION_MOVEBACK, 0.000000);
	bindAction(keyboard0,	make,	"w",	 TO, IDACTION_MOVEFORWARD, 1.000000);
	bindAction(keyboard0,	break,	"w",	 TO, IDACTION_MOVEFORWARD, 0.000000);
	bindAction(keyboard0,	make,	"r",	 TO, IDACTION_VIEW);
	bindAction(keyboard0,	make,	"e",	 TO, IDACTION_SNIPER_FOV, 1.000000);
	bindAction(keyboard0,	break,	"e",	 TO, IDACTION_SNIPER_FOV, 0.000000);

	bindCommand(keyboard0,	make,	"v",	 TO, "setCMMode(PlayChatMenu, 2);");
	bindCommand(keyboard0,	make,	"m",	 TO, "throwStart();");
	bindCommand(keyboard0,	break,	"m",	 TO, "throwRelease(\"Mine\");");
	bindCommand(keyboard0,	make,	"g",	 TO, "throwStart();");
	bindCommand(keyboard0,	break,	"g",	 TO, "throwRelease(\"Grenade\");");
	bindCommand(keyboard0,	make,	"1",	 TO, "use(\"Blaster\");");
	bindCommand(keyboard0,	make,	"2",	 TO, "use(\"Plasma Gun\");");
	bindCommand(keyboard0,	make,	"3",	 TO, "use(\"Chaingun\");");
	bindCommand(keyboard0,	make,	"4",	 TO, "use(\"Disc Launcher\");");
	bindCommand(keyboard0,	make,	"5",	 TO, "use(\"Grenade Launcher\");");
	bindCommand(keyboard0,	make,	"6",	 TO, "use(\"Laser Rifle\");");
	bindCommand(keyboard0,	make,	"7",	 TO, "use(\"ELF gun\");");
	bindCommand(keyboard0,	make,	"8",	 TO, "use(\"Mortar\");");
	bindCommand(keyboard0,	make,	"9",	 TO, "use(\"Targeting Laser\");");
	bindCommand(keyboard0,	make,	"h",	 TO, "use(\"Repair Kit\");");
	bindCommand(keyboard0,	make,	"p",	 TO, "use(\"BackPack\");");
	bindCommand(keyboard0,	make,	"q",	 TO, "nextWeapon();");
	bindCommand(keyboard0,	make,	shift, "q", TO, "prevWeapon();");
}


//************************************************************************
//   function isHat(%theButton)
//   Test to see if the current button is a hat or the top thumb button
//************************************************************************
function isHat(%theButton)
{
	if ((%theButton == $PXL_left_hat_up) ||
		(%theButton == $PXL_left_hat_right)	||	
		(%theButton == $PXL_left_hat_down) ||
		(%theButton == $PXL_left_hat_left) ||
		(%theButton == $PXL_right_hat_up) ||
		(%theButton == $PXL_right_hat_right) ||
		(%theButton == $PXL_right_hat_down) ||
		(%theButton == $PXL_right_hat_left) ||
		(%theButton == $PXL_upper_thumb) ||
		(%theButton == $PXL_pinky))
	{
		return 1;
	}
	else
	{
		return 0;
	}
}