//************************************************************************
// FILE NAME: autoexec.cs
// DESCRIPTION: A Panther XL autoexec.cs file for Tribes
// BY: [A3D]Malleus of Clan Assassin 3D
// REAL NAME: Charles Laine
// EMAIL: malleus@clana3d.com
// LAST MODIFIED: March 3, 1999
//
// VERSION: 1.7a
// VERSION HISTORY
// 1.0 - First attempt.  Just the basics.
// 1.1 - Added ammo checking and disc assisted jumping.
// 1.2 - Made major changes to ammo checking.
//     - Added custom pack handling and laser targeter stuff.
//     - Added best weapon selector.
//     - Removed bugs.
// 1.3 - Added message filtering for flag and in-game events.
// 1.4 - Made improvements to mine, grenade, and health kit usage.
//     - Modified button layout.
// 1.5 - Wrote Panther XL hat-based voice menu system.
//     - Added player animations to flag events.
// 1.6 - Modularized the button assignments to allow
//       for easier customization by other users
// 1.6a - fixed a beacon deployment bug.
// 1.6b - made changes to fix Tribes version 1.2 changes.
// 1.6c	- fixed yet another beacon bug as well as a mortar and 
//        bug caused by the version 1.2 patch
//	    - made substantial changes to the voice menu system, adding
//        several new sounds that aren't in the original menu
//      - added variables for the different messages that this
//      - script generates, providing for easier customization
// 1.6c	- added crouching for the sniper rifle.  Crouching is 
//        toggled via the "packhandler" button.  By default, this
//        is the lower right trackball button.  When the laser rifle
//        is selected, hit this button to crouch and stay crouched. 
//        Hitting the button again or selecting a different weapon
//        will "uncrouch" your dude.
//      - added a readme file
//      - added malleusprefs.cs.  Everything that you can customize
//        is in that file.  I don't recommend you changing much else.
//        If you do, don't bother me with it!  You are on your own! :-)
// 1.7  - Added "buy favorites" and "buy vehicles" code.  Now, you can 
//        buy your favorites as well as the vehicles using your PXL!
//      - When buying favorites, you auto equip your best weapon and do
//        a 180 degree turn
//      - added a "mine our flag" sound and message
//      - added version checking for mortar and grenade ammo types.
// 1.7a  - Fixed problem with buying favorites. 
//
// REQUIRED FILES: autoexec.cs, 
//                 voicemenu.cs, 
//                 binds.cs, 
//                 globals.cs, 
//                 malleusprefs.cs
//
// NOTE:  To re-execute this file from within the game, go to the 
//        console and type exec("autoexec.cs");
//************************************************************************

//tell the game you want to use a joystick
inputActivate(joystick0);

//bring in other files
exec("globals.cs");
exec("malleusprefs.cs");
exec("voicemenu.cs");
exec("binds.cs");

// do the binds...
doMyBinds($activateHats);


//define pdaMap
//These are the keys available when viewing the PDA
//button5 had to be included here as well to allow clearing
//of the scores screen if it's open when you activate an
//inventory station.
NewActionMap("pdaMap.sae");
bindAction(joystick0, make, $button[showscores], TO, IDACTION_MENU_PAGE, 1.000000);
bindAction(keyboard0, make, "z",				 TO, IDACTION_ZOOM_MODE_ON);
bindAction(keyboard0, break, "z",				 TO, IDACTION_ZOOM_MODE_OFF);


// define actionMap
//
// actionMap items are global throughout the game.  These will 
// always be available regardless of your current "mode".
// These are keyboard items.  You won't really need to change these since you are using
// the PXL.  They are here if you need them.
//
NewActionMap("actionMap.sae");
bindCommand(joystick0, make, $button[mapscreen], TO, "remoteEval(2048, ToggleCommandMode);");
bindAction(keyboard0,  make, "tab",				TO, IDACTION_MENU_PAGE, 1.000000);
bindAction(keyboard0,  make, "escape",			TO, IDACTION_ESCAPE_PRESSED, 0.000000);
bindAction(keyboard0,  make, "k",				TO, IDACTION_MENU_PAGE, 2.000000);
bindAction(keyboard0,  make, "t",				TO, IDACTION_CHAT, 0.000000);
bindAction(keyboard0,  make, "y",				TO, IDACTION_CHAT, 1.000000);
bindAction(keyboard0,  make, "u",				TO, IDACTION_CHAT_DISP_SIZE, -1.000000);
bindAction(keyboard0,  make, "prior",			TO, IDACTION_CHAT_DISP_PAGE, -1.000000);
bindAction(keyboard0,  make, "next",			TO, IDACTION_CHAT_DISP_PAGE, 1.000000);
bindCommand(keyboard0, make, "f1",				TO, "remoteEval(2048, PlayMode);");
bindCommand(keyboard0, make, "o",				TO, "remoteEval(2048, ToggleObjectivesMode);");
bindCommand(keyboard0, make, "i",				TO, "remoteEval(2048, ToggleInventoryMode);");
bindCommand(keyboard0, make, "c",				TO, "remoteEval(2048, ToggleCommandMode);");
bindCommand(keyboard0, make, $key[beacon],		TO, "DeployBeacon();");
bindCommand(keyboard0, make, $key[ack],			TO, "commandAck();");
bindCommand(keyboard0, make, $key[declined],	TO, "commandDeclined();");
bindCommand(keyboard0, make, $key[completed],	TO, "commandCompleted();");

//************************************************************************
//   function playMySound(%to, %msg, %ani)
//
//   plays a sound or animation
//   %to -  0 = everyone, 1 = team, 2 = local, 3=animate 
//   %msg - the text and sound to play
//   %ani - the animation to play.  See anim[] at the top for details
//************************************************************************
function playMySound(%to, %msg, %ani)
{
	if ((String::findSubStr(%msg, $autoLPCmsg) != -1) || (String::findSubStr(%msg, $autoHPCmsg) != -1))
	{
		if ($cantBuyAPC == 1)
		{
			$cantBuyAPC = 0;
		}
		else
		{
			say(%to, %msg);
		}
	}
	else
	{
		if (%to <=1)
		{
			say(%to, %msg);
		}
		else if (%to == 2)
		{
			localMessage(%msg); 
		}
		else if (%msg == "")
		{
			messageAndAnimate(%ani);
		}
		else
		{
			messageAndAnimate(%ani, %msg);
		}	
	}
}


//************************************************************************
//   function UseRepairKit()
//************************************************************************
function UseRepairKit()
{
	use("Repair Kit");
	$tempmessage = "<jc><f1>Using Repair Kit. <f2>You should feel better soon!";
	DisplayMessage();
}


//************************************************************************
//   function DeployMine()
//************************************************************************
function DeployMine()
{
	%mineCount = getItemCount("Mine");
	if (%mineCount == 0)
	{
		$tempmessage = "<jc>You are out of mines.";
	}
	else
	{
		throwRelease("Mine");
		if (%mineCount  == 1)
		{
			$tempmessage = "<jc><f1>Mine deployed.  <f2>That was your last mine.\n<f3>WATCH YOUR STEP!";
		}
		else if (%mineCount == 2)
		{	
			$tempmessage = "<jc><f1>Mine deployed. <f2>You have "  @ %mineCount - 1 @ " mine remainging.\n<f3>WATCH YOUR STEP! ";
		}		
		else
		{	
			$tempmessage = "<jc><f1>Mine deployed. <f2>You have "  @ %mineCount - 1 @ " mines remainging.\n<f3>WATCH YOUR STEP! ";
		}

		say(1, $minemsg);
	}
	DisplayMessage();
}


//************************************************************************
//   function DeployBeacon()
//************************************************************************
function DeployBeacon()
{	
	%beaconCount = getItemCount("Beacon");
	if (%beaconCount == 0)
	{
		$tempmessage = "<jc>You are out of targeting beacons.";
		DisplayMessage($tempmessage);
	}
	else
	{
		use("beacon");
	}
}


//************************************************************************
//   function ThrowGrenade()
//************************************************************************
function ThrowGrenade()
{	
	%grenadeCount = getItemCount("Grenade");
	if (%grenadeCount == 0)
	{
		$tempmessage = "<jc>You are out of Grenades.";
	}
	else
	{
		throwRelease("Grenade");
		if (%grenadeCount  == 1)
		{
			$tempmessage = "<jc><f1>Grenade thrown.  <f2>That was your last grenade.\n<f3>DUCK AND COVER! ";
 
		}
		else if (%grenadeCount == 2)
		{	
			$tempmessage = "<jc><f1>Grenade thrown. <f2>You have "  @ %grenadeCount - 1 @ " Grenade remainging.\n<f3>DUCK AND COVER!";
		}		
		else
		{	
			$tempmessage = "<jc><f1>Grenade thrown. <f2>You have "  @ %grenadeCount - 1 @ " Grenades remainging.\n<f3>DUCK AND COVER!";
		}
	}
	DisplayMessage();
}


//************************************************************************
//   function DisplayMessage()
//
//  This function displays a message to the user's screen
//************************************************************************
function DisplayMessage()
{
	Client::centerPrint($tempmessage, 1); 
	schedule("Client::centerPrint(\"\", 1);", 3);
}

//************************************************************************
//   function voiceDisabled()
//************************************************************************
function voiceDisabled()
{
	Client::centerPrint("\n<f1>          Voice menu deactivated while station in use.\n<f2>          Hat 1 N ->\t\tBuy favorites 1\t\t\t\t\tUpper Thumb -->\t\tScout\n          Hat 1 E ->\t\tBuy favorites 2\t\t\t\tLower Thumb -->\t\tLPC\n          Hat 1 S ->\t\tBuy favorites 3\t\t\t\tPinky\t\t\t\t\t\tHPC\n          Hat 1 W ->\t\tBuy favorites 4\n          Hat 2 N ->\t\tBuy favorites 5", 2);
}


//************************************************************************
//   onClientMessage(%client, %msg)
//
//  This function filters messages sent to you from the game
//  and does things based on the various messages received.
//************************************************************************
function onClientMessage(%client, %msg)
{	
	$name = Client::getName(%client);
	//echo("****************");
	//echo("name = [" @ $name @ "]");
	//echo("PCFG::Name = [" @ $PCFG::Name @ "]");
	//echo("msg = [" @ %msg @ "]");

	//game countdownstuff
	if((String::findSubStr(%msg, "Match started") != -1) && ($fmsg))
	{
		say(1, $startmsg);
	}

	//flag
	if((String::findSubStr(%msg, "flag") != -1) && ($fmsg))
	{
		if(String::findSubStr(%msg, "You captured the") != -1)
		{
			if ($cheer == 3)
			{
				$cheer = 0;
			}
			$cheer++;
		
			$cheerMsg = "cheer" @ $cheer;
			$cheerNo = "celeb" @ $cheer;
			schedule("playMySound(3, $cheerMsg, $anim[$cheerNo]);", 2);
		}
		else if(String::findSubStr(%msg, "You dropped the") != -1)
		{
			if ($cuss == 4)
			{
				$cuss = 0;
			}
			$cuss++;
		
			if($cuss == 1)
			{
				schedule("playMySound(1, \"Shazbot!~wcolor2\");", 2);
			}
			else if ($cuss == 2)
			{
				schedule("playMySound(1, \"Dammit!~wcolor6\");", 2);
			}
			else if ($cuss == 3)
			{
				schedule("playMySound(1, \"Ah Crap!~wcolor7\");", 2);
			}
			else	
			{
				schedule("playMySound(1, \"DOH!~woops1\");", 2);
			}
		}
		else if(String::findSubStr(%msg, "You took the") != -1)
		{
			schedule("playMySound(1, \"I have enemy flag. Returning to base!~whaveflg\");", 2);
		}
	}

	//station access
	if((String::findSubStr(%msg, "You couldn't buy") != -1) && (String::findSubStr(%msg, "Scout") == -1) && ($name == ""))
	{
		$cantBuyAPC = 1;
	}

	//station access
	if(String::findSubStr(%msg, "Station Access On") != -1)
	{
		//echo("<<<Station Access On>>>");
		if ($voiceActivated)
		{
			setCMMode(PlayChatMenu, 0);
			doMyBinds($activateHats);
		}
	
		//clear the old action map
		doMyBinds($deactivateHats);

		//set up the newly cleared action map for editing.
		EditActionMap("playMap.sae");
		bindCommand(joystick0, make,  $button[voicemenu],	TO, "voiceDisabled();");   

		Client::centerPrint("\n\n<f2>          Hat 1 N ->\t\tBuy favorites 1\t\t\t\t\tTrackball upper middle -->\t\tScout\n          Hat 1 E ->\t\tBuy favorites 2\t\t\t\tJoystick Upper Thumb -->\t\tLPC\n          Hat 1 S ->\t\tBuy favorites 3\t\t\t\tJoystick Pinky -->\t\t\t\t\t\tHPC\n          Hat 1 W ->\t\tBuy favorites 4\n          Hat 2 N ->\t\tBuy favorites 5", 2);
		bindCommand(joystick0, make,  $button[1], TO, "BuyMyFavorites(1);");
		bindCommand(joystick0, make,  $button[2], TO, "BuyMyFavorites(2);");
		bindCommand(joystick0, make,  $button[3], TO, "BuyMyFavorites(3);");
		bindCommand(joystick0, make,  $button[4], TO, "BuyMyFavorites(4);");
		bindCommand(joystick0, make,  $button[5], TO, "BuyMyFavorites(5);");
		bindCommand(joystick0, make,  $button[6], TO, "voiceDisabled();");
		bindCommand(joystick0, make,  $PXL_trackball_upper_middle, TO, "BuyMyVehicle(\"Scout\");");
		bindCommand(joystick0, make,  $PXL_upper_thumb, TO, "BuyMyVehicle(\"LPC\");");
		bindCommand(joystick0, make,  $PXL_pinky, TO, "BuyMyVehicle(\"HPC\");");
		$rebind = 1;
	}

	if(String::findSubStr(%msg, "Station Access Off") != -1) 
	{
		//echo("<<<Station Access Off>>>");
		if ($rebind)
		{
			schedule("doMyBinds($activateHats);", 0.2);
			schedule("bindCommand(joystick0, make,  $button[voicemenu],	TO, \"activateVoice();\");", 0.2);
			Client::centerPrint("", 1);
		}
	}

	//deployment info
	if((String::findSubStr(%msg, "Beacon deployed") != -1) && 
		(String::findSubStr(%msg, $beaconmsg) == -1) && 
		($name == ""))
	{
		say(1, $beaconmsg @ "~wfiretgt");

		%beaconCount = getItemCount("Beacon");
		if (%beaconCount  == 1)
		{
			$tempmessage = "<jc><f1>Beacon deployed.  <f2>That was your last beacon.\n<f3>GET THE HELL OUT OF THERE!";
		}
		else if (%beaconCount == 2)
		{	
			$tempmessage = "<jc><f1>Beacon deployed. <f2>You have "  @ %beaconCount - 1 @ " beacon remainging.\n<f3>GET THE HELL OUT OF THERE!";
		}		
		else
		{	
			$tempmessage = "<jc><f1>Beacon deployed. <f2>You have "  @ %beaconCount - 1 @ " beacons remainging.\n<f3>GET THE HELL OUT OF THERE!";
		}
		DisplayMessage();
	}

	else if((String::findSubStr(%msg, "deployed") != -1) && 
		(String::findSubStr(%msg, "Beacon") == -1) &&
		(String::findSubStr(%msg, "has been deployed at my location.") == -1) && 
		($name == ""))
	{
		%theBackpackItem = $BackpackName[$currBackpackItem];
		if(String::findSubStr(%theBackpackItem, "station") != -1)
		{
			say(1, "An " @ %theBackpackItem  @ " has been deployed at my location.");
		}
		else if(!(String::findSubStr(%msg, $minemsg) != -1))
		{
			say(1, "A " @ %theBackpackItem  @ " has been deployed at my location.");
		}		
	}
	//echo(" ");

	if(%client){$lastClientMessage = %client;} 
	return true;
}


//************************************************************************
//   function BuyMyVehicle(%favorite)
//************************************************************************
function BuyMyVehicle(%favorite)
{
	buy(%favorite);
	remoteEval(2048, PlayMode);

	if(String::findSubStr(%favorite, "LPC") != -1)
	{	
		schedule("playMySound($team, $autoLPCmsg);", 0.2);
	}	
	else if(String::findSubStr(%favorite, "HPC") != -1)
	{	
		schedule("playMySound($team, $autoHPCmsg);", 0.2);
	}

	Client::centerPrint("", 1);
	schedule("doMyBinds($activateHats);", 0.2);
	schedule("bindCommand(joystick0, make,  $button[voicemenu],	TO, \"activateVoice();\");", 0.2);
	$rebind = 0;

	postAction(2048, IDACTION_TURNLEFT, 0.32);
	schedule("postAction(2048, IDACTION_TURNLEFT, -0);", 0.32);
	schedule("GetBestWeap();", 0.3);

}
//************************************************************************
//   function BuyMyFavorites(%favorite)
//************************************************************************
function BuyMyFavorites(%favorite)
{
	CmdInventoryGui::buyFavorites(%favorite);
	remoteEval(2048, PlayMode);

	schedule("doMyBinds($activateHats);", 0.2);
	schedule("bindCommand(joystick0, make,  $button[voicemenu],	TO, \"activateVoice();\");", 0.2);
	$rebind = 0;

	postAction(2048, IDACTION_TURNLEFT,0.32);
	schedule("postAction(2048, IDACTION_TURNLEFT, -0);", 0.32);
	schedule("GetBestWeap();", 0.3);


}
//************************************************************************
//   function GetBestWeap()
//
//   This will select my "best" weapon.
//   I prefer weapons in the following order...
//   1. Mortar
//   2. Plasma gun
//   3. Disc Launcher
//   4. Grenade Launcher
//   5. Chaingun
//   6. Blaster
//   7. Laser Rifle
//   8. ELF Gun
//
//************************************************************************
function GetBestWeap()
{
	postAction(2048,IDACTION_STAND, -0);
	$crouching = 0;

	%currentWeapon   = $WeaponSlot[getMountedItem(0)];
	%currentAmmoType = $Ammo[%currentWeapon];

//	echo("*******");
//	echo("currentWeapon = [" @ %currentWeapon @ "]");
//	echo("currentAmmoType = [" @ %currentAmmoType @ "]");
//	echo("AmmoName[currentAmmoType] = [" @ $AmmoName[%currentAmmoType] @ "]");

	if (getItemCount($Ammo[Mortar]) && getItemCount($WeaponRealName[Mortar]))
	{
		if (%currentWeapon != $WeaponSlotName[Mortar])
		{
			$tempmessage = "<jc><f1>Activating your best weapon. <f2>Mortar";
			schedule("use($WeaponRealName[Mortar]);", 0.1);
		}
		else
		{
			$tempmessage = "<jc><f1>Already using your best weapon. <f2>Mortar";
		}
	}

	else if (getItemCount($Ammo[PlasmaGun]) && getItemCount($WeaponRealName[PlasmaGun]))
	{	
		if (%currentWeapon != $WeaponSlotName[PlasmaGun])
		{
			$tempmessage = "<jc><f1>Activating your best weapon. <f2>Plasma Gun";
			schedule("use($WeaponRealName[PlasmaGun]);", 0.1);
		}
		else
		{
			$tempmessage = "<jc><f1>Already using your best weapon. <f2>Plasma Gun";
		}
	}

	else if (getItemCount($Ammo[DiscLauncher]) &&  getItemCount($WeaponRealName[DiscLauncher]))		
	{
		if (%currentWeapon != $WeaponSlotName[DiscLauncher])
		{	
			$tempmessage = "<jc><f1>Activating your best weapon. <f2>Disc Launcher";
			schedule("use($WeaponRealName[DiscLauncher]);", 0.1);
		}
		else
		{
			$tempmessage = "<jc><f1>Already using your best weapon. <f2>Disc Launcher";
		}
	}

	else if (getItemCount($Ammo[GrenadeLauncher]) && getItemCount($WeaponRealName[GrenadeLauncher]))
	{
		if (%currentWeapon != $WeaponSlotName[GrenadeLauncher])
		{
			$tempmessage = "<jc><f1>Activating your best weapon. <f2>Grenade Launcher";	
			schedule("use($WeaponRealName[GrenadeLauncher]);", 0.1);
		}
		else
		{
			$tempmessage = "<jc><f1>Already using your best weapon. <f2>Grenade Launcher";
		}
	}	

	else if (getItemCount($Ammo[Chaingun]) && getItemCount($WeaponRealName[Chaingun]))
	{
		if (%currentWeapon != $WeaponSlotName[Chaingun])
		{
			$tempmessage = "<jc><f1>Activating your best weapon. <f2>Chaingun";
			schedule("use($WeaponRealName[Chaingun]);", 0.1);
		}
		else
		{
			$tempmessage = "<jc><f1>Already using your best weapon. <f2>Chaingun";
		}
	}

	else if (getItemCount($WeaponRealName[Blaster]))
	{
		if (%currentWeapon != $WeaponSlotName[Blaster])
		{
			$tempmessage = "<jc><f1>Activating your best weapon. <f2>Blaster";
			schedule("use($WeaponRealName[Blaster]);", 0.1);
		}
		else
		{
			$tempmessage = "<jc><f1>Already using your best weapon. <f2>Blaster";
		}
	}
	else if (getItemCount($WeaponRealName[LaserRifle]))
	{
		if(%currentWeapon != $WeaponSlotName[LaserRifle])
		{
			$tempmessage = "<jc><f1>Activating your best weapon. <f2>Laser Rifle";
			schedule("use($WeaponRealName[LaserRifle]);", 0.1);
		}
		else
		{
			$tempmessage = "<jc><f1>Already using your best weapon. <f2>Laser Rifle";
		}

	}
	else if (getItemCount($WeaponRealName[EnergyRifle]))
	{
		if (%currentWeapon != $WeaponSlotName[EnergyRifle])
		{
			$tempmessage = "<jc><f1>Activating your best weapon. <f2>ELF Gun";
			schedule("use($WeaponRealName[EnergyRifle]);", 0.1);
		}
		else
		{
			$tempmessage = "<jc><f1>Already using your best weapon. <f2>ELF Gun";
		}
	}
	else
	{
			$tempmessage = "<jc><f1>OUT OF AMMO! <f2>Resupply NOW!";				
	}
	DisplayMessage();
}


//************************************************************************
//   function AmmoCheck()
//
//   This is an automatic weapon changing script.  
//   It cycles to the next weapon if the ammo 
//   for the current weapon runs out.
//   Energy weapons are ignored, since their ammo is renewable.
//************************************************************************
function AmmoCheck()
{
	%currentWeapon = $WeaponSlot[getMountedItem(0)];	
	%currentAmmoType = $Ammo[%currentWeapon];

//	echo("*******");
//	echo("currentWeapon = [" @ %currentWeapon @ "]");
//	echo("currentAmmoType = [" @ %currentAmmoType @ "]");
//	echo("AmmoName[currentAmmoType] = [" @ $AmmoName[%currentAmmoType] @ "]");

	if($Ammo[%currentWeapon] == "")
	{
		// Energy based weapon. Do nothing
	}
	else if(getItemCount($Ammo[%currentWeapon]) == 0)
	{
		//switch weapons
		//my order of prefernce for weapons is...
		//1. Mortar
		//2. Plasma gun
		//3. Disc Launcher
		//4. Grenade Launcher
		//5. Chaingun
		//6. Blaster
		//7. Laser Rifle
		//8. ELF Gun
		if (getItemCount($Ammo[Mortar]) && getItemCount($WeaponRealName[Mortar]) && (%currentAmmoType != $Ammo[Mortar]))
		{
			$tempmessage = "<jc><f1>Out of " @ $AmmoName[%currentAmmoType] @ ". <f2>Activating Mortar";
			use($WeaponRealName[Mortar]);
		}
		else if (getItemCount($Ammo[PlasmaGun]) && getItemCount($WeaponRealName[PlasmaGun]) && (%currentAmmoType != $Ammo[PlasmaGun]))
		{
			$tempmessage = "<jc><f1>Out of " @ $AmmoName[%currentAmmoType] @ ". <f2>Activating Plasma Gun";
			use($WeaponRealName[PlasmaGun]);
		}
		else if (getItemCount($Ammo[DiscLauncher]) && getItemCount($WeaponRealName[DiscLauncher]) && (%currentAmmoType != $Ammo[DiscLauncher]))		
		{
			$tempmessage = "<jc><f1>Out of " @ $AmmoName[%currentAmmoType] @ ". <f2>Activating Disc Launcher";
//			schedule("use($WeaponRealName[DiscLauncher]);", 0.1);
			use($WeaponRealName[DiscLauncher]);
		}
		else if (getItemCount($Ammo[GrenadeLauncher]) && getItemCount($WeaponRealName[GrenadeLauncher]) && 
			  (%currentAmmoType != $Ammo[GrenadeLauncher]))
		{
			$tempmessage = "<jc><f1>Out of " @ $AmmoName[%currentAmmoType] @ ". <f2>Activating Grenade Launcher";
			use($WeaponRealName[GrenadeLauncher]);
		}	
		else if (getItemCount($Ammo[Chaingun]) && getItemCount($WeaponRealName[Chaingun]) && (%currentAmmoType != $Ammo[Chaingun]))
		{
			$tempmessage = "<jc><f1>Out of " @ $AmmoName[%currentAmmoType] @ ". <f2>Activating Chaingun";
			use($WeaponRealName[Chaingun]);
		}
		else if (getItemCount($WeaponRealName[Blaster]))
		{
			$tempmessage = "<jc><f1>Out of " @ $AmmoName[%currentAmmoType] @ ". <f2>Activating Blaster";
			use($WeaponRealName[Blaster]);
		}
		else if (getItemCount($WeaponRealName[LaserRifle]))
		{
			$tempmessage = "<jc><f1>Out of " @ $AmmoName[%currentAmmoType] @ ". <f2>Activating Laser Rifle";
			use($WeaponRealName[LaserRifle]);
		}
		else if (getItemCount($WeaponRealName[EnergyRifle]))
		{
			$tempmessage = "<jc><f1>Out of " @ $AmmoName[%currentAmmoType] @ ". <f2>Activating ELF Gun";
			use($WeaponRealName[EnergyRifle]);
		}

		else
		{
			$tempmessage = "<jc><f1>OUT OF AMMO! <f2>Resupply NOW!";				
		}
		DisplayMessage();
	}
	postAction(2048,IDACTION_FIRE1, -0); 

}
 

//************************************************************************
//   function GetPrevNext(%prevnext)
//
//   Gets previous or next weapon and resets buttonState.  
//************************************************************************
function GetPrevNext(%prevnext)
{
	postAction(2048,IDACTION_STAND, -0);
	$crouching = 0;

	if (%prevnext == "prev")
	{
		prevWeapon();
	}
	else
	{
		nextWeapon();
	}
	$buttonState = 0;
}


//************************************************************************
//   function PackHandler()
//
//   This will look at your various packs and and do different things
//   based on what kind of pack you are carrying.
//************************************************************************
function PackHandler()
{
	%currWeap = $WeaponSlot[getMountedItem(0)];
	if (%currWeap == $WeaponSlotName[EnergyRifle])
	{
		if($crouching)
		{
			postAction(2048,IDACTION_STAND, -0);
			$crouching = 0;
		}
		else
		{
			postAction(2048,IDACTION_CROUCH, -0); 
			$crouching = 1;
		}
	}
	else
	{
			
		if(getItemCount("Targeting Laser")) 
		{
			$haveLaser = 1;
		}
		else
		{
			$haveLaser = 0;
		}
		
		if($BackpackSlot[getMountedItem(1)] == '') 
		{
			$haveBackpackItems = 0;
		}	
		else
		{
			$haveBackpackItems = 1;
		}

		%ignorePack = 0;

		$currBackpackItem = $BackpackSlot[getMountedItem(1)];
			
		if (($currBackpackItem == "InventoryStation") || 
			($currBackpackItem == "AmmoStation") ||
			($currBackpackItem == "MotionSensor") || 
			($currBackpackItem == "PulseSensor") ||
			($currBackpackItem == "SensorJammer") || 
			($currBackpackItem == "Camera") ||
			($currBackpackItem == "Turret"))
		{

			schedule("use(\"BackPack\");", 0);	
			%ignorePack = 1;
		}
		//these items are toggled on and off, so its a bit more tricky as to how to 
		//incorporate this into a button that can also be used with the laser targeter.
		//at this point, I've decided that its unlikely that I'd ever carry one of these items
		//along with targeter anyway since they all use energy.
		//so, if I've got one of these, I don't care about the targeter.
		else if (($currBackpackItem == "ShieldPack") || ($currBackpackItem == "SensorJammerPack"))
		{
			schedule("use(\"BackPack\");", 0);
			%ignorePack = 1;
		}
		
		//since these items are "always on", then just skip them as being selectable. 
		//Just act like I don't have a backpack
		else if (($currBackpackItem == "AmmoPack") || ($currBackpackItem == "EnergyPack"))
		{
			$haveBackpackItems = 0;
		}
		
		if (%ignorePack == 0)
		{
			PackLaserToggle();
		}
	}
}


//************************************************************************
//   function PackLaserToggle()
//
//   The laser targeter is an item that is ignored by the standard
//   nextWeapon() prevWeapon() selectors.  Due to the limited number 
//   of buttons on the PXL, I can't find room for the laser targeter 
//   in my config.  Since it's not used that much, I decided to double
//   up the button for the repair pack with the ability to select the
//   laser targeter.  This function will cycle between your repair pack 
//   and the laser targeter and the last real weapon used
//   with the repair pack selected first
//************************************************************************
function PackLaserToggle()
{
	if($haveBackpackItems == 1)
	{
		if($haveLaser == 1)
		{
			if($buttonState == 0)
			{
				$buttonState = 1;
				$myLastWeapon = $WeaponSlot[getMountedItem(0)];
				schedule("use(\"BackPack\");", 0);
			}
			else if ($buttonState == 1)
			{
				$buttonState = 2;
				use("Targeting Laser");
			}
			else
			{
				$buttonState = 0;
				if(getItemCount($WeaponRealName[$myLastWeapon]))
				{
					use($WeaponRealName[$myLastWeapon]);		
				}
				else
				{
					GetPrevNext("prev");	
				}
			}
		}
		else //no laser...
		{
			if($buttonState == 0)
			{
				$buttonState = 1;
				$myLastWeapon = $WeaponSlot[getMountedItem(0)];
				use("Backpack");
			}
			else if ($buttonState == 1)
			{
				$buttonState = 0;
				if(getItemCount($WeaponRealName[$myLastWeapon]))
				{
					use($WeaponRealName[$myLastWeapon]);
				}
				else
				{
					GetPrevNext("next");	
				}
			}
		}
	}
	else //no backpack, so just toggle to laser...
	{
		if ($haveLaser)
		{
			if($buttonState == 0)
			{
				$buttonState = 1;
				$myLastWeapon = $WeaponSlot[getMountedItem(0)];
				use("Targeting Laser");
			}
			else
			{	
				$buttonState = 0;
				if($myLastWeapon == "TargetingLaser")
				{
					GetPrevNext("prev");
				}
				else if(getItemCount($WeaponRealName[$myLastWeapon]))
				{
					use($WeaponRealName[$myLastWeapon]);
				}
				else
				{
					GetPrevNext("prev");	
				}
			}
		}
		else
		{
			//do nothing.  You dont have laser or backpack.
		}
	}
}


//************************************************************************
//   function ShieldJump()
//
//   This results in a fantastic aerial display when combined with your 
//   jump jets.  It doesn't do much damage to you but avoid doing this
//   near your teammates!
//************************************************************************
function ShieldJump()
{
	$old = $WeaponSlot[getMountedItem(0)];

	if(getItemCount("Disc Launcher"))
	{
		if(getItemCount("Disc"))
		{
    			if($BackpackSlot[getMountedItem(1)] == "ShieldPack")
    			{	
    				%lagdelay = 0.00;
    				if($WeaponSlot[getMountedItem(0)] == "DiscLauncher") 
    				{ 
    					%timedelay = 0;
    				}
    				else 
    				{ 
    					%timedelay = 0.5;
    					schedule("use(\"Disc Launcher\");", 0.1);
    				}
    				schedule("use(\"BackPack\");", 0.2 + %timedelay + %lagdelay);
    				schedule("postAction(2048, IDACTION_LOOKDOWN, 1);", 0.4 + %timedelay + %lagdelay);
    				schedule("postAction(2048, IDACTION_MOVEUP, -0);", 0.5 + %timedelay + %lagdelay);
    				schedule("postAction(2048, IDACTION_FIRE1, -0);", 0.6 + %timedelay + %lagdelay);
    				schedule("postAction(2048, IDACTION_BREAK1, -0);", 0.7 + %timedelay + %lagdelay);
    				schedule("postAction(2048, IDACTION_LOOKDOWN, -0);", 0.8 + %timedelay + %lagdelay);
    				schedule("postAction(2048, IDACTION_CENTERVIEW, -0);", 0.9 + %timedelay + %lagdelay);
    				schedule("use(\"BackPack\");", 1 + %timedelay + %lagdelay);
    				schedule("use($WeaponRealName[$old]);", 1.1 + %timedelay + %lagdelay);
    			}
    			else 
    			{ 
    				$tempmessage = "<jc><f1>You don't have a Shield Pack... <f2>Jump aborted";
    				DisplayMessage();
    			}
		}
		else
		{
			$tempmessage = "<jc><f1>You don't have any Disc Ammo... <f2>Jump aborted";
    			DisplayMessage();
		}
	}
	else 
	{ 
		$tempmessage = "<jc><f1>You don't have a Disc Launcher... <f2>Jump aborted"; 
		DisplayMessage();
	}
} 




