//	exec("Presto\\Install.cs");
//	Include("NewOpts\\Install.cs");
//	Include("Fudge\\TinyCapHUD.cs");

if (!$Presto::installed || $Presto::version < 0.93) // Check presto pack is installed.
	echo("TinyCapHUD: requires Presto Pack 0.93 or later.");
else {


function TinyCapHUD::SetDefaults() {
	$FudgePref::TinyCapHUDPos = "0% 12% 40 17";
}

if(isFile("config\\FudgePrefs.cs")) {
	Include("FudgePrefs.cs");
} else {
	TinyCapHUD::SetDefaults();
}

if($FudgePref::TinyCapHUDPos == "") {
	TinyCapHUD::SetDefaults();
}

Include("Presto\\HUD.cs");
Include("Presto\\Event.cs");
Include("Presto\\TeamTrak.cs");

Event::Attach(eventConnected, "TinyCap::Init();");
Event::Attach(eventChangeMission, "TinyCap::Init();");
Event::Attach(eventFlagCaptured, TinyCap::FlagCaptured);
Event::Attach(eventClientChangeTeam, TinyCap::ChangedTeam);

function TinyCap::AddBanner()
{
	Presto::AddScriptBanner(TinyCapHUD,
		" <f2>TinyCapHUD <jr><f0>version 0.1 <jl>\n" @
		" \n" @
		" <f0>Displays number of flag\n" @
		" <f1>captures<f0>.\n" @
		" <f0>Uses <f2>NewOpts<f0> by <f1>Zear<f0>.\n" @
		" Icons ripped from <f1>|HH|Cruncy's<f0>\n" @
		" <f2>Objective HUD<f0>.\n" @
		" <f0>Written by: <f1>[TNT]Fudge\n" @
		" <f1>fudge@c2i.net");
}

function TinyCap::UpdateHUD()
{

	if( Client::GetTeam(getManagerID()) == -1 ) {
		%friendlyCaps = $TinyCap::Caps[0];
		%enemyCaps = $TinyCap::Caps[1];
	} else {
		%friendlyCaps = $TinyCap::Caps[Team::Friendly()];
		%enemyCaps = $TinyCap::Caps[Team::Enemy()];
	}

	if( %enemyCaps == %friendlyCaps ) {
		%icon = "<B0,4:six\\bmp\\small_flag_tie.bmp>";
	} else if( %enemyCaps > %friendlyCaps ) {
		%icon = "<B0,4:six\\bmp\\small_flag_enemy.bmp>";
	} else {
		%icon = "<B0,4:six\\bmp\\small_flag_friendly.bmp>";
	}

	HUD::AddTextLine(TinyCapHUD,"<f1>"@%friendlyCaps@%icon@%enemyCaps);

	return 0;
}

function TinyCap::FlagCaptured( %teamNum, %client) {

	$TinyCap::Caps[Client::GetTeam(%client)] += 1;

	HUD::Update(TinyCapHUD);
}

function TinyCap::ChangedTeam(%client, %team) {
	if(%client != getManagerID()) return;

	HUD::Update(TinyCapHUD);
}

function TinyCap::Init() {
	$TinyCap::Caps[0] = 0;
	$TinyCap::Caps[1] = 0;

	if(HUD::Exists(TinyCapHUD)) {
		HUD::Move(TinyCapHUD, $FudgePref::TinyCapHUDPos );
		HUD::Update(TinyCapHUD);
	} else {
		HUD::New(TinyCapHUD, TinyCap::UpdateHUD, $FudgePref::TinyCapHUDPos );
		HUD::Display(TinyCapHUD);
	}
}

//
// NewOpts
//

function TinyCap::onOpen()
{
	Control::setText("TinyCapHUD::XPos", getWord($FudgePref::TinyCapHUDPos,0));
	Control::setText("TinyCapHUD::YPos", getWord($FudgePref::TinyCapHUDPos,1));
	Control::setText("TinyCapHUD::Width", getWord($FudgePref::TinyCapHUDPos,2));
	Control::setText("TinyCapHUD::Height", getWord($FudgePref::TinyCapHUDPos,3));
}

function TinyCap::onClose()
{
	$FudgePref::TinyCapHUDPos = Control::getText("TinyCapHUD::XPos")@" "@
								   Control::getText("TinyCapHUD::YPos")@" "@
								   Control::getText("TinyCapHUD::Width")@" "@
								   Control::getText("TinyCapHUD::Height");

	if(HUD::Exists(TinyCapHUD))
		HUD::Move(TinyCapHUD, $FudgePref::TinyCapHUDPos);

	export("$FudgePref::*", "config\\FudgePrefs.cs", false);
}

TinyCap::AddBanner();
TinyCap::Init();
NewOpts::register("TinyCap HUD", "config\\six\\gui\\CapHUD.gui", "TinyCap::onOpen();", "TinyCap::onClose();", TRUE);
NewOpts::registerHelp("TinyCap HUD", "Positioning", "Read the documentation in Presto's HUD.cs.  This has a more in depth description of how to position HUDs in general.");
NewOpts::registerHelp("TinyCap HUD", "X Pos", "X posistion of the HUD. Examples: 0, 20%, left(KillHUD).");
NewOpts::registerHelp("TinyCap HUD", "Y Pos", "Y posistion of the HUD. Examples: 0, 50%, bottom(KillHUD).");
NewOpts::registerHelp("TinyCap HUD", "Width", "Width of the HUD. Best left at the default value.");
NewOpts::registerHelp("TinyCap HUD", "Height", "Height of the HUD. Best left at the default value.");
NewOpts::registerHelp("TinyCap HUD", "Author", "TinyCapHUD was written by [TNT]Fudge.\nEmail: <f0>fudge@c2i.net<f1>");

} // PrestoPack installed check
