// ---------------------------------------------------------------------------
// favorites.cs -- Version 1.5 -- May 19, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

// Copy this file to your Tribes\config folder...leave the original in
// Tribes\config\writer to serve as a "default" config.

// Set up your favorites for fast_favorites.cs in this file!
//
// Rules for use:
//
// To buy a single item, replace the "" with the $Inv:: variable name for the
// item you want to buy.  Make sure all the other fields (except loadout) have "".
//
// To buy multiple items, replace the "" with the $Inv:: variable name for the
// item you want to buy in each field (armor, pack, weapon1, weapon2 etc).
//
// fast_favorites.cs will automatically use buyFavorites instead of buyItem
// if more than one type of item is given.  Using buyFavorites means any items
// in your inventory that aren't in the favorites will be removed.
//
// To buy a single weapon, use only the weapon1 field.
//
// Set the exit field to true if you want to always automatically exit the
// station after you've pressed that favorites key.
//
// Set $FastFaves::BuyExtraAmmo to true if you want to buy extra ammo for weapons
// you aren't carrying (to give to your teammates in the field) by default.  You
// can toggle this on/off in the game with a key -- it's bound to ALT-/ by default.
//
// You can set up to 9 different types of "extra" ammo to buy and carry to your
// teammates below.  Note that you won't be able to buy any "extra" ammo for a
// weapon you're carrying.
//
// My drop_ammo.cs script comes in handy for delivering this extra ammo -- if
// you have drop_ammo.cs installed, just hit ALT-N to drop all the ammo you
// don't have a weapon for.  Try not to do this where the enemy can pick it up.  :)


// Set which favorites to use by default (after connecting to a game)
$FastFaves::defaultModifier = "";
$FastFaves::defaultKey      = numpad2;
$FastFaves::Vehicle         = $Inv::Scout;

// Set your default preference for BuyExtraAmmo mode
$FastFaves::BuyExtraAmmo = false;


// Set the types of "extra" ammo you want to carry when BuyExtraAmmo mode is on
$FastFaves::ExtraAmmo1     = $Inv::Mortar_Ammo;
$FastFaves::ExtraAmmo2     = $Inv::Grenade_Ammo;
$FastFaves::ExtraAmmo3     = "";
$FastFaves::ExtraAmmo4     = "";
$FastFaves::ExtraAmmo5     = "";
$FastFaves::ExtraAmmo6     = "";
$FastFaves::ExtraAmmo7     = "";


// Set up your favorites below!

$FastFaves::key["", decimal, loadout] = "";
$FastFaves::key["", decimal, armor]   = "";
$FastFaves::key["", decimal, pack]    = "";
$FastFaves::key["", decimal, weapon1] = "";
$FastFaves::key["", decimal, weapon2] = "";
$FastFaves::key["", decimal, weapon3] = "";
$FastFaves::key["", decimal, weapon4] = "";
$FastFaves::key["", decimal, weapon5] = "";
$FastFaves::key["", decimal, weapon6] = "";
$FastFaves::key["", decimal, vehicle] = "";
$FastFaves::key["", decimal, exit]    = false;

$FastFaves::key["", numpad0, loadout] = "";
$FastFaves::key["", numpad0, armor]   = "";
$FastFaves::key["", numpad0, pack]    = $Inv::Turret;
$FastFaves::key["", numpad0, weapon1] = "";
$FastFaves::key["", numpad0, weapon2] = "";
$FastFaves::key["", numpad0, weapon3] = "";
$FastFaves::key["", numpad0, weapon4] = "";
$FastFaves::key["", numpad0, weapon5] = "";
$FastFaves::key["", numpad0, weapon6] = "";
$FastFaves::key["", numpad0, vehicle] = "";
$FastFaves::key["", numpad0, exit]    = false;

$FastFaves::key["", numpad1, loadout] = "Indoor Offense w/Shields";
$FastFaves::key["", numpad1, armor]   = $Inv::Light_Armor;
$FastFaves::key["", numpad1, pack]    = $Inv::Shield_Pack;
$FastFaves::key["", numpad1, weapon1] = $Inv::Disc_Launcher;
$FastFaves::key["", numpad1, weapon2] = $Inv::Plasma_Gun;
$FastFaves::key["", numpad1, weapon3] = $Inv::Grenade_Launcher;
$FastFaves::key["", numpad1, weapon4] = "";
$FastFaves::key["", numpad1, weapon5] = "";
$FastFaves::key["", numpad1, weapon6] = "";
$FastFaves::key["", numpad1, vehicle] = "";
$FastFaves::key["", numpad1, exit]    = false;

$FastFaves::key["", numpad2, loadout] = "Special Ops/Offense w/Grenade Launcher";
$FastFaves::key["", numpad2, armor]   = $Inv::Light_Armor;
$FastFaves::key["", numpad2, pack]    = $Inv::Energy_Pack;
$FastFaves::key["", numpad2, weapon1] = $Inv::Disc_Launcher;
$FastFaves::key["", numpad2, weapon2] = $Inv::Plasma_Gun;
$FastFaves::key["", numpad2, weapon3] = $Inv::Grenade_Launcher;
$FastFaves::key["", numpad2, weapon4] = "";
$FastFaves::key["", numpad2, weapon5] = "";
$FastFaves::key["", numpad2, weapon6] = "";
$FastFaves::key["", numpad2, vehicle] = "";
$FastFaves::key["", numpad2, exit]    = false;

$FastFaves::key["", numpad3, loadout] = "Special Ops/Offense w/ELF";
$FastFaves::key["", numpad3, armor]   = $Inv::Light_Armor;
$FastFaves::key["", numpad3, pack]    = $Inv::Energy_Pack;
$FastFaves::key["", numpad3, weapon1] = $Inv::Disc_Launcher;
$FastFaves::key["", numpad3, weapon2] = $Inv::Plasma_Gun;
$FastFaves::key["", numpad3, weapon3] = $Inv::ELF_Gun;
$FastFaves::key["", numpad3, weapon4] = "";
$FastFaves::key["", numpad3, weapon5] = "";
$FastFaves::key["", numpad3, weapon6] = "";
$FastFaves::key["", numpad3, vehicle] = "";
$FastFaves::key["", numpad3, exit]    = false;

$FastFaves::key["", numpad4, loadout] = "Light Medic";
$FastFaves::key["", numpad4, armor]   = $Inv::Light_Armor;
$FastFaves::key["", numpad4, pack]    = $Inv::Repair_Pack;
$FastFaves::key["", numpad4, weapon1] = $Inv::Plasma_Gun;
$FastFaves::key["", numpad4, weapon2] = $Inv::Disc_Launcher;
$FastFaves::key["", numpad4, weapon3] = $Inv::ELF_Gun;
$FastFaves::key["", numpad4, weapon4] = "";
$FastFaves::key["", numpad4, weapon5] = "";
$FastFaves::key["", numpad4, weapon6] = "";
$FastFaves::key["", numpad4, vehicle] = "";
$FastFaves::key["", numpad4, exit]    = false;

$FastFaves::key["", numpad5, loadout] = "Medium Engineer";
$FastFaves::key["", numpad5, armor]   = $Inv::Medium_Armor;
$FastFaves::key["", numpad5, pack]    = $Inv::Inventory_Station;
$FastFaves::key["", numpad5, weapon1] = $Inv::Plasma_Gun;
$FastFaves::key["", numpad5, weapon2] = $Inv::Chaingun;
$FastFaves::key["", numpad5, weapon3] = $Inv::Disc_Launcher;
$FastFaves::key["", numpad5, weapon4] = $Inv::Grenade_Launcher;
$FastFaves::key["", numpad5, weapon5] = "";
$FastFaves::key["", numpad5, weapon6] = "";
$FastFaves::key["", numpad5, vehicle] = "";
$FastFaves::key["", numpad5, exit]    = false;

$FastFaves::key["", numpad6, loadout] = "Medium Special Ops/Offense";
$FastFaves::key["", numpad6, armor]   = $Inv::Medium_Armor;
$FastFaves::key["", numpad6, pack]    = $Inv::Shield_Pack;
$FastFaves::key["", numpad6, weapon1] = $Inv::Plasma_Gun;
$FastFaves::key["", numpad6, weapon2] = $Inv::Chaingun;
$FastFaves::key["", numpad6, weapon3] = $Inv::Disc_Launcher;
$FastFaves::key["", numpad6, weapon4] = $Inv::ELF_Gun;
$FastFaves::key["", numpad6, weapon5] = "";
$FastFaves::key["", numpad6, weapon6] = "";
$FastFaves::key["", numpad6, vehicle] = "";
$FastFaves::key["", numpad6, exit]    = false;

$FastFaves::key["", numpad7, loadout] = "Heavy Defender";
$FastFaves::key["", numpad7, armor]   = $Inv::Heavy_Armor;
$FastFaves::key["", numpad7, pack]    = $Inv::Shield_Pack;
$FastFaves::key["", numpad7, weapon1] = $Inv::Plasma_Gun;
$FastFaves::key["", numpad7, weapon2] = $Inv::Chaingun;
$FastFaves::key["", numpad7, weapon3] = $Inv::Disc_Launcher;
$FastFaves::key["", numpad7, weapon4] = $Inv::Grenade_Launcher;
$FastFaves::key["", numpad7, weapon5] = $Inv::Mortar;
$FastFaves::key["", numpad7, weapon6] = "";
$FastFaves::key["", numpad7, vehicle] = "";
$FastFaves::key["", numpad7, exit]    = false;

$FastFaves::key["", numpad8, loadout] = "Heavy Ops/Offense";
$FastFaves::key["", numpad8, armor]   = $Inv::Heavy_Armor;
$FastFaves::key["", numpad8, pack]    = $Inv::Shield_Pack;
$FastFaves::key["", numpad8, weapon1] = $Inv::Plasma_Gun;
$FastFaves::key["", numpad8, weapon2] = $Inv::Chaingun;
$FastFaves::key["", numpad8, weapon3] = $Inv::Disc_Launcher;
$FastFaves::key["", numpad8, weapon4] = $Inv::Grenade_Launcher;
$FastFaves::key["", numpad8, weapon5] = $Inv::Mortar;
$FastFaves::key["", numpad8, weapon6] = "";
$FastFaves::key["", numpad8, vehicle] = "";
$FastFaves::key["", numpad8, exit]    = false;

$FastFaves::key["", numpad9, loadout] = "Heavy Medic";
$FastFaves::key["", numpad9, armor]   = $Inv::Heavy_Armor;
$FastFaves::key["", numpad9, pack]    = $Inv::Repair_Pack;
$FastFaves::key["", numpad9, weapon1] = $Inv::Plasma_Gun;
$FastFaves::key["", numpad9, weapon2] = $Inv::Chaingun;
$FastFaves::key["", numpad9, weapon3] = $Inv::Disc_Launcher;
$FastFaves::key["", numpad9, weapon4] = $Inv::Grenade_Launcher;
$FastFaves::key["", numpad9, weapon5] = $Inv::Mortar;
$FastFaves::key["", numpad9, weapon6] = "";
$FastFaves::key["", numpad9, vehicle] = "";
$FastFaves::key["", numpad9, exit]    = false;

$FastFaves::key[control, decimal, loadout] = "";
$FastFaves::key[control, decimal, armor]   = "";
$FastFaves::key[control, decimal, pack]    = $Inv::Ammo_Station;
$FastFaves::key[control, decimal, weapon1] = "";
$FastFaves::key[control, decimal, weapon2] = "";
$FastFaves::key[control, decimal, weapon3] = "";
$FastFaves::key[control, decimal, weapon4] = "";
$FastFaves::key[control, decimal, weapon5] = "";
$FastFaves::key[control, decimal, weapon6] = "";
$FastFaves::key[control, decimal, vehicle] = "";
$FastFaves::key[control, decimal, exit]    = false;

$FastFaves::key[control, numpad0, loadout] = "";
$FastFaves::key[control, numpad0, armor]   = "";
$FastFaves::key[control, numpad0, pack]    = $Inv::Inventory_Station;
$FastFaves::key[control, numpad0, weapon1] = "";
$FastFaves::key[control, numpad0, weapon2] = "";
$FastFaves::key[control, numpad0, weapon3] = "";
$FastFaves::key[control, numpad0, weapon4] = "";
$FastFaves::key[control, numpad0, weapon5] = "";
$FastFaves::key[control, numpad0, weapon6] = "";
$FastFaves::key[control, numpad0, vehicle] = "";
$FastFaves::key[control, numpad0, exit]    = false;

$FastFaves::key[control, numpad1, loadout] = "";
$FastFaves::key[control, numpad1, armor]   = "";
$FastFaves::key[control, numpad1, pack]    = $Inv::Motion_Sensor;
$FastFaves::key[control, numpad1, weapon1] = "";
$FastFaves::key[control, numpad1, weapon2] = "";
$FastFaves::key[control, numpad1, weapon3] = "";
$FastFaves::key[control, numpad1, weapon4] = "";
$FastFaves::key[control, numpad1, weapon5] = "";
$FastFaves::key[control, numpad1, weapon6] = "";
$FastFaves::key[control, numpad1, vehicle] = "";
$FastFaves::key[control, numpad1, exit]    = false;

$FastFaves::key[control, numpad2, loadout] = "";
$FastFaves::key[control, numpad2, armor]   = "";
$FastFaves::key[control, numpad2, pack]    = $Inv::Sensor_Jammer;
$FastFaves::key[control, numpad2, weapon1] = "";
$FastFaves::key[control, numpad2, weapon2] = "";
$FastFaves::key[control, numpad2, weapon3] = "";
$FastFaves::key[control, numpad2, weapon4] = "";
$FastFaves::key[control, numpad2, weapon5] = "";
$FastFaves::key[control, numpad2, weapon6] = "";
$FastFaves::key[control, numpad2, vehicle] = "";
$FastFaves::key[control, numpad2, exit]    = false;

$FastFaves::key[control, numpad3, loadout] = "";
$FastFaves::key[control, numpad3, armor]   = "";
$FastFaves::key[control, numpad3, pack]    = $Inv::Pulse_Sensor;
$FastFaves::key[control, numpad3, weapon1] = "";
$FastFaves::key[control, numpad3, weapon2] = "";
$FastFaves::key[control, numpad3, weapon3] = "";
$FastFaves::key[control, numpad3, weapon4] = "";
$FastFaves::key[control, numpad3, weapon5] = "";
$FastFaves::key[control, numpad3, weapon6] = "";
$FastFaves::key[control, numpad3, vehicle] = "";
$FastFaves::key[control, numpad3, exit]    = false;

$FastFaves::key[control, numpad4, loadout] = "Medic";
$FastFaves::key[control, numpad4, armor]   = "";
$FastFaves::key[control, numpad4, pack]    = $Inv::Repair_Pack;
$FastFaves::key[control, numpad4, weapon1] = "";
$FastFaves::key[control, numpad4, weapon2] = "";
$FastFaves::key[control, numpad4, weapon3] = "";
$FastFaves::key[control, numpad4, weapon4] = "";
$FastFaves::key[control, numpad4, weapon5] = "";
$FastFaves::key[control, numpad4, weapon6] = "";
$FastFaves::key[control, numpad4, vehicle] = "";
$FastFaves::key[control, numpad4, exit]    = false;

$FastFaves::key[control, numpad5, loadout] = "Shielded";
$FastFaves::key[control, numpad5, armor]   = "";
$FastFaves::key[control, numpad5, pack]    = $Inv::Shield_Pack;
$FastFaves::key[control, numpad5, weapon1] = "";
$FastFaves::key[control, numpad5, weapon2] = "";
$FastFaves::key[control, numpad5, weapon3] = "";
$FastFaves::key[control, numpad5, weapon4] = "";
$FastFaves::key[control, numpad5, weapon5] = "";
$FastFaves::key[control, numpad5, weapon6] = "";
$FastFaves::key[control, numpad5, vehicle] = "";
$FastFaves::key[control, numpad5, exit]    = false;

$FastFaves::key[control, numpad6, loadout] = "";
$FastFaves::key[control, numpad6, armor]   = "";
$FastFaves::key[control, numpad6, pack]    = $Inv::Camera;
$FastFaves::key[control, numpad6, weapon1] = "";
$FastFaves::key[control, numpad6, weapon2] = "";
$FastFaves::key[control, numpad6, weapon3] = "";
$FastFaves::key[control, numpad6, weapon4] = "";
$FastFaves::key[control, numpad6, weapon5] = "";
$FastFaves::key[control, numpad6, weapon6] = "";
$FastFaves::key[control, numpad6, vehicle] = "";
$FastFaves::key[control, numpad6, exit]    = false;

$FastFaves::key[control, numpad7, loadout] = "";
$FastFaves::key[control, numpad7, armor]   = "";
$FastFaves::key[control, numpad7, pack]    = "";
$FastFaves::key[control, numpad7, weapon1] = "";
$FastFaves::key[control, numpad7, weapon2] = "";
$FastFaves::key[control, numpad7, weapon3] = "";
$FastFaves::key[control, numpad7, weapon4] = "";
$FastFaves::key[control, numpad7, weapon5] = "";
$FastFaves::key[control, numpad7, weapon6] = "";
$FastFaves::key[control, numpad7, vehicle] = $Inv::Scout;
$FastFaves::key[control, numpad7, exit]    = true;

$FastFaves::key[control, numpad8, loadout] = "";
$FastFaves::key[control, numpad8, armor]   = "";
$FastFaves::key[control, numpad8, pack]    = "";
$FastFaves::key[control, numpad8, weapon1] = "";
$FastFaves::key[control, numpad8, weapon2] = "";
$FastFaves::key[control, numpad8, weapon3] = "";
$FastFaves::key[control, numpad8, weapon4] = "";
$FastFaves::key[control, numpad8, weapon5] = "";
$FastFaves::key[control, numpad8, weapon6] = "";
$FastFaves::key[control, numpad8, vehicle] = $Inv::LPC;
$FastFaves::key[control, numpad8, exit]    = true;

$FastFaves::key[control, numpad9, loadout] = "";
$FastFaves::key[control, numpad9, armor]   = "";
$FastFaves::key[control, numpad9, pack]    = "";
$FastFaves::key[control, numpad9, weapon1] = "";
$FastFaves::key[control, numpad9, weapon2] = "";
$FastFaves::key[control, numpad9, weapon3] = "";
$FastFaves::key[control, numpad9, weapon4] = "";
$FastFaves::key[control, numpad9, weapon5] = "";
$FastFaves::key[control, numpad9, weapon6] = "";
$FastFaves::key[control, numpad9, vehicle] = $Inv::HPC;
$FastFaves::key[control, numpad9, exit]    = true;


$FastFaves::key[alt, decimal, loadout] = "";
$FastFaves::key[alt, decimal, armor]   = "";
$FastFaves::key[alt, decimal, pack]    = "";
$FastFaves::key[alt, decimal, weapon1] = "";
$FastFaves::key[alt, decimal, weapon2] = "";
$FastFaves::key[alt, decimal, weapon3] = "";
$FastFaves::key[alt, decimal, weapon4] = "";
$FastFaves::key[alt, decimal, weapon5] = "";
$FastFaves::key[alt, decimal, weapon6] = "";
$FastFaves::key[alt, decimal, vehicle] = "";
$FastFaves::key[alt, decimal, exit]    = false;

$FastFaves::key[alt, numpad0, loadout] = "";
$FastFaves::key[alt, numpad0, armor]   = "";
$FastFaves::key[alt, numpad0, pack]    = "";
$FastFaves::key[alt, numpad0, weapon1] = "";
$FastFaves::key[alt, numpad0, weapon2] = "";
$FastFaves::key[alt, numpad0, weapon3] = "";
$FastFaves::key[alt, numpad0, weapon4] = "";
$FastFaves::key[alt, numpad0, weapon5] = "";
$FastFaves::key[alt, numpad0, weapon6] = "";
$FastFaves::key[alt, numpad0, vehicle] = "";
$FastFaves::key[alt, numpad0, exit]    = false;

$FastFaves::key[alt, numpad1, loadout] = "Base Assault";
$FastFaves::key[alt, numpad1, armor]   = $Inv::Light_Armor;
$FastFaves::key[alt, numpad1, pack]    = $Inv::Shield_Pack;
$FastFaves::key[alt, numpad1, weapon1] = $Inv::Disc_Launcher;
$FastFaves::key[alt, numpad1, weapon2] = $Inv::Grenade_Launcher;
$FastFaves::key[alt, numpad1, weapon3] = $Inv::Plasma_Gun;
$FastFaves::key[alt, numpad1, weapon4] = "";
$FastFaves::key[alt, numpad1, weapon5] = "";
$FastFaves::key[alt, numpad1, weapon6] = "";
$FastFaves::key[alt, numpad1, vehicle] = "";
$FastFaves::key[alt, numpad1, exit]    = false;

$FastFaves::key[alt, numpad2, loadout] = "with ECM";
$FastFaves::key[alt, numpad2, armor]   = "";
$FastFaves::key[alt, numpad2, pack]    = $Inv::Sensor_Jammer_Pack;
$FastFaves::key[alt, numpad2, weapon1] = "";
$FastFaves::key[alt, numpad2, weapon2] = "";
$FastFaves::key[alt, numpad2, weapon3] = "";
$FastFaves::key[alt, numpad2, weapon4] = "";
$FastFaves::key[alt, numpad2, weapon5] = "";
$FastFaves::key[alt, numpad2, weapon6] = "";
$FastFaves::key[alt, numpad2, vehicle] = "";
$FastFaves::key[alt, numpad2, exit]    = false;

$FastFaves::key[alt, numpad3, loadout] = "";
$FastFaves::key[alt, numpad3, armor]   = "";
$FastFaves::key[alt, numpad3, pack]    = "";
$FastFaves::key[alt, numpad3, weapon1] = "";
$FastFaves::key[alt, numpad3, weapon2] = "";
$FastFaves::key[alt, numpad3, weapon3] = "";
$FastFaves::key[alt, numpad3, weapon4] = "";
$FastFaves::key[alt, numpad3, weapon5] = "";
$FastFaves::key[alt, numpad3, weapon6] = "";
$FastFaves::key[alt, numpad3, vehicle] = "";
$FastFaves::key[alt, numpad3, exit]    = false;

$FastFaves::key[alt, numpad4, loadout] = "Base Assault";
$FastFaves::key[alt, numpad4, armor]   = $Inv::Medium_Armor;
$FastFaves::key[alt, numpad4, pack]    = $Inv::Shield_Pack;
$FastFaves::key[alt, numpad4, weapon1] = $Inv::Plasma_Gun;
$FastFaves::key[alt, numpad4, weapon2] = $Inv::Disc_Launcher;
$FastFaves::key[alt, numpad4, weapon3] = $Inv::Chaingun;
$FastFaves::key[alt, numpad4, weapon4] = $Inv::Grenade_Launcher;
$FastFaves::key[alt, numpad4, weapon5] = "";
$FastFaves::key[alt, numpad4, weapon6] = "";
$FastFaves::key[alt, numpad4, vehicle] = "";
$FastFaves::key[alt, numpad4, exit]    = false;

$FastFaves::key[alt, numpad5, loadout] = "";
$FastFaves::key[alt, numpad5, armor]   = "";
$FastFaves::key[alt, numpad5, pack]    = "";
$FastFaves::key[alt, numpad5, weapon1] = "";
$FastFaves::key[alt, numpad5, weapon2] = "";
$FastFaves::key[alt, numpad5, weapon3] = "";
$FastFaves::key[alt, numpad5, weapon4] = "";
$FastFaves::key[alt, numpad5, weapon5] = "";
$FastFaves::key[alt, numpad5, weapon6] = "";
$FastFaves::key[alt, numpad5, vehicle] = "";
$FastFaves::key[alt, numpad5, exit]    = false;

$FastFaves::key[alt, numpad6, loadout] = "";
$FastFaves::key[alt, numpad6, armor]   = "";
$FastFaves::key[alt, numpad6, pack]    = "";
$FastFaves::key[alt, numpad6, weapon1] = "";
$FastFaves::key[alt, numpad6, weapon2] = "";
$FastFaves::key[alt, numpad6, weapon3] = "";
$FastFaves::key[alt, numpad6, weapon4] = "";
$FastFaves::key[alt, numpad6, weapon5] = "";
$FastFaves::key[alt, numpad6, weapon6] = "";
$FastFaves::key[alt, numpad6, vehicle] = "";
$FastFaves::key[alt, numpad6, exit]    = false;

$FastFaves::key[alt, numpad7, loadout] = "";
$FastFaves::key[alt, numpad7, armor]   = "";
$FastFaves::key[alt, numpad7, pack]    = "";
$FastFaves::key[alt, numpad7, weapon1] = "";
$FastFaves::key[alt, numpad7, weapon2] = "";
$FastFaves::key[alt, numpad7, weapon3] = "";
$FastFaves::key[alt, numpad7, weapon4] = "";
$FastFaves::key[alt, numpad7, weapon5] = "";
$FastFaves::key[alt, numpad7, weapon6] = "";
$FastFaves::key[alt, numpad7, vehicle] = "";
$FastFaves::key[alt, numpad7, exit]    = false;

$FastFaves::key[alt, numpad8, loadout] = "";
$FastFaves::key[alt, numpad8, armor]   = "";
$FastFaves::key[alt, numpad8, pack]    = "";
$FastFaves::key[alt, numpad8, weapon1] = "";
$FastFaves::key[alt, numpad8, weapon2] = "";
$FastFaves::key[alt, numpad8, weapon3] = "";
$FastFaves::key[alt, numpad8, weapon4] = "";
$FastFaves::key[alt, numpad8, weapon5] = "";
$FastFaves::key[alt, numpad8, weapon6] = "";
$FastFaves::key[alt, numpad8, vehicle] = "";
$FastFaves::key[alt, numpad8, exit]    = false;

$FastFaves::key[alt, numpad9, loadout] = "";
$FastFaves::key[alt, numpad9, armor]   = "";
$FastFaves::key[alt, numpad9, pack]    = "";
$FastFaves::key[alt, numpad9, weapon1] = "";
$FastFaves::key[alt, numpad9, weapon2] = "";
$FastFaves::key[alt, numpad9, weapon3] = "";
$FastFaves::key[alt, numpad9, weapon4] = "";
$FastFaves::key[alt, numpad9, weapon5] = "";
$FastFaves::key[alt, numpad9, weapon6] = "";
$FastFaves::key[alt, numpad9, vehicle] = "";
$FastFaves::key[alt, numpad9, exit]    = false;

$FastFaves::key[shift, decimal, loadout] = "";
$FastFaves::key[shift, decimal, armor]   = "";
$FastFaves::key[shift, decimal, pack]    = "";
$FastFaves::key[shift, decimal, weapon1] = "";
$FastFaves::key[shift, decimal, weapon2] = "";
$FastFaves::key[shift, decimal, weapon3] = "";
$FastFaves::key[shift, decimal, weapon4] = "";
$FastFaves::key[shift, decimal, weapon5] = "";
$FastFaves::key[shift, decimal, weapon6] = "";
$FastFaves::key[shift, decimal, vehicle] = "";
$FastFaves::key[shift, decimal, exit]    = false;

$FastFaves::key[shift, numpad0, loadout] = "";
$FastFaves::key[shift, numpad0, armor]   = "";
$FastFaves::key[shift, numpad0, pack]    = "";
$FastFaves::key[shift, numpad0, weapon1] = "";
$FastFaves::key[shift, numpad0, weapon2] = "";
$FastFaves::key[shift, numpad0, weapon3] = "";
$FastFaves::key[shift, numpad0, weapon4] = "";
$FastFaves::key[shift, numpad0, weapon5] = "";
$FastFaves::key[shift, numpad0, weapon6] = "";
$FastFaves::key[shift, numpad0, vehicle] = "";
$FastFaves::key[shift, numpad0, exit]    = false;


$FastFaves::key[shift, numpad1, loadout] = "";
$FastFaves::key[shift, numpad1, armor]   = "";
$FastFaves::key[shift, numpad1, pack]    = "";
$FastFaves::key[shift, numpad1, weapon1] = "";
$FastFaves::key[shift, numpad1, weapon2] = "";
$FastFaves::key[shift, numpad1, weapon3] = "";
$FastFaves::key[shift, numpad1, weapon4] = "";
$FastFaves::key[shift, numpad1, weapon5] = "";
$FastFaves::key[shift, numpad1, weapon6] = "";
$FastFaves::key[shift, numpad1, vehicle] = "";
$FastFaves::key[shift, numpad1, exit]    = false;


$FastFaves::key[shift, numpad2, loadout] = "";
$FastFaves::key[shift, numpad2, armor]   = "";
$FastFaves::key[shift, numpad2, pack]    = "";
$FastFaves::key[shift, numpad2, weapon1] = "";
$FastFaves::key[shift, numpad2, weapon2] = "";
$FastFaves::key[shift, numpad2, weapon3] = "";
$FastFaves::key[shift, numpad2, weapon4] = "";
$FastFaves::key[shift, numpad2, weapon5] = "";
$FastFaves::key[shift, numpad2, weapon6] = "";
$FastFaves::key[shift, numpad2, vehicle] = "";
$FastFaves::key[shift, numpad2, exit]    = false;


$FastFaves::key[shift, numpad3, loadout] = "";
$FastFaves::key[shift, numpad3, armor]   = "";
$FastFaves::key[shift, numpad3, pack]    = "";
$FastFaves::key[shift, numpad3, weapon1] = "";
$FastFaves::key[shift, numpad3, weapon2] = "";
$FastFaves::key[shift, numpad3, weapon3] = "";
$FastFaves::key[shift, numpad3, weapon4] = "";
$FastFaves::key[shift, numpad3, weapon5] = "";
$FastFaves::key[shift, numpad3, weapon6] = "";
$FastFaves::key[shift, numpad3, vehicle] = "";
$FastFaves::key[shift, numpad3, exit]    = false;


$FastFaves::key[shift, numpad4, loadout] = "";
$FastFaves::key[shift, numpad4, armor]   = "";
$FastFaves::key[shift, numpad4, pack]    = "";
$FastFaves::key[shift, numpad4, weapon1] = "";
$FastFaves::key[shift, numpad4, weapon2] = "";
$FastFaves::key[shift, numpad4, weapon3] = "";
$FastFaves::key[shift, numpad4, weapon4] = "";
$FastFaves::key[shift, numpad4, weapon5] = "";
$FastFaves::key[shift, numpad4, weapon6] = "";
$FastFaves::key[shift, numpad4, vehicle] = "";
$FastFaves::key[shift, numpad4, exit]    = false;


$FastFaves::key[shift, numpad5, loadout] = "";
$FastFaves::key[shift, numpad5, armor]   = "";
$FastFaves::key[shift, numpad5, pack]    = "";
$FastFaves::key[shift, numpad5, weapon1] = "";
$FastFaves::key[shift, numpad5, weapon2] = "";
$FastFaves::key[shift, numpad5, weapon3] = "";
$FastFaves::key[shift, numpad5, weapon4] = "";
$FastFaves::key[shift, numpad5, weapon5] = "";
$FastFaves::key[shift, numpad5, weapon6] = "";
$FastFaves::key[shift, numpad5, vehicle] = "";
$FastFaves::key[shift, numpad5, exit]    = false;


$FastFaves::key[shift, numpad6, loadout] = "";
$FastFaves::key[shift, numpad6, armor]   = "";
$FastFaves::key[shift, numpad6, pack]    = "";
$FastFaves::key[shift, numpad6, weapon1] = "";
$FastFaves::key[shift, numpad6, weapon2] = "";
$FastFaves::key[shift, numpad6, weapon3] = "";
$FastFaves::key[shift, numpad6, weapon4] = "";
$FastFaves::key[shift, numpad6, weapon5] = "";
$FastFaves::key[shift, numpad6, weapon6] = "";
$FastFaves::key[shift, numpad6, vehicle] = "";
$FastFaves::key[shift, numpad6, exit]    = false;


$FastFaves::key[shift, numpad7, loadout] = "";
$FastFaves::key[shift, numpad7, armor]   = "";
$FastFaves::key[shift, numpad7, pack]    = "";
$FastFaves::key[shift, numpad7, weapon1] = "";
$FastFaves::key[shift, numpad7, weapon2] = "";
$FastFaves::key[shift, numpad7, weapon3] = "";
$FastFaves::key[shift, numpad7, weapon4] = "";
$FastFaves::key[shift, numpad7, weapon5] = "";
$FastFaves::key[shift, numpad7, weapon6] = "";
$FastFaves::key[shift, numpad7, vehicle] = "";
$FastFaves::key[shift, numpad7, exit]    = false;


$FastFaves::key[shift, numpad8, loadout] = "";
$FastFaves::key[shift, numpad8, armor]   = "";
$FastFaves::key[shift, numpad8, pack]    = "";
$FastFaves::key[shift, numpad8, weapon1] = "";
$FastFaves::key[shift, numpad8, weapon2] = "";
$FastFaves::key[shift, numpad8, weapon3] = "";
$FastFaves::key[shift, numpad8, weapon4] = "";
$FastFaves::key[shift, numpad8, weapon5] = "";
$FastFaves::key[shift, numpad8, weapon6] = "";
$FastFaves::key[shift, numpad8, vehicle] = "";
$FastFaves::key[shift, numpad8, exit]    = false;


$FastFaves::key[shift, numpad9, loadout] = "";
$FastFaves::key[shift, numpad9, armor]   = "";
$FastFaves::key[shift, numpad9, pack]    = "";
$FastFaves::key[shift, numpad9, weapon1] = "";
$FastFaves::key[shift, numpad9, weapon2] = "";
$FastFaves::key[shift, numpad9, weapon3] = "";
$FastFaves::key[shift, numpad9, weapon4] = "";
$FastFaves::key[shift, numpad9, weapon5] = "";
$FastFaves::key[shift, numpad9, weapon6] = "";
$FastFaves::key[shift, numpad9, vehicle] = "";
$FastFaves::key[shift, numpad9, exit]    = false;



// ---------S-C-R-I-P-T-I-N-G----L-I-N-E----D-O----N-O-T----C-R-O-S-S---------

// IMPORTANT -- do not remove the following line!
Event::Trigger(eventFavoritesInitialized);
