// ---------------------------------------------------------------------------
// tap_action.cs -- Version 2.1 -- May 15, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------


include("writer\\version.cs");
version("writer\\tap_action.cs", "2.1", "Lorne Laliberte", "- May 15, 1999 - toggle action on key tap - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");

//
// Tap key to toggle action on/off,
// press key to perform action until key is released
//
function tapAction(%on, %taptime, %action, %exclude)
{
    if(%on) // Key Pressed
    {
        if(!$Action::Doing[%action])
        {
            // Action isn't being done, so
            // start doing it now

            if(%exclude)
            {
                // Cancel an opposing action
                postAction(2048, %exclude, 0);
          		$Action::Doing[%exclude] = 0;
            }

            // Do action
            postAction(2048, %action, 1);

            // Set action flag
      		$Action::Doing[%action] = 1;

            Event::Trigger(eventTapActionDoing, %action);

            // Set tap time flag for this action
            $Action::WithinTapTime[%action] = 1;

            // Clear tap time flag for this action in %taptime seconds
            schedule("$Action::WithinTapTime[" @ %action @ "]=0;", %taptime);
        }
    }
    else // Key Released
    {
        if(!$Action::WithinTapTime[%action])
        {
            // Key was pressed more than %taptime seconds ago

            // Stop action
      		postAction(2048, %action, 0);

            Event::Trigger(eventTapActionStopping, %action);

            // Clear action flag
      		$Action::Doing[%action] = 0;
        }
    }
}
