// ---------------------------------------------------------------------------
// respawn_event.cs -- Version 1.1 -- May 22, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\respawn_event.cs", "1.1", "Lorne Laliberte", "- May 22, 1999 - adds respawn event - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");
include("writer\\fire.cs");


// You'd best leave everything alone below this line!
//
// ---------S-C-R-I-P-T-I-N-G----L-I-N-E----D-O----N-O-T----C-R-O-S-S---------


function Respawn::onKillTrak(%killer, %victim, %weapon)
{
    if(%victim == getManagerID())
        $Respawn::PlayerDied = true;

    return;
}
Event::Attach(eventKillTrak, Respawn::onKillTrak);


function Respawn::onFirePressed(%weapon) // %weapon will be -1 if no weapon mounted
{
    if($Respawn::PlayerDied)
    {
        if(%weapon == -1)
            Event::Trigger(eventRespawned);
    }
    $Respawn::PlayerDied = false;
    return;
}	
Event::Attach(eventFirePressed, Respawn::onFirePressed);


Event::Attach(eventConnected, "$Respawn::PlayerDied = false;");
Event::Attach(eventChangeMission, "$Respawn::PlayerDied = false;");
