// ---------------------------------------------------------------------------
// pilot_mode.cs -- Version 2.2 -- May 21, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------


include("writer\\version.cs");
version("writer\\pilot_mode.cs", "2.2", "Lorne Laliberte", "- May 21, 1999 - change mouse sensitivity for piloting - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");
include("writer\\item_events.cs");
include("writer\\station_events.cs");
include("writer\\weapon_switch.cs");
if(include("presto\\killtrak.cs") == notfound)
    include("writer\\killtrak.cs");
if(include("presto\\schedule.cs") == notfound)
    include("writer\\schedule.cs");


$PilotMode::Sensitivity[0]  = 0.016;
$PilotMode::Sensitivity[1]  = 0.022;
$PilotMode::Sensitivities   = 2; // Number of different sensitivity levels in array


// Set this to true to automatically switch to Pilot Mode after you have no weapons for a couple seconds
$PilotMode::AutoDetectOn = false;


// You'd best leave everything alone below this line!
//
// ---------S-C-R-I-P-T-I-N-G----L-I-N-E----D-O----N-O-T----C-R-O-S-S---------


$PilotMode = 0;

$Sensitivity::Normal = Client::getMouseSensitivity("playMap.sae");

//
// Toggle auto-detect Pilot Mode on/off
//
function PilotMode::ToggleAutoDetect()
{
    remoteBP(2048, "<L5>Auto Detect Pilot Mode <f2>" @ wif($PilotMode::AutoDetectOn = !$PilotMode::AutoDetectOn, "ON", "OFF"),4);

    if($PilotMode::AutoDetectOn)
        PilotMode::AutoDetect::Start();
}


function PilotMode::AutoDetect()
{
    if($PilotMode::AutoDetectOn && !$PilotMode::Starting && !$PilotMode)
    {
        // Stop looping when we access a station
        if($Station::AtStation)
            return;

        if(getMountedItem(0) == -1)
                PilotMode::On();
        else
            schedule::add("PilotMode::AutoDetect();", 1.0);
    }
}


function PilotMode::AutoDetect::Start()
{
    $PilotMode::Starting = true;
    schedule::add("PilotMode::AutoDetect::StartLoop();", 1.0);
}
Event::Attach(eventExitStation, "PilotMode::AutoDetect::Start();");

Event::Attach(eventEnterStation, "$PilotMode::Weaponless = false;");


function PilotMode::AutoDetect::StartLoop()
{
    if($PilotMode::Starting)
    {
        if( (%weapon = getMountedItem(0)) == -1)
        {
            $PilotMode::Weaponless = true;
            schedule::add("PilotMode::AutoDetect::StartLoop();", 2.0);
        }
        else
        {
            if($PilotMode::Weaponless)
                Event::Trigger(eventWeaponSwitch, %weapon, -1);

            $PilotMode::Starting =
            $PilotMode::Weaponless = false;

            schedule::add("PilotMode::AutoDetect();", 2.0);
        }
    }
}
Event::Attach(eventConnected, "PilotMode::AutoDetect::Start();");
Event::Attach(eventChangeMission, "PilotMode::AutoDetect::Start();");


// Prevent Pilot Mode from turning on when we drop a mounted weapon
Event::Attach(eventUnmount, "PilotMode::AutoDetect::Start();");


//
// Turn Pilot Mode off when we die in a scout :)
//
function PilotMode::onKillTrak(%killer, %victim, %weapon)
{
    if(%victim == getManagerID())
    {
        if($PilotMode)
            PilotMode::Off(1);
        else
            PilotMode::AutoDetect::Start();
    }
    return;
}
Event::Attach(eventKillTrak, PilotMode::onKillTrak);


//
// Disable jump key while piloting so we don't accidentally jump out
// of the vehicle...I used to do that all the time and it's a real PITA :)
//
function PilotMode::onJump()
{
    if($PilotMode)
        return mute;

    return;
}
Event::Attach(eventJump, "PilotMode::onJump();");


//
// Switch to pilot mode, cycle between different mouse sensitivity boost
// levels and disable the jump key to avoid accidentally exiting the vehicle 
// if jump.cs is installed.
//
function PilotMode::On()
{
    $PilotMode::Starting = false;

    if($PilotMode >= $PilotMode::Sensitivities )
        $PilotMode = 0;

    setSensitivity($PilotMode::Sensitivity[$PilotMode]);
    $PilotMode++;

    remoteBP(2048, "<L5>Pilot Mode ON (" @ $PilotMode @ ")", 3);

    Event::Trigger(eventPilotModeOn);
}


//
// Restore normal mouse sensitivity, re-enable the jump key,
// and jump out of the vehicle
//
function PilotMode::Off(%quiet)
{
    $PilotMode = 0;
    setSensitivity($Sensitivity::Normal);

    if(!%quiet)
        remoteBP(2048, "<L5>Pilot Mode OFF", 3);

    EditActionMap("playMap.sae");

    // Jump out of the vehicle
    postAction(2048, IDACTION_MOVEUP, 0);

    Event::Trigger(eventPilotModeOff);

    $PilotMode::Weaponless = true;

    PilotMode::AutoDetect::Start();
}
Event::Attach(eventChangeMission, "PilotMode::Off(1);");


//
// Set mouse sensitivity to given value
//
function setSensitivity(%sensitivity)
{
    if(Client::getMouseXaxisFlip("playMap.sae"))
    {
        EditActionMap("playMap.sae");
        bindAction(mouse0, xaxis0, TO, IDACTION_YAW, Scale, %sensitivity);
    }
    else
    {
        EditActionMap("playMap.sae");
        bindAction(mouse0, xaxis0, TO, IDACTION_YAW, Flip, Scale, %sensitivity);
    }

    if(Client::getMouseYaxisFlip("playMap.sae"))
    {
        EditActionMap("playMap.sae");
        bindAction(mouse0, yaxis0, TO, IDACTION_PITCH, Scale, %sensitivity);
    }
    else
    {
        EditActionMap("playMap.sae");
        bindAction(mouse0, yaxis0, TO, IDACTION_PITCH, Flip, Scale, %sensitivity);
    }
}


// Bind to my default keys if keys.cs not used
if(!included("writer\\keys.cs"))
{
    EditActionMap("playMap.sae");

    // Turn on pilot mode and cycle through mouse sensitivity settings for flying
    bindCommand(keyboard0, make, l_shift, "c", TO, "PilotMode::On();");

    // Toggle auto-detect Pilot Mode on/off
    bindCommand(keyboard0, make, l_shift, "p", TO, "PilotMode::ToggleAutoDetect();");

    // Set a new jump key to turn off Pilot mode and exit the vehicle
    bindCommand(keyboard0, make, shift, "space", TO, "PilotMode::Off();");
}
