//----------------------------------------------------------------------------------
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! SixPak Script Pack !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//----------------------------------------------------------------------------------
// FILE NAME    | atf.cs
// AUTHOR       | Vacas_SixStringz  
// AUTHOR EMAIL | mccleans@inreach.com
// VERSION      | 2.2
// RELEASE DATE | 06/21/99
// REQUIREMENTS | SixHUD.cs, FlafResponse.cs
// DESCRIPTION  | Waypoint setting to enemy and friendly flag carrier
// DESCRIPTION  | Toggle Automatic waypoint setting for friendly and enemy flag carrier 
// DESCRIPTION  | Toggle Manual/Auto notify friendly carrier you will cover or 
// DESCRIPTION  | or command to attack enemy flag carrier 
// DESCRIPTION  | Taunt enemy flag carrier (sorry couldn't resist)
//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------

Include("Presto\\TeamTrak.cs");

if($SixPref::ATF =="")	                $SixPref::ATF = false;
if($SixPref::ATFAutoNotify =="")	$SixPref::ATFAutoNotify = false;
if($SixPref::ATF_AN_Delay =="")         $SixPref::ATF_AN_Delay = 3;
if($SixPref::ATFAutoNotify == true)
   $SixPref::ATF = true;

if($SixPref::ATFE =="")	                $SixPref::ATFE = false;
if($SixPref::ATFAutoENotify =="")	$SixPref::ATFAutoENotify = false;
if($SixPref::ATF_AEN_Delay =="")         $SixPref::ATF_AEN_Delay = 3;
if($SixPref::ATF == true)
   $SixPref::ATFAutoENotify = false;

function ATF::Notify()
{
    if ($SixVar::FC !="")
        if ($SixPref::ATFAutoNotify)   
            if(Flood::Protect(ATF::Notify, 10)) //AFT Notification
            {   
                say(1, "I have locked on to your coordinates " @ $SixVar::FC @ " and will cover you!~wproceed");
            }
}

function ATF::ManualNotify()
{
   $SixVar::Manual = true;
   $SixPref::ATFAutoNotify = true;
   TargetFlagTaker(true);
   $SixPref::ATFAutoNotify = false;
   $SixVar::Manual = false;
}

function ATF::ENotify()
{
    if ($SixVar::EC !="")
        if ($SixPref::ATFAutoENotify)   
            if(Flood::Protect(ATF::ENotify, 30)) //AFT Notification
            {   
                say(1,"" @ $SixVar::EC @ " has taken our flag!~wflgtkm2");
            }
}

function ATF::EManualNotify()
{
   $SixVar::EManual = true;
   $SixPref::ATFAutoENotify = true;
   TargetFlagTaker(false);
   $SixPref::ATFAutoENotify = false;
   $SixVar::EManual = false;
}

function ATF::Toggle()
{
   $SixPref::ATFE = false;
   $SixPref::ATFAutoENotify = false;

   if($SixPref::ATF)       
      if(!$SixPref::ATFAutoNotify)
      {
         $SixPref::ATFAutoNotify = true; 
         $SixPref::ATF = true;	
         schedule::Add("THGoAway(true);",0);
         remoteBP(2048, "<L5><f0> ATF AUTO NOTIFICATION NOW <f2>ON", 4);
      }
      else
      {
         $SixPref::ATF = false;		
         $SixPref::ATFAutoNotify = false; 
         schedule::Add("THGoAway(true);",0);
         remoteBP(2048, "<L5><f0> ATF FUNCTIONS <f0>OFF", 4);
      }
   else   
   {   
      $SixPref::ATF = true;	
      $SixPref::ATFAutoNotify = false;		
      schedule::Add("THGoAway(true);",0);
      remoteBP(2048, "<L5><f0> ATF <f2>ON", 4);
   }
}

function ATF::EToggle()
{
   $SixPref::ATF = false;
   $SixPref::ATFAutoNotify = false;

   if($SixPref::ATFE)       
      if(!$SixPref::ATFAutoENotify)
      {
         $SixPref::ATFAutoENotify = true; 
         $SixPref::ATFE = true;	
         schedule::Add("THGoAway(true);",0);
         remoteBP(2048, "<L5><f0> ATF ENEMY AUTO NOTIFICATION NOW <f2>ON", 4);
      }
      else
      {
         $SixPref::ATFE = false;		
         $SixPref::ATFAutoENotify = false; 
         schedule::Add("THGoAway(true);",0);
         remoteBP(2048, "<L5><f0> ATF ENEMY FUNCTIONS <f0>OFF", 4);
      }
   else   
   {   
      $SixPref::ATFE = true;	
      $SixPref::ATFAutoENotify = false;		
      schedule::Add("THGoAway(true);",0); 
      remoteBP(2048, "<L5><f0> ATF ENEMY <f2>ON", 4);
   }
}

function ClearWay()
{
 $RetComp::on = FALSE;   
        HUD::Display(XHairDist, $RetComp::on);
        HUD::Display(XHairCompass, $RetComp::on);
}

function targetClientByName(%name, %msg)
{
    %clientId = getClientByName(%name);
    remoteEval(2048, "IssueTargCommand", 0, %msg, %clientID - 2048, getManagerId());
}

function TargetFlagTaker(%friendly)
{
    if(%friendly)
    {
        %location = Team::GetFlagLocation(Team::Enemy());
	if(%location == $Trak::locationHome || %location == $Trak::locationField)
	    return;

	targetClientByName(%location, "Escort the flag carrier " @ %location @ ".~wescfr");
        if($SixVar::Manual)                                               
           ATF::Notify();                                                 
        else                                                              
           schedule("ATF::Notify();",$SixPref::ATF_AN_Delay);             

    }
    else
    {
        %location = Team::GetFlagLocation(Team::Friendly());
	if(%location == $Trak::locationHome || %location == $Trak::locationField)
            return;

	targetClientByName(%location, "Kill the flag carrier " @ %location @ "!~wattway");
        if($SixVar::EManual)                                               
           ATF::ENotify();                                                 
        else                                                               
           schedule("ATF::ENotify();",$SixPref::ATF_AEN_Delay);            

    }
}