//----------------------------------------------------------------------------------
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! SixPak Script Pack !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//----------------------------------------------------------------------------------
// FILE NAME    | sixkeys.cs 
// AUTHOR       | Vacas_SixStringz  
// AUTHOR EMAIL | mccleans@inreach.com
// VERSION      | 1.9
// RELEASE DATE | 06/30/99
// REQUIREMENTS | 
// DESCRIPTION  | Setup file for defaults key bindings
// DESCRIPTION  | 
//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------
//

function Six::bindKeys()
{

//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------
// OGLMode
// oglmode.sc

if(included("six\\oglmode.cs"))
{

    EditActionMap("playMap.sae");
    bindCommand(keyboard0, make, shift, "o", TO, "OGLToggle();");
    bindCommand(keyboard0, break, shift, "o", TO, "");
}

//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------
// Death Dance
// death_dance.cs

if(included("six\\death_dance.cs"))
{

    EditActionMap("playMap.sae");
    bindCommand(keyboard0, make, "/", TO, "DeathDance();");
    bindCommand(keyboard0, break, "/", TO, "");
}

//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------
// Incoming chat
// incomingchat.cs

if(included("six\\incomingchat.cs"))
{

    EditActionMap("playMap.sae");
    bindCommand(keyboard0, make, "insert", TO, "Menu::Display(menuIncoming);");
}
  
//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------
// Juggle stuff
// juggle.cs

if(included("six\\juggle.cs"))
{

    EditActionMap("playMap.sae");
    bindCommand(keyboard0, make, alt, "j", TO, "DropAll();");
    bindCommand(keyboard0, break, alt, "j", TO, "");
}

//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------
// Target flag
// targetflag.cs
//

if(included("six\\targetflag.cs"))
{

    EditActionMap("playMap.sae");
    bindCommand(keyboard0, make, shift, "f", TO, "TargetFlagTaker(true);");  // Friendly carrier
    bindCommand(keyboard0, break, shift, "f", TO, "");
    bindCommand(keyboard0, make, shift, "e", TO, "TargetFlagTaker(false);"); // Enemy carrier
    bindCommand(keyboard0, break, shift, "e", TO, ""); 
}

//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------
// Mine and Grenade
// mag.cs

if(included("six\\mag.cs"))
{

    EditActionMap("playMap.sae");
    bindCommand(keyboard0, make, "\\", TO, "MaG();");
    bindCommand(keyboard0, break, "\\", TO, "");
}

//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------
// random taunts and taunt responses with auto toggle
// ptr.cs

if(included("six\\tr.cs"))
{

    EditActionMap("playMap.sae");
    bindCommand(keyboard0, make, alt, "t", TO, "Taunt();");
    bindCommand(keyboard0, break, alt, "t", TO, "");
    bindCommand(keyboard0, make, alt, "r", TO, "Response();");
    bindCommand(keyboard0, break, alt, "r", TO, "");
    bindCommand(keyboard0, make, control, "t", TO, "AutoTToggle();");
    bindCommand(keyboard0, break, control, "t", TO, "");
    bindCommand(keyboard0, make, control, "r", TO, "AutoRToggle();");
    bindCommand(keyboard0, break, control, "t", TO, "");
}

//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------
// Sniper Duck
// sniper_duck.cs
// lets you duck/kneel without changing your line of sight allowing 
// you to snipe invisibly over a hill or ridge

if(included("six\\sniper_duck.cs"))
{
   editActionMap("playMap.sae");
   bindCommand(keyboard0, make, shift, "end", TO, "sniper_duck();");
   bindCommand(keyboard0, break, shift, "end", TO, "");
}

//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------
// Auto Target Flag
// atf.cs

if(included("six\\atf.cs"))
{
     EditActionMap("playMap.sae");
     bindCommand(keyboard0, make, shift, "f", TO, "TargetFlagTaker(true);");  // Friendly carrier
     bindCommand(keyboard0, break, shift, "f", TO, "");
     bindCommand(keyboard0, make, shift, "e", TO, "TargetFlagTaker(false);"); // Enemy carrier
     bindCommand(keyboard0, break, shift, "e", TO, "");     
     bindCommand(keyboard0, make, alt, "f", TO, "ATF::ManualNotify();");
     bindCommand(keyboard0, break, alt, "f", TO, "");
     bindCommand(keyboard0, make, alt, "e", TO, "ATF::EManualNotify();");
     bindCommand(keyboard0, break, alt, "e", TO, "");
     bindCommand(keyboard0, make, shift, "a", TO, "ATF::Toggle();");
     bindCommand(keyboard0, break, shift, "a", TO, "");
     bindCommand(keyboard0, make, control, "a", TO, "ATF::EToggle();");
     bindCommand(keyboard0, break, control, "a", TO, "");
}

//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------
// Stopwatch HUD
// stopwatch.cs
// This is a quick and dirty Stopwatch HUD.  
// It could be used to allow a team to coordinate attacks based on time.
// 

if(included("six\\stopwatch.cs"))
{
     EditActionMap("playMap.sae"); 
     bindCommand(keyboard0, make,  "=", TO, "stopwatch::sendsync($SW::zero,$SW::end);");
     bindCommand(keyboard0, break, "=", TO, "");
     bindCommand(keyboard0, make,  shift, "=", TO, "SW::togglemode();");
     bindCommand(keyboard0, break, shift, "=", TO, "");
     bindCommand(keyboard0, make,  "[", TO, "stopwatch::zplus(\"plus\");");
     bindCommand(keyboard0, break, "[", TO, "");
     bindCommand(keyboard0, make,  shift,"[", TO, "stopwatch::zplus(\"minus\");");
     bindCommand(keyboard0, break, shift,"[", TO, "");
     bindCommand(keyboard0, make,  "]", TO, "stopwatch::eplus(\"plus\");");
     bindCommand(keyboard0, break, "]", TO, "");
     bindCommand(keyboard0, make,  shift,"]", TO, "stopwatch::eplus(\"minus\");");
     bindCommand(keyboard0, break, shift,"]", TO, ""); 
}

//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------
// CDHUD
// CDHUD.cs

if(included("six\\cdhud.cs"))
{
   editActionMap("playMap.sae");
   bindCommand(keyboard0, make, alt, "up", to, "CDHUD::PlayAll();");
   bindCommand(keyboard0, make, alt, "down", to, "CDHUD::ToggleDisplay();");
   bindCommand(keyboard0, make, control, "up", to, "CDHUD::Play();");
   bindCommand(keyboard0, make, control, "down", to, "CDHUD::Stop();");
   bindCommand(keyboard0, make, control, "right", to, "CDHUD::Next();");
   bindCommand(keyboard0, make, control, "left", to, "CDHUD::Prev();");
}

//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------
// Warpoints waypoint system
// warpointer.cs & warpoints.cs

if(included("six\\warpoints.cs"))
{
   editActionMap("playMap.sae");
   bindCommand(keyboard0, make, alt, "w", TO, "Menu::Display(warmain);");
   bindCommand(keyboard0, break, alt, "w", TO, "");
}

if(included("six\\warpointer.cs"))
{
   editActionMap("playMap.sae");
   bindCommand(keyboard0, make, alt, "1", TO, "Warpointer::findWaypoint();");
   bindCommand(keyboard0, break, alt, "1", TO, "");
   bindCommand(keyboard0, make, alt, "2", TO, "Warpointer::exportFoundPoints();");
   bindCommand(keyboard0, break, alt, "2", TO, ""); 
}

//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------
// Help flag carrier at beacon and pack deploy help
// pack_help.cs

if(included("six\\pack_help.cs"))
{
   EditActionMap("actionMap.sae");
   bindCommand(keyboard0, make, "p", TO, "PacDeploy();");
   bindCommand(keyboard0, break, "p", TO, "PacDone();");
   bindCommand(keyboard0, make, "b", TO, "BeaconDeploy();");
   bindCommand(keyboard0, break, "b", TO, "BeaconDone();");
}

//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------
// mHUD
// mhud.cs

if(included("cowboy\\mhud.cs"))
{
   bindkey(play, "r", "mHUD::ToggleView();");
   bindkey(play, "alt q", "mHUD::ForceMortarToggle();");
}

//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------
// Duel countdown
// duel.cs

if(included("six\\duel.cs"))
{
    EditActionMap("playMap.sae");
    bindCommand(keyboard0, make, shift, "d", TO, "duel_countdown();");
    bindCommand(keyboard0, break, shift, "d", TO, "");
}

//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------
// SixHUD
// sixhud.cs

if(included("six\\sixhud.cs"))
{
   editActionMap("playMap.sae");
   bindCommand(keyboard0, make, control, "h", TO, "Hyper::Toggle();");
   bindCommand(keyboard0, break, control, "h", TO, "");
}

//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------

}  //do not remove this