//----------------------------------------------------------------------------------
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! SixPak Script Pack !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//----------------------------------------------------------------------------------
// FILE NAME    | SixHUD.cs  (HyperHUD)
// AUTHOR       | DarkNinja w/ modifications by Vacas_SixStringz  
// AUTHOR EMAIL | mccleans@inreach.com
// VERSION      | 2.0d.sixpak.1.2
// RELEASE DATE | 05/19/99
// REQUIREMENTS | Presto Pack .93+
// DESCRIPTION  | This script is 100% DarkNinja's HyperHUD and he deserves all the 
// DESCRIPTION  | credit. The only reason I renamed this file is because the
// DESCRIPTION  | modifications made to it are required by other scripts in this 
// DESCRIPTION  | pack. Removing it or replacing it with a newer version of HyperHUD
// DESCRIPTION  | will cause other scripts to not work!
//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------

$Hyper::c = -1;	// DO NOT MODIFY THIS LINE!!!

// ======================
//  HyperHUD Preferences
// ======================

// Set this to your screen width.  If there is a gap between the HUD and the right side of the
// screen, try increasing this value.  Remember to rerun TRIBES after modifying this setting.  You
// cannot edit while the game is running, then execute the script from the console.
$Hyper::ScreenWidth = 1024;

// Set this to your screen height.
$Hyper::ScreenHeight = 768;

// Where do you want the flag status HUDs to appear?  Options are:
//
//	   "left" - Appear vertically on the left side of the screen, between the power/health
//		  meters and the weapon icons.  If you have the general HUDs below set to
//		  "left" also, then the flag status HUDs will appear to the right of the
//		  general HUDs.
//	  "right" - Appear vertically on the right side of the screen, just under the compass.
//		  If you have the general HUDs below set to "right" also, then the flag status
//		  HUDs will appear to the left of the general HUDs.
//	"topchat" - Appear horizontally centered right under the chat message window.  If you
//		  have the general HUDs below set to "top", then the flag status HUDs will
//		  appear right below them.
//	    "top" - Appear horizontally at the top center of the screen.  Use this option only
//		  if you have turned off the chat window.  You can do this during gameplay
//		  via the prefs menu, default key is "k".
//	 "bottom" - Appear horizontally at the bottom of the screen.  If you choose this option,
//		  your team's flag status HUD will appear in bottom left corner and the
//		  enemy's will appear in the bottom right corner.
$Hyper::FlagHUDLoc = "left";

// Starting Y position of our flag HUDs.  This is how many pixels from top of screen the flag HUDs
// will be displayed.  Good values are 65 for 512x384, 70 for 640x480, 80 for 800x600 and 90 for
// 1024x768.  This value only applies if $Hyper::FlagHUDLoc equals "left", "right" or "topchat".
// You can modify this to your own liking.
$Hyper::FlagYPos = 82;

// Where do you want the general HUDs to appear?  Options are:
//
//	   "left" - Appear vertically on the left side of the screen, between the power/health
//		  meters and the weapon icons.
//	  "right" - Appear vertically on the right side of the screen, just under the compass.
//	"topchat" - Appear horizontally centered right under the chat message window.  If you
//		  have the flag status HUDs set to "top" above, then the general HUDs will
//		  appear right below them.
//	    "top" - Appear horizontally at the top center of the screen.  Use this only if you
//		  do not like having the chat message window open.  You can turn the chat
//		  window on/off via prefs menu during gameplay, default key is "k".
//	 "bottom" - Appear horizontally at bottom center of screen.
//
$Hyper::GenHUDLoc = "right";

// Starting Y position of our general HUDs (caps/kills/deaths/etc.).  This is how many pixels from
// top of screen the HUDs will be displayed.  This value only applies if $Hyper::GenHUDLoc equals
// "left", "right" or "topchat".  Good values are the same as for $Hyper::FlagYPos.  Modify to
// your liking.
$Hyper::GenYPos = 73;

// This is how many general HUDs to display per line ONLY IF $Hyper::GenHUDLoc equals "top",
// "topchat" or "bottom".  Good values are 4 for a screen width of 512, 6 for 640 and 9 for 800+.
$Hyper::HUDsPerLine = 9;

// For the following, true = uncommented line and false = commented line.  Commented lines
// begin with "//", so '//$Hyper::Gen[%c++] = "ShowCaps";' would turn off the flag capture HUD.
//
// Also, you can reorder the General HUDs to your liking.  All you have to do is CUT & PASTE the
// lines below in the order you want the HUDs to appear.

// General HUDs.
$Hyper::Gen[$Hyper::c++] = "ShowCaps";		// Show how many times you and/or your team have captured the enemy flag?
$Hyper::Gen[$Hyper::c++] = "ShowKills";		// Show how many kills you've made?
$Hyper::Gen[$Hyper::c++] = "ShowDeaths";	// Show how many times you have been killed?
$Hyper::Gen[$Hyper::c++] = "ShowMines";		// Show how many mines you have?
$Hyper::Gen[$Hyper::c++] = "ShowGrenades";	// Show how many grenades you have?
$Hyper::Gen[$Hyper::c++] = "ShowRepair";	// Show if you have a repair kit and/or beacons?
$Hyper::Gen[$Hyper::c++] = "ShowPlayers";	// Show how many players are on each team?
//$Hyper::Gen[$Hyper::c++] = "ShowObjective";	// Show how many objectives your team holds?
//$Hyper::Gen[$Hyper::c++] = "ShowTime";		// Show how long you've been playing?

// For the following, true = on and false = off.

$Hyper::ShowVictim = true;	// Upon a kill, do you want the victim and weapon used shown
			// temporarily onscreen?
$Hyper::ShowKiller = true;	// Upon your death, do you want to view the killer and weapon used
			// temporarily onscreen?

$Hyper::AutoStart = true;	// Do you want HyperHUD to automatically run on startup?

$Hyper::GenStart = false;	// Do you want HyperHUD to start up in the General Gameplay screen?  (No flag status HUDs.)

$Hyper::BalanceNotify = false;	// Notify everyone when teams are unbalanced?  NOTE: You must have
			// the player count HUD active above ("ShowPlayers"), otherwise this
			// is useless.
$Hyper::Outnumber = 5;	// By how many players do you consider a team outnumbered?

// ===============================================================================================
//  HyperHUD V2.0d
//  May 17, 1999
//
//  DarkNinja
//  http://www.zianet.com/mjaecks/hyperhud/
// ===============================================================================================
//  This is another HUD script file for Starsiege TRIBES.  It is a variant of DynHUD by Presto,
//  which in turn is a modification of the original DynHUD by KillerBunny.
//
//  So what?  Well, I've tried to venture down a different path by making the HUD totally
//  configurable.  There are many separate HUDs available.  I've also designed some custom icons
//  for the General HUDs.  These will be located in your "Tribes\base" directory and filenames
//  will start with "HyperHUD_...".
//
//	NOTE: These can be placed on any four sides of the screen.
//
//	- CTF HUDs for your team's flag status and the enemy's flag status.
//	- Flag Capture HUD shows how many times your team, the enemy team and you personally have captured the flag.
//	- Kills HUD shows how many kills you've made so far.
//	- Deaths HUD shows how many times you've died.
//	- Mines HUD shows how many mines you have.
//	- Grenades HUD shows how many grenades you have.
//	- Repair/Beacon HUD shows if you have a repair kit and/or beacon.
//	- Player Count HUD for showing how many players are on each team.
//	- Objectives HUD for showing how many objectives our team currently holds.
//	- Play time HUD shows how long you have been playing the current session of TRIBES.
//
//	Extras (non-HUD):
//
//	- Show who you have killed along with the weapon you used.
//	- Show who killed you along with the weapon they used.
//	- Notify all players when there is team unbalance.
//
//  There are now three styles of HUD screens available.  Hitting "Control-H" will cycle through
//  these accordingly.
//
//	1) Capture the Flag - Shows your team and enemy team flag status HUDs.  Also, shows your
//	   general HUDs.
//	2) Multiple Team CTF - Shows your team's flag status along with the general HUDs.  Right
//	   now HyperHUD can only handle two teams at most in CTF, so there is no sense in
//	   showing the enemy's flag status if there are three or more teams playing.
//	3) General Gameplay - Shows only the general HUDs.  This option is useful for other
//	   gameplay, such as Defend & Destroy, Deathmatch, etc.
//
//  NOTE: For more detailed information, please read the descriptions for each function in the
//  script.  The HUD update function descriptions will tell you what the HUDs look like and how
//  they work.
// ===============================================================================================
//  History:
//	- 2.0d, May 17, 1999
//	  Ahhh crap!  Fixed a bug where if "$Hyper::GenStart" equals true, it would still show
//	  the flag status HUDs.  Thanks UberGuy!
//
//	- 2.0c, May 15, 1999
//	  Added a team unbalance notification routine, tied in with the player count HUD.  This
//	  includes two new variables in "HyperHUD Preferences".  "$Hyper::BalanceNotify" let's
//	  you turn on/off this new function.  "$Hyper::Outnumber" equals the number of extra
//	  players that are considered to cause team unbalance.  That is, if a team outnumbers
//	  the other team by at least this amount, then our team unbalance routine will notify
//	  everyone.  By default, teams are unbalanced when a team has five or more extra
//	  players on their side.  Upon team unbalance, the phrase "Teams are unbalanced!!!" will
//	  be sent to all players along with a random colorful verbal remark for added emphasis.
//	  :)
//
//	  OK!  Now you say I'm a whiner.  That may be true, but some players don't really take
//	  a good look at team unbalance.  For example, let's say team A is outnumbered by team B
//	  by a factor of five players.  In a man-to-man combat situation, team B has five free
//	  players to either defend or attack team A.  This can make for a frustrating game and
//	  cause some players to just drop from the server, thus causing a greater team
//	  unbalance.  Granted there are some good players that can handle two or even three
//	  players by themselves, but for most, one-on-one is the easiest way to go.  Had to get
//	  my two-cents worth in here! :)
//
//	  Added a banner to the TRIBES main screen.  Thanks to [RL]Prey for the code submission!
//
//	- 2.0b, May 9, 1999
//	  Fixed incompatibility bug with timeHUD by Shots.
//
//	  Resized the flag capture HUD icon so that the HUD can accommodate team capture totals
//	  greater than nine. :)
//
//	- 2.0a, May 9, 1999
//	  Damn I suck as a beta tester! :(  Fixed bug where flag capture HUD wasn't updating
//	  upon the enemy's capture of your flag.  Had to move one line of code to fix it too. :)
//
//	- 2.0, May 8, 1999
//	  Finally, you can now place the general HUDs in any order you like.  Just CUT & PASTE
//	  the general HUD lines above in "HyperHUD Preferences" to your liking.  Also changed
//	  the way you turn them on or off.  Comment the lines with "//" at the beginning to turn
//	  that particular general HUD off.
//
//	  Fixed the general HUD limit of four in the "top", "topchat" and "bottom" positions for
//	  512x384 users.
//
//	  You can now place BOTH the flag status HUDs and general HUDs on the same side of the
//	  screen (left or right).  The general HUDs will always be placed at the edge of the
//	  screen, with the flag status HUDs on the inside towards the center of the screen.
//	  This is due to the variable display widths of the flag status HUDs.  Thanks Jacknife!
//
//	  Changed the flag capture HUD again:
//
//		CTF HUD screen - The HUD will have your team's flag capture total to the left
//		of the capture icon and the enemy total to the right.  If there are no capture
//		totals, they will be left blank.  Upon a capture by YOU, the HUD will blink
//		(alternate) between the normal display and a display just showing your
//		personal capture count.  This will continue for a few seconds.
//
//		Multiple Team HUD screen - The HUD will have your personal capture total to
//		the left of the icon and your team's capture total to the right.  If there are
//		no personal captures or team captures, they will be left blank.  
//
//	- 1.9, May 2, 1999
//	  Added another HUD to keep track of how long you've been playing the current session of
//	  TRIBES.  The time is updated every minute.  The counter begins upon a server
//	  connection.  It basically keeps a counter incremented every 60 seconds using the
//	  "schedule" function.
//
//	  Fixed a bug that did not reset the flag capture HUD upon a team change.  Flag captures
//	  are now tracked for all teams.  Your personal captures are tracked for each team you
//	  join.  So during a game, you capture the flag twice for team A.  You decide to switch
//	  to team B.  If for some reason you were to join team A again, you will still retain
//	  the two personal flag captures and team A's total flag capture amount.
//
//	- 1.8b, May 1, 1999
//	  Minor change to the flag capture HUD.  It now monitors both how many times you
//	  personally have captured the enemy flag and how many times your team has captured the
//	  enemy flag.  Your personal total is displayed to the left of the flag capture icon and
//	  the team total is on the right side of the icon.  If there are no totals, then they
//	  will be left blank.  Also, if you don't have any personal captures, the icon will be
//	  left justified.
//
//	  NOTE: If you join a game in progress, the flag capture amount may be incorrect.  This
//	        will be corrected once the server begins a new mission.
//
//	- 1.8a, April 27, 1999
//	  Fixed bug that would display both flag status HUDs when you were in Multiple Team HUD
//	  screen or General Gameplay HUD screen.  This was due to redesign of compact flag
//	  status HUDs in V1.7.
//
//	- 1.8, April 25, 1999
//	  Added another HUD to keep track of how many objectives your team currently holds.
//
//	  NOTE:
//		- Objectives are defined as tower switches for now.  So destroying enemy
//		  generators in D&D does not count.
//		- Upon joining a server, the amount is set to zero, since we do not know how
//		  many objectives are currently held by our team.
//		- The amount is also set to zero when you switch teams.  At the moment, we
//		  cannot track the enemy's objective count, because no client messages tell us
//		  if the objective we just took was open are previously held by the enemy.
//
//	- 1.7a, April 25, 1999
//	  Removed the "$Hyper::MaxPlayers" preference.  HyperHUD now determines the last known
//	  client for use with the team player count HUD.
//
//	- 1.7, April 24, 1999
//	  Changed flag status HUDs so now they are more compact when a flag is not being carried
//	  by a player.
//
//	  Also, when YOU are in possession of the enemy flag, the text will blink on and off to
//	  show that you have it.  This comes in handy during a battle and you unknowingly pick
//	  up the enemy flag from a teammate who was just killed.  In the heat of battle, I
//	  sometimes forget to check the HUDs. :)
//
//	- 1.6a, April 22, 1999
//	  Fixed bug where HyperHUD would advance (simulate hitting Control-H) everytime you
//	  would connect/reconnect to a server without actually quitting TRIBES and restarting
//	  each time.  This basically deals with the use of the built-in server locater.  I
//	  use GameSpy, so I didn't notice this problem. :(  Thanks Razor!
//
//	- 1.6, April 16, 1999
//	  Added user preference to start HyperHUD in the General Gameplay screen (no flag status
//	  HUDs shown).  Hitting Control-H will toggle HyperHUD normally thereafter.
//
//	- 1.5, April 11, 1999
//	  Added another HUD to keep track of how many players are on each team.  Now you'll know
//	  when team balance is unfair. :)  Now that there are seven HUDs available at once, I
//	  have gone ahead and designed HyperHUD to put any HUDs after the sixth one on the next
//	  line.  This applies only when you have $Hyper::GenHUDLoc set to "top", "topchat" or
//	  "bottom".  Also introduced a new related preference $Hyper::MaxPlayers.  This refers
//	  to the server's maximum number of players allowed.  HyperHUD's default is 32, but if
//	  you play on servers that allow more than 32 players, you will need to change this
//	  accordingly.  Otherwise, the player count HUD won't function correctly.  Don't forget
//	  you are assigned to a team in "Observer" mode, even though the score menu (TAB) will
//	  leave your team name blank.  NOTE: 512x384 users are still limited to four HUDs in the
//	  "top", "topchat" or "bottom" areas.  Will try and fix this restriction in the future.
//
//	  Also added an auto-start option in HyperHUD Preferences.  This lets HyperHUD activate
//	  automatically upon a server connection, instead of you having to hit Control-H for the
//	  first time.  I should have done this a long time ago.
//
//	  Fixed CTF HUD bug when player switched teams, the flag status would not switch also.
//
//	- 1.4, April 3, 1999
//	  Multiple HUD placements available now in the HyperHUD Preferences.  Flag status HUDs
//	  can be placed on the left, right, top and bottom of the screen.  You can also place
//	  them beneath the chat window.  The same goes for the general HUDs.  You cannot have
//	  conflicts though.  Don't place the flag status HUDs and general HUDs in the same
//	  place.  The only exception to this is placing them both on the bottom of the screen.
//	  Flag status HUDs are put in opposite corners and the general HUDs would be between
//	  them.
//
//	  NOTE: For 512x384 users, you can only have up to four general HUDs showing if you want
//	        them in the "top" position, "topchat" position or in the "bottom" position with
//	        the flag status HUDs in the "bottom" position also.
//
//	  Also fixed a bug when you switched teams during gameplay, general HUDs would not be
//	  updated properly.
//
//	- 1.3a, March 29, 1999
//	  Double DOH!  Mines, grenades, repair/beacon HUDs do not reset upon mission change.
//	  Fixed that.  Resets about a second after you get the "Match started." message.
//
//	- 1.3, March 29, 1999
//	  DOH!  Added back in the preference to display the victim and weapon used upon a
//	  verified kill by you.  Also added the preference to display the killer and weapon he
//	  used to kill you.  Both messages are displayed at the bottom center of your screen for
//	  about four seconds, upon a kill or death.
//
//	  Hoorah!!!  Mines, grenades and repair kit/beacon HUDs are no longer updated every two
//	  seconds.  Updates now occur only when a station is accessed for supplies, an item is
//	  thrown (grenade, etc.), an item is used (repair kit, etc.), after you have died or if
//	  you pick something up.
//
//	  Shazbot!  Two problems with the new update system though:
//		1) When accessing an AMMO station, you must wait until "Resupply Complete".
//		2) When you die, you must respawn within 30 seconds.  If you wait any longer,
//		   the HUDs will not be reset properly and you'll still see how many mines,
//		   grenades, etc. you had before death.
//
//	- 1.2, March 28, 1999
//	  Reworked attached events.  Events concerning HUDs are now only active when the HUD is
//	  displayed.  This applies to the flag capture, kills and deaths HUDs.  Tried to improve
//	  on reported slowdown of computer during gameplay.
//
//	  Added option in HyperHUD Preferences above to modify how far from the top of the
//	  screen you want the HUDs to appear.
//
//	- 1.1, March 27, 1999
//	  Added a flag capture HUD for counting how many times you have captured the enemy flag.
//
//	- 1.0, March 27, 1999
//	  First public release.
// ===============================================================================================
//  Requirements:
//	- Presto's ScriptPak V0.93 or higher.
//	  (http://www.planetstarsiege.com/presto/)
//	- "autoexec.cs" in your "Tribes\config" directory.  If you don't have this file, just
//	  copy the one supplied with Presto's ScriptPak.
//	- A screen width of at least 512 works best.  Anything smaller isn't worthwhile.
// ===============================================================================================
//  Installation:
//	- After installing Presto's ScriptPak, you should have in your
//	  "Tribes\config\autoexec.cs" file the following, if you don't already have it:
//
//		exec("Presto\\install.cs");
//
//	- If you followed the installation instructions from Presto, then add this next:
//
//		exec("HyperHUD.cs");
//
//	- HyperHUD's default control is currently set to "Control-H".  You can change this at
//	  the top of the script under "HyperHUD Control".
//
//	- At the beginning of this script is the "HyperHUD Preferences" section.  Make sure you
//	  read that.  This is where the user can determine what HUDs to display.
//
//	- If you're not using Presto's DynHUD, edit "Tribes\config\Presto\PrestoPrefs.cs" and
//	  change the line:
//
//	  $PrestoPref::DynHud = "control h";
//
//	  to
//
//	  $PrestoPref::DynHud = false;
// ===============================================================================================
//  Bugs:
//	- After you've installed everything correctly and have run TRIBES, HyperHUD may not
//	  activate when you press "Control-H".
//
//	  Solution:
//		- Edit your "Tribes\config\config.cs" file and make sure that there are only
//		  two references to the "Control-H" bind.  The first line is the "make" bind
//		  referring to "Hyper::Toggle();".  The second line will be the "break" bind
//		  referring to "".  If you see any other lines with something like
//		  "control, "h"", then delete them.
//
//	- Player names will wrap in the flag status HUDs if they are very long. This has to do
//	  with Presto's ScriptPak, but I really don't think it's that bad.  I've left three
//	  lines for a player's name, in case there are some out there who insist on long names
//	  with meaningless symbols in them. :)
//
//	- For more help, check out:
//
//	  http://www.zianet.com/mjaecks/hyperhud/help.html
// ===============================================================================================
//  Future:
//	- Add team score tracking perhaps.
//	- Clean up the code some.
// ===============================================================================================
//  Thanks to:
//	- Presto: Without his ScriptPak, life would be a little bit harder. :)
//	- KillerBunny: For starting a revolution with the release of the original DynHUD.
//	- Starsiege Team: Great game!  Can't wait to get Starsiege.
//	- Scripters: Keep up the good work.
// ===============================================================================================
//  Contact:
//	- Comments and suggestions are welcome.
//	- Permission is granted to use parts of my HyperHUD.cs script in helping you develop a
//	  cool HUD of your own. All I ask is for some mention/credit of my script name and/or
//	  nickname.  References to DynHUD, Presto and KillerBunny would be welcome too.
//	- Permission is granted to use my custom icons in your HUD development as long as some
//	  mention/credit of my script name and/or nickname is given.
//	- PLEASE do not contact me about any problems installing or using Presto's ScriptPak.
//	  Instead, take a stroll over to PlanetStarsiege and check out their Scripting Forum.
//	  Presto is very good at replying to messages there.
//	  (http://www.planetstarsiege.com/)
//	- PLEASE do not ask me to add any third party scripts to my HUD. By this I mean scripts
//	  that execute messages, like a "I'm repairing ..." when you're repairing a generator or
//	  something.  Also, a script that makes you super jump or such. These scripts can be
//	  executed from your Tribes\config\autoexec.cs file. They can function perfectly as a
//	  separate entity most of the time.
//
//  DarkNinja
//  mjaecks@zianet.com
// ===============================================================================================

// Presto ScriptPak functions needed.
Include("presto\\Event.cs");
Include("presto\\HUD.cs");
Include("presto\\TeamTrak.cs");
Include("presto\\KillTrak.cs");

// ===============================================================================================
//  Function: UpdateHomeHUD
//
//  Purpose: Update our team's flag status.
//
//	Flag status updates:
//
//	- Green flag indicates our team's flag is safe at home.
//	- Grey flag with a eagle (bird) symbol indicates that the flag is currently being
//	  carried by an enemy player.  If so, a message will appear next to the flag symbol
//	  informing you who currently holds the flag.
//	- A flag with a question mark can indicate two possibilities:
//
//	  1) When you CONNECT for the first time to a server, the flag status will be unknown.
//	     Therefore, we will initially start with the ? flag.
//	  2) After a capture, the flag status will be correct.  From this point, a ? flag will
//	     indicate that the team's flag has been dropped in the field.  This is usually due
//	     to the carrier's death.
// ===============================================================================================
function Hyper::UpdateHomeHUD()
{
	%teamFlag = Team::GetFlagLocation(Team::Friendly());	// Status of our flag.

	if (%teamFlag == $Trak::locationHome)
      {
		HUD::AddText(hudCTFHomeSmall, "<B4,2:flag_atbase.bmp>");		// Our flag is safe at home.
            $SixVar::EC = "";   //ADDED LINE FOR AUTO TARGET FLAG NOTIFY TAUNT ENEMY
      } 
	else if (%teamFlag == $Trak::locationField)
      {
		HUD::AddText(hudCTFHomeSmall, "<B4,2:flag_notatbase.bmp>");	// Our flag was dropped in the field.
            $SixVar::EC = "";   //ADDED LINE FOR AUTO TARGET FLAG NOTIFY TAUNT ENEMY
      }
	else if (%teamFlag == "")
      { 
		HUD::AddText(hudCTFHomeSmall, "<B4,2:flag_notatbase.bmp>");	// Upon first-time connection, our flag status is unknown.
            $SixVar::EC = "";   //ADDED LINE FOR AUTO TARGET FLAG NOTIFY TAUNT ENEMY
      }      
      else
      {
		HUD::AddText(hudCTFHome, "<B4,2:flag_neutral.bmp><f1>ATTACK:\n<f2>" @ %teamFlag @ "\n\n\n");	// Enemy has our flag!
            $SixVar::EC = %teamflag;   //ADDED LINE FOR AUTO TARGET FLAG NOTIFY TAUNT ENEMY
      }  
	return 0;
}

// ===============================================================================================
//  Function: UpdateEnemyHUD
//
//  Purpose: Update enemy team's flag status.
//
//	Flag status updates:
//
//	- Red flag indicates enemy team's flag is safe at home.
//	- Grey flag with a eagle (bird) symbol indicates that the flag is currently being
//	  carried by a teammate.  If so, a message will appear next to the flag symbol informing
//	  you who currently holds the flag.  If you are carrying the flag, the text will blink
//	  in the HUD to notify you.
//	- A flag with a question mark can indicate two possibilities:
//
//	  1) When you CONNECT for the first time to a server, the flag status will be unknown.
//	     Therefore, we will initially start with the ? flag.
//	  2) After a capture, the flag status will be correct.  From this point, a ? flag will
//	     indicate that the team's flag has been dropped in the field.  This is usually due
//	     to the carrier's death.
// ===============================================================================================
function Hyper::UpdateEnemyHUD()
{
	%enemyFlag = Team::GetFlagLocation(Team::Enemy());	// Status of the enemy's flag.

	if (%enemyFlag == $Trak::locationHome)
      {
		HUD::AddText(hudCTFEnemySmall, "<B4,2:flag_enemycaptured.bmp>");	// Enemy flag is safe at home.
            $SixVar::FC = "";   //ADDED LINE FOR AUTO TARGET FLAG NOTIFY
      } 
	else if (%enemyFlag == $Trak::locationField)
      {
		HUD::AddText(hudCTFEnemySmall, "<B4,2:flag_notatbase.bmp>");	// Enemy flag was dropped in the field.
            $SixVar::FC = "";   //ADDED LINE FOR AUTO TARGET FLAG NOTIFY
      } 
	else if (%enemyFlag == "")
      {
		HUD::AddText(hudCTFEnemySmall, "<B4,2:flag_notatbase.bmp>");	// Upon first-time connection, enemy flag status is unknown.
            $SixVar::FC = "";   //ADDED LINE FOR AUTO TARGET FLAG NOTIFY
      }
	else if (%enemyFlag == client::getname(getManagerId()))
	{
		if ($Hyper::BlinkToggle == 0)
		{
			HUD::AddText(hudCTFEnemy, "<B4,2:flag_neutral.bmp><f2>YOU <f1>have\nthe enemy\nflag!");	// YOU are carrying the enemy flag.
			$Hyper::BlinkToggle++;
	            $SixVar::FC = "";   //ADDED LINE FOR AUTO TARGET FLAG NOTIFY

	      }
		else
		{
			HUD::AddText(hudCTFEnemy, "<B4,2:flag_neutral.bmp>");	// Blink the text off in the HUD.
			$Hyper::BlinkToggle = 0;
		}

		return 1;	// If you are carrying the flag, schedule an update in one second so we can blink the text.
	}
	else
      {
		HUD::AddText(hudCTFEnemy, "<B4,2:flag_neutral.bmp><f1>ESCORT:\n<f2>" @ %enemyFlag);	// A teammate has the enemy flag.
            $SixVar::FC = %enemyflag;   //ADDED LINE FOR AUTO TARGET FLAG NOTIFY
      }     
	return 0;
}

// ===============================================================================================
//  Function: UpdateCapsHUD
//
//  Purpose: Update how many times your team, the enemy team and you personally have captured the
//	   flag.  The HUD will have a small TRIBES-like flag with a "C" in it.  There are two
//	   different displays available, depending on which HUD screen you have chosen by
//	   hitting "Control-H".
//
//	   CTF HUD screen - Your team's flag capture total will be displayed to the left of the
//	   icon and the enemy flag capture total will be on the right of the icon.  If your team
//	   has no captures yet, then the icon will be left justified.  If there are no enemy
//	   captures yet, the right will be left blank.  Upon a flag capture by YOU, the HUD will
//	   blink (alternate) between the normal display and a display just showing how many
//	   times you have captured the enemy flag personally so far.
//
//	   Multiple Team HUD screen - Your personal flag capture count will be displayed on the
//	   left side of the icon and your team's total flag capture amount is on the right side.
//	   If you have no personal captures, the icon will be left justified.  If your team has
//	   no captures, it will be left blank to the right of the icon.
//
//	   NOTE: The flag capture HUD display will be turned off automatically if you choose the
//	   General Gameplay HUD screen.  If you're not going to show the flag status, no sense
//	   in showing your captures. :)
// ===============================================================================================
function Hyper::UpdateCapsHUD()
{
	%myteam = Client::getTeam(getManagerId());	// Get which team I'm on.
	%mycaps = $Hyper::YourCaps[%myteam];		// Get how many captures I have so far.
	%teamcaps = $Hyper::Caps[%myteam];		// Get how many captures my team has.
	%enemycaps = $Hyper::Caps[1 - %myteam];		// Get how many captures the enemy team has.

	if ($Hyper::YouCapped)	// If you captured the flag, then let's blink the flag capture HUD.
	{
		if ($Hyper::CapBlinkCnt++ > 11)
		{
			$Hyper::CapBlinkCnt = 0;
			$Hyper::CapBlink = 0;
			$Hyper::YouCapped = false;
		}

		if ($Hyper::CapBlink == 1)	// Show your capture count every other second.
		{
			if (%mycaps < 10)
				HUD::AddText(hudCaps, " ");

			HUD::AddText(hudCaps, "   <f1>" @ %mycaps);	// If we have some captures, let's show them.
			$Hyper::CapBlink = 0;
			return 1;
		}
	}

	if ($Hyper::Mode == "CTF")
	{
		if (%teamcaps > 0)
		{
			if (%teamcaps < 10)
			{
				HUD::AddText(hudCaps, " ");	// Put the amount over one space if less than 10 for a nicer appearance.

				if (%enemycaps == 0)
					HUD::AddText(hudCaps, " ");	// Put the amount over one space for a nicer appearance.
			}

			HUD::AddText(hudCaps, "<f2>" @ %teamcaps);	// If we have some team captures, let's show them.
		}
		else if (%enemycaps > 0)
		{
			HUD::AddText(hudCaps, " ");

			if (%enemycaps < 10)
				HUD::AddText(hudCaps, " ");
		}
	}
	else
	{
		if (%mycaps > 0)
		{
			if ((%mycaps < 10) && (%teamcaps < 10))
				HUD::AddText(hudCaps, " ");	// Put the amount over one space if less than 10 for a nicer appearance.

			HUD::AddText(hudCaps, "<f1>" @ %mycaps);	// If we have some captures, let's show them.
		}
	}

	if ((($Hyper::Mode == "CTF") && ((%teamcaps > 0) || (%enemycaps > 0))) ||
	    (($Hyper::Mode == "MT") && ((%mycaps >0) || (%teamcaps > 0))))
		HUD::AddText(hudCaps, "<B4,2:HyperHUD_cap.bmp>");		// Show our flag capture icon.
	else
		HUD::AddText(hudCaps, "<B17,2:HyperHUD_cap.bmp>");

	if ($Hyper::Mode == "CTF")
	{
		if (%enemycaps > 0)
			HUD::AddText(hudCaps, "<f0>" @ %enemycaps);	// If the enemy has some captures, let's show them.
	}
	else if (%teamcaps > 0)
			HUD::AddText(hudCaps, "<f2>" @ %teamcaps);	// If we have some team captures, let's show them.

	if ($Hyper::YouCapped)	// Set our blink toggle for our next call to this function.
	{
		$Hyper::CapBlink = 1;
		return 1;
	}
	else
		return 0;
}

// ===============================================================================================
//  Function: UpdateKillsHUD
//
//  Purpose: Update our verified kills.  This HUD will show a SKULL & CROSSBONES icon.  To the
//	   right will be shown the amount of kills you have so far.  If you don't have any, then
//	   the number will be left blank.
// ===============================================================================================
function Hyper::UpdateKillsHUD()
{
	HUD::AddText(hudKills, "<B4,2:HyperHUD_kills.bmp><f2>");	// Show our Kills icon.

	if ($Hyper::Kills > 0)
	{
		if ($Hyper::Kills < 10)
			HUD::AddText(hudKills, " ");	// Put the amount over one space if less than 10 for a nicer appearance.

		HUD::AddText(hudKills, $Hyper::Kills);	// If we have some kills, let's show them.
	}

	return 0;
}

// ===============================================================================================
//  Function: UpdateDeathsHUD
//
//  Purpose: Update how many times we have been killed. :(  This HUD will have a CROSS icon along
//	   with how many times you have been killed.  If there are no deaths, then the number
//	   will be left blank.
// ===============================================================================================
function Hyper::UpdateDeathsHUD()
{
	HUD::AddText(hudDeaths, "<B4,2:HyperHUD_deaths.bmp><f2>");	// Show our Deaths icon.

	if ($Hyper::Deaths > 0)
	{
		if ($Hyper::Deaths < 10)
			HUD::AddText(hudDeaths, " ");		// Put the amount over one space if less than 10 for a nicer appearance.

		HUD::AddText(hudDeaths, $Hyper::Deaths);	// If we have some deaths, let's show them.
	}

	return 0;
}

// ===============================================================================================
//  Function: UpdateMinesHUD
//
//  Purpose: Update how many mines we have.  This HUD will have a MINE icon along with how many
//	   mines we have.  If there are no mines, then the number will be left blank.
// ===============================================================================================
function Hyper::UpdateMinesHUD()
{
	HUD::AddText(hudMines, "<B4,2:HyperHUD_mine.bmp><f2>");	// Show our Mine icon.

	%mines = getItemCount("Mine");

	if (%mines > 0)
	{
		if (%mines < 10)
			HUD::AddText(hudMines, " ");	// Put the amount over one space if less than 10 for a nicer appearance.

		HUD::AddText(hudMines, %mines);	// If we have some mines, show them.
	}

	return 0;
}

// ===============================================================================================
//  Function: UpdateGrenadesHUD
//
//  Purpose: Update how many grenades we have.  This HUD will have a GRENADE icon along with how
//	   many grenades we have.  If there are no mines, then the number will be left blank.
// ===============================================================================================
function Hyper::UpdateGrenadesHUD()
{
	HUD::AddText(hudGrenades, "<B4,2:HyperHUD_grenade.bmp><f2>");	// Show our Grenade icon.

	%grenades = getItemCount("Grenade");

	if (%grenades > 0)
	{
		if (%grenades < 10)
			HUD::AddText(hudGrenades, " ");	// Put the amount over one space if less than 10 for a nicer appearance.

		HUD::AddText(hudGrenades, %grenades);		// If we have some grenades, show them.
	}

	return 0;
}

// ===============================================================================================
//  Function: UpdateRepairHUD
//
//  Purpose: Update inventory of a repair kit and beacons.  This HUD will show a REPAIR icon if
//	   you currently have a repair kit.  A BEACON icon will be shown if you have a beacon.
//	   If you do not have the item, then the HUD will be blank.
// ===============================================================================================
function Hyper::UpdateRepairHUD()
{
	if (getItemCount("Repair Kit") > 0)
	{
		if (getItemCount("Beacon") > 0)
			HUD::AddText(hudRepair, "<B1,2:HyperHUD_repair.bmp><B0,2:HyperHUD_beacon.bmp>");
		else
			HUD::AddText(hudRepair, "<B14,2:HyperHUD_repair.bmp>");
	}
	else if (getItemCount("Beacon") > 0)
		HUD::AddText(hudRepair, "<B14,2:HyperHUD_beacon.bmp>");

	return 0;
}

// DO NOT MODIFY THESE THREE LINES!!!
// They are used in the UpdatePlayersHUD function below for team unbalance notification.
$Hyper::ComSay[0] = "color2";	// Yell Shazbot!
$Hyper::ComSay[1] = "color6";	// Yell Dammit!
$Hyper::ComSay[2] = "color7";	// Yell Ahhh crap!

// ===============================================================================================
//  Function: UpdatePlayersHUD
//
//  Purpose: Check how many players are on each team.  In the center of the HUD, you will see an
//	   icon with a green arrow on the left and a red arrow on the right.  The number of
//	   players on your team will appear on the left (green arrow pointing to your team) and
//	   the enemy player count will appear on the right (red arrow pointing to enemy team).
//	   If there are no players on a team, then it will be left blank.  Also added a team
//	   unbalance notification routine.  Everyone will be sent the phrase "Teams are
//	   unbalanced!!!" when a team is outnumbered along with a random colorful verbal remark.
// ===============================================================================================
function Hyper::UpdatePlayersHUD()
{
	%teamplayers = 0;	// Set our team count to zero.
	%enemyplayers = 0;	// Set the enemy team count to zero.

	%clientteam = Client::getTeam(getManagerId());	// Find out which team you are on.

	for (%i = $Hyper::LastClient; %i > 2048; %i--)	// Check all valid players up to the last known client.
	{
		%team = Client::getTeam(%i);		// Find out which team this player is on.

		if (Client::getName(%i) != "")	// Is it a valid player?
			if (%team == %clientteam)	// If so, check to see if it's a teammate.
				%teamplayers++;	// Increment our team player count.
			else if (%team > -1)
				%enemyplayers++;	// Otherwise, this is an enemy player.  Increment the enemy player count.
	}

	if ((%teamplayers < 10) || ((%teamplayers < 20) && (%enemyplayers < 20)))	// Alphanumeric characters are not fixed-width.  So let's add a
	{
		HUD::AddText(hudPlayers, " ");				// space if the number is small to try and center the display.

		if (%enemyplayers == 0)
			HUD::AddText(hudPlayers, " ");
	}

	HUD::AddText(hudPlayers, "<f2>" @ %teamplayers @ "<BHyperHUD_players.bmp>");	// Display our team count and the icon in the HUD.

	if (%enemyplayers > 0)
		HUD::AddText(hudPlayers, %enemyplayers);	// Display the enemy count.  If none, then leave it blank.

	if ($Hyper::BalanceNotify)	// Do you want to notify everyone when there is team unbalance?
	{
		%balance = %teamplayers - %enemyplayers;	// Determine by how many players teams are unbalanced.

		if (%balance != 0)
		{
			if (%balance < 0)
				%balance = -(%balance);	// If it is a negative number, let's make it positive.

			if ((%balance >= $Hyper::Outnumber) && ($Hyper::BalanceToggle == 0) &&
			    ($Hyper::LastMsg != "Teams are unbalanced!!!") &&
			    ($Hyper::Next2LastMsg != "Teams are unbalanced!!!"))
			{
				remoteEval(2048, say, 0, "Teams are unbalanced!!!~w" @ $Hyper::ComSay[floor(getRandom() * 3)]);	// Tell everyone about team unbalance and yell a random remark.
				$Hyper::BalanceToggle = 1;	// Toggle our team balance variable so we don't say this repeatedly.
			}
			else if (%balance < 3)
				$Hyper::BalanceToggle = 0;	// If team unbalance drops below three, then reset our variable, so we can say it the next time there is team unbalance.
		}
	}

	return 0;
}

// ===============================================================================================
//  Function: UpdateObjectiveHUD
//
//  Purpose: Display how many objectives our team currently holds.  A small checkmark is used in
//	   the icon to represent objectives.  The current amount of objectives held will be
//	   displayed to the right of the icon.  If there are no objectives, then this amount
//	   will be left blank.  NOTE:  If you join a game currently in progress, the displayed
//	   objective amount may be incorrect.  Also, if you switch teams, the objective count
//	   is reset to zero.
// ===============================================================================================
function Hyper::UpdateObjectiveHUD()
{
	HUD::AddText(hudObjective, "<B4,2:HyperHUD_objective.bmp><f2>");	// Show our Objective icon.

	if ($Hyper::TeamObjectives > 0)
	{
		if ($Hyper::TeamObjectives < 10)
			HUD::AddText(hudObjective, " ");		// Put the amount over one space if less than 10 for a nicer appearance.

		HUD::AddText(hudObjective, $Hyper::TeamObjectives);	// If our team holds some objectives, show them.
	}

	return 0;
}

// ===============================================================================================
//  Function: UpdateTimeHUD
//
//  Purpose: Update how long you have been playing online so far for this session.  
// ===============================================================================================
function Hyper::UpdateTimeHUD()
{
	HUD::AddText(hudPlayTime, "<f2>  ");

	if ($Hyper::TimeHour > 0)
	{
		if ($Hyper::TimeHour < 10)
			HUD::AddText(hudPlayTime, " ");

		HUD::AddText(hudPlayTime, $Hyper::TimeHour);
	}
	else
		HUD::AddText(hudPlayTime, " ");

	HUD::AddText(hudPlayTime, ":");

	if ($Hyper::TimeMin < 10)
		HUD::AddText(hudPlayTime, "0");

	HUD::AddText(hudPlayTime, $Hyper::TimeMin);

	return 0;
}

// ===============================================================================================
//  Function: UpdateItemHUDs
//
//  Purpose: Here we update our mines, grenades and repair kit/beacon HUDs when certain events
//	   have occurred, such as throwing of an item or the use of an item.
// ===============================================================================================
function Hyper::UpdateItemHUDs()
{
	if ($Hyper::ItemToggle == 0)
	{
		schedule("Hyper::UpdateItemHUDs();", 1);	// Update our HUDs in one second if an event has
		$Hyper::ItemToggle++;			// occurred.  This allows time for the inventory
		return;					// count to catch up after event has ended.
	}

	if (Hyper::CheckGenHUDs("ShowMines"))
		HUD::Update(hudMines);	// Update our mines HUD.
	if (Hyper::CheckGenHUDs("ShowGrenades"))
		HUD::Update(hudGrenades);	// Update our grenades HUD.
	if (Hyper::CheckGenHUDs("ShowRepair"))
		HUD::Update(hudRepair);	// Update our repair kit/beacon HUD.

	$Hyper::ItemToggle = 0;		// Reset our timer toggle.
}

// ===============================================================================================
//  Function: UpdateCTF
//
//  Purpose: Update our flag status HUDs from this one function instead of having to monitor two
//	   separate flag events, one for our flag and one for the enemy's.
// ===============================================================================================
function Hyper::UpdateCTF()
{
	if (($Hyper::Mode == "Gen") || ($Hyper::Mode == "") || ($Hyper::GenStart))
		return;

	%teamFlag = Team::GetFlagLocation(Team::Friendly());	// Status of our flag.

	if ((%teamFlag == $Trak::locationHome) || (%teamFlag == $Trak::locationField) ||
	    (%teamFlag == ""))
	{
		HUD::Display(hudCTFHome, false);
		HUD::Display(hudCTFHomeSmall);
		HUD::Update(hudCTFHomeSmall);	// Upon a flag event, update our team's flag HUD.
	}
	else
	{
		HUD::Display(hudCTFHomeSmall, false);
		HUD::Display(hudCTFHome);
		HUD::Update(hudCTFHome);	// Upon a flag event, update our team's flag HUD.
	}

	if ($Hyper::Mode != "CTF")
		return;

	%enemyFlag = Team::GetFlagLocation(Team::Enemy());	// Status of the enemy's flag.

	if ((%enemyFlag == $Trak::locationHome) || (%enemyFlag == $Trak::locationField) ||
	    (%enemyFlag == ""))
	{
		HUD::Display(hudCTFEnemy, false);
		HUD::Display(hudCTFEnemySmall);
		HUD::Update(hudCTFEnemySmall);	// Upon a flag event, update our team's flag HUD.
	}
	else
	{
		HUD::Display(hudCTFEnemySmall, false);
		HUD::Display(hudCTFEnemy);
		HUD::Update(hudCTFEnemy);	// Upon a flag event, update our team's flag HUD.
	}
}

//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------

Presto::AddScriptBanner(SixPak, "\n<f2><jc>SixPak\n\n<f0><jc>(Version 2.7 07/03/99)\n\n<f1><jc>By Vacas_SixStringz\n\n<f0><jc>mccleans@inreach.com");

//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------

// ===============================================================================================
//  Function: UpdatePlayers
//
//  Purpose: Update our team player count HUD using a short delay.
// ===============================================================================================
function Hyper::UpdatePlayers()
{
	if ($Hyper::PlayerToggle == 0)
	{
		schedule("Hyper::UpdatePlayers();", 1);		// Update our player HUD in one second if someone has
		$Hyper::PlayerToggle++;			// joined or dropped.  This allows time for the player
		return;					// count to catch up after event has ended.
	}

	HUD::Update(hudPlayers);	// Update the HUD.

	$Hyper::PlayerToggle = 0;	// Reset our timer toggle.
}

// ===============================================================================================
//  Function: SortObjective
//
//  Purpose: Determine which team has taken an objective and update our objectives HUD.
// ===============================================================================================
function Hyper::SortObjective(%msg)
{
	if (%msg == "Your team has taken an objective.")
		$Hyper::TeamObjectives++;
	else if ($Hyper::TeamObjectives > 0)
		$Hyper::TeamObjectives--;

	HUD::Update(hudObjective);
}

// ===============================================================================================
//  Function: UpdateMinutes
//
//  Purpose: Increment our minutes counter every 60 seconds, then update our play time HUD.
// ===============================================================================================
function Hyper::UpdateMinutes()
{
	schedule("Hyper::UpdateMinutes();", 60);	// Call back in a minute.

	$Hyper::TimeMin++;				// Increment our minutes counter.

	if ($Hyper::TimeMin > 59)			// Are our minutes over an hour?
	{
		$Hyper::TimeMin = 0;		// If so, reset our minutes and
		$Hyper::TimeHour++;			// increment our hour counter.
	}

	HUD::Update(hudPlayTime);			// Update our play time HUD.

}

// ===============================================================================================
//  Function: MakeNewHUDs
//
//  Purpose: This is where we initially create our various HUDs.  This function is only called
//	   once during a server connection.  Depending on your selected preferences, the flag
//	   status HUDs and general HUDs will be created.
// ===============================================================================================
function Hyper::MakeNewHUDs()
{
	%FlagXPos = 1;			// By default, flag status HUDs are placed on the left side of the screen.
	%FlagYPos = $Hyper::FlagYPos;		// Initialize how far down we want them displayed from the top of the screen.
	%FlagXGap = 0;			// Since, by default, the flag status HUDs are placed vertically, our X dimension gap is set to zero.
	%FlagYGap = 56;			// Set our Y dimension gap to this value.  This is how far down the enemy flag status HUD will be displayed.
	%SmallHomeGap = 0;
	%SmallEnemyGap = 0;
	%GenXPos = $Hyper::ScreenWidth - 61;	// By default, our general HUDs are placed on the right side of the screen.
	%GenYPos = $Hyper::GenYPos;		// Initialize our general HUD position from top of screen.
	%HUDWidthGap = 0;			// Since, by default, the general HUDs are placed vertically, our X dimension gap is set to zero.
	%HUDHeightGap = 20;			// Set our general HUD gap.  This is how many pixels down the next HUD will be displayed.

	if (($Hyper::FlagHUDLoc == "left") && (($Hyper::GenHUDLoc == "left") && ($Hyper::NumGenHUDs > 0)))
	{
		%FlagXPos += 59;	// Put them to the right of the general HUDs.
	}
	else if ($Hyper::FlagHUDLoc == "right")	// Our flag status HUDs are on the right side of the screen.
	{
		%FlagXPos = $Hyper::ScreenWidth - 126;	// Put them near the right.
		%SmallHomeGap = 69;
		%SmallEnemyGap = 69;

		if (($Hyper::GenHUDLoc == "right") && ($Hyper::NumGenHUDs > 0))
			%FlagXPos -= 59;		// Put them just inside the general HUDs.
	}
	else if ($Hyper::FlagHUDLoc == "topchat")	// Our flag HUDs are centered under the chat window.
	{
		%FlagXPos = ($Hyper::ScreenWidth - 250) / 2;	// Center the HUDs.
		%FlagXGap = 125;				// Set our enemy flag status HUD to be displayed over this many pixels.
		%FlagYGap = 0;				// The enemy flag status HUD will be shown horizonatally on the same line as our team's HUD.
		%SmallHomeGap = 69;

		if (($Hyper::GenHUDLoc == "top") && ($Hyper::NumGenHUDs > 0))	// If our general HUDs are at the top of the screen,
		{
			%FlagYPos = 22;

			%i += $Hyper::HUDsPerLine;

			while (%i < $Hyper::NumGenHUDs)
			{
				%FlagYPos += %HUDHeightGap;
				%i += $Hyper::HUDsPerLine;
			}

		}
		else
			%FlagYPos -= 15;			// Try to create them right below the chat window.
	}
	else if ($Hyper::FlagHUDLoc == "top")	// Our flag HUDs are at the top center of the screen.
	{
		%FlagXPos = ($Hyper::ScreenWidth - 250) / 2;	// Center the HUDs.
		%FlagYPos = 1;				// Flag status HUDs start at the top of the screen.
		%FlagXGap = 125;				// Set our enemy flag status HUD to be displayed over this many pixels.
		%FlagYGap = 0;				// The enemy flag status HUD will be shown horizonatally on the same line as our team's HUD.
		%SmallHomeGap = 69;
	}
	else if ($Hyper::FlagHUDLoc == "bottom")	// Our flag HUDs are at the bottom corners of the screen.
	{
		%FlagYPos = $Hyper::ScreenHeight - 58;	// Both flag status HUDs will be shown at bottom of screen.
		%FlagXGap = $Hyper::ScreenWidth - 127;	// The enemy's HUD will be shown in the bottom right.
		%FlagYGap = 0;			// The enemy flag status HUD will be shown horizonatally on the same line as our team's HUD.
		%SmallEnemyGap = 69;
	}

	HUD::New(hudCTFHome, Hyper::UpdateHomeHUD, %FlagXPos, %FlagYPos, 125, 57);						// Our flag HUD.
	HUD::New(hudCTFEnemy, Hyper::UpdateEnemyHUD, %FlagXPos + %FlagXGap, %FlagYPos + %FlagYGap, 125, 57);		// Enemy flag HUD.
	HUD::New(hudCTFHomeSmall, Hyper::UpdateHomeHUD, %FlagXPos + %SmallHomeGap, %FlagYPos, 56, 57);						// Our small flag HUD.
	HUD::New(hudCTFEnemySmall, Hyper::UpdateEnemyHUD, %FlagXPos + %FlagXGap + %SmallEnemyGap, %FlagYPos + %FlagYGap, 56, 57);	// Small enemy flag HUD.

	if ($Hyper::NumGenHUDs == 0)	// If we have no general HUDs, then let's exit this function.
		return;

	if (($Hyper::GenHUDLoc != "left") && ($Hyper::GenHUDLoc != "right"))
		%HUDWidthGap = 59;	// This is how far over horizontally our general HUDs will be spaced, due to centered display choice.

	if ($Hyper::GenHUDLoc == "topchat")		// Are our general HUDs to be displayed under the chat window?
		if ($Hyper::FlagHUDLoc == "top")	// If the flag status HUDs are at the top of the screen, then
			%GenYPos = 58;		// put our general HUDs right belown them.
		else
			%GenYPos -= 15;		// Set our HUDs below the chat window.
	else if ($Hyper::GenHUDLoc == "top")		// Are the HUDs to be displayed at the top of the screen?
		%GenYPos = 1;			// Set how many pixels down to start display.
	else if ($Hyper::GenHUDLoc == "bottom") 	// Are they to be displayed at the bottom of the screen?
	{
		%GenYPos = $Hyper::ScreenHeight - 22;	// Set how many pixels down to start display.

		%i = $Hyper::NumGenHUDs - $Hyper::HUDsPerLine;

		while (%i > 0)
		{
			%GenYPos -= %HUDHeightGap;
			%i -= $Hyper::HUDsPerLine;
		}
	}

	if ($Hyper::GenHUDLoc == "left")				// Are they to appear on the right side?
		%GenXPos = 1;					// Set them at the right side then.
	else if ($Hyper::GenHUDLoc != "right")				// Or are they to be centered?
		if ($Hyper::NumGenHUDs < $Hyper::HUDsPerLine)
			%GenXPos = ($Hyper::ScreenWidth - ($Hyper::NumGenHUDs * 60)) / 2;	// Calculate the center starting point.
		else
			%GenXPos = ($Hyper::ScreenWidth - ($Hyper::HUDsPerLine * 60)) / 2;

	%mulcnt = 1;
	$Hyper::ItemUse = false;

	for (%i = 0; %i < $Hyper::NumGenHUDs; %i++)
	{
		if ((%i == ($Hyper::HUDsPerLine * %mulcnt)) && ($Hyper::GenHUDLoc != "left") && ($Hyper::GenHUDLoc != "right"))
		{
			%GenYPos += %HUDHeightGap;
			%GenXPos = ($Hyper::ScreenWidth - ($Hyper::HUDsPerLine * 60)) / 2;
			%mulcnt++;
		}

		if ($Hyper::Gen[%i] == "ShowCaps")		// Show our flag capture HUD.
			HUD::New(hudCaps, Hyper::UpdateCapsHUD, %GenXPos, %GenYPos, 60, 21);	// Create our flag capture HUD.
		else if ($Hyper::Gen[%i] == "ShowKills")	// Show our kills HUD.
			HUD::New(hudKills, Hyper::UpdateKillsHUD, %GenXPos, %GenYPos, 60, 21);	// Create our kills HUD.
		else if ($Hyper::Gen[%i] == "ShowDeaths")	// Show our deaths HUD.
			HUD::New(hudDeaths, Hyper::UpdateDeathsHUD, %GenXPos, %GenYPos, 60, 21);	// Create our deaths HUD.
		else if ($Hyper::Gen[%i] == "ShowMines")	// Show our mines HUD.
		{
			HUD::New(hudMines, Hyper::UpdateMinesHUD, %GenXPos, %GenYPos, 60, 21);	// Create our mines HUD.
			$Hyper::ItemUse = true;
		}
		else if ($Hyper::Gen[%i] == "ShowGrenades")	// Show our grenades HUD.
		{
			HUD::New(hudGrenades, Hyper::UpdateGrenadesHUD, %GenXPos, %GenYPos, 60, 21);	// Create our grenades HUD.
			$Hyper::ItemUse = true;
		}
		else if ($Hyper::Gen[%i] == "ShowRepair")	// Show our repair kit/beacon HUD.
		{
			HUD::New(hudRepair, Hyper::UpdateRepairHUD, %GenXPos, %GenYPos, 60, 21);	// Create our repair kit/beacon HUD.
			$Hyper::ItemUse = true;
		}
		else if ($Hyper::Gen[%i] == "ShowPlayers")	// Show our player count HUD.
			HUD::New(hudPlayers, Hyper::UpdatePlayersHUD, %GenXPos, %GenYPos, 60, 21);	// Create our player count HUD.
		else if ($Hyper::Gen[%i] == "ShowObjective")	// Show our objective HUD.
			HUD::New(hudObjective, Hyper::UpdateObjectiveHUD, %GenXPos, %GenYPos, 60, 21);	// Create our objective HUD.
		else if ($Hyper::Gen[%i] == "ShowTime")		// Show our play time HUD.
			HUD::New(hudPlayTime, Hyper::UpdateTimeHUD, %GenXPos, %GenYPos, 60, 21);	// Create our play time HUD.

		if (($Hyper::GenHUDLoc == "left") || ($Hyper::GenHUDLoc == "right"))
			%GenYPos += %HUDHeightGap;	// Skip down for next HUD display.
		else
			%GenXPos += %HUDWidthGap;	// Skip over to the right for next HUD display.
	}
}

// ===============================================================================================
//  Function: Toggle
//
//  Purpose: Since we have designed three different HUD screens, we must offer the ability to
//	   switch between them.  As a default, Control-H is our toggle switch.  NOTE:  By HUD
//	   screens, I mean we work with TRIBES' default HUD display and add to that.  The three
//	   screens are:
//
//	   1) Our first HUD screen consists of the CTF flag status HUDs for each team.  These
//	      are located on the left, right, top or bottom of the screen, depending on your
//	      preferences.  Our general HUDs are located on one of the four sides of the screen
//	      also.
//
//	   2) The second HUD screen is basically just for Multiple Team CTF.  Your team's flag
//	      status HUD and the general HUDs are displayed.
//
//	   3) Our last HUD screen is for any other type of game (i.e. Defend & Destroy,
//	      Deathmatch, etc.).  This screen will only show your general HUDs.
// ===============================================================================================
function Hyper::Toggle()
{
	if ($Hyper::HUDTypeToggle == 0)	// Setup our HUDs.  Done on first call to HyperHUD only.
	{
		if ($Hyper::FlagHUDLoc == $Hyper::GenHUDLoc)	// A conflict occurred because you placed flag status HUDs and general HUDs in same place.
		{
			if (($Hyper::FlagHUDLoc == "top") || ($Hyper::FlagHUDLoc == "topchat"))
			{
				Client::centerPrint("<jc><f2>You cannot have your HUDs overlap!\nChange your HyperHUD Preferences.", 1); 
		    		schedule("Client::centerPrint(\"\", 1);", 10);
				return;
			}
		}

		$Hyper::NumGenHUDs = $Hyper::c + 1;	// How many General HUDs do we have?

		Hyper::MakeNewHUDs();		// Call our HUD creation function.

		$Hyper::HUDTypeToggle++;		// Point our toggle counter to the CTF HUD screen layout.
	}

	if ($Hyper::HUDTypeToggle == 1)	// Capture the Flag HUD screen.
	{
		$Hyper::Mode = "CTF";

		Hyper::UpdateCTF();
		Event::Attach(eventFlagsUpdated, Hyper::UpdateCTF, flagcheck);	// Update our flag Status HUDs upon a flag event.

		Event::Attach(eventClientMessage, Hyper::onClientMessage, msgcheck);	// Check if we have accessed a station for supplies, picked up an item
									// or server went through a mission change.
		%killdeathshown = false;
		%minegrenshown = false;

		for (%i = 0; %i < $Hyper::NumGenHUDs; %i++)
		{
			if (($Hyper::Gen[%i] == "ShowCaps") && ($Hyper::GenStart == false))
			{
				HUD::Display(hudCaps);		// Turn on our flag capture HUD if preferred.
				Event::Attach(eventFlagCaptured, Hyper::Capture, capflag);	// If a flag is captured, check to see if it was you.
			}
			else if (($Hyper::Gen[%i] == "ShowKills") || ($Hyper::Gen[%i] == "ShowDeaths"))
			{
				if ($Hyper::Gen[%i] == "ShowKills")
					HUD::Display(hudKills);	// Turn on our kills HUD if preferred.
				else
					HUD::Display(hudDeaths);	// Turn on our deaths HUD if preferred.

				if (%killdeathshown == false)
				{
					Event::Attach(eventKillTrak, Hyper::VerifiedKill, killcheck);	// Execute our VerifiedKill function upon a kill event.
					%killdeathshown = true;
				}
			}
			else if (($Hyper::Gen[%i] == "ShowMines") || ($Hyper::Gen[%i] == "ShowGrenades"))
			{
				if ($Hyper::Gen[%i] == "ShowMines")
					HUD::Display(hudMines);	// Turn on our mines HUD if preferred.
				else
					HUD::Display(hudGrenades);	// Turn on our grenades HUD if preferred.

				if (%minegrenshown == false)
				{
					Event::Attach(eventThrowRelease, Hyper::UpdateItemHUDs, throwcheck);	// Upon the throwing of an object (grenade, mine, etc.), update our
					%minegrenshown = true;
				}
			}
			else if ($Hyper::Gen[%i] == "ShowRepair")
			{
				HUD::Display(hudRepair);		// Turn on our repair kit/beacon HUD if preferred.
				Event::Attach(eventUse, Hyper::UpdateItemHUDs, usecheck);	// Upon the use of an item (repair kit, beacon, etc.), update our
				%repairshown = true;					// mines, grenades and repair kit/beacon HUDs.
			}
			else if ($Hyper::Gen[%i] == "ShowPlayers")
			{
				HUD::Display(hudPlayers);		// Turn on our player count HUD if preferred.
				Event::Attach(eventClientJoin, Hyper::onClientJoin, joincheck);			// Update the HUD upon a player joining a team.
				Event::Attach(eventClientDrop, Hyper::onClientDrop, dropcheck);			// Update the HUD upon a player leaving the game.
				Event::Attach(eventClientChangeTeam, Hyper::onClientChangeTeam, changecheck);	// Update the HUD upon a player switching teams.
			}
			else if ($Hyper::Gen[%i] == "ShowObjective")
				HUD::Display(hudObjective);		// Turn on our objectives HUD if preferred.
			else if ($Hyper::Gen[%i] == "ShowTime")
				HUD::Display(hudPlayTime);		// Turn on our play time HUD if preferred.
		}

		$Hyper::HUDTypeToggle++;	// Increment our toggle counter to point to Multiple Team CTF HUD next.
		if ($Hyper::GenStart)
			Hyper::Toggle();	// If user wants to start in General Gameplay HUD screen, advance our HyperHUD toggle.
	}
	else if ($Hyper::HUDTypeToggle == 2)	// Multiple Team CTF HUD screen.
	{
		$Hyper::Mode = "MT";
		HUD::Display(hudCTFEnemy, false);	// Turn off enemy flag HUD.
		HUD::Display(hudCTFEnemySmall, false);
		if (Hyper::CheckGenHUDs("ShowCaps"))
			HUD::Update(hudCaps);
		$Hyper::HUDTypeToggle++;		// Increment our toggle counter to point to the General Gameplay HUD.
		if ($Hyper::GenStart)
			Hyper::Toggle();	// If user wants to start in General Gameplay HUD screen, advance our HyperHUD toggle.
	}
	else if ($Hyper::HUDTypeToggle == 3)	// General Gameplay HUD screen.
	{
		$Hyper::Mode = "Gen";

		HUD::Display(hudCTFHome, false);	// Turn off our team's flag HUD.
		HUD::Display(hudCTFHomeSmall, false);

		Event::Detach(eventFlagsUpdated, flagcheck);	// Disable flag status HUD updates on a flag event.

		if (Hyper::CheckGenHUDs("ShowCaps"))
		{
			HUD::Display(hudCaps, false);			// Turn off our flag capture HUD.
			Event::Detach(eventFlagCaptured, capflag);	// Disable detection for the flag capture HUD.
		}

		$Hyper::HUDTypeToggle++;	// Increment our toggle counter to point to our last choice of no HUDs at all.
	}
	else	// No HUDs at all.
	{
		$Hyper::Mode = "";

		Event::Detach(eventClientMessage, msgcheck);	// Disable event check for station access, pickups and mission changes.

		%killdeathshown = false;
		%minegrenshown = false;

		for (%i = 0; %i < $Hyper::NumGenHUDs; %i++)
		{
			if (($Hyper::Gen[%i] == "ShowKills") || ($Hyper::Gen[%i] == "ShowDeaths"))
			{
				if ($Hyper::Gen[%i] == "ShowKills")
					HUD::Display(hudKills, false);	// Turn off our kills HUD.
				else
					HUD::Display(hudDeaths, false);	// Turn off our deaths HUD.

				if (%killdeathshown == false)
				{
					Event::Detach(eventKillTrak, killcheck);	// Disable our VerifiedKill function upon a kill event.
					%killdeathshown = true;
				}
			}
			else if (($Hyper::Gen[%i] == "ShowMines") || ($Hyper::Gen[%i] == "ShowGrenades"))
			{
				if ($Hyper::Gen[%i] == "ShowMines")
					HUD::Display(hudMines, false);	// Turn off our mines HUD.
				else
					HUD::Display(hudGrenades, false);	// Turn off our grenades HUD.

				if (%minegrenshown == false)
				{
					Event::Detach(eventThrowRelease, throwcheck);	// Disable checking of the throwing of an object.
					%minegrenshown = true;
				}
			}
			else if ($Hyper::Gen[%i] == "ShowRepair")
			{
				HUD::Display(hudRepair, false);	// Turn off our repair kit/beacon HUD.
				Event::Detach(eventUse, usecheck);	// Disable the USE event up an item's use.
				%repairshown = true;
			}
			else if ($Hyper::Gen[%i] == "ShowPlayers")
			{
				HUD::Display(hudPlayers, false);			// Turn off our player count HUD.
				Event::Detach(eventClientJoin, joincheck);		// Disable client joining event.
				Event::Detach(eventClientDrop, dropcheck);		// Disable client dropping event.
				Event::Detach(eventClientChangeTeam, changecheck);	// Disable client changin teams event.
			}
			else if ($Hyper::Gen[%i] == "ShowObjective")
				HUD::Display(hudObjective, false);		// Turn off our objectives HUD.
			else if ($Hyper::Gen[%i] == "ShowTime")
				HUD::Display(hudPlayTime, false);		// Turn off our play time HUD.
		}

		$Hyper::HUDTypeToggle = 1;	// Reset our toggle counter to point to the CTF HUD again.

		$Hyper::GenStart = false;	// Turn off our General Gameplay screen startup preference, so we can toggle HyperHUD normally again.
	}
}

// ===============================================================================================
//  Function: ResetHUDs
//
//  Purpose: Call our update functions for each HUD.
// ===============================================================================================
function Hyper::ResetHUDs()
{
	Hyper::UpdateCTF();		// Update
	HUD::Update(hudCaps);
	HUD::Update(hudKills);	// our
	HUD::Update(hudDeaths);
	Hyper::UpdateItemHUDs();	// HUDs.
	Hyper::UpdatePlayers();
	HUD::Update(hudObjective);
}

$Hyper::TimeMin = -1;	// DO NOT MODIFY THIS LINE!!!

// ===============================================================================================
//  Function: Reset
//
//  Purpose: Reset variables and update flag HUDs.
// ===============================================================================================
function Hyper::Reset()
{
	for (%i = 0; %i < 4; %i++)
	{
		$Hyper::Caps[%i] = 0;	// Reset all teams capture totals.
		$Hyper::YourCaps[%i] = 0;	// Reset your personal captures.
	}

	$Hyper::Kills = 0;		// Reset how many kills we have made.
	$Hyper::Deaths = 0;		// Reset how times we have been killed.
	$Hyper::TeamObjectives = 0;	// Reset how many objectives our team holds.
	$Hyper::ItemToggle = 0;	// Reset our timer toggle for use with UpdateItemHUDs.
	$Hyper::PlayerToggle = 0;	// Reset our timer toggle for use with UpdatePlayers.
	$Hyper::BlinkToggle = 0;	// Reset our flag toggle to blink enemy flag status when you have the flag.
	$Hyper::YouCapped = false;	// Reset our capture toggle.
	$Hyper::CapBlink = 0;	// Reset our blink toggle for personal captures displayed in the flag capture HUD.
	$Hyper::CapBlinkCnt = 0;	// Reset our blink counter.
	$Hyper::BalanceToggle = 0;	// Reset our team balance toggle.

	Hyper::ResetHUDs();		// Update our HUDs.

	if (Hyper::CheckGenHUDs("ShowTime"))
		if ($Hyper::TimeMin < 0)
		{
			$Hyper::TimeMin = 0;
			schedule("Hyper::UpdateMinutes();", 60);	// Start our play timer in a minute.
		}
}

// ===============================================================================================
//  Function: Capture
//
//  Purpose: Keep track of which team has captured the flag along with your personal captures for
//	   the each team you are a member of during a mission.
// ===============================================================================================
function Hyper::Capture(%team, %client)
{
	%whichteam = Client::getTeam(%client);

	$Hyper::Caps[%whichteam]++;			// Increment the team that captured the flag counter.

	if (%client == getManagerId())		// Did you capture?
	{
		$Hyper::YourCaps[%whichteam]++;	// Increment your capture total.

		if ($Hyper::Mode == "CTF")
			$Hyper::YouCapped = true;	// If in CTF mode, blink our flag capture HUD.
	}

	HUD::Update(hudCaps);			// Update our flag capture HUD.
}

// ===============================================================================================
//  Function: VerifiedKill
//
//  Purpose: Determine if we have killed someone or if we have been killed.
// ===============================================================================================
function Hyper::VerifiedKill(%killer, %victim, %weapon)
{
	%me = getManagerId();	// Get our client ID.

	if (%victim == %me)	// I've been killed. :(
	{
		for (%i = 1; %i < 7; %i++)				// If we die, update our item HUDs every five seconds for 30 seconds.
			schedule("Hyper::UpdateItemHUDs();", 5 * %i);	// If you respawn after that, HUDs won't be updated correctly and you
											// will still be shown item count from before death.  Remember, the
											// item count is not reset until you respawn alive.

		if ($Hyper::ShowKiller)
		{
			if (%killer != %victim)
			{
                        schedule::Add("THGoAway();",0);                  //SIX
				Client::centerPrint("<jc><f1>You died!\n<f0>Killed by: <f2>" @ Client::getName(%killer) @"\n <f0>Weapon: <f2>" @ %weapon, 1); 
		    		schedule("Client::centerPrint(\"\", 1);", 5);
                        if($SixPref::AutoResponse)
                        Response();
			}
		}

		$Hyper::Deaths++;		// Increment our deaths counter.
		HUD::Update(hudDeaths);	// Update our Deaths HUD.
	}
	else if (%killer == %me)	// I've killed someone. :)
	{
		if ($Hyper::ShowVictim)
		{

                  schedule::Add("THGoAway();",0);                  //SIX
      		Client::centerPrint("<jc><f1>Kill Added\n<f0>Killed: <f2>" @ Client::getName(%victim) @"\n <f0>Weapon: <f2>" @ %weapon, 1); 
		    	schedule("Client::centerPrint(\"\", 1);", 5);
                  if($SixPref::AutoTaunt)
                  Taunt();
		}

		$Hyper::Kills++;		// Increment our kills counter.
		HUD::Update(hudKills);	// Update our Kills HUD.
	}
}

// ===============================================================================================
//  Function: onClientMessage
//
//  Purpose: Determine if we have accessed a station for supplies, picked up an item, went through
//	   a server mission change.  If so, we will update our HUDs.
// ===============================================================================================
function Hyper::onClientMessage(%client, %msg)
{
	$Hyper::Next2LastMsg = $Hyper::LastMsg;
	$Hyper::LastMsg = %msg;

	if (%client != 0)
	{
		return;
	}

	if ($Hyper::ItemUse)
		if ((%msg == "Station Access Off") || (%msg == "Resupply Complete") ||
		    (String::findSubStr(%msg, "You received") != -1) || (%msg == "Match started."))
			Hyper::UpdateItemHUDs();	// Update our mines, grenades and repair kit/beacon HUDs.  NOTE: If you use an ammo
						// station, you must wait until "Resupply Complete", otherwise the HUDs will not be
						// updated correctly.

	if (%msg == "Match started.")
		Hyper::UpdateCTF();

	if (Hyper::CheckGenHUDs("ShowObjective"))
		if ((%msg == "Your team has taken an objective.") || (String::findSubStr(%msg, "taken your objective") != -1))
			Hyper::SortObjective(%msg);
}

// ===============================================================================================
//  Function: onClientJoin
//
//  Purpose: Update our team player count HUD when someone joins.
// ===============================================================================================
function Hyper::onClientJoin(%client)
{
	if (%client > $Hyper::LastClient)	// If the new client that joined is greater than our last known client,
		$Hyper::LastClient = %client;	// then set our last known client equal to the newly joined client.

	Hyper::UpdatePlayers();		// Update the team player count HUD.

	if (%client == getManagerId())
		Hyper::UpdateItemHUDs();	// Update our item HUDs.
}

// ===============================================================================================
//  Function: onClientDrop
//
//  Purpose: Update our team player count HUD when someone drops.
// ===============================================================================================
function Hyper::onClientDrop(%client)
{
	if (%client == $Hyper::LastClient)	// If our last known client dropped,
		Hyper::GetLastClient();	// then find a new last known client.

	Hyper::UpdatePlayers();		// Update the team player count HUD.
}

// ===============================================================================================
//  Function: onClientChangeTeam
//
//  Purpose: Update ALL HUDs if you changed teams.  Otherwise, just update the team player count
//	   HUD.
// ===============================================================================================
function Hyper::onClientChangeTeam(%client, %team)
{
	if (%client == getManagerId())	// Did you change teams?
	{
		$Hyper::TeamObjectives = 0;	// If so, reset our objectives count,
		Hyper::ResetHUDs();		// update ALL the HUDs.
	}
	else if (Hyper::CheckGenHUDs("ShowPlayers"))
		Hyper::UpdatePlayers();	// Otherwise, update the team player count HUD.
}

// ===============================================================================================
//  Function: GetLastClient
//
//  Purpose: Determine who is the last known client currently on the server.  This helps in the
//	   scanning phase for our team player count HUD.
// ===============================================================================================
function Hyper::GetLastClient()
{
	for (%i = $Hyper::LastClient; %i > 2048; %i--)	// Check all valid players up to the last known client.
		if (Client::getName(%i) != "")	// Is it a valid player?
		{
			$Hyper::LastClient = %i;	// If so, this is our new last known client.
			%i = 2048;
		}

	if ($Hyper::LastClient == 2176)
		schedule("Hyper::GetLastClient();", 3);	// Execute GetLastClient until we find the last known client.

}

// ===============================================================================================
//  Function: FindClient
//
//  Purpose: Simple function to initialize our last known client variable and to call the function
//	   for determining the last known client.  This is the function to be called upon on a
//	   accepted server connection.
// ===============================================================================================
function Hyper::FindClient()
{
	$Hyper::LastClient = 2176;	// Initialize our last client to the 128th player (2048 + 128).

	Hyper::GetLastClient();	// Find the last known client.
}

// ===============================================================================================
//  Function: CheckGenHUDs
//
//  Purpose: Check to see if our preference (%pref) is turned on according to the user.  Return
//	   "true" if it is, otherwise return "false".
// ===============================================================================================
function Hyper::CheckGenHUDs(%pref)
{
	%result = false;

	for (%i = 0; %i < $Hyper::NumGenHUDs; %i++)
		if ($Hyper::Gen[%i] == %pref)
		{
			%result = true;
			%i = $Hyper::c;
		}

	return %result;
}

// Below are our NEW event triggered client functions.

// ===============================================================================================
//  Function: throwRelease
//
//  Purpose: Determine if we have thrown an object.
// ===============================================================================================
function throwRelease(%desc)
{
	%type = getItemType(%desc);
	if (%type != -1) {
		%delta = getSimTime() - $throwStartTime;
		if (%delta > 1)
			%delta = 100;
		else
			%delta = floor(%delta * 100);
		remoteEval(2048,throwItem,%type,%delta);

		Event::Trigger(eventThrowRelease, %desc);	// Added this trigger for event use.

	}
	else {
		echo("Unknown item \"" @ %desc @ "\"");
	}

}

// ===============================================================================================
//  Function: use
//
//  Purpose: Determine if we have used an item.
// ===============================================================================================
function use(%desc)
{
	%type = getItemType(%desc);
	if (%type != -1) {
		useItem(%type);

		Event::Trigger(eventUse, %desc);	// Added this trigger for event use.

	}
	else {
		echo("Unknown item \"" @ %desc @ "\"");
	}
}

// Events
if (Hyper::CheckGenHUDs("ShowPlayers"))
	Event::Attach(eventConnectionAccepted, Hyper::FindClient);	// Initialize and find the last known client.

Event::Attach(eventConnectionAccepted, Hyper::Reset);		// Execute our Reset function upon a first-time connection to a server.

Event::Attach(eventChangeMission, Hyper::Reset);			// Also execute the Reset function upon a server-side mission change.

Event::Attach(eventClientChangeTeam, Hyper::onClientChangeTeam);	// See if we have switched teams during gameplay.

if ($Hyper::AutoStart)
	Hyper::Toggle();					// Automatically start HyperHUD according to user preference.
