//----------------------------------------------------------------------------------
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! SixPak Script Pack !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//----------------------------------------------------------------------------------
// FILE NAME    | CDHUD.cs
// AUTHOR       | Vacas_SixStringz - CDHUD icon by Neuromancer  
// AUTHOR EMAIL | mccleans@inreach.com
// VERSION      | 1.3
// RELEASE DATE | 06/21/99
// REQUIREMENTS | 
// DESCRIPTION  | Audio CD player
// DESCRIPTION  | 
//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------
// Known Limitations ///
////////////////////////
//
// 1. Currently if you advance beyond a track that actually exists on the CD, CDHUD
//    has no way to know. Nothing bad will happen, it will just not play the track
//
//


include("presto\\HUD.cs");
if (include("presto\\schedule.cs") == notfound)
   include("writer\\schedule.cs");

$pref::cdMusic = "true";

// Use this line to place CDHUD at an absolute position
$CDHUD::position = "1 223 120 32";  

function CDHUD::Update()
{
   if ($CDHUD::PlayType == 1)
   {  
      HUD::AddText(CDHUD, "<B0,1:CDHUD_CD.bmp><f2><jc>" @ $CDHUD::Status);
      HUD::AddText(CDHUD, "\n<jc>Track: " @ $CDHUD::CurrCDTrack);
   }
   else
   {    
      HUD::AddText(CDHUD, "<B0,1:CDHUD_CD.bmp><f2><jc>" @ $CDHUD::Status);
      HUD::AddText(CDHUD,"\n<jc>" @ $CDHUD::AutoTxt);
   }  
}

function CDHUD::resetdisplay()
{
   %displayed = HUD::GetDisplayed(CDHUD);
   if (%displayed == false)
      HUD::Display(CDHUD, true);
}

function CDHUD::Init()
{
   echo("Initilizing CDHUD");

   if(!$CDHUD::CurrCDTrack)
      $CDHUD::CurrCDTrack = 1;
   
   if ($CDHUD::PlayType != 2)
   {
      $CDHUD::Status = "Ready";
   }

   $CDHUD::AutoTxt = " ";
   rbStop(CD);
   $CDHUD::PlayMode = 0;
   $CDHUD::PlayType = 1;
   $pref::userCDOverride = "True";
   $pref::cdMusic = "True";
   rbStop(CD);
   rbSetPlayMode(CD, $CDHUD::PlayMode);
   echo("CDHUD Initilized on Track: " @ $CDHUD::CurrCDTrack @ " in Mode: " @ $CDHUD::PlayMode @ " Type: " @ $CDHUD::PlayType);
}

function CDHUD::Play()
{
   if ($CDHUD::PlayType == 2)
      CDHUD::Init();
   CDHUD::resetdisplay();
   $CDHUD::PlayType = 1;
   rbStop(CD);
   rbPlay(CD, $CDHUD::CurrCDTrack);
   $CDHUD::Status = "Playing";
   echo("CDHUD Playing Track: " @ $CDHUD::CurrCDTrack @ " in Mode: " @ $CDHUD::PlayMode @ " Type: " @ $CDHUD::PlayType);
   HUD::Update(CDHUD);

}

function CDHUD::PlayAll()
{
   $CDHUD::PlayType = 2;
   CDHUD::resetdisplay();
   rbStop(CD);
   usercd();
   echo("CDHUD Playing all CD tracks in Mode: " @ $CDHUD::PlayMode @ " Type: " @ $CDHUD::PlayType);
   $CDHUD::Status = "Auto Playing";
   $CDHUD::AutoTxt = "All Tracks";
   HUD::Update(CDHUD);
}

function CDHUD::Stop()
{
   if ($CDHUD::PlayType == 2)
      CDHUD::Init();
   CDHUD::resetdisplay();
   $CDHUD::PlayType = 1;
   rbPlay(CD, 0);
   rbStop(CD);
   $CDHUD::Status = "Stopped";
   HUD::Update(CDHUD);
  echo("CDHUD Stopped on Track: " @ $CDHUD::CurrCDTrack @ " in Mode: " @ $CDHUD::PlayMode @ " Type: " @ $CDHUD::PlayType);
}

function CDHUD::Next()
{
   if ($CDHUD::PlayType == 2)
      CDHUD::Init();
   CDHUD::resetdisplay();
   $CDHUD::CurrCDTrack++;
   $CDHUD::PlayType = 1;
   echo("Current Track: " @ $CDHUD::CurrCDTrack);
   $CDHUD::Status = "Seeking";
   HUD::Update(CDHUD);
   schedule::ADD("CDHUD::Play();",2);
}

function CDHUD::Prev()
{
   if ($CDHUD::PlayType == 2)
      CDHUD::Init();
   CDHUD::resetdisplay();
   $CDHUD::PlayType = 1;
   if ($CDHUD::CurrCDTrack == 1)
      echo("CANNOT PLAY PREVIOUS TRACK: You are currently on the 1st track");
   else
   { 
   $CDHUD::CurrCDTrack--;
   echo("Current Track: " @ $CDHUD::CurrCDTrack);
   $CDHUD::Status = "Seeking";
   HUD::Update(CDHUD);
   schedule::ADD("CDHUD::Play();",2);
   }
}

function CDHUD::ToggleDisplay()
{
   if (HUD::GetDisplayed(CDHUD))
      HUD::Display(CDHUD, false);
   else
      HUD::Display(CDHUD, true);
}


CDHUD::Init();

HUD::New(CDHUD, CDHUD::Update, $CDHUD::position);
HUD::Display(CDHUD,false);

Event::Attach(eventConnectionAccepted, CDHUD::Init);
Event::Attach(eventConnectionLost, CDHUD::Init);

if(!included("six\\sixkeys.cs"))
{

   editActionMap("playMap.sae");
   bindCommand(keyboard0, make, alt, "up", to, "CDHUD::PlayAll();");
   bindCommand(keyboard0, make, alt, "down", to, "CDHUD::ToggleDisplay();");
   bindCommand(keyboard0, make, control, "up", to, "CDHUD::Play();");
   bindCommand(keyboard0, make, control, "down", to, "CDHUD::Stop();");
   bindCommand(keyboard0, make, control, "right", to, "CDHUD::Next();");
   bindCommand(keyboard0, make, control, "left", to, "CDHUD::Prev();");

}