//=======================================================================================
// removes all trace of objects that have %string as part of their name
//=======================================================================================

function purgeNGSof (%string)
{
	%deleted=0;
	%objectsLeft=0;
    %ngs = nameToId(NamedGuiSet);
    %len = Group::objectCount(%ngs);
	echo("***********************************************************************");
	echo("Number of Objects in Set: "@%len);
	echo ();
    for(%i = 0; %i < %len; %i++)
	    {
	    %obj = Group::getObject(%ngs, %i);
		%objectName=Object::getName(%obj);
		if (%objectName=="") // There aren't any unnamed objects in the Named Gui Set
			{                // so something went wrong retrieving the object
			echo ("Object: "@%i@" ("@%obj@") is an invalid object. Delete on next pass");
			%objectsLeft++;
			}
		else if(Match::String (%objectName, "*"@%string@"*"))
		    {
			echo("Object: "@%i@" ("@%obj@") : "@%objectName@" - deleting");
			deleteObject(%obj);
			%deleted++;
		    }
		else
			echo("Object: "@%i@" ("@%obj@") : "@%objectName);
    	}

	//This is pedantic, but do you think I care ?
	if (%deleted=0)
		%numOfObjects="No objects to delete";
	else if (%deleted=1)
		%numOfObjects="Deleted a single object";
	else %numOfObjects="Deleted "@%deleted@" objects";

	if (%objectsLeft==0)
		%objectsLeftText="are no objects";
	else if (%objectsLeft==1)
		%objectsLeftText="is only one object";
	else %objectsLeftText="are "@%objectsLeft@" objects";

	echo();
	echo(%numOfObjects@". There "@%objectsLeftText@" left to delete");
	echo("***********************************************************************");
	if (%objectsLeft!=0)
		purgeNGSof (%string);
	return;
}
