//---------------------------------------------------------------------------------
// Map Rotation by Mental Trousers

//evalSearchPath ();

//use this map rotation. Change to false to go back to the original scheme
$MR::enabled=true;
$MR::noRepeatForNMaps=5;  //don't play the same map for at least this number of maps
$MR::exportMapList=true;


//==================    Don't touch stuff below here     ==================
$MR::numOfChoices=4;

//if this is the only mod, then you will see this message.
$MR::version="0.91";
if ($MODInfo!="")
	$MODInfo=$MODInfo@"\n<f2>mapRotation "@$MR::version;
else
	$MODInfo="<f2>mapRotation "@$MR::version;

function MR::setRating (%map, %rating)
{
	$MR::rating[%map]=$mapRating::[%rating];
}

function MR::nextMission ()
{
	if ((%rating=getWord ($MR::ratioString, $MR::currentPos))==-1)
		{
		%rating=getWord ($MR::ratioString, 0);
		$MR::currentPos=0;
		}
	else
		$MR::currentPos++;

	%map=$MR::current[%rating];
	$MR::current[%rating]=$MR::missionList[$MR::current[%rating]];
	return %map;
}

function MR::getMapRating (%map)
{
	return $MR::rating[%map];
}

function MR::setLastMap ()
{
	for (%i=1;%i<$MR::numOfRatings; %i++)
		{
		$MR::missionList[$MR::current[%i]]=$MR::firstMap[%i];
		}
}

function MR::missionList ()
{
	%index=1;
	while ((%map=$MLIST::EName[%index])!="")
		{
		if ($MLIST::EType [%index]!="Training")
			{
			if ((%rating=MR::getMapRating (%map))=="")
				%rating=3;

			if ($MR::firstMap[%rating]=="")
				$MR::firstMap[%rating]=%map;

			$MR::missionList[$MR::current[%rating]]=%map;
			$MR::current[%rating]=%map;
			echo ("$MR::current["@%rating@"]="@$MR::current[%rating]);
			}
		%index++;
		}
	MR::setLastMap ();
}

function MR::test ()
{
	for (%i=1;%i<=100;%i++)
		echo (MR::nextMission ());
}

function MR::initialiseMapRotation ()
{
	if ($MLIST::Count<1)
		return false;

	%first=file::findFirst ("missions\\*.dsc");
	if (%first!="")
		MR::missionList ();
	else
		echo ("Invalid missions - unable to assemble missionList");

	if ($MR::exportMapList)
		export ("$MR::missionList*", "config\\MRmaps.cs", false);
}

exec ("mapRatings.cs");
exec ("server.cs");

$MR::currentPos=0;

MR::initialiseMapRotation ();
