//
// Autoload
// By Tim 'Zear' Hammock
//

function Autoload::loadObject(%name, %filename)
{
    %file = Autoload::findFile(%filename);
    if(%file != "")
    {
        %obj = loadObject(%name, %file);
        if(%obj != 0)
        {
            $Autoload::last = %file;
            return %obj;
        }
    }
    echo("File "@%file@" not found in Autoload::loadObject");
    $Autoload::last = "";
    return %file;
}

function Autoload::findFile(%filename)
{
    %filetest = %filename;  // exact, as file
    if(!isFile(%filetest))
    {
        %filetest = "config\\"@%filename;  // prepend 'config\\', as file
        if(!isFile(%filetest))
        {
            %anyfile = "*"@%filename;
            %filetest = File::findFirst(%anyfile); // any match anywhere, as file
            if(!isFile(%filetest))
            {
                %filetest = "config\\"@%filetest;   // any match anywhere, as file, prepend 'config'
                if(!isFile(%filetest))
                {
                    return %filename;  // assume in a .vol
                }
            }
        }
        else
            return %filename;
    }
    return %filetest;
}

//
// NewOpts v0.96
// By Tim 'Zear' Hammock
//

$NewOpts::activePage = "";
$NewOpts::regCount = 0;
$NewOpts::doRegister = true;

function NewOpts::register(%pagename, %file, %initfunc, %closefunc, %visall)
{
    %frame = Autoload::loadObject(%pagename@"OptFrame", %file);
    if(%frame != 0)
    {
        echo("Registering "@%pagename@"  File: "@Autoload::getLast());
        %res = NewOpts::_register(%pagename, %frame, %initfunc, %closefunc, %visall);
        if(%res)
	        $NewOpts::pagelist[%pagename, type] = "static";
	    return %res;
	}
	echo("File "@%file@" for page "@%pagename@" not found in NewOpts::register");
	return FALSE;
}

function NewOpts::registerHelp(%pagename, %topic, %text)
{
    $NewOpts::pagelist[%pagename, help] = $NewOpts::pagelist[%pagename, help]@"<f2>"@%topic@"\n<f1>"@%text@"\n\n";
}

function NewOpts::_register(%pagename, %frame, %initfunc, %closefunc, %visall)
{
    if($NewOpts::doRegister)    // register only at startup
    {
        for(%i = 0; %i < $NewOpts::regCount; %i++)
            if($NewOpts::nameList[%i] == %pagename)
            {
                echo("Second attempt to register page "@%pagename@" ignored in NewOpts::_register");
                return FALSE;         // prevent duplicate registrations
            }
                
        $NewOpts::nameList[$NewOpts::regCount] = %pagename;
	    $NewOpts::regCount++;
    	
	    $NewOpts::pagelist[%pagename, frame] = %frame;
	    $NewOpts::pagelist[%pagename, init] = %initfunc;
	    $NewOpts::pagelist[%pagename, close] = %closefunc;
	    $NewOpts::pagelist[%pagename, visall] = %visall;
	    return TRUE;
	}
	echo("Late registration of "@%pagename@" ignored in NewOpts::_register");
	return FALSE;
}

function NewOpts::_doRegister()
{
	if($NewOpts::doRegister)
	{
        FGCombo::clear(NewOptsScriptList);
	    
	    %ngs = nameToId(NamedGuiSet);
	    %len = Group::objectCount(%ngs);
	    for(%i = 0; %i < %len; %i++)
	    {
		    %obj = Group::getObject(%ngs, %i);
		    if(Object::getName(%obj) == "NewOptsFrame")
		    {
		        $NewOpts::frame = %obj;
		        %i = %len;
		    }
	    }

	    $NewOpts::firstpage = $NewOpts::nameList[0];
	    for(%lcv = 0; %lcv < $NewOpts::regCount; %lcv++)
	    {
	        %pagename = $NewOpts::nameList[%lcv];
	        $NewOpts::pageList[%pagename, objlist] = "";
	        %frame = $NewOpts::pagelist[%pagename, frame];
	        %len = Group::objectCount(%frame);
	        for(%i = 0; %i < %len; %i++)
	        {
		        %obj = Group::getObject(%frame, 0);
		        %objname = Object::getName(%obj);
		        if(%objname != "NewOptsChooser")
		        {
		            if(%objname == false)
		            {
		                %objname = %pagename@"::noname::"@%i;
		                renameObject(%obj, %objname);
		            }
		            $NewOpts::pageList[%pagename, objlist] = $NewOpts::pageList[%pagename, objlist]@%obj@" ";
		            addToSet($NewOpts::frame, %obj);
		            Control::setVisible(%objname, false);
		        }
                else
                    deleteObject(%obj);
	        }
	        deleteObject(%frame);
	        FGCombo::addEntry(NewOptsScriptList, %pagename, %lcv);
	        if(%pagename < $NewOpts::firstpage)
	            $NewOpts::firstpage = %pagename;
	    }
	    $NewOpts::doRegister = false;
	    GuiLoadContentCtrl(MainWindow, "Options.gui");
    }
}

function NewOpts::openPage(%pagename)
{
    if($NewOpts::pagelist[%pagename, visall])
    {
        %num = String::getWordCount($NewOpts::pagelist[%pagename, objlist]);
        for(%lcv = 0; %lcv < %num; %lcv++)
        {
            %obj = getWord($NewOpts::pagelist[%pagename, objlist], %lcv);
            %objname = Object::getName(%obj);
            Control::setVisible(%objname, true);
        }
    }
    
    if($NewOpts::pagelist[%pagename, help] == "")
    {
        Control::setActive(NewOpts::helpButton, false);
        Control::setActive(NewOpts::helpLabel, false);
    }
    else
    {
        Control::setActive(NewOpts::helpButton, true);
        Control::setActive(NewOpts::helpLabel, true);
    }

    if($NewOpts::pagelist[%pagename, init] != "")
        eval($NewOpts::pagelist[%pagename, init]);
}

function NewOpts::closePage(%pagename)
{
    if($NewOpts::pagelist[%pagename, close] != "")
        eval($NewOpts::pagelist[%pagename, close]);

    %num = String::getWordCount($NewOpts::pagelist[%pagename, objlist]);
    for(%lcv = 0; %lcv < %num; %lcv++)
    {
        %obj = getWord($NewOpts::pagelist[%pagename, objlist], %lcv);
        %objname = Object::getName(%obj);
        Control::setVisible(%objname, false);
    }
}

function NewOpts::onPageSelect()
{
    if($NewOpts::activePage != "")
        NewOpts::closePage($NewOpts::activePage);
        
    $NewOpts::activePage = FGCombo::getSelectedText(NewOptsScriptList);
    NewOpts::openPage($NewOpts::activePage);
}

function NewOpts::onHelpClick()
{
    HelpDlg($NewOpts::activePage@" Help", $NewOpts::pagelist[$NewOpts::activePage, help]);
}

function NewOpts::onOptionsOpen(%gui)   // NewOpts::onOptionsOpen(OptionsGui);
{
    if(%gui != OptionsGui)
        return;

    NewOpts::_doRegister();
    
    if($NewOpts::activePage == "")
    {
        FGCombo::setSelected(NewOptsScriptList, FGCombo::findEntry(NewOptsScriptList, $NewOpts::firstpage));
        $NewOpts::activePage = FGCombo::getSelectedText(NewOptsScriptList);
    }
    NewOpts::openPage($NewOpts::activePage);
}
Event::Attach(eventGuiOpen, NewOpts::onOptionsOpen);

function NewOpts::onOptionsClose(%gui)
{
    if(%gui == OptionsGui)
        NewOpts::onExit();
}
Event::Attach(eventGuiClose, NewOpts::onOptionsClose);

function NewOpts::savePrefs()
{
    if($NewOpts::activePage != "")
        NewOpts::closePage($NewOpts::activePage);
    HudMover::quit();
//    SenseStack::_setSense($NewPrefs::baseSensitivity);
//    $pref::PlayerFOV = $FovStack::baseFov;
//    export("$NewPrefs::*", "config\\NewPrefsPrefs.cs");
}
Event::Attach(eventExit, NewOpts::savePrefs);

// bracket for Presto < 0.93
function OptionsGui::onOpen()
{
   //the IRC options page
   IRCOptions::init();

   OptionsMovement::init();
   OptionsVideo::init();
   OptionsGraphics::init();
   OptionsNetwork::init();
   OptionsSound::init();
   
   Event::Trigger(eventGuiOpen, OptionsGui);
}

function OptionsGui::onClose()
{
   Event::Trigger(eventGuiClose, OptionsGui);

   //the IRC options page
   IRCOptions::Shutdown();

   OptionsNetwork::shutdown();
}
// end bracket

//
// ----------------------------------------------------------------------------
//

function NewOpts::isValidString(%val, %charsAllowed)
{
    %valid = TRUE;
    for(%i = 0; %i < String::len(%val); %i++)
    {
        %char = String::getSubStr(%val, %i, 1);
        if(String::findSubStr(%charsAllowed, %char) == -1)
        {
            %valid = FALSE;
            break;
        }
    }
    return %valid;
}

function NewOpts::validateNumericText(%val, %decimalAllowed, %negAllowed)
{
    %newval = "";
    %foundDecimal = false;
    for(%i = 0; %i < String::len(%val); %i++)
    {
        %char = String::getSubStr(%val, %i, 1)@"x";
        if(%char == ".x" && %decimalAllowed == TRUE && %foundDecimal == false)
        {
            %newval = %newval@String::getSubStr(%char, 0, 1);
            %foundDecimal = true;
        }
        if(%char == "-x" && %negAllowed == TRUE && %i == 0)
            %newval = %newval@String::getSubStr(%char, 0, 1);
        if(String::findSubStr("0x1x2x3x4x5x6x7x8x9x", %char) != -1)
            %newval = %newval@String::getSubStr(%char, 0, 1);
    }
    return %newval;
}

function NewOpts::validateAlphaText(%val, %charsAllowed)
{
    %newval = "";
    for(%i = 0; %i < String::len(%val); %i++)
    {
        %char = String::getSubStr(%val, %i, 1);
        if(String::findSubStr(%charsAllowed, %char) != -1)
            %newval = %newval@%char;
    }
    return %newval;
}

function NewOpts::getIdFromSet(%set, %name)
{
    for(%i = Group::objectCount(%set); %i > 0; %i--)
    {
        %obj = Group::getObject(%set ,%i-1);
        if(Object::getName(%obj) == %name)
            break;
    }
    return %obj;
}
