// Autoload 1.11
// By Tim 'Zear' Hammock

function Autoload::autoload()
{
    $Autoload::autoloaded = 0;
    %actualLoads = 0;

    if(isFile("config\\AutoloadPrefs.cs"))
        exec("AutoloadPrefs.cs");

    $ConsoleWorld::DefaultSearchPath = "config";

    // load auto .cs files ("*.acs.cs")
    %file = File::findFirst("*.acs.cs");
    while(%file != "")
    {
        Autoload::buildList(%file);
        %file = File::findNext("*.acs.cs");
    }

    // load auto .vol files ("*.avl.vol")
    %file = File::findFirst("*.avl.vol");
    while(%file != "")
    {
        Autoload::buildList(%file);
        %file = File::findNext("*.avl.vol");
    }
    for(%i = 0; %i < $Autoload::autoloaded; %i++)
    {
        if(String::ICompare(String::right($Autoload::autoloaded[%i, loc], 7), ".acs.cs") == 0)
            Include(%file);
        else
        {
            %base = File::getBase(File::getBase($Autoload::autoloaded[%i, loc]));
    		newObject(%base, SimVolume, $Autoload::autoloaded[%i, loc]);
            Autoload::include(%base@".cs");
        }
    }

    echo("Autoload: "@$Autoload::autoloaded@" files considered, "@%actualLoads@" loaded.");

    deleteVariables("$Autoload::doAutoload*");
    for(%i = 0; %i < $Autoload::autoloaded; %i++)
    {
        if($Autoload::autoloaded[%i, acs] == true)
            echo(%i@" -> "@$Autoload::autoloaded[%i, loc]);
        %safeStr = "\""@String::replace($Autoload::autoloaded[%i, loc], "\\", "/")@"\"";
        $Autoload::doAutoload["["@%safeStr@"]"] = $Autoload::autoloaded[%i, acs];
    }
    export("$Autoload::doAutoload*", "config\\AutoloadPrefs.cs");
    
    EvalSearchPath();
}

function Autoload::buildList(%file)
{
    %safeStr = String::replace(%file, "\\", "/");
    if($Autoload::doAutoload[%safeStr] == false)
    {
        $Autoload::autoloaded[$Autoload::autoloaded, loc] = %file;
        $Autoload::autoloaded[$Autoload::autoloaded, acs] = false;
        $Autoload::autoloaded++;
    }
    else
    {
        %unique = true;
        for(%i = 0; (%i < $Autoload::autoloaded) && %unique; %i++)    // this all seems unnecessary, but it is needed
        {                                                           // otherwise, the same file is loaded multiple times
            if($Autoload::autoloaded[%i, loc] == %file)             // timing issue maybe? I dunno.
                %unique = false;
        }
            
        if(%unique)
        {
            $Autoload::autoloaded[$Autoload::autoloaded, loc] = %file;
            $Autoload::autoloaded[$Autoload::autoloaded, acs] = true;
            $Autoload::autoloaded++;
            %actualLoads++;
        }
    }
}

function Autoload::getFileByNumber(%idx)
{
    if(%idx < 1 || %idx > $Autoload::autoloaded)
        return "";
    return $Autoload::autoloaded[%idx, loc];
}

function Autoload::loadObject(%name, %filename)
{
    %file = Autoload::findFile(%filename);
    if(%file != "")
    {
        %obj = loadObject(%name, %file);
        if(%obj != 0)
        {
            $Autoload::last = %file;
            return %obj;
        }
    }
    echo("File "@%file@" not found in Autoload::loadObject");
    $Autoload::last = "";
    return %file;
}

function Autoload::include(%filename)
{
    %file = Autoload::findFile(%filename);
    if(%file != "")
        Include(%file);
    else
        echo("File "@%file@" not found in Autoload::include");
    $Autoload::last = %file;
    return %file;
}

function Autoload::findFile(%filename)
{
    %filetest = %filename;  // exact, as file
    if(!isFile(%filetest))
    {
        %filetest = "config\\"@%filename;  // prepend 'config\\', as file
        if(!isFile(%filetest))
        {
            %anyfile = "*"@%filename;
            %filetest = File::findFirst(%anyfile); // any match anywhere, as file
            if(!isFile(%filetest))
            {
                %filetest = "config\\"@%filetest;   // any match anywhere, as file, prepend 'config'
                if(!isFile(%filetest))
                {
                    return %filename;  // assume in a .vol
                }
            }
        }
        else
            return %filename;
    }
    return %filetest;
}

function Autoload::getLast()
{
    return $Autoload::last;
}

%file = File::findFirst("NewOpts.vol");
if(%file != "")
{
    newObject("NewOpts", SimVolume, %file);
    Autoload::include("NewOpts\\NewOptsInstall.cs");
}
else
    echo("NewOpts.vol not found!");
    
Autoload::autoload();
