//=======================================================================================
// Install - by Mental Trousers as part of the Tribes scripting documents at
// http://planetstarsiege.com/mt/
// version 1.1
//=======================================================================================
//
// This script is not intended as one of the tutorial files. However it is fully
// documented. It is not for beginners though, as one of the things it does is to
// dynamically redefine a function. That can be very dangerous in the wrong hands.
//
// This script will ensure that the files required to successfully run all of the scripts
// obtained from http://planetstarsiege.com/mt/ are present and that there are no other
// unexecuted versions on the same machine. If there are it will echo a prominent
// message to the console and also pop up a message on the play screen when that opens.
// It doesn't prevent the game from being played, however none of the tutorial script (or
// any others written by MT) will function properly if at all.
//
// Things covered in this script
// -----------------------------
//
// Alot of file matching
// file copying and deleting
// text formatting
// using centerprint
// using schedule
// dynamically redefining functions (eck !!)
//
//=======================================================================================

//=======================================================================================
// Sniffs out if there is more than one copy of a file in Tribes/config or it's
// sub-directories and checks to see if it's been executed using the include function
//=======================================================================================
function _checkForOtherVersions (%file, %path)
{
	//if there is only one copy of the file, the 2nd find will return ""
	%check=file::findFirst ("*\\"@%file);
	%check=file::findNext ("*\\"@%file);

	if (%check=="")
		{
		//only one has been found so we'll include it
		include (%path@%file);
		return true;
		}
	else
		//found a second copy. included tells us whether it's been included already or not
		{
		%included=included (%path@%file, flat);
		return %included;
		}
}

//=======================================================================================
// Tests to see if include.cs has been execed. If it hasn't then calling the function
// include() will result in a false because it hasn't been defined yet. It then checks
// for another copy of include.cs and returns false it one is found
//=======================================================================================
function checkForInclude ()
{
	//if include.cs hasn't been executed then the function include() doesn't exist and
	//calling it will return a false or the unknown command message. If it has been
	//executed, including a non-existant file will return something other than false or
	//the unknown command message
	%error=include ("testing_for_include.cs");
	echo (%error);
	if (%error==False || string::findSubStr(%error, "include: Unknown command.")!=-1)
		{

		//include.cs hasn't been executed so check for more than one copy
		%check=file::findFirst ("*\\include.cs");
		%check=file::findNext ("*\\include.cs");

		//if theres another copy, %check will equal something rather than ""
		if (%check!="")

			//found another copy so return false
			return false;
		else
			{
			//no other copies exist
			exec ("mt\\writer\\include.cs");
			return true;
			}
		}

	//include.cs has been found and executed
	else
		{

		//all versions of include.cs up to and including version 1.9 contain an error.
		//This installer wont work correctly with this error, so here is the work
		//around. I have to test for the error, and if it's found execute the version of
		//include.cs that shipped with this installer
		%includeError=include("MT\\Library\\test_for_include_error.cs");
		if (%includeError)
			{
			if (included ("MT\\Library\\test_for_include_error.cs", flat)!=1)
				{
				echo ("** Attention. You are using an outdated version of include.cs that contains an error. Please update **");
				exec ("mt\\writer\\include.cs");
				}
			}
		return true;
		}
}

//=======================================================================================
// Calls the above checking functions, sets a variable to indicate if there was an error
// and then echoes a message if there was one.
//=======================================================================================
function checkForOtherVersions ()
{
	//checks if include.cs exists etc - see function above
	if (checkForInclude ())
		{

		//check for the other 4 required files and assemble a list of files if errors
		if (!_checkForOtherVersions ("event.cs", "mt\\writer\\")) $fileList=" event.cs";
		if (!_checkForOtherVersions ("events.cs", "mt\\presto\\")) $fileList=$fileList@" events.cs";
		if (!_checkForOtherVersions ("match.cs", "mt\\presto\\")) $fileList=$fileList@" match.cs";
		if (!_checkForOtherVersions ("autoload.cs", "mt\\zear\\")) $fileList=$fileList@" autoload.cs";
		if (!_checkForOtherVersions ("NewOpts.cs", "mt\\zear\\")) $fileList=$fileList@" NewOpts.cs";
		if (!_checkForOtherVersions ("moreString.cs", "mt\\zear\\")) $fileList=$fileList@" moreString.cs";

		//bug fix
		for (%i=0;%i<1000;%i++)
			{}

		//if theres an error $fileList wont be empty
		if ($fileList != "")
			{

			//set the error variable and echo warning to console
			$errorWhileLoading=True;
			echo ("**************************************************************************");
			echo ("* An error occured while executing the following files");
			echo ("*"@$fileList);
			echo ("* Other versions of these files have been found but have not been");
			echo ("* executed using the include function. Please check your autoexec.cs file");
			echo ("* and ensure that these files are included correctly");
			echo ("* If that does not prevent this message from appearing then please");
			echo ("* change the extension of the file that you DO NOT wish to include");
			echo ("* Any scripts written by Mental Trousers may not preform properly");
			echo ("* because of this.");
			echo ("**************************************************************************");
			}
		}
	else
		{

		//another copy of include.cs was found and hasn't been executed. Set error
		//variable and echo error message
		$errorWhileLoading=True;
		$fileList=" include.cs";
		echo ("**************************************************************************");
		echo ("* An alternative version of include.cs has been found but not executed");
		echo ("* None of the files necessary to properly execute scripts found at http://planetstarsiege.com/mt/");
		echo ("* have been executed. Please check your autoexec.cs file to ensure that the other version of");
		echo ("* include.cs is executed, or alternatively rename that file.");
		echo ("**************************************************************************");
		}
}

//=======================================================================================
// Sets up the error message that is displayed on the play screen and prints it
//=======================================================================================
function fileErrorMessage ()
{
	//pretty straight forward really. <jc> is "justify center". <f1><f2> are just 2
	//of the fonts. I believe there a 5 available
	%line1="<jc><f2>Attention - Major Error in scripts - Attention\n\n";
	%line2="<jc><f1>An error has occured while executing files required to use scripts obtained from\n";
	%line3="<jc>Mental Trousers scripting tutorial site http://www.planetstarsiege.com/mt/\n";
	%line4="<jc>Other versions of the file/s<f2>"@$fileList@"\n";
	%line5="<jc><f1>were found but have not been executed.\n";
	%line6="<jc>Please check your autoexec.cs file (located in the Tribes/config directory)\n";
	%line7="<jc>and ensure that the other versions of these files are executed before mt\\\\install.cs.\n";
	%line8="<jc>Alternatively rename the other files in Windows explorer\n\nThis message will appear for 45 secs\n";
	%message = %line1@%line2@%line3@%line4@%line5@%line6@%line7@%line8;

	//print the message in the center of the screen. 0=center, 1=bottom, 2=top
	client::centerPrint (%message, 0);
}

//=======================================================================================
// Redefine the play gui again so that the error message doesn't pop up every 30 seconds
// or so.
//=======================================================================================
function redefinePlayGuiOpen ()
{

	//clear the message from the screen
	client::centerPrint ("",0);

	//redefine this function to the default event definition from events.cs. This is 
	//bad form by the way, however when this lot is executed, the scheduler isn't running
	//and we don't have the event queues up and running yet (theres a time delay between
	//executing the event.cs file and the functions being available, a minor problem with
	//unsynchronised multithreading)
	function PlayGui::onOpen()
		{
		Event::Trigger(eventGuiOpen, PlayGui);
		}

}

//=======================================================================================
// Heres where it's all set in motion
//=======================================================================================

//default to "no errors", changed if there is one
$errorWhileLoading=False;

//as it says
checkForOtherVersions ();

//if theres an error then redefine the callback function that executes when the play gui
//opens. Schedule the error message to pop up 5 seconds after the play gui opens rather
//than displaying it straight away cos theres sometimes a delay between when the function
//is called and when the screen actually appears. Printing on a screen that isn't up yet
//doesn't work :)
if ($errorWhileLoading)
	{
	function PlayGui::onOpen()
		{
			schedule ("fileErrorMessage ();",5);
			schedule ("redefinePlayGuiOpen ();",40);
		}
	}										

//This gets changed when I do an update. I decided to do it here because the files that
// are executed may change over time as I add or delete things from the pack
$MTPack::Version="0.93";

// all the includes needed
if (isFile("config\\MTFavouritesPrefs.cs"))
	include ("MTFavouritesPrefs.cs");
else
	include ("MT\\MTFavouritesPrefs.cs");

if ($MTPack::version!=$MTPack::currentVersion)
	{
	exec ("MT\\MTFavouritesPrefs.cs");
	exec ("MTFavouritesPrefs.cs");
	exec ("MT\\MTdefaultKeyMaps.cs");
	}

$MTPack::currentVersion=$MTPack::Version;

if (isFile("config\\MTKeyMaps.cs"))
	include ("MTKeyMaps.cs");
else
	include ("MT\\MTdefaultKeyMaps.cs");

include ("MT\\MTFavouritesDefaults.cs");
include ("MT\\MTPermanentKeyBinds.cs");
include ("MT\\Keys.cs");

include ("MT\\Library\\purgeNGS.cs");
include ("mt\\Library\\action.cs");

include ("MT\\QuickFavourites.cs");
include ("MT\\Jump.cs");
include ("MT\\Huds.cs");

include ("MT\\onExit.cs");

