//===============================================================
// QuickFavourites.cs by Mental Trousers
//===============================================================
// This script does a whole bunch of stuff with favourites at
// the inventory stations. The different options are:
//   1) walk into an inventory station, keep the forward key
//      pressed and walk away with your preselected favourite
//   2) let go of the forward key, and one of 2 things will
//      automatically activate. Either a "litterbug" will start
//      or up to 3 lots of items will be bought and tossed out,
//      before buying your preselected favourite. You can
//      activate other drop groups or litterbugs using your
//      favourites shortcut keys.
//   3) Have the inventory screen open as per normal.
// You can also buy stuff without having to open the inventory
// gui (it doesn't open if you preselect a favourite) using the
// number keys below the function keys on your keyboard. These,
// and everythingelse, are set in NewOpts.
//
// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
// NOTE: The last 2 lines of CamHud.cs (part of the presto pack)
// should be commented out using //
//
//===============================================================
// 
// Future tweaks to this script. Add mod support - Insomniax,
// Renegades and Shifter.
// Fix the little bug where you can't buy Laser Rifles in
// the same drop group as mortars (maybe. May not because
// throwing weapons isn't of any use at all in a game. I only put
// them in because it would have complicated things alot to leave
// the weapons out)
//
//===============================================================

//===============================================================
// Turns you off center when a drop group has more than one item
// in it so you don't get mixed groups of stuff
//===============================================================
function MT::turnOffCenter (%fav, %item)
{
	if (%item==1)
		{
		if ($throwItem::[%fav, amount2]!="")
			postAction (2048, IDACTION_YAW, 0.10);
		}
	else if (%item==3)
		postAction (2048, IDACTION_YAW, -0.10);
	return true;
}

//===============================================================
// Returns you to center when a drop group has more than one item
// in it
//===============================================================
function MT::returnToCenter (%fav, %item, %delay)
{
		if (%item==1)
			{
			if ($throwItem::[%fav, amount2]!="")
				schedule ("postAction (2048, IDACTION_YAW, -0.10);", %delay);
			}
		else if (%item==3)
			schedule ("postAction (2048, IDACTION_YAW, 0.10);", %delay);
		return true;
}

//===============================================================
// The Inventory gui didn't open because
// $pref::noEnterInvStation=true; but it is at the inventory
// station.
//===============================================================
function MT::InvStatGuiOpen_ ()
{
	schedule ("popActionMap(\"MTsetFavsMap.sae\"); pushActionMap(\"MTInventMap.sae\");", 0.2);

	MT::quickHeal ();
	if ($MT::curFavourites=="")
		$MT::curFavourites=$curFavorites;
	if ($curFavorites==19 || $MT::throwType[$curFavorites]==ordinary)
		remoteEval(2048, ToggleInventoryMode);
	else
		MT::InvStatGuiOpen__ (getMountedItem(0));
}

//===============================================================
// This is ripped from repairKitBuy.cs from Plague :)
//===============================================================
function MT::quickHeal ()
{
	%armour=(getItemCount("Light Armor")*2)+(getItemCount("Medium Armor")*3)+(getItemCount("Heavy Armor")*4);
	%str="remoteEval(2048, useItem, 39);remoteEval(2048, buyItem, 39);";
	if (%armour==2)
		%armour=1;
	for (%i=1;%i<%armour+3;%i++)
		%string=%string@%str;
	eval (%string);
}

//===============================================================
// Catch the inventory station opening event
//===============================================================
function MT::chooseInvStatOption (%mounted)
{
	$pref::noEnterInvStation=true;
	if ($curFavorites==19)
		MT::InvStatGuiOpen_ ();
	else
		MT::InvStatGuiOpen__ (%mounted);
}

//===============================================================
// Heres where we start to do stuff at the inventory station
//===============================================================
function MT::InvStatGuiOpen__ (%weapon)
{
	if (%weapon==-1)
		{
		schedule ("popActionMap(\"MTsetFavsMap.sae\"); pushActionMap(\"MTInventMap.sae\");", 0.2);

		if ($MT::atStation)
			{
			MT::quickHeal ();
			if (!MT::anyMoveKeyPressed ())
				{
				if ($MT::curFavourites=="")
					$MT::curFavourites=$curFavorites;

				if ($curFavorites!=19)
					MT::muteMoveButtons ();

				MT::throwChooser ($curFavorites);
				}
			else 
				{
				MT::postBuy ($curFavorites);
				}
			}
		}
	else
		{
		$MT::atVehicleStation=true;
		event::trigger(eventVehicleStationEnter);
		}
}

//===============================================================
// Figures out whether or not to change armour for the requested
// item
//===============================================================
function MT::buyArmour (%fav, %throwItem::amount, %item)
{
	if (%throwItem::amount>0)
		{
		%category=MT::getItemName (%item);

		if (getItemCount(%category)!=0)
			schedule ("sell (\""@%category@"\");", 0.1);
		%armour=(getItemCount("Light Armor")*2)+(getItemCount("Medium Armor")*3)+(getItemCount("Heavy Armor")*4);
		if (!match::string (%item, "* "@%armour@"*"))
			{
			if (match::paramString (%item, "%1# %a"))
				{
				%newArmour=getWord (match::result (a), 0);
				if (%newArmour!=%armour)
					schedule ("remoteEval (2048, buyItem, "@%newArmour@");", 0.0);
				}
			}
		return %category;
		}
}

//===============================================================
// Just returns the maximum number of stuff to drop. Doesn't
// matter if it returns a number that is too big, cos there
// aren't any messages to catch and mute etc and it doesn't make
// any difference to how fast things are done.
//===============================================================
function MT::getDropNumber(%item, %name)
{
	if (%item==12)
		return 14;
	else if (%item==14)
		return 16;
	else if (%item==16 || %item==20)
		return 6;
	else if (%item==18)
		return 4;
	else if (%item==40 || %item==41 || %item==42)
		return 5;
	else
		return 1;
}

//===============================================================
// assembles the string to drop all of whatever it is that is to
// be dropped
//===============================================================
function MT::dropString (%item, %name)
{
	%num=MT::getDropNumber(%item, %name);
	for (%j=0;%j<%num;%j++)
		%tmp=%tmp@"drop(\""@%name@"\");";
	return %tmp;
}

//===============================================================
// contructs a string of "buy ... drop ..." items and then evals
// it. Handling the favourites complicates things somewhat though
//===============================================================
function MT::doDropGroup (%fav, %index, %category, %throwItem::amount)
{
	if ($throwItem::[%fav, "item"@%index]!=15)
		{
		for (%i=0;%i<%throwItem::amount;%i++)
			{
			%str=%str@"remoteEval (2048, buyItem, $throwItem::["@%fav@", item"@%index@"]+10);";
			%str=%str@"drop(\""@%category@"\");";
			}
		eval (%str);
		}
	else
		{
		for (%i=11;%i<43;%i++)
			{
			%name=MT::getItemName($MT::Item::[%i]);
			if (!match::string ($pref::favoriteList[$curFavorites @ $ServerFavoritesKey], %i) && getItemCount(%name)>0)
				%temp=%temp@"sell (\""@%name@"\");";
			}
		eval (%temp);
		for (%i=1;%i<20;%i++)
			{
			%item=getWord($pref::favoriteList[$curFavorites @ $ServerFavoritesKey], %i);
			%name=MT::getItemName($MT::Item::[%item]);
			if (%item!=-1)
				{
				%list=%list@"sell (\""@%name@"\");";
				%str=%str@"remoteEval (2048, buyItem,"@%item@");";
				%str=%str@MT::dropString (%item, %name);
				}
			else
				%i=20;
			}
		for (%i=0;%i<%throwItem::amount;%i++)
			{
			%list=%list@%str;
			}
		eval (%list);
		}
}

//===============================================================
// does stuff before the drop group is done, such as swapping
// armour, turning etc
//===============================================================
function MT::buyAndDrop (%fav, %index)
{
	%throwItem::amount=$throwItem::[%fav, "amount"@%index];
	%multi=($throwItem::[%fav, amount1]>0)+($throwItem::[%fav, amount2]>0)+($throwItem::[%fav, amount3]>0);
	%item=$MT::Item::[$throwItem::[%fav, "item"@%index]+10];

	%category=MT::buyArmour (%fav, %throwItem::amount, %item);

	if (%throwItem::amount>0)
		{
		if (%multi>1 && %index!=2)
			MT::turnOffCenter (%fav, %index);
		schedule ("MT::doDropGroup ("@%fav@", "@%index@", \""@%category@"\", "@%throwItem::amount@");", 0.2);
		if (%multi>1 && %index!=2)
			MT::returnToCenter (%fav, %index, 0.2);
		}

	%index++;
	if (%index<=3) schedule ("MT::buyAndDrop ("@%fav@", "@%index@");" ,0.2);
	else schedule ("MT::postBuy ("@%fav@");" ,0.2);

}

//===============================================================
// At the inventory stations, the movement keys are muted so that
// everything can be done before the player leaves the station.
// If they press a movement key, favourites are bought etc etc
// and then this is called. If a movement key is pressed then
// this will start them moving again
//===============================================================
function MT::restoreMovement ()
{
	if ($MT::forwardPressed)
		postAction(2048, IDACTION_MOVEFORWARD, 1.0);
	else if ($MT::backPressed)
		postAction(2048, IDACTION_MOVEBACK, 1.0);
	else if ($MT::moveLeftPressed)
		postAction(2048, IDACTION_MOVELEFT, 1.0);
	else if ($MT::moveRightPressed)
		postAction(2048, IDACTION_MOVERIGHT, 1.0);
	else if ($MT::jumpPressed)
		postAction(2048, IDACTION_MOVEUP, 1.0);
	else if ($MT::jetPressed)
		postAction(2048, IDACTION_JET, 1.0);
}
//===============================================================
// Buy the favourite and cleans up
//===============================================================
function MT::buyFavourites (%fav)
{
	CmdInventoryGui::buyFavorites (%fav);
	MT::restoreMovement ();
	MT::releaseMoveButtons ();
    remoteBP(2048, "<jc>Bought "@$MT::favouriteName[$curFavorites], 4);
	schedule ("action::completed (buyFavouritePressed);", 0.0);
}

//===============================================================
// Add the little hud that shows what favourite is the current
// preselect
//===============================================================
function MT::FavPreselectHud (%gui)
{
	if (%gui==playGui && $MT::favPreselectHud)
		{
		$MT::XCE::FavPre=100;
		$MT::YCE::FavPre=20;
		$MT::Container::FavPreselect=newObject ("MTContainerFavPreselect",
												SimGui::Control,
												$MT::XCC::FavPre,
												$MT::YCC::FavPre,
												$MT::XCE::FavPre,
												$MT::YCE::FavPre);
	
		$MT::BG::FavPreselect=newObject ("MTBgFavPreselect",
										FearGui::FearGuiMenu, 0, 0,
										$MT::XCE::FavPre,
										$MT::YCE::FavPre);
	
		$MT::Text::FavPreselect=newObject ("MTTextFavPreselect",
											FearGuiFormattedText, 0, 0,
											$MT::XCE::FavPre,
											$MT::YCE::FavPre);
	
		AddToSet (MTContainerFavPreselect, $MT::BG::FavPreselect);
		AddToSet (MTContainerFavPreselect, $MT::Text::FavPreselect);
		AddToSet ($MTControlObject, $MT::Container::FavPreselect);
		control::setValue (MTTextFavPreselect, "<jc><f2> "@$MT::favouriteName[19]);

		control::setVisible(MT_huds_overlay1, $MT::enableFavsHud);
		control::setVisible(MTContainerFavPreselect, $MT::enableFavsHud);

		$MT::favPreselectHud=false;
		schedule ("event::detach (eventGuiOpen, MT::FavPreselectHud);", 30);
		}
}

//===============================================================
// Register with NewOpts. Simple
//===============================================================
function MT::registerWithNewOpts ()
{
	NewOpts::registerHelp("MT Favourites", "Mods", "At the moment there isn't any support for anything other"@
							" base Tribes. Sometime in the future I will put in support for a few mods, namely"@
							" Renegades, Insomniax and Shifter");
	NewOpts::registerHelp("MT Favourites", "Favourites selector", "This drop box (more correctly it's a combo"@
							" box) is used to select which favourite you would like to change the options below"@
							" for.");
	NewOpts::registerHelp("MT Favourites", "Ordinary favourite", "Tick this box to make the selected favourite"@
							" an ordinary one. Ordinary favourites will open the inventory screen when you enter"@
							" the inventory stations and will not throw anything at all. By default, the inventory"@
							" screen should not appear unless you use this");
	NewOpts::registerHelp("MT Favourites", "Litterbug favourite", "Tick this box to make the selected favourite"@
							" a litterbug type favourite. A litterbug favourite will automatically start throwing"@
							" out the item that you select in the <f2>Item 1<f1> drop box below, when you enter an "@
							" inventory station and lift your finger off the forward key. To cancel the litterbug"@
							" and buy your favourite, press one of your favourites keys or any of the movement"@
							" keys, ie forward. There is no limit on the amount of items that the litterbug will"@
							" throw, however throwing alot of stuff can severly affect frame rates and will annoy"@
							" the hell out of everyone. I will probably be removed the litterbug type favourite in"@
							" the future as none of the beta testers or myself use it at all. It's too slow and"@
							" inefficient compared to the drop groups (next paragraph)");
	NewOpts::registerHelp("MT Favourites", "Drop group favourite", "Tick this box to make the selected favourite"@
							" a drop group type. The drop group favourites can be set to drop up to 3 different"@
							" items (limited to 5 of each) into 3 neat little piles. These drop groups are very"@
							" fast and are the primary type used by everyone that has tested this pack for me."@
							" They can be activated the same way as the litterbug type, ie simply lift your"@
							" finger off the forward key when you walk into the inventory station or press"@
							" a favourites key when at the station. An example of a typical drop group for"@
							" deploying turrets and sensors might have <f2>Item 1<f1> set to drop 2 motion sensors,"@
							" <f2>Item 2<f1> set to drop 2 turrets, and <f2>Item 3<f1> set to drop a pulse sensor. All"@
							" of which could be deployed before they fade out. Throwing too much stuff is simply"@
							" wasteful and unnecessary and can drain portable inventory stations dry in less than"@
							" 2 seconds.");
	NewOpts::registerHelp("MT Favourites", "Preselect key", "This is the key that you can press at anytime while"@
							" playing Tribes (any time you can move around the map) to preselect which favourite"@
							" you would like to buy when you enter the inventory stations. When you press these"@
							" keys you should see the text in a small hud somewhere on the screen change to show"@
							" you which one you have choosen. If you have turned off the hud in the <f2>MT Huds<f1>"@								" screen in the <f2>Scripts<f1> section of the Options screen, a message will pop up at"@
							" the bottom of the screen instead. The preselect keys can (and probably should be so that"@ 							" they are easily remembered) be the same as your favourites keys. <f3>HOWEVER<f1>, the"@
							" keys <f3>MUST<f1> be set in the <f2>MT Favourites<f1> page <f3>FIRST<f1>, and then in the"@
							" usual <f2>Misc<f1> page of the Options screen. For some reason Tribes losses the key"@
							" binding if you do it the other way around.");
	NewOpts::registerHelp("MT Favourites", "Item selectors", "These 3 combo boxes are used to select which items"@
							" you want to drop for the selected favourite. The small text boxes to the right allow"@
							" you to choose the amount of each item to drop. Although you can enter up to 99 as"@
							" the amounts for each, the limit is actually 5. Unfortunately I have not been able to"@
							" change these so that it will only show 0-5 as my computer keeps crashing everytime"@
							" I try to change these.");
	NewOpts::registerHelp("MT Favourites", "", "Due to another wierd idiosyncracy of Tribes, <f2>Item 2<f1> and"@
							" <f2>Item 3<f1> will not show all of the list as it disappears off the bottom of the"@
							" screen at any resolution below 1024x768. The solution is to press alt-enter and set your"@
							" drop items in windowed mode.");
	NewOpts::registerHelp("MT Favourites", "Auto mount", "The last combo box is used to select what weapon will"@
							" be automatically mounted when you leave the inventory station. It only shows the"@
							" weapons that you have choosen for the selected favourite, so you can't choose to"@
							" mount a mortar for a light favourite for example.");
	NewOpts::register("MT Favourites", "MT\\gui\\MTPack\\MTFavourites.gui", "MT::optionGuiInit();", "", true);
}

//===============================================================
// Set up some stuff before doing a "litterbug"
//===============================================================
function MT::prepareLitterbug (%fav)
{
	%item=$MT::Item::[$throwItem::[%fav, item1]+10];
	%category=MT::buyArmour (%fav, 1, %item);

	$MT::thrown=0;
	$MT::turn=0.02;
	$MT::doLitterbug=true;
	MT::postBuy (%fav, true);
	MT::litterbug (%fav, %category);
}

//===============================================================
// Meant to return you to the centre after doing a litterbug, but
// it gets it wrong sometimes. Oh well, doesn't bother me :P
//===============================================================
function MT::returnToCentre ()
{
	%rmd=$MT::thrown%10;
	%dir=floor ($MT::thrown/10);
	if ((%dir&1)==0)
		$MT::turn*=-1;
	postAction(2048, IDACTION_YAW, $MT::turn*%rmd);
}

//===============================================================
// takes care of buying the correct favourite. Was an issue with
// long litterbugs, you'd walk away with the wrong favourite
//===============================================================
function MT::postBuy (%fav, %delay)
{
	if (%delay)
		$MT::delay=true;

	if (%fav==-1)
		{
		MT::buyFavourites ($MT::buyPending);
		$MT::delay=false;
		}
	else if ($MT::delay)
		$MT::buyPending=%fav;
	else if (%fav!="")
		{
		MT::buyFavourites (%fav);
		$MT::delay=false;
		}
	else
		return false;
}

//===============================================================
// Do the the litterbug thing
//===============================================================
function MT::litterbug (%fav, %category)
{
	if ($MT::doLitterbug && !MT::anyMoveKeyPressed ())
		{
		$MT::thrown++;
		%temp1=$MT::thrown/10;
		%temp2=floor (%temp1);
		if (%temp1==%temp2)
			{
			if (%temp2&1)
				$MT::turn*=-1;
			}
		%str="postAction(2048, IDACTION_YAW, "@$MT::turn@");remoteEval (2048, buyItem, "@$throwItem::[%fav, item1]+10@");drop (\""@%category@"\");";
		eval (%str);
		schedule ("MT::litterbug ("@%fav@", \""@%category@"\");", 0.1);
		}
	else
		{
		MT::returnToCentre ();
		schedule ("MT::postBuy (\"-1\");", 0.3+(floor($MT::thrown/10)*0.1));
		$MT::doLitterbug=false;		
		}
}

//===============================================================
// Figures out whether to do a drop group or a litterbug
//===============================================================
function MT::throwChooser (%fav)
{
	CmdInventoryGui::favoritesSel (%fav);
	if (match::string ($inventoryDrop::[%fav], "-1"))
		return;

	if ($MT::curFavourites=="")
		$MT::curFavourites=$curFavorites;

	if ($MT::throwType[%fav]=="group")
		schedule ("MT::buyAndDrop ("@%fav@", 1);", 0.2);
	else if ($MT::throwType[%fav]=="continuous")
		MT::prepareLitterbug (%fav);
	else
		MT::InvStatGuiOpen_ ();
//		return false;
}

//===============================================================
// Stops litterbug
//===============================================================
function MT::cancelLitterbug (%fav)
{
	$MT::doLitterbug=false;
}

//===============================================================
// Mute the movement buttons
//===============================================================
function MT::muteMoveButtons ()
{
	action::mute (forwardPressed,true);
	action::mute (backPressed,true);
	action::mute (moveLeftPressed,true);
	action::mute (moveRightPressed,true);
	action::mute (jumpPressed,true);
	action::mute (jumpReleased,true);
	action::mute (jetPressed,true);
}

//===============================================================
// Unmute the movement buttons
//===============================================================
function MT::releaseMoveButtons ()
{
	action::mute (forwardPressed,false);
	action::mute (backPressed,false);
	action::mute (moveLeftPressed,false);
	action::mute (moveRightPressed,false);
	action::mute (jumpPressed,false);
	action::mute (jumpReleased,false);
	action::mute (jetPressed,false);
}

//===============================================================
// Determine whether any of the movement keys is currently
// depressed
//===============================================================
function MT::anyMoveKeyPressed ()
{
	if ($MT::forwardPressed||$MT::backPressed||$MT::moveLeftPressed||$MT::moveRightPressed||$MT::jumpPressed||$MT::jetPressed)
		return true;
	else
		return false;
}

//===============================================================
// Sell off all the weapons
//===============================================================
function MT::sellWeapons ()
{
	%str="sell (\"Plasma Gun\");sell (\"Chaingun\");sell (\"Disc Launcher\");sell (\"Grenade Launcher\");sell (\"Laser Rifle\");sell (\"Elf Gun\");sell (\"Mortar\");sell (\"Blaster\");";
	eval (%str);
}

//===============================================================
// Set the text for the favourites preselect hud
//===============================================================
function MT::setFavourite (%fav)
{
	$curFavorites=%fav;
	if ($MT::enableFavsHud)
			control::setValue (MTTextFavPreselect, "<jc><f2> "@$MT::favouriteName[$curFavorites]);
	else
			remoteBP(2048, "<jc><f2> "@$MT::favouriteName[$curFavorites], 4);
}

//===============================================================
// Chops up the strings stored in the MTFavourites.cs file into
// something more useful, although not as pretty :P
//===============================================================
function MT::setupFavs ()
{
	for (%i=1;%i<19;%i++)
		{
		$throwItem::[%i, amount1]=getWord ($inventoryDrop::[%i], 0);
		$throwItem::[%i, amount2]=getWord ($inventoryDrop::[%i], 1);
		$throwItem::[%i, amount3]=getWord ($inventoryDrop::[%i], 2);
		$throwItem::[%i, item1]=getWord ($inventoryDrop::[%i], 3);
		$throwItem::[%i, item2]=getWord ($inventoryDrop::[%i], 4);
		$throwItem::[%i, item3]=getWord ($inventoryDrop::[%i], 5);
		$MT::throwType[%i]=getWord ($inventoryDrop::[%i], 6);
		$throwItem::[%i, weapon]=getWord ($inventoryDrop::[%i], 7);
		}
}

//===============================================================
// Initialisation function for the NewOpts page
//===============================================================
function MT::optionGuiInit ()
{
	if ($MT::optionGuiInit)
		{
		control::setvalue (MTBackground, "<b47,38:mt\\bmps\\MTPack\\MTPack_background.bmp>");
		FGCombo::clear(MT_mod_favs);
		FGCombo::clear(MT_favs_chooser);
		FGCombo::clear(MT_droptype_chooser);
		FGCombo::clear(MT_item1_fav);
		FGCombo::clear(MT_item2_fav);
		FGCombo::clear(MT_item3_fav);
		FGCombo::clear(MT_weapon_fav);
	
		for (%i=1;%i<=19;%i++)
			FGCombo::addEntry(MT_favs_chooser, $MT::favouriteName[%i], %i);
		FGCombo::setSelected(MT_favs_chooser, 1);
	
		FGCombo::addEntry(MT_droptype_chooser, "Drop group", 1);
		FGCombo::addEntry(MT_droptype_chooser, "Litterbug", 2);
		FGCombo::addEntry(MT_droptype_chooser, "Ordinary", 3);

		for (%i=11;%i<=42;%i++)
			{
			%item=MT::getItemName($MT::Item::[%i]);
			FGCombo::addEntry(MT_item1_fav, %item, %i-10);
			FGCombo::addEntry(MT_item2_fav, %item, %i-10);
			FGCombo::addEntry(MT_item3_fav, %item, %i-10);
			}
		for (%i=1;%i<=19;%i++)
			control::setPosition ("MT_preselect_fav"@%i, 300, 151);
		}
	$MT::optionGuiInit=false;
	MT::handleFav ();
}

//===============================================================
// The Favourites Combo box handler
//===============================================================
function MT::handleFav ()
{
	%MT::dropChoice["Drop group"]=1;
	%MT::dropChoice["Litterbug"]=2;
	%MT::dropChoice["Ordinary"]=3;

	FGCombo::clear(MT_weapon_fav);
	%fav=FGCombo::getSelected(MT_favs_chooser);
	%favslist=$pref::favoriteList[%fav @ $ServerFavoritesKey];

	$MT::litterbug=$MT::litterbug[%fav];
	$MT::ordinary=$MT::ordinary[%fav];
	$MT::dropGroup=$MT::dropGroup[%fav];

	//110, 125
	control::setValue (MT_preselect_text, "<f2>Key used to preselect\n favourite "@%fav);
	FGCombo::setSelected(MT_droptype_chooser, %MT::dropChoice[$MT::throwType[1]]);
	FGCombo::setSelected(MT_item1_fav, $throwItem::[%fav, item1]);
	FGCombo::setSelected(MT_item2_fav, $throwItem::[%fav, item2]);
	FGCombo::setSelected(MT_item3_fav, $throwItem::[%fav, item3]);
	control::setText (MT_item1_amount, $throwItem::[%fav, amount1]);
	control::setText (MT_item2_amount, $throwItem::[%fav, amount2]);
	control::setText (MT_item3_amount, $throwItem::[%fav, amount3]);
	control::setActive (MT_item1_amount, ($throwItem::[%fav, amount1]>0));
	control::setActive (MT_item2_amount, ($throwItem::[%fav, amount2]>0));
	control::setActive (MT_item3_amount, ($throwItem::[%fav, amount3]>0));
	for (%i=1;%i<=7;%i++)
		{
		%weapon=getWord (%favslist, %i);
		%name=MT::getItemName($MT::Item::[%weapon]);
		if (%weapon<=24)
			FGCombo::addEntry(MT_weapon_fav, %name, %weapon);
		else %i=8;
		}

	for (%i=1;%i<=19;%i++)
		control::setPosition ("MT_preselect_fav"@%i, 300, 300);
	control::setPosition ("MT_preselect_fav"@%fav, 20, 125);

	if ($MT::throwType[%fav]=="group")
		{
		FGCombo::setSelected(MT_droptype_chooser, 1);
		MT::handleGrpFav();
		}
	else if ($MT::throwType[%fav]=="continuous")
		{
		FGCombo::setSelected(MT_droptype_chooser, 2);
		MT::handleLitFav();
		}
	else
		{
		FGCombo::setSelected(MT_droptype_chooser, 3);
		MT::handleOrdFav();
		}
	MT::handleDropChooser();
	MT::handleItem (1);
	MT::handleItem (2);
	MT::handleItem (3);

	if (($throwItem::[%fav, weapon]!="" && match::string (%favslist, "*"@$throwItem::[%fav, weapon]@"*")) ||
			($throwItem::[%fav, weapon]=getWord (%favslist, 1))<=24
		)
		FGCombo::setSelected(MT_weapon_fav, $throwItem::[%fav, weapon]);

	MT::handleWeapon();
	if (%fav==19)
		{
		control::setActive (MT_ord_fav, false);
		control::setActive (MT_litterbug_fav, false);
		control::setActive (MT_dropgroup_fav, false);
		control::setActive (MT_weapon_fav, false);
		}
	else
		{
		control::setActive (MT_ord_fav, true);
		control::setActive (MT_litterbug_fav, true);
		control::setActive (MT_dropgroup_fav, true);
		control::setActive (MT_weapon_fav, true);
		}
}

//===============================================================
// The sets a whole bunch of stuff for the choosen item
//===============================================================
function MT::handleItem (%index)
{
	%fav=FGCombo::getSelected(MT_favs_chooser);
	%item=FGCombo::getSelected("MT_item"@%index@"_fav");
	$throwItem::[%fav, "item"@%index]=%item;
	if ($MT::throwType[%fav]!="continuous")
		{
		if (%item==16)
			{
			$throwItem::[%fav, "amount"@%index]=0;
			control::setText ("MT_item"@%index@"_amount", 0);
			control::setActive ("MT_item"@%index@"_amount", false);
			}
		else
			{
			if ($throwItem::[%fav, "amount"@%index]==0)
				$throwItem::[%fav, "amount"@%index]=1;
			control::setActive ("MT_item"@%index@"_amount", true);
			control::setText ("MT_item"@%index@"_amount", $throwItem::[%fav, "amount"@%index]);
			}
		}
	else
		{
		$throwItem::[%fav, "amount"@%index]=0;
		control::setText ("MT_item"@%index@"_amount", 0);
		control::setActive ("MT_item"@%index@"_amount", false);
		if (%item==15)
			{
			%item=16;
			FGCombo::setSelected ("MT_item"@%index@"_fav", 16);
			MT::handleItem (%index);
			return;
			}
		}
}
//157, 130
//MT::handleDropChooser();
//MT_droptype_chooser

//===============================================================
// 
//===============================================================
function MT::handleDropChooser()
{
	%sel=FGCombo::getSelected(MT_droptype_chooser);
	if (%sel==1)
		MT::handleGrpFav();
	else if (%sel==2)
		MT::handleLitFav();
	else if (%sel==3)
		MT::handleOrdFav();
}

//===============================================================
// Handles choosing an ordinary favourite - disables stuff etc
//===============================================================
function MT::handleOrdFav()
{
	%fav=FGCombo::getSelected(MT_favs_chooser);

	schedule ("$MT::ordinary=$MT::ordinary[%fav]=true;", 0.3);
	$MT::dropGroup=$MT::dropGroup[%fav]=$MT::litterbug=$MT::litterbug[%fav]=false;
	$throwItem::[%fav, item1]=16;
	$throwItem::[%fav, item2]=16;
	$throwItem::[%fav, item3]=16;

	$MT::throwType[%fav]="ordinary";

	FGCombo::setSelected(MT_item1_fav, 16);
	FGCombo::setSelected(MT_item2_fav, 16);
	FGCombo::setSelected(MT_item3_fav, 16);

	control::setActive (MT_item1_fav, false);
	control::setActive (MT_item2_fav, false);
	control::setActive (MT_item3_fav, false);

	control::setText (MT_item1_amount, 0);
	control::setText (MT_item2_amount, 0);
	control::setText (MT_item3_amount, 0);

	control::setActive (MT_item1_amount, false);
	control::setActive (MT_item2_amount, false);
	control::setActive (MT_item3_amount, false);
}

//===============================================================
// disables/enables stuff for choosing a litterbug type
//===============================================================
function MT::handleLitFav()
{
	%fav=FGCombo::getSelected(MT_favs_chooser);

	schedule ("$MT::litterbug=$MT::litterbug[%fav]=true;", 0.3);
	$MT::ordinary=$MT::ordinary[%fav]=$MT::dropGroup=$MT::dropGroup[%fav]=false;
	$throwItem::[%fav, item1]=16;
	$throwItem::[%fav, item3]=16;

	$MT::throwType[%fav]="continuous";

	FGCombo::setSelected(MT_item2_fav, 16);
	FGCombo::setSelected(MT_item3_fav, 16);

	control::setActive (MT_item1_fav, true);
	control::setActive (MT_item2_fav, false);
	control::setActive (MT_item3_fav, false);

	control::setText (MT_item1_amount, 0);
	control::setText (MT_item2_amount, 0);
	control::setText (MT_item3_amount, 0);

	control::setActive (MT_item1_amount, false);
	control::setActive (MT_item2_amount, false);
	control::setActive (MT_item3_amount, false);

	MT::handleItem (1);
	MT::handleItem (2);
	MT::handleItem (3);
}

//===============================================================
// Enables stuff for handling a drop group type favourite
//===============================================================
function MT::handleGrpFav()
{
	%fav=FGCombo::getSelected(MT_favs_chooser);

	schedule ("$MT::dropGroup=$MT::dropGroup[%fav]=true;", 0.3);
	$MT::ordinary=$MT::ordinary[%fav]=$MT::litterbug=$MT::litterbug[%fav]=false;
	$throwItem::[%fav, item1]=16;
	$throwItem::[%fav, item2]=16;

	$MT::throwType[%fav]="group";

	control::setActive (MT_item1_fav, true);
	control::setActive (MT_item2_fav, true);
	control::setActive (MT_item3_fav, true);

	control::setActive (MT_item1_amount, true);
	control::setActive (MT_item2_amount, true);
	control::setActive (MT_item3_amount, true);

	MT::handleItem (1);
	MT::handleItem (2);
	MT::handleItem (3);
}

//===============================================================
// gets the amount of an item to throw
//===============================================================
function MT::handleItemAmount(%index)
{
	%fav=FGCombo::getSelected(MT_favs_chooser);
	%item=control::getText("MT_item"@%index@"_amount");
	if (%item>5)
		%item=5;
	else if (%item<0)
		%item=0;

	$throwItem::[%fav, "amount"@%index]=%item;
}

//===============================================================
// Handles which weapon will be mounted when exiting the
// inventory station
//===============================================================
function MT::handleWeapon()
{
	%fav=FGCombo::getSelected(MT_favs_chooser);
	$throwItem::[%fav, weapon]=FGCombo::getSelected(MT_weapon_fav);
}

//===============================================================
// Handles the mod combo box
//===============================================================
function MT::chooseMod()
{

}

//===============================================================
// sets the correct key maps for the play gui
//===============================================================

function MT::pushActionMap (%gui)
{
	if (%gui==playGui)
		schedule ("pushActionMap(\"MTsetFavsMap.sae\"); popActionMap(\"MTInventMap.sae\");", 0.2);
}

//===============================================================
// extracts the name of the item from the string
//===============================================================
function MT::getItemName (%item)
{
	if (match::paramString (%item, "%n# %t"))
		%name=match::result(n);
	return %name;
}

//===============================================================
// Stuff executed at start up
//===============================================================

//If people bind their movement keys in Writers scripts, that can
//really screw things up. So this is here to get people to set
//their keys in the Options screen, where both mine AND Writers
//scripts will work (see WriterCompat.cs for more information
//on compatibility between the two sets of scripts).
if ($Enabled["writer\\move.cs"]==true)
	{
		function ForwardPressed()
		{
		    remoteBP(2048, "Please set your movement keys in the Options screen\n\nWriters scripts will continue to function perfectly even with your keys set in the Options screen", 10);
		}
		
		function BackPressed()
		{
		    remoteBP(2048, "Please set your movement keys in the Options screen\n\nWriters scripts will continue to function perfectly even with your keys set in the Options screen", 10);
		}
		
		function LeftPressed()
		{
		    remoteBP(2048, "Please set your movement keys in the Options screen\n\nWriters scripts will continue to function perfectly even with your keys set in the Options screen", 10);
		}
		
		function RightPressed()
		{
		    remoteBP(2048, "Please set your movement keys in the Options screen\n\nWriters scripts will continue to function perfectly even with your keys set in the Options screen", 10);
		}
	}

//Unfortunately, Fast Favs and my Quick Favs are 100% incompatible. So to make sure nothing strange
//happens, I have to override Writers Fast Favs.
if($Enabled["writer\\fast_favorites.cs"])
{
	function FastFaves::DropPackHoldKeyPressed()
	{}
	function FastFaves::DropPackHoldKeyReleased()
	{}
	function FastFaves::DropPackToggleKeyPressed()
	{}
	function FastFavorites()
	{}
	function FastFaves::doKey()
	{}
	function FastFaves::redoKey()
	{}
	function FastFaves::ScheduleLoop()
	{}
	function FastFaves::ladderClientMessage()
	{}
	function FastFaves::BuyArmor()
	{}
	function FastFaves::BuyPack()
	{}
	function FastFaves::BuyWeapon()
	{}
	function FastFaves::BuyExtra()
	{}
	function FastFaves::BuyVehicle()
	{}
	function FastFaves::BuyLoadout()
	{}
	function FastFaves::PreloadMessage()
	{}
	function FastFaves::LoadoutMessage()
	{}
	function FastFaves::ShowWeaponsToggle()
	{}
	function FastFaves::weaponList()
	{}
	function FastFaves::actualArmor()
	{}
	function FastFaves::actualPack()
	{}
	function FastFaves::actualWeapons()
	{}
	function FastFaves::VerifyLoadout()
	{}
	function FastFaves::AutoBuy()
	{}
	function FastFaves::DropPack()
	{}
	function FastFaves::AutoMount()
	{}
	function FastFaves::AutoBuyToggle()
	{}
	function FastFaves::AutoBuyVehicleToggle()
	{}
	function FastFaves::onGuiOpen()
	{}
	function FastFaves::NoPackOnExitWarning()
	{}
	function FastFaves::bindKey()
	{}
	function fast_favorites::init()
	{}
	function fast_favorites::exit()
	{
	    Event::Detach(eventFavoritesInitialized, "schedule::add(\"FastFavorites($FastFaves::defaultModifier, $FastFaves::defaultKey);\", 4);");
	    Event::Detach(eventInventoryTableReady, "FastFaves::setupFavorites();");
	    Event::Detach(eventEnterStation, "$FastFaves::Loop = true; FastFaves::ScheduleLoop();");
	    Event::Detach(eventExitStation, "$FastFaves::Loop = $FastFaves::Handling = false; Queue::flush(FastFavesModifier); Queue::flush(FastFavesKey);");
	    Event::Detach(eventConnected, "$FastFaves::Loop = $FastFaves::Handling = false; $FastFaves::PingID = 0;");
	    Event::Detach(eventChangeMission, "$FastFaves::Loop = $FastFaves::Handling = false; $FastFaves::PingID = 0;");
	    Event::Detach(eventExitStation, "remoteBP(2048, \"\");");
	    Event::Detach(ladderClientMessage, FastFaves::ladderClientMessage);
	    Event::Detach(eventEnterStation, "FastFaves::AutoBuy();");
	    Event::Detach(eventBeforeFFAutoBuy, "FastFaves::DropPack();");
	    Event::Detach(eventExitStation, "FastFaves::AutoMount();");
	    Event::Detach(eventGuiOpen, FastFaves::onGuiOpen);
	    Event::Detach("event" @ $FastFaves::DropPackHoldKey @ "Pressed", "FastFaves::DropPackHoldKeyPressed();");
	    Event::Detach("event" @ $FastFaves::DropPackHoldKey @ "Released", "FastFaves::DropPackHoldKeyReleased();");
	    Event::Detach(eventExitStation, "FastFaves::NoPackOnExitWarning();");
	    Event::Detach(eventExitStation, "schedule(\"FastFaves::NoPackOnExitWarning();\", 0.8);");
	    Event::Detach(eventExitStation, "cursorOff(MainWindow);schedule::add(\"cursorOff(MainWindow);\", 1);");
	    Event::Detach(eventEnterStation, "schedule::cancel(\"cursorOff(MainWindow);\");");
	}
	fast_favorites::exit();
}

//Likewise with keep_moving. It rebinds the movement keys on the fly, a no no if Quick
//Favs is to work properly
if($Enabled["writer\\keep_moving.cs"])
{
	function KeepMoving::onPilotModeOn()
	{}
	function KeepMoving::onPilotModeOff()
	{}
	function KeepMoving::Toggle(%on, %quiet)
	{}
	function keep_moving::init()
	{}
    Event::detach(eventPilotModeOn, "KeepMoving::onPilotModeOn();");
    Event::detach(eventPilotModeOff, "KeepMoving::onPilotModeOff();");
}

$MT::delay=false;
$MT::favPreselectHud=true;
$MT::atVehicleStation=false;
$MT::optionGuiInit=true;
$pref::noEnterInvStation=true;
$pref::favoriteList19="";
$curFavorites=19;
$PrestoPref::CamHudTurnAround=false;

event::attach (eventInvStationOpen,	MT::InvStatGuiOpen_);
event::attach (eventGuiOpen,		MT::FavPreselectHud, %gui);
event::attach (eventInvStationClose, MT::invStationClosed, %gui);
event::attach (eventGuiClose,		MT::releaseMoveButtons);
event::attach (eventGuiOpen,		MT::pushActionMap, %gui);

action::attach::pre (buyFavouritePressed,	MT::throwChooser, %fav);
action::attach (buyFavouriteReleased,		MT::cancelLitterbug, %fav);

MT::setupFavs ();
NGS::register (FavPreselect);
MT::registerWithNewOpts ();

//string layout "Item# armours"
//armours - 2=light, 3=medium, 4=heavy
$MT::Item::[11]="Blaster# 2 3 4";
$MT::Item::[12]="Bullet# 2 3 4";
$MT::Item::[13]="Chaingun# 2 3 4";
$MT::Item::[14]="Plasma Bolt# 2 3 4";
$MT::Item::[15]="Plasma Gun# 2 3 4";
$MT::Item::[16]="Grenade Ammo# 2 3 4";
$MT::Item::[17]="Grenade Launcher# 2 3 4";
$MT::Item::[18]="Mortar Ammo# 2 3 4";
$MT::Item::[19]="Mortar# 4";
$MT::Item::[20]="Disc# 2 3 4";
$MT::Item::[21]="Disc Launcher# 2 3 4";
$MT::Item::[22]="Laser Rifle# 2";
$MT::Item::[23]="Targeting Laser# 2 3 4";
$MT::Item::[24]="ELF Gun# 2 3 4";
$MT::Item::[25]="<Favourite># 2 3 4";
$MT::Item::[26]="<NONE># 2 3 4";
$MT::Item::[27]="Inventory Station# 3 4";
$MT::Item::[28]="Ammo Station# 3 4";
$MT::Item::[29]="Energy Pack# 2 3 4";
$MT::Item::[30]="Repair Pack# 2 3 4";
$MT::Item::[31]="Shield Pack# 2 3 4";
$MT::Item::[32]="Sensor Jammer Pack# 2 3 4";
$MT::Item::[33]="Motion Sensor# 2 3 4";
$MT::Item::[34]="Ammo Pack# 2 3 4";
$MT::Item::[35]="Pulse Sensor# 2 3 4";
$MT::Item::[36]="Sensor Jammer# 2 3 4";
$MT::Item::[37]="Camera# 2 3 4";
$MT::Item::[38]="Turret# 3 4";
$MT::Item::[39]="Repair Kit# 2 3 4";
$MT::Item::[40]="Mine# 2 3 4";
$MT::Item::[41]="Grenade# 2 3 4";
$MT::Item::[42]="Beacon# 2 3 4";

include ("MT\\InventoryStation.cs");

