//=======================================================================================
// This file initialises the actions that are triggered when a key is pressed or released
//=======================================================================================
action::initPressed ("ItemSelect", -1, "use(%p0);");

action::initPressed ("BuyFavouritePressed", -1, "CmdInventoryGui::buyFavorites(%p0);");
action::initReleased ("BuyFavouriteReleased", "null();");

// The 3 screens that are used in game
action::initPressed ("inventoryPressed", -1, "remoteEval(2048, ToggleInventoryMode);");
action::initReleased ("inventoryReleased", "null();");

action::initPressed ("objectivesPressed", -1, "remoteEval(2048, ToggleObjectivesMode);");
action::initReleased ("objectivesReleased", "null();");

action::initPressed ("commanderPressed", -1, "remoteEval(2048, ToggleCommandMode);");
action::initReleased ("commanderReleased", "null();");

// Movement keys
// NOTE the movement, jet, jump and fire are very sensitive to any delays between the key
// press and the actual action being triggered. That is why there is a limit on the
// number of functions that can be attached to their pre-action queues
action::initPressed ("forwardPressed", 0, "postAction(2048, IDACTION_MOVEFORWARD, 1.0);");
action::initReleased ("forwardReleased", "postAction(2048, IDACTION_MOVEFORWARD, 0.0);");

action::initPressed ("backPressed", 0, "postAction(2048, IDACTION_MOVEBACK, 1.0);");
action::initReleased ("backReleased", "postAction(2048, IDACTION_MOVEBACK, 0.0);");

action::initPressed ("moveLeftPressed", 0, "postAction(2048, IDACTION_MOVELEFT, 1.0);");
action::initReleased ("moveLeftReleased", "postAction(2048, IDACTION_MOVELEFT, 0.0);");

action::initPressed ("moveRightPressed", 0, "postAction(2048, IDACTION_MOVERIGHT, 1.0);");
action::initReleased ("moveRightReleased", "postAction(2048, IDACTION_MOVERIGHT, 0.0);");

action::initPressed ("jumpPressed", 0, "postAction (2048, IDACTION_MOVEUP, 1.0);");
action::initReleased ("jumpReleased", "null();");

action::initPressed ("jetPressed", 0, "postAction(2048, IDACTION_JET, 1.0);");
action::initReleased ("jetReleased", "postAction(2048, IDACTION_JET, 0.0);");

action::initPressed ("turnLeftPressed", -1, "postAction(2048, IDACTION_TURNLEFT, 0.10);");
action::initReleased ("turnLeftReleased", "postAction(2048, IDACTION_TURNLEFT, 0.0);");

action::initPressed ("turnRightPressed", -1, "postAction(2048, IDACTION_TURNRIGHT, 0.10);");
action::initReleased ("turnRightReleased", "postAction(2048, IDACTION_TURNRIGHT, 0.0);");

action::initPressed ("lookUpPressed", -1, "postAction(2048, IDACTION_LOOKUP, 0.10);");
action::initReleased ("lookUpReleased", "postAction(2048, IDACTION_LOOKUP, 0.0);");

action::initPressed ("lookDownPressed", -1, "postAction(2048, IDACTION_LOOKDOWN, 0.10);");
action::initReleased ("lookDownReleased", "postAction(2048, IDACTION_LOOKDOWN, 0.0);");

action::initPressed ("crouchPressed", -1, "postAction(2048, IDACTION_CROUCH, 1.0);");
action::initReleased ("crouchReleased", "postAction(2048, IDACTION_STAND, 1.0);");

action::initPressed ("freeLookPressed", -1, "setFreeLook(TRUE);");
action::initReleased ("freeLookReleased", "setFreeLook(FALSE);");

action::initPressed ("centerViewPressed", -1, "postAction(2048, IDACTION_CENTERVIEW, 1.0);");
action::initReleased ("centerViewReleased", "null();");

action::initPressed ("chatMenuPressed", -1, "setCMMode(PlayChatMenu, 2);");
action::initReleased ("chatMenuReleased", "null();");

action::initPressed ("commandAcknowledgedPressed", -1, "commandAck();");
action::initReleased ("commandAcknowledgedReleased", "null();");

action::initPressed ("commandDeclinedPressed", -1, "commandDeclined();");
action::initReleased ("commandDeclinedReleased", "null();");

action::initPressed ("commandCompletedPressed", -1, "commandCompleted();");
action::initReleased ("commandCompletedReleased", "null();");

action::initPressed ("zoomPressed", -1, "postAction(2048, IDACTION_SNIPER_FOV, 1);");
action::initReleased ("zoomReleased", "postAction(2048, IDACTION_SNIPER_FOV, 0);");

action::initPressed ("zoomMagnificationPressed", -1, "postAction(2048, IDACTION_INC_SNIPER_FOV, 1);");
action::initReleased ("zoomMagnificationReleased", "null();");

action::initPressed ("firstThirdViewPressed", -1, "postAction(2048, IDACTION_VIEW, 0);");
action::initReleased ("firstThirdViewReleased", "null();");

action::initPressed ("dropFlagPressed", -1, "drop(Flag);");
action::initReleased ("dropFlagReleased", "null();");

action::initPressed ("playModePressed", -1, "remoteEval(2048, PlayMode);");
action::initReleased ("playModeReleased", "null();");

action::initPressed ("killPressed", -1, "kill();");
action::initReleased ("killReleased", "null();");

//the weapons
action::initPressed ("useBlasterPressed", -1, "use(Blaster);");
action::initReleased ("useBlasterReleased", "null();");

action::initPressed ("usePlasmaGunPressed", -1, "use(\"Plasma Gun\");");
action::initReleased ("usePlasmaGunReleased", "null();");

action::initPressed ("useDiscLauncherPressed", -1, "use(\"Disc Launcher\");");
action::initReleased ("useDiscLauncherReleased", "null();");

action::initPressed ("useChaingunPressed", -1, "use(Chaingun);");
action::initReleased ("useChaingunReleased", "null();");

action::initPressed ("useGrenadeLauncherPressed", -1, "use(\"Grenade Launcher\");");
action::initReleased ("useGrenadeLauncherReleased", "null();");

action::initPressed ("useLaserRiflePressed", -1, "use(\"Laser Rifle\");");
action::initReleased ("useLaserRifleReleased", "null();");

action::initPressed ("useELFGunPressed", -1, "use(\"ELF Gun\");");
action::initReleased ("useELFGunReleased", "null();");

action::initPressed ("useTargetingLaserPressed", -1, "use(\"Targeting Laser\");");
action::initReleased ("useTargetingLaserReleased", "null();");

action::initPressed ("useMortarPressed", -1, "use(Mortar);");
action::initReleased ("useMortarReleased", "null();");

action::initPressed ("useRepairKitPressed", -1, "use(\"Repair Kit\");");
action::initReleased ("useRepairKitReleased", "null();");

//other stuff
action::initPressed ("throwMinePressed", -1, "throwStart();");
action::initReleased ("throwMineReleased", "throwRelease(\"Mine\");");

action::initPressed ("throwGrenadePressed", -1, "throwStart();");
action::initReleased ("throwGrenadeReleased", "throwRelease(\"Grenade\");");

action::initPressed ("prevWeaponPressed", -1, "prevWeapon();");
action::initReleased ("prevWeaponReleased", "null();");

action::initPressed ("nextWeaponPressed", -1, "nextWeapon();");
action::initReleased ("nextWeaponReleased", "null();");

//fire
action::initPressed ("firePressed", -1, "postAction(2048, IDACTION_FIRE1, 1);");
action::initReleased ("fireReleased", "postAction(2048, IDACTION_BREAK1, 1);");

action::initPressed ("useBackpackPressed", -1, "use(\"Backpack\");");
action::initReleased ("useBackpackReleased", "null();");

action::initPressed ("useBeaconPressed", -1, "use(Beacon);");
action::initReleased ("useBeaconReleased", "null();");

action::initPressed ("dropWeaponPressed", -1, "drop(Weapon);");
action::initReleased ("dropWeaponReleased", "null();");

action::initPressed ("dropAmmoPressed", -1, "drop(Ammo);");
action::initReleased ("dropAmmoReleased", "null();");

action::initPressed ("dropBackPackPressed", -1, "drop(BackPack);");
action::initReleased ("dropBackPackReleased", "null();");

action::initPressed ("useRepairKitPressed", -1, "use(\"Repair Kit\");");
action::initReleased ("useRepairKitReleased", "null();");

action::initPressed ("voteYesPressed", -1, "voteYes();");
action::initReleased ("voteYesReleased", "null();");

action::initPressed ("voteNoPressed", -1, "voteNo();");
action::initReleased ("voteNoReleased", "null();");

action::initPressed ("targetClientPressed", -1, "targetClient();");
action::initReleased ("targetClientReleased", "null();");

//These five are special. I have not been able to trigger them from script
//so it is not possible to catch the key press AND trigger the action as
//well. Bummer.
action::initReleased ("toggleMessageSizeReleased", "null();");

action::initReleased ("hudConfigReleased", "null();");

action::initReleased ("scoreListReleased", "null();");

action::initReleased ("teamChatReleased", "null();");

action::initReleased ("gameChatReleased", "null();");

//===============================================================
// Set a few globals so we can tell when certain keys are pressed
// Note that they are attached to the post-action queues and may
// not be accurate for functions attached to the pre-action
// queues
//===============================================================

action::attach (forwardPressed,"$MT::forwardPressed=true;");
action::attach (forwardReleased,"$MT::forwardPressed=false;");

action::attach (backPressed,"$MT::backPressed=true;");
action::attach (backReleased,"$MT::backPressed=false;");

action::attach (moveLeftPressed,"$MT::moveLeftPressed=true;");
action::attach (moveLeftReleased,"$MT::moveLeftPressed=false;");

action::attach (moveRightPressed,"$MT::moveRightPressed=true;");
action::attach (moveRightReleased,"$MT::moveRightPressed=false;");

action::attach (jumpPressed,"$MT::jumpPressed=true;");
action::attach (jumpReleased,"$MT::jumpPressed=false;");

action::attach (jetPressed,"$MT::jetPressed=true;");
action::attach (jetReleased,"$MT::jetPressed=false;");
