//=======================================================================================
// Makes the OptionGui and action.cs compatible with Writers scripts - fire.cs
//=======================================================================================
if ($Enabled["writer\\fire.cs"]==true)
	{
	function WCompat::firePressed()
		{
	    %weapon = getMountedItem(0);
	    event::trigger(eventFirePressed, %weapon); // %weapon will be -1 if no weapon mounted
	    action::mute (firePressed, Event::Returned(eventFirePressed, mute));
		schedule ("action::completed (firePressed);", 0.0);
		}
	
	function WCompat::weaponFired ()
		{
	    if(!$action::[mute, FirePressed])
	        event::trigger(eventWeaponFired, %weapon);
		}
	
	function WCompat::fireReleased()
		{
	    %weapon = getMountedItem(0);
	    event::trigger(eventFirePressed, %weapon); // %weapon will be -1 if no weapon mounted
	    action::mute (fireReleased, Event::Returned(eventFirePressed, mute));
	    if(!$action::[mute, fireReleased])
	        event::trigger(eventWeaponFired, %weapon);
		}
	
	action::overRideLimitOnPre (firePressed);
	action::attach::pre (firePressed, WCompat::firePressed);
	action::attach (firePressed, WCompat::weaponFired);
	action::attach (fireReleased, WCompat::fireReleased);
	}

//=======================================================================================
// Makes the OptionGui and action.cs compatible with Writers scripts - jet.cs
//=======================================================================================
if ($Enabled["writer\\jet.cs"]==true)
	{
	function WCompat::jetPressed()
		{
	    event::trigger(eventjetPressed);
	    action::mute (jetPressed, Event::Returned(eventjetPressed, mute));
		schedule ("action::completed (jetPressed);", 0.0);
		}
	
	function WCompat::weaponjetd ()
		{
	    if(!$action::[mute, jetPressed])
	        event::trigger(eventJetsStarted, %weapon);
		}
	
	function WCompat::jetReleased()
		{
	    event::trigger(eventjetPressed);
	    action::mute (jetReleased, Event::Returned(eventjetPressed, mute));
	    if(!$action::[mute, jetReleased])
	        event::trigger(eventJetsStopped, %weapon);
		}
	
	action::overRideLimitOnPre (jetPressed);
	action::attach::pre (jetPressed, WCompat::jetPressed);
	action::attach (jetPressed, WCompat::weaponjetd);
	action::attach (jetReleased, WCompat::jetReleased);
	}

//=======================================================================================
// Makes the OptionGui and action.cs compatible with Writers scripts - move.cs
//=======================================================================================
if ($Enabled["writer\\move.cs"]==true)
	{
	function WCompat::forwardPressed()
		{
	    event::trigger(eventforwardPressed);
	    action::mute (forwardPressed, Event::Returned(eventforwardPressed, mute));
		schedule ("action::completed (forwardPressed);", 0.0);
		}
	
	function WCompat::movedForward ()
		{
	    if(!$action::[mute, forwardPressed])
	        event::trigger(eventForwardStarted, %weapon);
		}
	
	function WCompat::forwardReleased()
		{
	    event::trigger(eventforwardPressed);
	    action::mute (forwardReleased, Event::Returned(eventforwardPressed, mute));
	    if(!$action::[mute, forwardReleased])
	        event::trigger(eventForwardStopped, %weapon);
		}
	
	action::overRideLimitOnPre (forwardPressed);
	action::attach::pre (forwardPressed, WCompat::forwardPressed);
	action::attach (forwardPressed, WCompat::movedForward);
	action::attach (forwardReleased, WCompat::forwardReleased);

	function WCompat::backPressed()
		{
	    event::trigger(eventbackPressed);
	    action::mute (backPressed, Event::Returned(eventbackPressed, mute));
		schedule ("action::completed (backPressed);", 0.0);
		}
	
	function WCompat::movedBack ()
		{
	    if(!$action::[mute, backPressed])
	        event::trigger(eventBackStarted, %weapon);
		}
	
	function WCompat::backReleased()
		{
	    event::trigger(eventbackPressed);
	    action::mute (backReleased, Event::Returned(eventbackPressed, mute));
	    if(!$action::[mute, backReleased])
	        event::trigger(eventBackStopped, %weapon);
		}
	
	action::overRideLimitOnPre (backPressed);
	action::attach::pre (backPressed, WCompat::backPressed);
	action::attach (backPressed, WCompat::movedBack);
	action::attach (backReleased, WCompat::backReleased);

	function WCompat::moverightPressed()
		{
	    event::trigger(eventrightPressed);
	    action::mute (moverightPressed, Event::Returned(eventrightPressed, mute));
		schedule ("action::completed (moverightPressed);", 0.0);
		}
	
	function WCompat::movedRight ()
		{
	    if(!$action::[mute, moverightPressed])
	        event::trigger(eventRightStarted, %weapon);
		}
	
	function WCompat::moverightReleased()
		{
	    event::trigger(eventrightPressed);
	    action::mute (moverightReleased, Event::Returned(eventrightPressed, mute));
	    if(!$action::[mute, moverightReleased])
	        event::trigger(eventRightStopped, %weapon);
		}
	
	action::overRideLimitOnPre (moverightPressed);
	action::attach::pre (moverightPressed, WCompat::moverightPressed);
	action::attach (moverightPressed, WCompat::movedRight);
	action::attach (moverightReleased, WCompat::moverightReleased);

	function WCompat::moveleftPressed()
		{
	    event::trigger(eventleftPressed);
	    action::mute (moveleftPressed, Event::Returned(eventleftPressed, mute));
		schedule ("action::completed (moveleftPressed);", 0.0);
		}
	
	function WCompat::movedLeft ()
		{
	    if(!$action::[mute, moveleftPressed])
	        event::trigger(eventLeftStarted, %weapon);
		}
	
	function WCompat::moveleftReleased()
		{
	    event::trigger(eventleftPressed);
	    action::mute (moveleftReleased, Event::Returned(eventleftPressed, mute));
	    if(!$action::[mute, moveleftReleased])
	        event::trigger(eventLeftStopped, %weapon);
		}
	
	action::overRideLimitOnPre (moveleftPressed);
	action::attach::pre (moveleftPressed, WCompat::moveleftPressed);
	action::attach (moveleftPressed, WCompat::movedLeft);
	action::attach (moveleftReleased, WCompat::moveleftReleased);
	}

//=======================================================================================
// Makes the OptionGui and action.cs compatible with Writers scripts - jump.cs
// For some reason, Writer doesn't trigger an event when the action has been posted, or 
// when the key is released as he does with all the others.
//=======================================================================================
if ($Enabled["writer\\jump.cs"]==true)
	{
	function WCompat::jumpPressed()
		{
	    event::trigger(eventJumpPressed);
	    action::mute (jumpPressed, Event::Returned(eventJumpPressed, mute));
		schedule ("action::completed (jumpPressed);", 0.0);
		}
	
	action::overRideLimitOnPre (jumpPressed);
	action::attach::pre (jumpPressed, WCompat::jumpPressed);
	}