//===============================================================
// Jump.cs by Mental Trousers
//===============================================================
// There a bunch of stuff in here to do with jumping. It contains
// a ski script, the timing for auto-ski on/off can be adjusted 
// in NewOpts to suit. There is a mortar jump that lets you set
// 2 ordinary mortar jumps and one combined mine/mortar jump.
// There is also a simple jump/jet implemented (it doesn't fiddle
// the mouse sensitivity when piloting a flyer and it will eject
// you from the flyer, rather than making it rise :)
//===============================================================
include ("MT\\Library\\purgeNGS.cs");

function MT::jumpPressed ()
{
	if ($MT::autoJump)
		{
		$MT::autoJump=false;
		control::setValue (MTTextJump, "");
		return;
		}

	if (!$action::[mute, jumpPressed])
		{
		$MT::jumpPressed=true;
		if ($MT::enableSki)
			{
			schedule ("MT::autoJump ();", $MT::jumpTapTime);
			schedule ("MT::cancelAutoJump ();", $MT::jumpHeldTime);
			}
		MT::_jump ();
		}
}

function MT::_jump ()
{
	if (($MT::jumpPressed || $MT::autoJump))
		{
		schedule ("postAction (2048, IDACTION_MOVEUP, 0.0);", 0.1);
		schedule ("MT::_jump ();", 0.05);
		}
}

function MT::autoJump ()
{
	if ($MT::jumpPressed && ($MT::jumpHeldTime-$MT::jumpTapTime > 0.2))
		{
		$MT::autoJump=true;
		control::setValue (MTTextJump, "<jc>Ski");
		}
}

function MT::cancelAutoJump ()
{
	if ($MT::jumpPressed)
		{
		$MT::autoJump=false;
		control::setValue (MTTextJump, "");
		}
}

function MT::jumpReleased ()
{
	$MT::jumpPressed=false;
}

$MT::autoJump=false;

action::Attach::post (jumpPressed, MT::jumpPressed);
action::Attach::post (jumpReleased, MT::jumpReleased);

function MT::mortarJump ()
{
	say (1, "Mortar jumping ..... stand clear~wtakcovr");
	if ($MT::mortarJump==0)
		{
		use ("Mortar");
		postAction (2048, IDACTION_LOOKDOWN, 1);
		schedule ("postAction (2048, IDACTION_LOOKDOWN, -0);", 0.1);
		schedule ("postAction (2048, IDACTION_PITCH, "@$MT::fireAngle[0]@");", 0.2);
		schedule ("postAction (2048, IDACTION_FIRE1, 1);", 0.5);
		schedule ("postAction (2048, IDACTION_BREAK1, 1);", 0.85);
		schedule ("postAction (2048, IDACTION_MOVERIGHT, 1);", 1.1);
		schedule ("postAction (2048, IDACTION_MOVERIGHT, 0);", 1.265);
		schedule ("postAction (2048, IDACTION_MOVEUP, 1.0);", $MT::jumpDelay[0]+0.1);
		schedule ("postAction (2048, IDACTION_JET, 1.0);", $MT::jumpDelay[0]+0.1);
		schedule ("postAction (2048, IDACTION_JET, 0.0);", $MT::jumpDelay[0]+0.2);
		schedule ("postAction (2048, IDACTION_JET, 1.0);", 3.2);
		schedule ("postAction (2048, IDACTION_PITCH, 0.1);", 3.6);
		schedule ("use (\"Repair Kit\");", 6);
		}
	else if ($MT::mortarJump==1)
		{
		use ("Mortar");
		postAction (2048, IDACTION_LOOKDOWN, 1);
		schedule ("postAction (2048, IDACTION_LOOKDOWN, -0);", 0.1);
		schedule ("postAction (2048, IDACTION_PITCH, "@$MT::fireAngle[1]@");", 0.2);
		schedule ("postAction (2048, IDACTION_FIRE1, 1);", 0.6);
		schedule ("postAction (2048, IDACTION_BREAK1, 1);", 0.85);
		schedule ("postAction (2048, IDACTION_MOVERIGHT, 1);", 1.1);
		schedule ("postAction (2048, IDACTION_MOVERIGHT, 0);", 1.265);
		schedule ("postAction (2048, IDACTION_MOVEUP, 1.0);", $MT::jumpDelay[1]+0.1);
		schedule ("postAction (2048, IDACTION_JET, 1.0);", $MT::jumpDelay[1]+0.1);
		schedule ("postAction (2048, IDACTION_JET, 0.0);", $MT::jumpDelay[1]+0.2);
		schedule ("postAction (2048, IDACTION_JET, 1.0);", 3.2);
		schedule ("postAction (2048, IDACTION_PITCH, 0.1);", 3.6);
		schedule ("use (\"Repair Kit\");", 6);
		}
	else if ($MT::mortarJump==2)
		{
		use ("Mortar");
		postAction (2048, IDACTION_LOOKDOWN, 1);
		schedule ("postAction (2048, IDACTION_LOOKDOWN, -0);", 0.1);
		schedule ("postAction (2048, IDACTION_PITCH, "@$MT::fireAngle[2]@");", 0.2);
		schedule ("throwStart();", 0.2);
		schedule ("throwRelease(\"Mine\");", $MT::mineDelay+0.1);
		schedule ("postAction (2048, IDACTION_FIRE1, 1);", 0.6);
		schedule ("postAction (2048, IDACTION_BREAK1, 1);", 0.85);
		schedule ("postAction (2048, IDACTION_MOVERIGHT, 1);", 1.1);
		schedule ("postAction (2048, IDACTION_MOVERIGHT, 0);", 1.265);
		schedule ("postAction (2048, IDACTION_MOVEUP, 1.0);", $MT::jumpDelay[2]+0.1);
		schedule ("postAction (2048, IDACTION_JET, 1.0);", $MT::jumpDelay[2]+0.1);
		schedule ("postAction (2048, IDACTION_JET, 0.0);", $MT::jumpDelay[2]+0.2);
		schedule ("postAction (2048, IDACTION_JET, 1.0);", 3.2);
		schedule ("postAction (2048, IDACTION_PITCH, 0.1);", 3.6);
		schedule ("use (\"Repair Kit\");", 6);
		}
}

function MT::handleSkiEnable ()
{
	control::setActive (MT_tapTime, $MT::enableSki);
	control::setActive (MT_startSki, $MT::enableSki);

	control::setActive (MT_enablejumpHud, $MT::enableSki);
	control::setVisible(MTContainerJump, $MT::enableSki);
	control::setActive (MT_jumpXCoord, $MT::enableSki);
	control::setActive (MT_jumpYCoord, $MT::enableSki);
}

function MT::mortarJumpCycle ()
{
	$MT::mortarJump++;
	if ($MT::mortarJump>2)
		$MT::mortarJump=0;

	if ($MT::mortarJump==2)
	    remoteBP(2048, "<jc>Mine/Mortar jump", 4);
	else
	    remoteBP(2048, "<jc>Mortar jump "@$MT::mortarJump+1, 4);
}

function MT::handleTapTime()
{
	$MT::jumpTapTime=control::getValue(MT_tapTime);
	Control::setValue(MT_jumpTapTimeLabel, "["@string::getSubStr ($MT::jumpTapTime, 0, 5)@"] Jump tap time");
}

function MT::handleSki ()
{
	$MT::jumpHeldTime=control::getValue(MT_startSki)*5;
	Control::setValue(MT_releaseTime, "["@string::getSubStr ($MT::jumpHeldTime, 0, 3)@"] Release time");
}

function MT::handleMortarJump()
{
	%sel=FGCombo::getSelected(MT_mortarJumpCombo);

	%val1=string::getSubStr($MT::fireAngle[%sel], 0, 4);
	%val2=string::getSubStr(2+((floor(($MT::jumpDelay[%sel]-2)/0.001)+1)/1000), 0, 4);
	Control::setValue(MT_fireAngle, (%val1-0.2)*10);
	Control::setValue(MT_jumpDelay, %val2-2);
	Control::setValue(MT_fireAngleLabel, "["@%val1@"] Fire angle");
	Control::setValue(MT_jumpDelayLabel, "["@%val2@"] Jump delay");
	if (%sel==2)
		{
		control::setActive (MT_mineDelay, true);
		Control::setValue(MT_mineDelay, $MT::mineDelay);
		Control::setValue(MT_mineDelayLabel, "["@string::getSubStr ($MT::mineDelay, 0, 3)@"] Mine Delay");
		}
	else
		control::setActive (MT_mineDelay, false);
}

function MT::handleFireAngle()
{
	%sel=FGCombo::getSelected(MT_mortarJumpCombo);
	$MT::fireAngle[%sel]=Control::getValue(MT_fireAngle)*0.1+0.2;
	%val=string::getSubStr($MT::fireAngle[%sel], 0, 5);
	Control::setValue(MT_fireAngleLabel, "["@%val@"] Fire angle");

}

function MT::handleJumpDelay()
{
	%sel=FGCombo::getSelected(MT_mortarJumpCombo);
	$MT::jumpDelay[%sel]=Control::getValue(MT_jumpDelay)+2;
	%val=string::getSubStr(2+((floor(($MT::jumpDelay[%sel]-2)/0.001)+1)/1000), 0, 4);
	Control::setValue(MT_jumpDelayLabel, "["@%val@"] Jump delay");
}

function MT::handleMineDelay()
{
	$MT::mineDelay=control::getValue(MT_mineDelay);    
	Control::setValue(MT_mineDelayLabel, "["@string::getSubStr ($MT::mineDelay, 0, 4)@"] Mine Delay");
}

function MT::jetToJumpAndJet ()
{
	if ($MT::enableCombinedJumpJet)
		{
		postAction(2048, IDACTION_MOVEUP, 1.000);
		}

    schedule ("action::completed(jetPressed);", 0.0);
	return;
}

function MT::JumpAndJet ()
{
	postAction(2048, IDACTION_MOVEUP, 1.000);
	postAction(2048, IDACTION_JET, 1.000);
}

action::overRideLimitOnPre (jetPressed);
action::attach::pre (jetPressed,	MT::jetToJumpAndJet);

//===============================================================
// 
//===============================================================
function MT::JumpHud (%gui)
{
	if (%gui==playGui && $MT::JumpHud)
		{
		$MT::XCE::Jump=100;
		$MT::YCE::Jump=20;
		$MT::Container::Jump=newObject ("MTContainerJump",
										SimGui::Control,
										$MT::XCC::Jump,
										$MT::YCC::Jump,
										$MT::XCE::Jump,
										$MT::YCE::Jump);
	
		$MT::Text::Jump=newObject ("MTTextJump",
									FearGuiFormattedText, 0, 0,
									$MT::XCE::Jump,
									$MT::YCE::Jump);
	
		AddToSet (MTContainerJump, $MT::Text::Jump);
		AddToSet ($MTControlObject, $MT::Container::Jump);
		control::setValue (MTTextJump, "");

		control::setVisible(MT_huds_overlay2, $MT::enableJumpHud);
		control::setVisible(MTContainerJump, $MT::enableJumpHud);

		$MT::JumpHud=false;
		schedule ("event::detach (eventGuiOpen, MT::JumpHud);", 30);
		}
}

//===============================================================
// 
//===============================================================
function MT::initJump ()
{
	if ($MT::initJump)
		{
		control::setvalue (MT_jump_background, "<b47,38:mt\\bmps\\MTPack\\MTPack_background.bmp>");
	
		Control::setValue(MT_tapTime, $MT::jumpTapTime);
		Control::setValue(MT_startSki, $MT::jumpHeldTime/5);
		Control::setValue(MT_mineDelay, $MT::mineDelay);
		Control::setValue(MT_jumpTapTimeLabel, "["@string::getSubStr ($MT::jumpTapTime, 0, 5)@"] Jump tap time");
		Control::setValue(MT_releaseTime, "["@string::getSubStr ($MT::jumpHeldTime, 0, 3)@"] Release time");
		Control::setValue(MT_mineDelayLabel, "["@string::getSubStr ($MT::mineDelay, 0, 4)@"] Mine Delay");

		FGCombo::clear(MT_mortarJumpCombo);
		FGCombo::addEntry(MT_mortarJumpCombo, "Mortar jump 1", 0);
		FGCombo::addEntry(MT_mortarJumpCombo, "Mortar jump 2", 1);
		FGCombo::addEntry(MT_mortarJumpCombo, "Mine/Mortar jump 1", 2);
		FGCombo::setSelected(MT_mortarJumpCombo, 0);
	
		%val1=string::getSubStr($MT::fireAngle[0], 0, 4);
		%val2=string::getSubStr(2+((floor(($MT::jumpDelay[0]-2)/0.001)+1)/1000), 0, 4);
		Control::setValue(MT_fireAngle, (%val1-0.2)*10);
		Control::setValue(MT_jumpDelay, %val2-2);
		Control::setValue(MT_fireAngleLabel, "["@%val1@"] Fire angle");
		Control::setValue(MT_jumpDelayLabel, "["@%val2@"] Jump delay");

		control::setActive (MT_mineDelay, false);
		MT::handleSkiEnable ();
		$MT::initJump=false;
		}
}

//===============================================================
// Register with NewOpts. Simple
//===============================================================
function MT::registerJump ()
{
	NewOpts::registerHelp("MT Jump", "Enable ski/auto jump", "Tick this to enable the ski/auto jump. What this does"@
							" is, if you hold the jump key down for a certain length of time and then release it,"@
							" you will still automatically jump. This is useful for hilly terrain, especially for"@
							" a heavy. To stop the auto jump, simply press jump again.");
	NewOpts::registerHelp("MT Jump", "Jump tap time", "This isused to adjust the length of time before the ski/"@
							"auto jump is activated.");
	NewOpts::registerHelp("MT Jump", "Release time", "The release time is used to adjest now long it will wait"@
							" before deactivating the ski/auto jump when the jump button is held down. For instance,"@
							" holding the jump button will activate the ski/auto jump after a small amount of time."@
							" Holding the jump button for longer will cause the ski/auto jump to turn off. So, when"@
							" you release the jump key you will stop jumping. If you release the jump key when the"@
							" ski/auto jump is active, you will keep jumping.");
	NewOpts::registerHelp("MT Jump", "Seperate jump/jet key", "Set a key here if you want a combined jump/jet key,"@
							" but also want just a jet key as well. <f2>NOTE<f1> The jump/jet in this pack will"@
							" eject you from a flyer if you press it when piloting. It is not an error.");
	NewOpts::registerHelp("MT Jump", "Make jet a jump/jet", "Tick this to make your jet key a combined jump/jet."@
							" <f2>NOTE<f1> The jump/jet in this pack will eject you from a flyer if you press it"@
							" when piloting. It is not an error.");
	NewOpts::registerHelp("MT Jump", "Mortar jump key", "Set this to use the mortar jumps. When you wish to do a"@
							" mortar jump, find a large flat area, aim at where you want to go, hold down the"@
							" forward key, press you mortar jump key, and hang on. Once airbourne, use your jet"@
							" and direction keys to control where you land.");
	NewOpts::registerHelp("MT Jump", "Mortar cycle key", "You can do 3 different mortar jumps. The first 2 are just"@
							" simple mortar jumps, while the 3rd is a combined mine/mortar jump. Set this key to"@
							" cycle through them.");
	NewOpts::registerHelp("MT Jump", "Mortar jump selector", "This combo box allows you to select which of the"@
							" mortar jumps you wish to alter the settings for. The 2 mortar jumps allow you to"@
							" alter the timing for the fire angle and jump delay, while the combined mine/mortar"@
							" jump allows you to alter the timing for the mine throw as well.");
	NewOpts::registerHelp("MT Jump", "Fire angle", "This allows you to change the angle that the mortar will fire"@
							" at when doing a mortar jump.");
	NewOpts::registerHelp("MT Jump", "Jump delay", "This allows you to change the delay before jumping when"@
							" doing a mortar jump. Less delay means jumping earlier and you will going higher"@
							" but not as far.");
	NewOpts::registerHelp("MT Jump", "Mine delay", "This sets how long before the mine is released, and therefore"@
							" how far it goes. <f2>NOTE<f1> The mine may behave differently online so try it out.");
	NewOpts::register("MT Jump", "MT\\gui\\MTPack\\MTJump.gui", "MT::initJump();", "", true);
}

MT::registerJump ();
NGS::register (MTContainerJump);
NGS::register (MTBgJump);
NGS::register (MTTextJump);
event::attach (eventGuiOpen, MT::JumpHud, %gui);
$MT::JumpHud=true;
$MT::initJump=true;
$MT::mortarJump=0;