//===============================================================
// InventoryStation.cs by Mental Trousers
//===============================================================
// Takes care of a bunch of stuff to do with the inventory
// stations. Can't tell whether or not you are using a portable
// or permanent inventory station unfortunately. I haven't
// figured out how to do that very quickly yet. Sometime in the
// future I will hopefully resolve this problem but for the mean
// time, we'll just have to live with it like this.
//
// Unfortunately parts of this file are still buried in the
// QuickFavourites.cs script, because thats where it started life.
// After a while I started to realise that it needed to be moved
// to a file of it's own, however I haven't done a thorough job of
// moving it to here. Bummer, something to fix one day.
//
//===============================================================
// Sets which bank of 18 buttons is visible in the Inventory gui
//===============================================================
function MT::setButtonBanks ()
{
	control::setVisible (InvButtons, $MT::Item::InvFavsButtons);
	control::setVisible (StatButtons, $MT::Item::StatFavsButtons);
}

//===============================================================
// Handles the combo box for choosing which side the bank of 18
// buttons appears on in the inventory station
//===============================================================
function MT::handleButtons()
{
	%sel=FGCombo::getSelected(MT_buttons_combo);
	if (%sel==1)
		{
		$MT::Item::InvFavsButtons=True;
		$MT::Item::StatFavsButtons=false;
		}
	else if (%sel==2)
		{
		$MT::Item::InvFavsButtons=false;
		$MT::Item::StatFavsButtons=true;
		}
	else
		{
		$MT::Item::InvFavsButtons=true;
		$MT::Item::StatFavsButtons=true;
		}
}

//===============================================================
// Handles selecting what each quickbuy button buys
//===============================================================
function MT::handleQuickBuy(%qb)
{
	%sel=FGCombo::getSelected("MT_quickbuy"@%qb);
	$MT::quickBuy[%qb]=%sel+10;
	for (%i=1; %i<=10; %i++)
		{
		if (%i!=%qb)
			{
			%item=FGCombo::getSelected("MT_quickbuy"@%i);
			if (%sel==%item)
				FGCombo::setSelected("MT_quickbuy"@%i, 16);
			}
		}
}

//===============================================================
// Register with NewOpts. Simple
//===============================================================
function MT::registerForNewOpts ()
{
	NewOpts::registerHelp("MT Inventory Station", "Quick buys", "Tick this to enable the Quick buys. These are"@
							" bound to the number keys along the top of the keyboard and are there so that you"@
							" can easily and quickly change your backpack, buy beacons etc without having to"@
							" wait for the inventory screen to open and then having to scroll through the list"@
							" blah blah. There is no checking to see if you are able to buy the item, so even if"@
							" you are a light and attempt to buy a turret using the Quick buy keys, you will see"@
							" a message saying that you bought a turret, when you didn't. That is why the weapons"@
							" are not on the list because to buy one you would have to sell one. I haven't made it"@
							" that smart.");
	NewOpts::registerHelp("MT Inventory Station", "Check backpack", "Tick this and when you leave the inventory"@
							" station, the game will automatically zoom out to the third person view for half a second"@
							" and then return to the first person view. This enables you to check that you have the"@
							" correct back pack etc. I put this in because when I originally started writing Quick"@
							" Favs, it took a very long time to get used to how quickly it worked and having the check"@
							" back pack turned on reassured me that it had in fact worked correctly.");
	NewOpts::registerHelp("MT Inventory Station", "Quick buys selectors", "These allow you to set what each Quick buy"@
							" key buys. Quick buy 1 sets the item for key 1 etc");
	NewOpts::register("MT Inventory Station", "MT\\gui\\MTPack\\MTInventoryStation.gui", "MT::inventoryStationGuiInit();", "", true);
}

//===============================================================
// extracts the name of the item from the string
//===============================================================
function MT::getInvItemName (%item)
{
	if (match::paramString (%item, "%n# %t"))
		%name=match::result(n);
	return %name;
}

//===============================================================
// Initialize the combo boxes etc
//===============================================================
function MT::inventoryStationGuiInit()
{
	if ($MT::inventoryStationGuiInit)
		{
		control::setvalue (MT_inventory_background, "<b47,38:mt\\bmps\\MTPack\\MTPack_background.bmp>");
		for (%i=1; %i<=10; %i++)
			{
			FGCombo::clear("MT_quickbuy"@%i);
			for (%j=11;%j<=42;%j++)
				{
				%item=MT::getInvItemName($MT::Item::[%j]);
				if (%j>24 && %j!=25)
					FGCombo::addEntry("MT_quickbuy"@%i, %item, %j-10);
				else if (%j<=20 && !(%j&1))
					FGCombo::addEntry("MT_quickbuy"@%i, %item, %j-10);
				}
			FGCombo::setSelected("MT_quickbuy"@%i, $MT::quickBuy[%i]-10);
			}
		FGCombo::clear(MT_buttons_combo);
		FGCombo::addEntry(MT_buttons_combo, "Left", 1);
		FGCombo::addEntry(MT_buttons_combo, "Right", 2);
		FGCombo::addEntry(MT_buttons_combo, "Both", 3);
		FGCombo::setSelected(MT_buttons_combo, ($MT::Item::InvFavsButtons==true)+($MT::Item::StatFavsButtons==true)*2);
		$MT::inventoryStationGuiInit=false;
		}
}

//===============================================================
// Quick buys. Damn handy cos the inventory gui doesn't open when
// $pref::noEnterInvStation is true
//===============================================================
function MT::quickBuy (%buy)
{
	if (!$MT::enableQuickBuys)
		return;

	if ($MT::doLitterbug)
		{
	    remoteBP(2048, "<jc>Cannot buy item while Litterbug is active", 4);
		return;
		}
	%item=MT::getInvItemName ($MT::Item::[$MT::quickBuy[%buy]]);
	buy (%item);
    remoteBP(2048, "<jc>Quick buy - bought "@%item, 4);
}


//=======================================================================================
// Zooms out to show you whats on your back, then zooms back in again
//=======================================================================================
function MT::checkBackPack ()
{
	postAction (2048, IDACTION_VIEW, -0);
	schedule ("postAction (2048, IDACTION_VIEW, -0);", 0.6);
	return;
}

//===============================================================
// Handler for the combo box that shows which side the 18 buttons
// appear on at the inventory station
//===============================================================
function MT::showButtonPanels ()
{
	%panels=$curFavorites=FGCombo::getSelected(ThrowPackInvButtonPanels);
	if (%panels==1)
		{
		$MT::Item::InvFavsButtons=true;
		$MT::Item::StatFavsButtons=false;
		}
	else if (%panels==2)
		{
		$MT::Item::InvFavsButtons=false;
		$MT::Item::StatFavsButtons=true;
		}
	else if (%panels==3)
		{
		$MT::Item::InvFavsButtons=true;
		$MT::Item::StatFavsButtons=true;
		}
}

//===============================================================
// Does a perfect 180
//===============================================================
function MT::turnAround ()
{
	if ($MT::turnAround)
		{
		postAction (2048, IDACTION_YAW, 0.3);
		schedule ("postAction (2048, IDACTION_YAW, 0.3);", 0.1);
		schedule ("postAction (2048, IDACTION_YAW, 0.3);", 0.2);
//		postAction (2048, IDACTION_YAW, 1.0);
		}
}

//===============================================================
// Catch messages associated with inventory stations
//===============================================================
function MT::catchInventStation (%client, %msg)
{
	if (match::string(%msg, "Station Access On*"))
		{
		$MT::isInvStation=true;
		schedule ("$MT::isInvStation=false;", 1);
		MT::turnAround ();
		schedule ("MT::checkForWeapon (0);", 0.1);
		}
	else if (match::string(%msg, "Station Access Off*"))
		{
		cursorOff (mainWindow);  //A kludge, but it works. I think
		event::trigger(eventInvStationClose, "CmdInventoryGui");
		$MT::isInvStation=false;
		}
	else if (match::string (%msg, "To many weapons*"))
		MT::sellWeapons ();
}

//===============================================================
// The inventory station is closed
//===============================================================
function MT::invStationClosed(%gui)
{
	if (%gui==CmdInventoryGui)
		{
		if ($MT::atVehicleStation)
			{
			event::trigger(eventVehicleStatLeft);
			$MT::atVehicleStation=false;
			}
		$MT::atStation=true;
		$MT::turnAround=true;
		$MT::doLitterbug=false;

		useItem ($throwItem::[$curFavorites, weapon]);

		if ($MT::curFavourites!="")
			$curFavorites=$MT::curFavourites;

		$MT::curFavourites="";

		if ($MT::enableCheckBackPack)
			MT::checkBackPack ();
		}
	MT::pushActionMap (playGui);
}

//===============================================================
// The Inventory gui is open
//===============================================================
function MT::InvStatGuiOpen (%gui)
{
	if (%gui==CmdInventoryGui)
		{
		MT::setButtonBanks ();
		schedule ("popActionMap(\"MTsetFavsMap.sae\"); pushActionMap(\"MTInventMap.sae\");", 0.2);
		if ($MT::curFavourites=="")
			$MT::curFavourites=$curFavorites;
		}
}

//===============================================================
// If we are at an inventory station, the weapon is dismounted
// straight away, so here we check for it. The check is triggered
// by the "Access On" message
//===============================================================
function MT::checkForWeapon (%count)
{
	if ($ServerVersion>=1.8)
		{
		if (%count<20 && $MT::isInvStation)
			{
			%mounted=getMountedItem(0);
			if (%mounted!=-1)
				schedule ("MT::checkForWeapon ("@%count@");", 0.1);
			else
				event::trigger (eventInvStationOpen, %mounted);
			}
		}
	else
		{
		if ($curFavorites==19) 
			MT::InvStatGuiOpen_ ();
		else
			MT::InvStatGuiOpen__ (-1);
		}
}

//===============================================================
// Overrides the one in client.cs. It sets which favourite is 
// choosen at the station
//===============================================================
function CmdInventoryGui::favoritesSel(%favList)
{
   $curFavorites = %favList;
   CmdInventory::setFavorites($pref::favoriteList[$curFavorites @ $ServerFavoritesKey]);
	for (%i = 1; %i <= 18; %i++)
		{
		%btnName = "InvFavButton" @ %i;
		Control::setValue(%btnName, FALSE);
		%btnName = "StatFavButton" @ %i;
		Control::setValue(%btnName, FALSE);
		}
	%btnName = "InvFavButton" @ $curFavorites;
    Control::setValue(%btnName, TRUE);
	%btnName = "StatFavButton" @ $curFavorites;
    Control::setValue(%btnName, TRUE);
    schedule ("action::completed (buyFavouritePressed);", 0.0);
}

//===============================================================
// The inventory screen button has been pressed
//===============================================================
function MT::inventoryPressed ()
{
	$MT::turnAround=false;
	$MT::atStation=false;
	schedule ("action::completed (\"inventoryPressed\");", 0.1);
}

//===============================================================
// Stuff to do at start up time
//===============================================================
MT::registerForNewOpts ();

$MT::atStation=true;
$MT::turnAround=true;
$MT::isInvStation=false;
$MT::inventoryStationGuiInit=true;
$buttonsVis[1]="Left";
$buttonsVis[2]="Right";
$buttonsVis[3]="Both";

if ($MT::Item::InvFavsButtons=="")
	$MT::Item::InvFavsButtons=True;
if ($MT::Item::StatFavsButtons=="")
	$MT::Item::StatFavsButtons=True;

event::attach (eventClientMessage,	MT::catchInventStation, %client, %msg);
event::attach (eventGuiClose,		MT::invStationClosed, %gui);
event::attach (eventGuiOpen,		MT::InvStatGuiOpen, %gui);

action::attach::pre (inventoryPressed,		MT::inventoryPressed);
